/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.bos.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextThreadBinder;
import kd.bos.lang.Lang;
import kd.bos.thread.ManagedThreadFeature;
import kd.sdk.kingscript.debug.DebugThreadLocalRestorer;

public final class DebugThreadLocalRestorerImpl
implements DebugThreadLocalRestorer {
    public Map<String, String> get() {
        RequestContext ctx = RequestContext.get();
        if (ctx == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> env = new HashMap<String, String>(16);
        env.put("traceId", ctx.getTraceId());
        env.put("sessionId", ctx.getGlobalSessionId());
        env.put("userId", String.valueOf(ctx.getCurrUserId()));
        env.put("accountId", ctx.getAccountId());
        env.put("orgId", String.valueOf(ctx.getOrgId()));
        env.put("accCompanyId", ctx.getAccCompanyId());
        env.put("lang", ctx.getLang().name());
        env.put("tenantCode", ctx.getTenantCode());
        env.put("tenantId", ctx.getTenantId());
        env.put("userName", ctx.getUserName());
        env.put("userAgent", ctx.getUserAgent());
        env.put("client", ctx.getClient());
        env.put("userOpenId", ctx.getUserOpenId());
        env.put("userType", ctx.getUserType());
        env.put("yzjAppId", ctx.getYzjAppId());
        env.put("yzjAppTicket", ctx.getYzjAppTicket());
        env.put("uid", ctx.getUid());
        return env;
    }

    public void set(Map<String, String> env) {
        if (env != null && !env.isEmpty()) {
            String traceId = env.get("traceId");
            String sessionId = env.get("sessionId");
            String userId = env.get("userId");
            String accountId = env.get("accountId");
            String orgId = env.get("orgId");
            String accCompanyId = env.get("accCompanyId");
            String lang = env.get("lang");
            RequestContext ctx = RequestContext.get();
            if (!(ctx != null && Objects.equals(traceId, ctx.getTraceId()) && Objects.equals(sessionId, ctx.getGlobalSessionId()) && Objects.equals(userId, String.valueOf(ctx.getCurrUserId())) && Objects.equals(accountId, ctx.getAccountId()) && Objects.equals(orgId, String.valueOf(ctx.getOrgId())) && Objects.equals(accCompanyId, ctx.getAccCompanyId()) && Objects.equals(lang, ctx.getLang().name()))) {
                ctx = RequestContext.create((boolean)true);
                ctx.setTraceId(traceId);
                ctx.setGlobalSessionId(sessionId);
                ctx.setUserId(userId);
                ctx.setAccountId(accountId);
                ctx.setOrgId(Long.parseLong(orgId));
                ctx.setAccCompanyId(env.get("accCompanyId"));
                ctx.setLang(Lang.valueOf((String)lang));
                ctx.setTenantCode(env.get("tenantCode"));
                ctx.setTenantId(env.get("tenantId"));
                ctx.setUserName(env.get("userName"));
                ctx.setUserAgent(env.get("userAgent"));
                ctx.setClient(env.get("client"));
                ctx.setUserOpenId(env.get("userOpenId"));
                ctx.setUserType(env.get("userType"));
                ctx.setYzjAppId(env.get("yzjAppId"));
                ctx.setYzjAppTicket(env.get("yzjAppTicket"));
                ctx.setUid(env.get("uid"));
                RequestContextThreadBinder.bind((RequestContext)ctx);
                if (!ManagedThreadFeature.isManaged()) {
                    new ManagedThreadFeature().start();
                }
            }
        }
    }

    public void remove() {
    }
}

