/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.bos.config;

import java.net.InetAddress;
import java.util.concurrent.atomic.AtomicBoolean;
import kd.bos.dlock.DLock;
import kd.bos.instance.Instance;
import kd.bos.lock.DLockUtil;
import kd.sdk.kingscript.config.EnvProvider;
import kd.sdk.kingscript.debug.dlock.DLocker;
import kd.sdk.kingscript.exception.ScriptTimeoutException;

public class EnvProviderImpl
implements EnvProvider {
    private static String hostAddress;

    public String getInstanceIp() {
        return hostAddress;
    }

    public String getInstanceId() {
        return Instance.getInstanceId();
    }

    public DLocker tryLock(String key, long timeout) {
        DLock dlock = DLock.create((String)key);
        AtomicBoolean closed = new AtomicBoolean();
        if (dlock.tryLock(timeout)) {
            return () -> {
                if (closed.compareAndSet(false, true)) {
                    dlock.close();
                }
            };
        }
        throw new ScriptTimeoutException("Waiting lock timeout, the locker key is: " + key);
    }

    static {
        try {
            hostAddress = DLockUtil.getIpAddress();
        }
        catch (Exception e1) {
            try {
                hostAddress = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception e2) {
                hostAddress = "127.0.0.1";
            }
        }
    }
}

