/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.bos.config;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.data.BusinessDataReader;
import kd.bos.orm.query.QFilter;
import kd.sdk.kingscript.log.Logs;
import kd.sdk.kingscript.security.GenericValidator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;

public class TypeScriptISVValidator
implements GenericValidator<String> {
    private static final Logger logger = Logs.getLogger();
    private static final Set<String> NON_ISV_KEYWORDS = new HashSet<String>(4);

    public boolean validate(String scriptPath) {
        if (StringUtils.isEmpty((CharSequence)scriptPath) || !scriptPath.endsWith(".ts")) {
            logger.warn("Invalid TypeScript path: {}", (Object)scriptPath);
            return false;
        }
        try {
            QFilter qFilter = new QFilter("classname", "=", (Object)scriptPath);
            Map result = BusinessDataReader.loadFromCache((String)"ide_pluginscript", (String)"isv", (QFilter[])qFilter.toArray());
            return result.values().stream().findFirst().map(dynamicObject -> !NON_ISV_KEYWORDS.contains(dynamicObject.getString("isv"))).orElse(false);
        }
        catch (Exception e) {
            logger.error("Error validating ISV script path: {}", (Object)scriptPath, (Object)e);
            return false;
        }
    }

    static {
        NON_ISV_KEYWORDS.add("kingdee");
        NON_ISV_KEYWORDS.add("kdtest");
    }
}

