/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.bos.launch;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Properties;
import kd.sdk.bos.launch.Launcher;
import kd.sdk.bos.launch.MachineId;
import kd.sdk.bos.launch.ProjectInitializer;
import kd.sdk.kingscript.config.Env;
import kd.sdk.kingscript.engine.ScriptInitializer;
import kd.sdk.kingscript.lib.provider.LibModuleProvider;
import kd.sdk.kingscript.lib.provider.ScriptProjectModuleProvider;
import kd.sdk.kingscript.util.FileUtil;

public final class Application {
    public static final String conf_file = "conf/application.conf";
    public static final String log_file = "conf/log.config.xml";

    public static void main(String[] args) {
        String projectPath = new File("").getAbsolutePath();
        Application.start(projectPath, new String[0]);
    }

    public static void start(String projectPath, String ... libProjectPaths) {
        Application.start(projectPath, (LibModuleProvider)(libProjectPaths == null ? null : new ScriptProjectModuleProvider(libProjectPaths)), null);
    }

    public static void start(String projectPath, LibModuleProvider libModuleProvider) {
        Application.start(projectPath, libModuleProvider, null);
    }

    public static void start(String projectPath, LibModuleProvider libModuleProvider, ScriptInitializer customInitializer) {
        projectPath = new File(projectPath).getAbsolutePath();
        System.out.println("\u6b63\u5728\u542f\u52a8\u82cd\u7a79\u670d\u52a1@" + projectPath);
        Launcher launcher = new Launcher(projectPath);
        Application.setupDefault(launcher, projectPath);
        Application.loadConfig(launcher, projectPath);
        if (Env.isOldCosmic() && Env.isKingScriptEnable()) {
            ProjectInitializer.initialize(projectPath, libModuleProvider, customInitializer);
        }
        launcher.start();
    }

    private static void setupDefault(Launcher launcher, String projectPath) {
        launcher.setClusterNumber("cosmic");
        launcher.setTenantNumber("sample");
        launcher.setServerIP("localhost");
        String appName = "cosmic-" + System.getProperty("user.name") + "-" + new File(projectPath).getName() + "-" + MachineId.getId();
        String instanceInfo = "appName=" + appName;
        System.out.println(instanceInfo);
        try (FileWriter fw2 = new FileWriter(projectPath + "/runtime/.instance");){
            fw2.write(instanceInfo);
        }
        catch (IOException fw2) {
            // empty catch block
        }
        launcher.setAppName(appName);
        String webPath = projectPath + "/runtime/webapp/static-file-service";
        if (!new File(webPath).exists()) {
            webPath = projectPath + "/runtime/webapp";
        }
        launcher.setWebPath(webPath);
        launcher.setStartWithQing(false);
    }

    private static void loadConfig(Launcher launcher, String projectPath) {
        File logConfigFile = new File(projectPath + '/' + log_file);
        if (logConfigFile.exists()) {
            try {
                String log = FileUtil.readString((Path)logConfigFile.toPath());
                System.setProperty("log.config", log);
            }
            catch (Exception log) {
                // empty catch block
            }
        }
        try (FileInputStream fis = new FileInputStream(projectPath + '/' + conf_file);){
            Properties ps = new Properties();
            ps.load(fis);
            String serverIP = ps.getProperty("serverIP");
            if (serverIP != null) {
                launcher.setServerIP(serverIP);
            }
            for (String key : ps.stringPropertyNames()) {
                launcher.set(key, ps.getProperty(key));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

