/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.bos.launch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.form.plugin.IFormPlugin;
import kd.sdk.bos.launch.ProjectInitializer;
import kd.sdk.kingscript.mixture.MixtureFactory;
import kd.sdk.kingscript.mixture.MixtureProxy;
import kd.sdk.kingscript.mixture.PluginMixtureProxy;

public final class KingScriptPluginRegister {
    private static Map<String, List<ScriptReplacer>> scriptPlugins = new HashMap<String, List<ScriptReplacer>>();

    public static void addScriptPlugin(String formId, String scriptPath) {
        KingScriptPluginRegister.replaceScriptPlugin(formId, scriptPath, (String)null);
    }

    public static void replaceScriptPlugin(String formId, String scriptPath, Class<?> replaced) {
        KingScriptPluginRegister.replaceScriptPlugin(formId, scriptPath, replaced.getName());
    }

    public static void replaceScriptPlugin(String formId, String scriptPath, String replacedPluginClassName) {
        List list = scriptPlugins.computeIfAbsent(formId, k -> new ArrayList());
        list.add(new ScriptReplacer(scriptPath, replacedPluginClassName));
    }

    public static List<IFormPlugin> addKingScriptPlugin(List<IFormPlugin> plugins, String formId) {
        List<ScriptReplacer> list = scriptPlugins.get(formId);
        if (list != null) {
            for (ScriptReplacer sr : list) {
                IFormPlugin plugin = (IFormPlugin)MixtureFactory.createMixtureProxy((MixtureProxy)new PluginMixtureProxy(sr.scriptPath, scriptPath -> ProjectInitializer.getEngineAutoDebug(scriptPath)));
                boolean replaced = false;
                if (sr.replacedClassName != null) {
                    int n = plugins.size();
                    for (int i = 0; i < n; ++i) {
                        if (!sr.replacedClassName.equals(plugins.get(i).getClass().getName())) continue;
                        plugins.set(i, plugin);
                        replaced = true;
                        break;
                    }
                }
                if (replaced) continue;
                plugins.add(plugin);
            }
        }
        return plugins;
    }

    private static class ScriptReplacer {
        private final String scriptPath;
        private final String replacedClassName;

        private ScriptReplacer(String scriptPath, String replacedClassName) {
            this.scriptPath = scriptPath;
            this.replacedClassName = replacedClassName;
        }

        public String toString() {
            return this.scriptPath + " <- " + this.replacedClassName;
        }
    }
}

