/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.bos.launch;

import java.io.File;
import java.lang.reflect.Method;
import java.nio.file.Files;

public final class Launcher {
    public Launcher(String projectPath) {
        this.setDefault(projectPath);
    }

    private void setDefault(String projectPath) {
        this.set("configAppName", "mservice,web");
        this.set("webmserviceinone", "true");
        this.set("file.encoding", "utf-8");
        this.set("mq.consumer.register", "true");
        this.set("MONITOR_HTTP_PORT", "9998");
        this.set("JMX_HTTP_PORT", "9091");
        this.set("dubbo.protocol.port", "28888");
        this.set("dubbo.consumer.url", "dubbo://localhost:28888");
        this.set("dubbo.consumer.url.qing", "dubbo://localhost:30880");
        this.set("dubbo.registry.register", "false");
        this.set("dubbo.service.lookup.local", "true");
        this.set("appSplit", "false");
        this.set("lightweightdeploy", "false");
        this.set("tenant.code.type", "config");
        this.set("JETTY_WEB_PORT", "8080");
        this.set("domain.contextUrl", "http://localhost:8080/ierp");
        try {
            String logConfig = new String(Files.readAllBytes(new File(projectPath + "/conf/log.config.xml").toPath()), "UTF-8");
            this.set("log.config", logConfig);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setClusterNumber("cosmic");
        this.setTenantNumber("sample");
        this.setAppName("cosmic-server");
        this.setStartWithQing(true);
        this.setXdbEnable(false);
        this.setSqlOut(true, true);
    }

    public void start() {
        try {
            Class<?> jettyServer = Class.forName("kd.bos.service.webserver.JettyServer");
            Method main = jettyServer.getMethod("main", String[].class);
            main.invoke(null, new Object[]{null});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void set(String key, String value) {
        System.setProperty(key, value);
    }

    public String get(String key) {
        return System.getProperty(key);
    }

    public void setServerIP(String ip) {
        this.setMCServerUrl("http://" + ip + ":8090/mc");
        this.setConfigUrl(ip + ":2181");
        this.set("fileserver", "http://" + ip + ":8100/fileserver/");
        this.set("imageServer.url", "http://" + ip + ":8100/fileserver/");
    }

    public void setMCServerUrl(String mcServerUrl) {
        this.set("mc.server.url", mcServerUrl);
    }

    public void setConfigUrl(String configUrl) {
        this.set("configUrl", configUrl);
    }

    public void setConfigUrl(String connectString, String user, String password) {
        if (user != null && password != null) {
            this.setConfigUrl(connectString + "?user=" + user + "&password=" + password);
        } else {
            this.setConfigUrl(connectString);
        }
    }

    public void setClusterNumber(String clusterNumber) {
        this.set("clusterName", clusterNumber);
    }

    public void setAppName(String appName) {
        this.setAppName(appName, true);
    }

    public void setAppName(String appName, boolean alsoSetQueueTag) {
        this.set("appName", appName);
        if (alsoSetQueueTag) {
            this.setQueueTag(appName);
        }
    }

    public void setStartWithQing(boolean b) {
        this.set("bos.app.special.deployalone.ids", b ? " " : "qing");
    }

    public void setTenantNumber(String tenantNumber) {
        this.set("domain.tenantCode", tenantNumber);
    }

    public void setXdbEnable(boolean enable) {
        this.set("xdb.enable", String.valueOf(enable));
    }

    public void setQueueTag(String tag) {
        this.set("mq.debug.queue.tag", tag);
    }

    public void setWebPath(String path) {
        this.set("JETTY_WEBRES_PATH", path);
    }

    public void setSqlOut(boolean outSQL, boolean withParameter) {
        this.set("db.sql.out", String.valueOf(outSQL));
        this.set("db.sql.out.withParameter", String.valueOf(withParameter));
    }
}

