/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.bos.launch;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.sdk.kingscript.log.Logs;
import org.slf4j.Logger;

public class MachineId {
    private static final Logger logger = Logs.getLogger();
    public static final String WINDOWS = "windows";
    public static final String LINUX = "linux";
    public static final String UNIX = "unix";
    public static final String REGEX = "\\b\\w+:\\w+:\\w+:\\w+:\\w+:\\w+\\b";
    private static String cacheId = null;

    private static String getWindowsMainBoardSerialNumber() {
        StringBuilder result = new StringBuilder();
        try {
            File file = File.createTempFile("realhowto", ".vbs");
            file.deleteOnExit();
            try (FileWriter fw = new FileWriter(file);){
                String vbs = "Set objWMIService = GetObject(\"winmgmts:\\\\.\\root\\cimv2\")\nSet colItems = objWMIService.ExecQuery _ \n   (\"Select * from Win32_BaseBoard\") \nFor Each objItem in colItems \n    Wscript.Echo objItem.SerialNumber \n    exit for  ' do the first cpu only! \nNext \n";
                fw.write(vbs);
                fw.close();
                Process p = Runtime.getRuntime().exec("cscript //NoLogo " + file.getPath());
                try (BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                    String line;
                    while ((line = input.readLine()) != null) {
                        result.append(line);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result.toString().trim();
    }

    private static String getLinuxMainBoardSerialNumber() {
        StringBuilder result = new StringBuilder();
        String maniBord_cmd = "dmidecode | grep 'Serial Number' | awk '{print $3}' | tail -1";
        try {
            Process p = Runtime.getRuntime().exec(new String[]{"sh", "-c", maniBord_cmd});
            try (BufferedReader br = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                String line = br.readLine();
                if (line != null) {
                    result.append(line);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result.toString();
    }

    private static String getMacFromBytes(byte[] bytes) {
        StringBuilder mac = new StringBuilder();
        boolean first = false;
        for (byte b : bytes) {
            if (first) {
                mac.append("-");
            }
            byte currentByte = (byte)((b & 0xF0) >> 4);
            mac.append(Integer.toHexString(currentByte));
            currentByte = (byte)(b & 0xF);
            mac.append(Integer.toHexString(currentByte));
            first = true;
        }
        return mac.toString().toUpperCase();
    }

    private static String getWindowsMACAddress() {
        InetAddress ip = null;
        NetworkInterface ni = null;
        ArrayList<String> macList = new ArrayList<String>();
        try {
            Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
            while (netInterfaces.hasMoreElements()) {
                ni = netInterfaces.nextElement();
                Enumeration<InetAddress> ips = ni.getInetAddresses();
                while (ips.hasMoreElements()) {
                    ip = ips.nextElement();
                    if (ip.isLoopbackAddress() || !ip.getHostAddress().matches("(\\d{1,3}\\.){3}\\d{1,3}")) continue;
                    macList.add(MachineId.getMacFromBytes(ni.getHardwareAddress()));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (macList.size() > 0) {
            return (String)macList.get(0);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getLinuxMACAddressForEth0() {
        String mac = null;
        BufferedReader bufferedReader = null;
        Process process = null;
        try {
            process = Runtime.getRuntime().exec("ifconfig eth0");
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            int index = -1;
            while ((line = bufferedReader.readLine()) != null) {
                index = line.toLowerCase().indexOf("hwaddr");
                if (index < 0) continue;
                mac = line.substring(index + "hwaddr".length() + 1).trim();
                break;
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
            bufferedReader = null;
            process = null;
        }
        return mac;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getLinuxMACAddress() {
        String mac = null;
        BufferedReader bufferedReader = null;
        Process process = null;
        try {
            process = Runtime.getRuntime().exec("ifconfig");
            bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String line = null;
            int index = -1;
            while ((line = bufferedReader.readLine()) != null) {
                Pattern pat = Pattern.compile(REGEX);
                Matcher mat = pat.matcher(line);
                if (!mat.find()) continue;
                mac = mat.group(0);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {}
            bufferedReader = null;
            process = null;
        }
        return mac;
    }

    private static String getWindowsProcessorIdentification() {
        StringBuilder result = new StringBuilder();
        try {
            File file = File.createTempFile("tmp", ".vbs");
            file.deleteOnExit();
            try (FileWriter fw = new FileWriter(file);){
                String vbs = "Set objWMIService = GetObject(\"winmgmts:\\\\.\\root\\cimv2\")\nSet colItems = objWMIService.ExecQuery _ \n   (\"Select * from Win32_Processor\") \nFor Each objItem in colItems \n    Wscript.Echo objItem.ProcessorId \n    exit for  ' do the first cpu only! \nNext \n";
                fw.write(vbs);
                fw.close();
                Process p = Runtime.getRuntime().exec("cscript //NoLogo " + file.getPath());
                try (BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                    String line;
                    while ((line = input.readLine()) != null) {
                        result.append(line);
                    }
                }
                if (!file.delete()) {
                    logger.info("\u5220\u9664\u6587\u4ef6\u5931\u8d25, \u6587\u4ef6\u8def\u5f84: " + file.getPath());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result.toString().trim();
    }

    private static String getLinuxProcessorIdentification() {
        String result = "";
        String CPU_ID_CMD = "dmidecode";
        BufferedReader bufferedReader = null;
        Process p = null;
        try {
            p = Runtime.getRuntime().exec(new String[]{"sh", "-c", CPU_ID_CMD});
            bufferedReader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            String line = null;
            int index = -1;
            while ((line = bufferedReader.readLine()) != null) {
                index = line.toLowerCase().indexOf("uuid");
                if (index < 0) continue;
                result = line.substring(index + "uuid".length() + 1).trim();
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result.trim();
    }

    public static String getOSName() {
        return System.getProperty("os.name").toLowerCase();
    }

    public static String getOSNamePrefix() {
        String name = MachineId.getOSName();
        if (name.startsWith(WINDOWS)) {
            return WINDOWS;
        }
        if (name.startsWith(LINUX)) {
            return LINUX;
        }
        if (name.startsWith(UNIX)) {
            return UNIX;
        }
        return "";
    }

    public static String getMainBoardSerialNumber() {
        switch (MachineId.getOSNamePrefix()) {
            case "windows": {
                return MachineId.getWindowsMainBoardSerialNumber();
            }
            case "linux": {
                return MachineId.getLinuxMainBoardSerialNumber();
            }
        }
        return "";
    }

    public static String getMACAddress() {
        switch (MachineId.getOSNamePrefix()) {
            case "windows": {
                return MachineId.getWindowsMACAddress();
            }
            case "linux": {
                String macAddressForEth0 = MachineId.getLinuxMACAddressForEth0();
                if (macAddressForEth0 == null || macAddressForEth0.length() == 0) {
                    macAddressForEth0 = MachineId.getLinuxMACAddress();
                }
                return macAddressForEth0;
            }
        }
        return "";
    }

    public static String getCPUIdentification() {
        switch (MachineId.getOSNamePrefix()) {
            case "windows": {
                return MachineId.getWindowsProcessorIdentification();
            }
            case "linux": {
                return MachineId.getLinuxProcessorIdentification();
            }
        }
        return "";
    }

    public static ComputerUniqueIdentification getComputerUniqueIdentification() {
        return new ComputerUniqueIdentification(MachineId.getOSNamePrefix(), MachineId.getMainBoardSerialNumber(), MachineId.getMACAddress(), MachineId.getCPUIdentification());
    }

    public static String getComputerUniqueIdentificationString() {
        return MachineId.getComputerUniqueIdentification().toString();
    }

    public static String getId() {
        if (cacheId == null) {
            String id = MachineId.getMainBoardSerialNumber();
            Map<String, String> env = System.getenv();
            if (id.isEmpty()) {
                id = env.getOrDefault("COMPUTERNAME", env.getOrDefault("USERDOMAIN_ROAMINGPROFILE", env.getOrDefault("USERDOMAIN", System.getProperty("user.name"))));
            }
            cacheId = id;
        }
        return cacheId;
    }

    private static class ComputerUniqueIdentification {
        private String namePrefix;
        private String mainBoardSerialNumber;
        private String MACAddress;
        private String CPUIdentification;

        public ComputerUniqueIdentification(String namePrefix, String mainBoardSerialNumber, String MACAddress, String CPUIdentification) {
            this.namePrefix = namePrefix;
            this.mainBoardSerialNumber = mainBoardSerialNumber;
            this.MACAddress = MACAddress;
            this.CPUIdentification = CPUIdentification;
        }

        public String toString() {
            return '{' + "\"namePrefix=\":\"" + this.namePrefix + "\"," + "\"mainBoardSerialNumber=\":\"" + this.mainBoardSerialNumber + "\"," + "\"MACAddress=\":\"" + this.MACAddress + "\"," + "\"CPUIdentification=\":\"" + this.CPUIdentification + "\"}";
        }
    }
}

