/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.bos.launch;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.function.Supplier;
import kd.sdk.bos.config.DebugThreadLocalRestorerImpl;
import kd.sdk.kingscript.config.ConfigurableItem;
import kd.sdk.kingscript.config.Env;
import kd.sdk.kingscript.debug.AutoDebugEngineManager;
import kd.sdk.kingscript.debug.DebugThreadLocalRestorer;
import kd.sdk.kingscript.engine.KingScriptEngine;
import kd.sdk.kingscript.engine.KingScriptEngineImpl;
import kd.sdk.kingscript.engine.ScriptInitializer;
import kd.sdk.kingscript.lib.LibModule;
import kd.sdk.kingscript.lib.provider.LibModuleProvider;
import kd.sdk.kingscript.lib.provider.ScriptProjectModuleProvider;
import kd.sdk.kingscript.log.Logs;
import kd.sdk.kingscript.monitor.cost.Collector;
import kd.sdk.kingscript.monitor.cost.Cost;
import kd.sdk.kingscript.monitor.report.ReportService;
import kd.sdk.kingscript.monitor.timeout.service.TimeoutConfigService;
import kd.sdk.kingscript.pool.CommonPoolNames;
import kd.sdk.kingscript.pool.KingScriptEnginePool;
import kd.sdk.kingscript.thread.recycle.ThreadEngineRecycle;
import kd.sdk.kingscript.types.ScriptValue;
import org.slf4j.Logger;

public final class ProjectInitializer {
    private static final Logger logger = Logs.getLogger();
    private static final String project_pool_name = CommonPoolNames.COSMIC_PLUGIN.name();
    @ConfigurableItem(desc="kingscript.env.project")
    public static final String KINGSCRIPT_CONFIG_ENV_PROJECT = "kingscript.env.project";
    @ConfigurableItem(desc="kingscript.env.initialize")
    public static final String KINGSCRIPT_CONFIG_ENV_INITIALIZE = "kingscript.env.initialize";
    @ConfigurableItem(desc="kingscript.debug.enable")
    public static final String KINGSCRIPT_CONFIG_DEBUG = "kingscript.debug.enable";
    @ConfigurableItem(desc="kingscript.collector.enable")
    public static final String KINGSCRIPT_COLLECTOR_ENABLE = "kingscript.collector.enable";
    @ConfigurableItem(desc="pool.activeSize")
    public static final String KINGSCRIPT_CONFIG_POOL_ACTIVE_SIZE = "kingscript.pool.activeSize";
    @ConfigurableItem(desc="pool.maxSize")
    public static final String KINGSCRIPT_CONFIG_POOL_MAX_SIZE = "kingscript.pool.maxSize";
    @ConfigurableItem(desc="debug.pool.activeSize")
    public static final String KINGSCRIPT_CONFIG_DEBUG_POOL_ACTIVE_SIZE = "kingscript.debug.pool.activeSize";
    @ConfigurableItem(desc="debug.pool.maxSize")
    public static final String KINGSCRIPT_CONFIG_DEBUG_POOL_MAX_SIZE = "kingscript.debug.pool.maxSize";
    @ConfigurableItem(desc="kingscript.preheat.editor.modules")
    public static final String KINGSCRIPT_CONFIG_PREHEAT_EDITOR_MODULES = "kingscript.preheat.editor.modules";
    @ConfigurableItem(desc="DEFAULT_PREHEAT_EDITOR_MODULES")
    public static final String DEFAULT_PREHEAT_EDITOR_MODULES = "@cosmic/bos-framework,@cosmic/bos-core,@cosmic/bos-util,@cosmic/bos-script";
    private static boolean debuggable = true;
    private static String[] preheat;
    private static final String project_env_init_script_export_config = "Config";
    private static final String project_env_init_script_export_config_preheat = "preheat";
    private static final String project_env_init_script_export_config_debug = "debug";
    private static String project_env_initialize_script_path;
    private static volatile AutoDebugEngineManager autoDebugEngineManager;
    private static final Object autoDebugEngineManagerLock;

    public static void setEnvInitialize(String envInitializeScriptPath) {
        System.setProperty(KINGSCRIPT_CONFIG_ENV_INITIALIZE, envInitializeScriptPath);
        project_env_initialize_script_path = envInitializeScriptPath;
    }

    public static KingScriptEngine getEngineAutoDebug(String scriptPath) {
        return ProjectInitializer.getEngineAutoDebugWithDefaultNonDebugEngine(scriptPath, () -> ProjectInitializer.getEngine(false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KingScriptEngine getEngineAutoDebugWithDefaultNonDebugEngine(String scriptPath, Supplier<KingScriptEngine> defaultNonDebugEngine) {
        if (debuggable) {
            if (autoDebugEngineManager == null) {
                Object object = autoDebugEngineManagerLock;
                synchronized (object) {
                    if (autoDebugEngineManager == null) {
                        autoDebugEngineManager = new AutoDebugEngineManager(project_pool_name, () -> ProjectInitializer.getEngine(false), () -> ProjectInitializer.getEngine(true));
                    }
                }
            }
            return autoDebugEngineManager.getEngine(scriptPath);
        }
        return defaultNonDebugEngine == null ? ProjectInitializer.getEngine(false) : defaultNonDebugEngine.get();
    }

    public static KingScriptEngine getEngine(boolean debug) {
        KingScriptEnginePool pool = debug && debuggable ? KingScriptEnginePool.getDebug((String)project_pool_name) : KingScriptEnginePool.get((String)project_pool_name);
        KingScriptEngine engine = pool.acquire();
        ThreadEngineRecycle.hookRecycle((KingScriptEngine)engine);
        return engine;
    }

    public static boolean isDebugEnabled() {
        return debuggable;
    }

    public static void initialize(String projectPath, String ... libProjectPaths) {
        ProjectInitializer.initialize(projectPath, (LibModuleProvider)(libProjectPaths == null ? null : new ScriptProjectModuleProvider(libProjectPaths)), null);
    }

    static void initialize(String projectPath, LibModuleProvider libModuleProvider, ScriptInitializer customInitializer) {
        String newPaths;
        long ts = System.currentTimeMillis();
        ReportService.start();
        TimeoutConfigService.preheat();
        Collector.setEnabled((boolean)Boolean.parseBoolean(System.getProperty(KINGSCRIPT_COLLECTOR_ENABLE, String.valueOf(Collector.isEnabled()))));
        Env.autoSetupEnv();
        ArrayList projectLibModules = new ArrayList(new ScriptProjectModuleProvider(new String[]{projectPath}).getLibModules());
        if (libModuleProvider != null) {
            projectLibModules.addAll(libModuleProvider.getLibModules());
        }
        KingScriptEngine initEngine = KingScriptEngine.create(scriptOptions -> {
            for (LibModule libModule : projectLibModules) {
                scriptOptions.addModule(libModule);
            }
            if (customInitializer != null) {
                customInitializer.initialize(scriptOptions);
            }
        });
        ProjectInitializer.runInitializeScript(initEngine);
        String[] preheatScriptPaths = ((KingScriptEngineImpl)initEngine).getOptions().getPreheatScriptPaths();
        CountDownLatch cdInitialized = new CountDownLatch(2);
        ProjectInitializer.preListModuleExports(initEngine, cdInitialized, ts);
        String string = newPaths = preheat == null ? "[]" : Arrays.asList(preheat).toString();
        if (!Objects.deepEquals(preheat, preheatScriptPaths)) {
            String oldPaths = preheatScriptPaths == null ? "[]" : Arrays.asList(preheatScriptPaths).toString();
            logger.info("\u5f15\u64ce\u9884\u70ed\u811a\u672c\u914d\u7f6e\u53d8\u5316: " + oldPaths + " -> " + newPaths);
        } else {
            logger.info("\u5f15\u64ce\u9884\u70ed\u811a\u672c\u914d\u7f6e: " + newPaths);
        }
        Runnable target = () -> {
            logger.info("Initialize kingscript engine pool...");
            try (Cost cost = Collector.cost((String)"ProjectInitializer.initializeEnginePool", (String)(debuggable ? "with debug" : "without debug")).logOnClose();){
                ScriptInitializer normalInit = ProjectInitializer.createScriptInitializer(customInitializer, projectLibModules, false);
                KingScriptEnginePool.get((String)project_pool_name).initialize(Integer.parseInt(System.getProperty(KINGSCRIPT_CONFIG_POOL_ACTIVE_SIZE, "64")), Integer.parseInt(System.getProperty(KINGSCRIPT_CONFIG_POOL_MAX_SIZE, "400")), normalInit);
                if (debuggable) {
                    ScriptInitializer debugInit = ProjectInitializer.createScriptInitializer(customInitializer, projectLibModules, true);
                    KingScriptEnginePool.getDebug((String)project_pool_name).initialize(Integer.parseInt(System.getProperty(KINGSCRIPT_CONFIG_DEBUG_POOL_ACTIVE_SIZE, "16")), Integer.parseInt(System.getProperty(KINGSCRIPT_CONFIG_DEBUG_POOL_MAX_SIZE, "100")), debugInit);
                }
                long used = System.currentTimeMillis() - ts;
                logger.info("Initialize kingscript engine pool completed, used " + used + "ms");
            }
            catch (Throwable e) {
                logger.error("Initialize kingscript engine pool error: " + e.getMessage(), e);
            }
            finally {
                cdInitialized.countDown();
            }
        };
        ProjectInitializer.runAsync("KingScript-ProjectInitializer-initializeEnginePool", target);
        if (Collector.isEnabled()) {
            ProjectInitializer.runAsync("KingScript-Collector-log", () -> {
                try {
                    cdInitialized.await();
                    long used = System.currentTimeMillis() - ts;
                    logger.info("Initialize kingscript engine pool & listModuleExports completed, used " + used + "ms");
                    Collector.log();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
        }
        long used = System.currentTimeMillis() - ts;
        logger.info("Call ProjectInitializer.initialize used " + used + "ms");
    }

    private static void preListModuleExports(KingScriptEngine initEngine, CountDownLatch cdInitialized, long ts) {
        Runnable target = () -> {
            String[] modules = System.getProperty(KINGSCRIPT_CONFIG_PREHEAT_EDITOR_MODULES, DEFAULT_PREHEAT_EDITOR_MODULES).split(",");
            HashSet<String> list = new HashSet<String>();
            for (int i = 0; i < modules.length; ++i) {
                String module = modules[i].trim();
                if (module.isEmpty()) continue;
                list.add(module);
            }
            logger.info("listModuleExports for ScriptEditor: " + list);
            initEngine.enter();
            try (Cost cost = Collector.cost((String)"ProjectInitializer.preListModuleExports", (String)"listModuleExports").logOnClose();){
                initEngine.listModuleExports(list.toArray(new String[list.size()]));
                long used = System.currentTimeMillis() - ts;
                logger.info("listModuleExports completed, used " + used + "ms");
            }
            catch (Throwable e) {
                logger.error("listModuleExports error: " + e.getMessage(), e);
            }
            finally {
                initEngine.leave();
                initEngine.close();
                cdInitialized.countDown();
            }
        };
        ProjectInitializer.runAsync("KingScript-ProjectInitializer-preListModuleExports", target);
    }

    private static void runAsync(String name, Runnable target) {
        logger.info("run async: " + name);
        Thread th = new Thread(target);
        th.setName(name);
        th.setDaemon(true);
        th.start();
    }

    private static ScriptInitializer createScriptInitializer(ScriptInitializer customInitializer, List<LibModule> projectLibModules, boolean debug) {
        return scriptOptions -> {
            if (preheat != null) {
                scriptOptions.setPreheatScriptPaths(preheat);
            }
            for (LibModule libModule : projectLibModules) {
                scriptOptions.addModule(libModule);
            }
            if (customInitializer != null) {
                customInitializer.initialize(scriptOptions);
            }
            if (debug) {
                scriptOptions.getDebugOptions().setThreadLocalRestorer((DebugThreadLocalRestorer)new DebugThreadLocalRestorerImpl());
            }
        };
    }

    private static void runInitializeScript(KingScriptEngine engine) {
        try (Cost cost = Collector.cost((String)"ProjectInitializer.runInitializeScript", (String)project_env_initialize_script_path).logOnClose();){
            engine.evalPath(project_env_initialize_script_path);
            ScriptValue scriptConfig = engine.getBindings().getExport().getMember(project_env_init_script_export_config);
            if (scriptConfig != null && scriptConfig.hasMembers()) {
                ScriptValue preheatValue;
                ScriptValue debugValue = scriptConfig.getMember(project_env_init_script_export_config_debug);
                if (debugValue != null && debugValue.isBoolean() && debugValue.asBoolean()) {
                    debuggable = true;
                }
                if ((preheatValue = scriptConfig.getMember(project_env_init_script_export_config_preheat)) != null) {
                    List list = (List)preheatValue.as(List.class);
                    preheat = new String[list.size()];
                    for (int i = 0; i < preheat.length; ++i) {
                        ProjectInitializer.preheat[i] = (String)list.get(i);
                    }
                }
            }
        }
        debuggable = Boolean.parseBoolean(System.getProperty(KINGSCRIPT_CONFIG_DEBUG, String.valueOf(debuggable)));
    }

    static {
        project_env_initialize_script_path = System.getProperty(KINGSCRIPT_CONFIG_ENV_INITIALIZE, "/@cosmic/bos-framework/@env/initialize");
        autoDebugEngineManagerLock = new Object();
    }
}

