/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.bos.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import kd.bos.cache.CacheFactory;
import kd.bos.dts.lock.Lock;
import kd.bos.dts.lock.LockFactory;
import kd.bos.kingscript.api.ScriptLibService;
import kd.bos.session.EncreptSessionUtils;
import kd.sdk.bos.service.FileFilter;
import kd.sdk.bos.service.TypeScriptPackageFileFilter;
import kd.sdk.bos.service.ZipDirectory;
import kd.sdk.kingscript.log.Logs;
import org.slf4j.Logger;

public class ScriptLibServiceImpl
implements ScriptLibService {
    private static final Logger logger = Logs.getLogger();

    public String uploadLib() {
        String scriptModulesDir = "script_modules";
        File root = new File("script_modules");
        if (root.exists()) {
            try {
                return this.createZipAndUpload(root);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createZipAndUpload(File root) throws IOException {
        String zipUrl = "";
        File zipFile = null;
        try (Lock lock = LockFactory.create((String)"kingscript-poll-sdkzip");){
            boolean isLock = lock.lock();
            if (!isLock) {
                String string = zipUrl;
                return string;
            }
            zipFile = ZipDirectory.gen(root, String.format("script_modules_%s.zip", System.currentTimeMillis()), (FileFilter)TypeScriptPackageFileFilter.getInstance());
            try (FileInputStream zipStream = new FileInputStream(zipFile);){
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
                LocalDateTime now = LocalDateTime.now();
                String fileName = "script_modules_" + now.format(formatter) + ".zip";
                zipUrl = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(fileName, (InputStream)zipStream, 5000);
                zipUrl = EncreptSessionUtils.encryptSession((String)zipUrl);
            }
            catch (FileNotFoundException e) {
                logger.error("SDKService.createZipAndUpload-" + zipFile, (Throwable)e);
                e.printStackTrace();
            }
        }
        finally {
            if (zipFile != null && zipFile.exists()) {
                zipFile.delete();
            }
        }
        return zipUrl;
    }
}

