/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.bos.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import kd.sdk.bos.service.FileFilter;
import kd.sdk.kingscript.log.Logs;
import org.slf4j.Logger;

public class TypeScriptPackageFileFilter
implements FileFilter {
    private static final Logger logger = Logs.getLogger();
    private static TypeScriptPackageFileFilter instance;

    private TypeScriptPackageFileFilter() {
    }

    public static TypeScriptPackageFileFilter getInstance() {
        if (instance == null) {
            instance = new TypeScriptPackageFileFilter();
        }
        return instance;
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return false;
        }
        if (TypeScriptPackageFileFilter.isFileEmpty(file)) {
            return false;
        }
        String fileName = file.getName();
        if (fileName.equals("package.json")) {
            return true;
        }
        return fileName.endsWith(".d.ts");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isFileEmpty(File file) {
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            boolean bl = br.read() == -1;
            return bl;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return true;
        }
    }
}

