/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.bos.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.util.FileUtils;
import kd.sdk.bos.service.DefaultFileFilter;
import kd.sdk.bos.service.FileFilter;

public class ZipDirectory {
    public static File gen(File dir, String zipPath, FileFilter fileFilter) {
        File zipFile;
        try {
            String property = System.getProperty("user.home");
            String FILEPATH = FileUtils.cleanString((String)(property + File.separator + zipPath));
            zipFile = new File(FILEPATH);
            ZipDirectory.gen(dir, zipFile, fileFilter);
        }
        catch (IOException e) {
            throw new KDException((Throwable)e, new ErrorCode("", String.format(ResManager.loadKDString((String)"\u6587\u4ef6\u538b\u7f29\u65f6\u76ee\u5f55\u5f02\u5e38", (String)"FileHandlerUtil_2", (String)"bos-svc-common", (Object[])new Object[0]), e.getMessage())), new Object[0]);
        }
        return zipFile;
    }

    public static void gen(File dir, File zipFile, FileFilter fileFilter) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(zipFile);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            ZipDirectory.zipSubDirectory("", dir, zos, fileFilter);
        }
    }

    private static void zipSubDirectory(String basePath, File dir, ZipOutputStream zos, FileFilter fileFilter) throws IOException {
        byte[] buffer = new byte[4096];
        File[] files = dir.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                String path = basePath + file.getName() + "/";
                zos.putNextEntry(new ZipEntry(path));
                ZipDirectory.zipSubDirectory(path, file, zos, fileFilter);
                continue;
            }
            if (!fileFilter.accept(file)) continue;
            try (FileInputStream fis = new FileInputStream(file);){
                int length;
                zos.putNextEntry(new ZipEntry(basePath + file.getName()));
                while ((length = fis.read(buffer)) > 0) {
                    zos.write(buffer, 0, length);
                }
            }
        }
    }

    public static void main(String[] args) throws IOException {
        File dirToZip = new File("/path/to/folder");
        File outputZip = new File("/path/to/output.zip");
        ZipDirectory.gen(dirToZip, outputZip, (FileFilter)new DefaultFileFilter());
    }
}

