/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.bos.util.cache;

import java.util.ConcurrentModificationException;
import java.util.Map;
import java.util.Objects;
import kd.sdk.annotation.SdkScriptBound;
import kd.sdk.bos.util.cache.LRUCache;
import kd.sdk.kingscript.types.adapter.ForEachMapFunction;

@SdkScriptBound(value="@cosmic/bos-util/cache")
public final class ScriptLRUCache<K, V> {
    private final LRUCache<K, V> cache;

    public ScriptLRUCache(int maxCacheSize) {
        this.cache = new LRUCache(maxCacheSize);
    }

    public ScriptLRUCache(int maxCacheSize, int initialCapacity) {
        this.cache = new LRUCache(maxCacheSize, initialCapacity);
    }

    public V get(K key) {
        return this.cache.get(key);
    }

    public V set(K key, V value) {
        return this.cache.put(key, value);
    }

    public V remove(K key) {
        return this.cache.remove(key);
    }

    public boolean containsKey(K key) {
        return this.cache.containsKey(key);
    }

    public void clear() {
        this.cache.clear();
    }

    public void forEach(ForEachMapFunction<K, V> consume) {
        this.forEach(consume, null);
    }

    public void forEach(ForEachMapFunction<K, V> consume, Object thisArg) {
        Objects.requireNonNull(consume);
        for (Map.Entry entry : this.cache.entrySet()) {
            Object v;
            Object k;
            try {
                k = entry.getKey();
                v = entry.getValue();
            }
            catch (IllegalStateException ise) {
                throw new ConcurrentModificationException(ise);
            }
            consume.forEach(k, v, thisArg);
        }
    }

    public int size() {
        return this.cache.size();
    }

    public boolean isEmpty() {
        return this.cache.isEmpty();
    }
}

