/*
 * Decompiled with CFR 0.152.
 */
package kd.sdk.bos.util.http;

import java.util.HashMap;
import java.util.Map;
import kd.sdk.annotation.SdkScriptBound;

@SdkScriptBound(value="@cosmic/bos-util/http")
public final class HttpClientOptions {
    private Map<String, String> header = new HashMap<String, String>();
    private int connectionTimeout = Integer.getInteger("httpclient.connectionTimeout", 3000);
    private int readTimeout = Integer.getInteger("httpclient.readTimeout", 5000);

    public static HttpClientOptions create() {
        return new HttpClientOptions();
    }

    private HttpClientOptions() {
    }

    public HttpClientOptions header(String name, String value) {
        this.header.put(name, value);
        return this;
    }

    public Map<String, String> header() {
        return this.header;
    }

    public int connectionTimeout() {
        return this.connectionTimeout;
    }

    public HttpClientOptions connectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
        return this;
    }

    public int readTimeout() {
        return this.readTimeout;
    }

    public HttpClientOptions readTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }
}

