/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.botp;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.botp.LogTable;
import kd.bos.data.BusinessDataReader;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.log.AbstractDetailLogInfo;
import kd.bos.entity.botp.log.BOTPLog;
import kd.bos.entity.botp.log.DetailLogInfoFactory;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;

public class BOTPLogService {
    private static final Log LOG = LogFactory.getLog(BOTPLogService.class);
    private static Map<String, MainEntityType> BOTP_LOG_TYPES = new ConcurrentHashMap<String, MainEntityType>();
    private static final String FORMID_BOTP_LOG = "botp_log";
    private static final String KEY_ID = "id";
    private static final String KEY_PARENTID = "parentid";
    private static final String KEY_TASKID = "taskid";
    private static final String KEY_SENTITYNUMBER = "sentitynumber";
    private static final String KEY_STABLEID = "stableid";
    private static final String KEY_SBILLID = "sbillid";
    private static final String KEY_SBILLNO = "sbillno";
    private static final String KEY_TENTITYNUMBER = "tentitynumber";
    private static final String KEY_TTABLEID = "ttableid";
    private static final String KEY_TBILLID = "tbillid";
    private static final String KEY_TBILLNO = "tbillno";
    private static final String KEY_USERID = "userid";
    private static final String KEY_OPTYPE = "optype";
    private static final String KEY_STARTTIME = "starttime";
    private static final String KEY_ENDTIME = "endtime";
    private static final String KEY_STATUS = "status";
    private static final String KEY_LOGTYPE = "logtype";
    private static final String KEY_ZIP_VER = "zipver";
    private static final String KEY_DATA = "data";
    private static final String KEY_DATA_TAG = "data_tag";
    private Date endTime = new Date();

    private static synchronized MainEntityType getLogType(String dbRouteKey) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)FORMID_BOTP_LOG);
        MainEntityType cacheType = BOTP_LOG_TYPES.get(dbRouteKey);
        if (cacheType != null && !StringUtils.equals((CharSequence)mainType.getVersion(), (CharSequence)cacheType.getVersion())) {
            cacheType = null;
        }
        if (cacheType == null) {
            try {
                cacheType = (MainEntityType)mainType.clone();
            }
            catch (CloneNotSupportedException exp) {
                throw new KDException((Throwable)exp, new ErrorCode("BOTPLogService.getLogType", exp.getMessage()), new Object[0]);
            }
            cacheType.setDBRouteKey(dbRouteKey);
            BOTP_LOG_TYPES.put(dbRouteKey, cacheType);
        }
        return cacheType;
    }

    public BOTPLog[] load(String dbRouteKey, Long[] logIds) {
        if (StringUtils.isBlank((CharSequence)dbRouteKey) || logIds == null || logIds.length == 0) {
            return new BOTPLog[0];
        }
        MainEntityType mainType = BOTPLogService.getLogType(dbRouteKey);
        DBRoute dbRoute = new DBRoute(dbRouteKey);
        if (!LogTable.existTable(dbRoute).booleanValue()) {
            return new BOTPLog[0];
        }
        Object[] ids = new Object[logIds.length];
        System.arraycopy(logIds, 0, ids, 0, logIds.length);
        DynamicObject[] objs = BusinessDataReader.load((Object[])ids, (DynamicObjectType)mainType, (Boolean)false);
        ArrayList<BOTPLog> logs = new ArrayList<BOTPLog>(10);
        for (DynamicObject obj : objs) {
            BOTPLog log = this.buildBOTPLog(obj);
            logs.add(log);
        }
        return logs.toArray(new BOTPLog[0]);
    }

    public BOTPLog[] loadSimpleLogs(String dbRouteKey, final Long[] logIds) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid, fparentid, ftaskid", new Object[0]);
        sqlBuilder.append(", fsentitynumber, fstableid, fsbillid, fsbillno", new Object[0]);
        sqlBuilder.append(", ftentitynumber, fttableid, ftbillid, ftbillno", new Object[0]);
        sqlBuilder.append(", foptype, fuserid, fstarttime, fendtime", new Object[0]);
        sqlBuilder.append(", flogtype, fstatus, fdata ", new Object[0]);
        sqlBuilder.append(" from t_botp_log", new Object[0]);
        sqlBuilder.append(" where ", new Object[0]);
        sqlBuilder.appendIn("fid", (Object[])logIds);
        ResultSetHandler<List<BOTPLog>> action = new ResultSetHandler<List<BOTPLog>>(){

            public List<BOTPLog> handle(ResultSet rs) throws SQLException {
                ArrayList<BOTPLog> logList = new ArrayList<BOTPLog>(logIds.length);
                while (rs.next()) {
                    BOTPLog log = new BOTPLog();
                    log.setId(rs.getLong("fid"));
                    log.setParentId(rs.getLong("fparentid"));
                    log.setTaskId(rs.getLong("ftaskid"));
                    log.setSentityNumber(rs.getString("fsentitynumber"));
                    log.setSTableId(rs.getLong("fstableid"));
                    log.setSBillId(rs.getLong("fsbillid"));
                    log.setSBillno(rs.getString("fsbillno"));
                    log.setTentityNumber(rs.getString("ftentitynumber"));
                    log.setTTableId(rs.getLong("fttableid"));
                    log.setTBillId(rs.getLong("ftbillid"));
                    log.setTBillno(rs.getString("ftbillno"));
                    log.setOpType(rs.getString("foptype"));
                    log.setUserId(rs.getLong("fuserid"));
                    log.setStartTime((Date)rs.getTimestamp("fstarttime"));
                    log.setEndTime((Date)rs.getTimestamp("fendtime"));
                    log.setLogType(rs.getString("flogtype"));
                    log.setStatus(rs.getString("fstatus"));
                    log.setRemark(rs.getString("fdata"));
                    logList.add(log);
                }
                return logList;
            }
        };
        List logs = (List)DB.query((DBRoute)new DBRoute(dbRouteKey), (SqlBuilder)sqlBuilder, (ResultSetHandler)action);
        return logs.toArray(new BOTPLog[0]);
    }

    public BOTPLog[] loadByParentIds(String dbRouteKey, final Long[] parentIds) {
        if (StringUtils.isBlank((CharSequence)dbRouteKey) || parentIds == null || parentIds.length == 0) {
            return new BOTPLog[0];
        }
        DBRoute dbRoute = new DBRoute(dbRouteKey);
        if (!LogTable.existTable(dbRoute).booleanValue()) {
            return new BOTPLog[0];
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fid, fparentid", new Object[0]);
        sqlBuilder.append(" from t_botp_log", new Object[0]);
        sqlBuilder.append(" where ", new Object[0]);
        sqlBuilder.appendIn("fparentid", (Object[])parentIds);
        ResultSetHandler<List<Long>> action = new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws SQLException {
                ArrayList<Long> ids = new ArrayList<Long>(parentIds.length);
                while (rs.next()) {
                    ids.add(rs.getLong("fid"));
                }
                return ids;
            }
        };
        List logIds = (List)DB.query((DBRoute)new DBRoute(dbRouteKey), (SqlBuilder)sqlBuilder, (ResultSetHandler)action);
        return this.load(dbRouteKey, logIds.toArray(new Long[0]));
    }

    public void addLogs(String dbRouteKey, BOTPLog[] logs, OperateOption option) {
        if (StringUtils.isBlank((CharSequence)dbRouteKey) || logs == null || logs.length == 0) {
            return;
        }
        if (option == null) {
            option = OperateOption.create();
        }
        MainEntityType mainType = BOTPLogService.getLogType(dbRouteKey);
        Object[] objs = new DynamicObject[logs.length];
        for (int i = 0; i < objs.length; ++i) {
            DynamicObject obj;
            BOTPLog log = logs[i];
            if (log == null) continue;
            objs[i] = obj = this.buildLogObject(mainType, log);
        }
        LogTable.createTable(new DBRoute(dbRouteKey));
        try (TXHandle h = TX.requiresNew();){
            try {
                BusinessDataWriter.save((IDataEntityType)mainType, (Object[])objs, (OperateOption)option);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public void updateLogStatus(String dbRouteKey, Long[] logIds, String status, OperateOption option) {
        if (logIds == null || logIds.length == 0) {
            return;
        }
        String updateSql = "update t_botp_log set fstatus = ?, fendtime = ? where fid = ?";
        ArrayList<SqlParameter[]> paramsList = new ArrayList<SqlParameter[]>(logIds.length);
        for (Long logId : logIds) {
            SqlParameter[] params = new SqlParameter[]{new SqlParameter("fstatus", 1, (Object)status), new SqlParameter("fendtime", 91, (Object)this.endTime), new SqlParameter("fid", -5, (Object)logId)};
            paramsList.add(params);
        }
        LogTable.createTable(new DBRoute(dbRouteKey));
        try (TXHandle h = TX.requiresNew();){
            try {
                DB.executeBatch((DBRoute)new DBRoute(dbRouteKey), (String)updateSql, paramsList);
            }
            catch (Throwable e) {
                h.markRollback();
                LOG.warn(e);
            }
        }
    }

    public void delete(String dbRouteKey, Date lastDate, String logType) {
        Object[] params;
        String deleteSql;
        DBRoute dbRoute = new DBRoute(dbRouteKey);
        if (!LogTable.existTable(dbRoute).booleanValue()) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)logType)) {
            deleteSql = "delete t_botp_log where fstarttime < ?";
            params = new SqlParameter[]{new SqlParameter("fstarttime", 91, (Object)lastDate)};
        } else {
            deleteSql = "delete t_botp_log where fstarttime < ? and flogtype = ?";
            params = new SqlParameter[]{new SqlParameter("fstarttime", 91, (Object)lastDate), new SqlParameter("flogtype", 1, (Object)logType)};
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                DB.execute((DBRoute)dbRoute, (String)deleteSql, (Object[])params);
            }
            catch (Throwable e) {
                h.markRollback();
                LOG.error(e);
                throw e;
            }
        }
    }

    public Boolean existBotpLogTable(String dbRouteKey) {
        DBRoute dbRoute = new DBRoute(dbRouteKey);
        return LogTable.existTable(dbRoute);
    }

    public void delete(String dbRouteKey, Long[] ids) {
        DBRoute dbRoute = new DBRoute(dbRouteKey);
        if (!LogTable.existTable(dbRoute).booleanValue()) {
            return;
        }
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("delete t_botp_log where ", new Object[0]);
        sqlBuilder.appendIn("fid", (Object[])ids);
        try (TXHandle h = TX.requiresNew();){
            try {
                DB.execute((DBRoute)dbRoute, (SqlBuilder)sqlBuilder);
            }
            catch (Throwable e) {
                h.markRollback();
                LOG.error(e);
                throw e;
            }
        }
    }

    public void deleteWBLogs(String dbRouteKey, final Long[] wbLogIds) {
        if (StringUtils.isBlank((CharSequence)dbRouteKey) || wbLogIds == null || wbLogIds.length == 0) {
            return;
        }
        DBRoute dbRoute = new DBRoute(dbRouteKey);
        SqlBuilder sqlBuilder1 = new SqlBuilder();
        sqlBuilder1.append("select fid, fparentid", new Object[0]);
        sqlBuilder1.append(" from t_botp_log", new Object[0]);
        sqlBuilder1.append(" where ", new Object[0]);
        sqlBuilder1.appendIn("fid", (Object[])wbLogIds);
        ResultSetHandler<List<Long>> action1 = new ResultSetHandler<List<Long>>(){

            public List<Long> handle(ResultSet rs) throws SQLException {
                ArrayList<Long> ids = new ArrayList<Long>(wbLogIds.length);
                while (rs.next()) {
                    ids.add(rs.getLong("fparentid"));
                }
                return ids;
            }
        };
        final List tcLogIds = (List)DB.query((DBRoute)dbRoute, (SqlBuilder)sqlBuilder1, (ResultSetHandler)action1);
        this.delete(dbRouteKey, wbLogIds);
        if (CollectionUtils.isEmpty((Collection)tcLogIds)) {
            return;
        }
        SqlBuilder sqlBuilder2 = new SqlBuilder();
        sqlBuilder2.append("select fid, fparentid", new Object[0]);
        sqlBuilder2.append(" from t_botp_log", new Object[0]);
        sqlBuilder2.append(" where ", new Object[0]);
        sqlBuilder2.appendIn("fparentid", (Object[])tcLogIds.toArray(new Long[0]));
        ResultSetHandler<Set<Long>> action2 = new ResultSetHandler<Set<Long>>(){

            public Set<Long> handle(ResultSet rs) throws SQLException {
                HashSet<Long> ids = new HashSet<Long>(tcLogIds.size());
                while (rs.next()) {
                    ids.add(rs.getLong("fparentid"));
                }
                return ids;
            }
        };
        Set existTCLogIds = (Set)DB.query((DBRoute)dbRoute, (SqlBuilder)sqlBuilder2, (ResultSetHandler)action2);
        ArrayList<Long> nochildTCLogIds = new ArrayList<Long>(tcLogIds.size());
        for (Long tcLogId : tcLogIds) {
            if (existTCLogIds.contains(tcLogId)) continue;
            nochildTCLogIds.add(tcLogId);
        }
        if (!nochildTCLogIds.isEmpty()) {
            this.delete(dbRouteKey, nochildTCLogIds.toArray(new Long[0]));
        }
    }

    private DynamicObject buildLogObject(MainEntityType mainType, BOTPLog log) {
        DynamicObject obj = new DynamicObject((DynamicObjectType)mainType);
        obj.set(KEY_ID, (Object)log.getId());
        obj.set(KEY_PARENTID, (Object)log.getParentId());
        obj.set(KEY_TASKID, (Object)log.getTaskId());
        obj.set(KEY_SENTITYNUMBER, (Object)log.getSentityNumber());
        obj.set(KEY_STABLEID, (Object)log.getSTableId());
        obj.set(KEY_SBILLID, (Object)log.getSBillId());
        obj.set(KEY_SBILLNO, (Object)log.getSBillno());
        obj.set(KEY_TENTITYNUMBER, (Object)log.getTentityNumber());
        obj.set(KEY_TTABLEID, (Object)log.getTTableId());
        obj.set(KEY_TBILLID, (Object)log.getTBillId());
        obj.set(KEY_TBILLNO, (Object)log.getTBillno());
        obj.set(KEY_OPTYPE, (Object)log.getOpType());
        obj.set(KEY_USERID, (Object)log.getUserId());
        obj.set(KEY_STARTTIME, (Object)log.getStartTime());
        if (log.getEndTime() != null) {
            obj.set(KEY_ENDTIME, (Object)log.getEndTime());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)log.getStatus(), (CharSequence)"1")) {
            obj.set(KEY_ENDTIME, (Object)this.endTime);
        }
        obj.set(KEY_STATUS, (Object)log.getStatus());
        obj.set(KEY_LOGTYPE, (Object)log.getLogType());
        String ver = "";
        obj.set(KEY_ZIP_VER, (Object)ver);
        obj.set(KEY_DATA, (Object)log.getRemark());
        if (log.getDetailInfo() != null) {
            String detail = DetailLogInfoFactory.toJsonString((AbstractDetailLogInfo)log.getDetailInfo(), (String)ver);
            obj.set(KEY_DATA_TAG, (Object)detail);
        }
        return obj;
    }

    private BOTPLog buildBOTPLog(DynamicObject obj) {
        BOTPLog log = new BOTPLog();
        log.setId(((Long)obj.getPkValue()).longValue());
        log.setParentId(obj.getLong(KEY_PARENTID));
        log.setTaskId(obj.getLong(KEY_TASKID));
        log.setSentityNumber(obj.getString("sentitynumber_id"));
        log.setSTableId(obj.getLong(KEY_STABLEID));
        log.setSBillId(obj.getLong(KEY_SBILLID));
        log.setSBillno(obj.getString(KEY_SBILLNO));
        log.setTentityNumber(obj.getString("tentitynumber_id"));
        log.setTTableId(obj.getLong(KEY_TTABLEID));
        log.setTBillId(obj.getLong(KEY_TBILLID));
        log.setTBillno(obj.getString(KEY_TBILLNO));
        log.setOpType(obj.getString(KEY_OPTYPE));
        log.setUserId(obj.getLong("userid_id"));
        log.setStartTime(obj.getDate(KEY_STARTTIME));
        log.setEndTime(obj.getDate(KEY_ENDTIME));
        log.setStatus(obj.getString(KEY_STATUS));
        log.setLogType(obj.getString(KEY_LOGTYPE));
        log.setRemark(obj.getString(KEY_DATA));
        String zipVer = obj.getString(KEY_ZIP_VER);
        log.setZipVer(zipVer);
        String json = obj.getString(KEY_DATA_TAG);
        AbstractDetailLogInfo detailInfo = DetailLogInfoFactory.fromJsonString((String)log.getLogType(), (String)zipVer, (String)json);
        log.setDetailInfo(detailInfo);
        return log;
    }
}

