/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.botp;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.botp.EntryTrackReader;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;

final class BillTrackReader {
    private static final String FORM_BOTP_BILLTRACKER = "botp_billtracker";
    private static final String KEY_S_TABLEID = "stableid";
    private static final String KEY_S_BILLID = "sbillid";
    private static final String KEYS_TTABLEID_TBILLID = "ttableid, tbillid";
    private static final String KEYS_STABLEID_SBILLID_TTABLEID_TBILLID = "stableid, sbillid, ttableid, tbillid";
    private static final String ALGO_KEY_READ_DOWN_BILL_BFROWIDS = "kd.bos.botp.BillTrackReader.readDownBillBFRowIds";
    private static final String ALGO_KEY_READ_DOWN_BILL_BFROWS = "kd.bos.botp.BillTrackReader.readDownBillBFRows";
    private EntryTrackReader entryTrackReader;

    BillTrackReader() {
    }

    public EntryTrackReader getEntryTrackReader() {
        if (this.entryTrackReader == null) {
            this.entryTrackReader = new EntryTrackReader();
        }
        return this.entryTrackReader;
    }

    public void setEntryTrackReader(EntryTrackReader entryTrackReader) {
        this.entryTrackReader = entryTrackReader;
    }

    protected List<BFRowId> readDownBillBFRowIds(Long srcMainTableId, Long[] srcBillIds) {
        if (srcBillIds == null || srcBillIds.length == 0) {
            return new ArrayList<BFRowId>();
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter(KEY_S_TABLEID, "=", (Object)srcMainTableId));
        qFilters.add(new QFilter(KEY_S_BILLID, "in", (Object)srcBillIds));
        ArrayList<BFRowId> rowIds = new ArrayList<BFRowId>(srcBillIds.length);
        try (DataSet ds = ORM.create().queryDataSet(ALGO_KEY_READ_DOWN_BILL_BFROWIDS, FORM_BOTP_BILLTRACKER, KEYS_TTABLEID_TBILLID, qFilters.toArray(new QFilter[0]));){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long tTableId = row.getLong(0);
                Long tBillId = row.getLong(1);
                BFRowId rowId = new BFRowId(tTableId, tBillId, tTableId, tBillId);
                rowIds.add(rowId);
            }
        }
        return rowIds;
    }

    protected List<BFRow> readDownBillBFRows(Long srcMainTableId, Long[] srcBillIds) {
        if (srcBillIds == null || srcBillIds.length == 0) {
            return new ArrayList<BFRow>();
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter(KEY_S_TABLEID, "=", (Object)srcMainTableId));
        qFilters.add(new QFilter(KEY_S_BILLID, "in", (Object)srcBillIds));
        ArrayList<BFRow> rows = new ArrayList<BFRow>(srcBillIds.length);
        try (DataSet ds = ORM.create().queryDataSet(ALGO_KEY_READ_DOWN_BILL_BFROWS, FORM_BOTP_BILLTRACKER, KEYS_STABLEID_SBILLID_TTABLEID_TBILLID, qFilters.toArray(new QFilter[0]));){
            while (ds.hasNext()) {
                Row row = ds.next();
                Long sTableId = row.getLong(0);
                Long sBillId = row.getLong(1);
                Long tTableId = row.getLong(2);
                Long tBillId = row.getLong(3);
                BFRowId sRowId = new BFRowId(sTableId, sBillId, sTableId, sBillId);
                BFRowId rowId = new BFRowId(tTableId, tBillId, tTableId, tBillId);
                BFRow bfRow = new BFRow();
                bfRow.setSId(sRowId);
                bfRow.setId(rowId);
                rows.add(bfRow);
            }
        }
        return rows;
    }

    protected List<BFRow> readDownEntryBFRows(Long srcMainTableId, Long srcTableId, Long[] srcBillIds, Set<Long> srcEntryIds, boolean searchEntry) {
        List<BFRowId> targetBillRowIds = this.readDownBillBFRowIds(srcMainTableId, srcBillIds);
        HashMap tgtBillIds = new HashMap();
        for (BFRowId rowId : targetBillRowIds) {
            Long tMainTableId = rowId.getMainTableId();
            Long tBillId = rowId.getBillId();
            this.getEntryTrackReader().addToMap(tgtBillIds, tMainTableId, tBillId);
        }
        ArrayList<BFRow> allEntryRows = new ArrayList<BFRow>();
        for (Map.Entry entry : tgtBillIds.entrySet()) {
            Long tMainTableId = (Long)entry.getKey();
            Long[] tBillIds = ((Set)entry.getValue()).toArray(new Long[0]);
            List<BFRow> bfRows = this.getEntryTrackReader().readUpEntryBFRows(tMainTableId, tBillIds);
            for (BFRow bfRow : bfRows) {
                if (searchEntry && Long.compare(bfRow.getId().getMainTableId(), bfRow.getId().getTableId()) == 0 || Long.compare(srcTableId, bfRow.getSId().getTableId()) != 0 || !srcEntryIds.contains(bfRow.getSId().getEntryId())) continue;
                allEntryRows.add(bfRow);
            }
        }
        return allEntryRows;
    }

    protected List<BFRow> readFullDownBillBFRows(Long srcMainTableId, Long[] srcBillIds) {
        List<BFRow> rows = this.readDownBillBFRows(srcMainTableId, srcBillIds);
        ArrayList<BFRow> allRows = new ArrayList<BFRow>(rows);
        int count = 0;
        while (!rows.isEmpty() && count < 100) {
            Long tMainTableId;
            ++count;
            HashMap targetBillIds = new HashMap(2);
            for (BFRow bFRow : rows) {
                tMainTableId = bFRow.getId().getMainTableId();
                Long tBillId = bFRow.getId().getBillId();
                this.getEntryTrackReader().addToMap(targetBillIds, tMainTableId, tBillId);
            }
            rows.clear();
            for (Map.Entry entry : targetBillIds.entrySet()) {
                tMainTableId = (Long)entry.getKey();
                Long[] tBillIds = ((Set)entry.getValue()).toArray(new Long[0]);
                rows.addAll(this.readDownBillBFRows(tMainTableId, tBillIds));
            }
            allRows.addAll(rows);
        }
        return allRows;
    }

    protected List<BFRow> readFullDownEntryBFRows(Long srcMainTableId, Long[] srcBillIds, boolean onlyDirtLink) {
        List<BFRowId> targetBillRowIds = this.readDownBillBFRowIds(srcMainTableId, srcBillIds);
        HashMap allTgtBillIds = new HashMap();
        HashMap tgtBillIds = new HashMap();
        for (BFRowId rowId : targetBillRowIds) {
            Iterator tMainTableId = rowId.getMainTableId();
            Long l = rowId.getBillId();
            if (!this.getEntryTrackReader().addToMap(allTgtBillIds, tMainTableId, l)) continue;
            this.getEntryTrackReader().addToMap(tgtBillIds, tMainTableId, l);
        }
        if (!onlyDirtLink) {
            int count = 0;
            while (tgtBillIds.size() > 0 && count < 100) {
                ++count;
                ArrayList<BFRowId> allBillRowIds = new ArrayList<BFRowId>();
                for (Map.Entry entry : tgtBillIds.entrySet()) {
                    Long sMainTableId = (Long)entry.getKey();
                    Long[] sBillIds = ((Set)entry.getValue()).toArray(new Long[((Set)entry.getValue()).size()]);
                    List<BFRowId> billRowIds = this.readDownBillBFRowIds(sMainTableId, sBillIds);
                    allBillRowIds.addAll(billRowIds);
                }
                tgtBillIds.clear();
                for (BFRowId bFRowId : allBillRowIds) {
                    Long tMainTableId = bFRowId.getMainTableId();
                    Long tBillId = bFRowId.getBillId();
                    if (!this.getEntryTrackReader().addToMap(allTgtBillIds, tMainTableId, tBillId)) continue;
                    this.getEntryTrackReader().addToMap(tgtBillIds, tMainTableId, tBillId);
                }
            }
        }
        ArrayList<BFRow> allEntryRows = new ArrayList<BFRow>();
        for (Map.Entry entry : allTgtBillIds.entrySet()) {
            Long l = (Long)entry.getKey();
            Long[] tBillIds = ((Set)entry.getValue()).toArray(new Long[((Set)entry.getValue()).size()]);
            List<BFRow> entryRows = this.getEntryTrackReader().readUpEntryBFRows(l, tBillIds);
            allEntryRows.addAll(entryRows);
        }
        return allEntryRows;
    }

    protected List<BFRow> readFullDownEntryBFRows(Long srcMainTableId, Long srcEntryTableId, Long[] srcBillIds, Set<Long> srcEntryIds, boolean onlyDirtLink, boolean searchEntry) {
        ArrayList<BFRow> allEntryRows = new ArrayList<BFRow>();
        List<BFRow> targetBFRows = this.readDownEntryBFRows(srcMainTableId, srcEntryTableId, srcBillIds, srcEntryIds, searchEntry);
        allEntryRows.addAll(targetBFRows);
        if (onlyDirtLink) {
            return allEntryRows;
        }
        HashMap allTargetRowIds = new HashMap();
        HashMap targetRowIds = new HashMap();
        for (BFRow bfRow : targetBFRows) {
            Long tTableId = bfRow.getId().getTableId();
            if (!this.getEntryTrackReader().addToMap(allTargetRowIds, tTableId, bfRow.getId())) continue;
            this.getEntryTrackReader().addToMap(targetRowIds, tTableId, bfRow.getId());
        }
        int count = 0;
        while (targetRowIds.size() > 0 && count < 100) {
            Long tTableId;
            ++count;
            ArrayList<BFRow> list = new ArrayList<BFRow>();
            for (Map.Entry entry : targetRowIds.entrySet()) {
                tTableId = (Long)entry.getKey();
                Long tMainTableId = ((BFRowId)((Set)entry.getValue()).iterator().next()).getMainTableId();
                HashSet<Long> tBillIds = new HashSet<Long>(((Set)entry.getValue()).size());
                HashSet<Long> tEntryIds = new HashSet<Long>(((Set)entry.getValue()).size());
                for (BFRowId rowId : (Set)entry.getValue()) {
                    tBillIds.add(rowId.getBillId());
                    tEntryIds.add(rowId.getEntryId());
                }
                targetBFRows = this.readDownEntryBFRows(tMainTableId, tTableId, tBillIds.toArray(new Long[0]), tEntryIds, searchEntry);
                allEntryRows.addAll(targetBFRows);
                list.addAll(targetBFRows);
            }
            targetRowIds.clear();
            for (BFRow bfRow : list) {
                tTableId = bfRow.getId().getTableId();
                if (!this.getEntryTrackReader().addToMap(allTargetRowIds, tTableId, bfRow.getId())) continue;
                this.getEntryTrackReader().addToMap(targetRowIds, tTableId, bfRow.getId());
            }
        }
        return allEntryRows;
    }
}

