/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.botp;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.botp.ConvertDataService;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.botp.PushAndDrawUtil;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.orm.ORM;
import kd.bos.orm.dataentity.ShardingHinter;
import kd.bos.orm.query.QFilter;
import kd.bos.xdb.hint.ShardingHintContext;

final class EntryTrackReader {
    private static final String FIELD_FTBILLID = "FTBillId";
    private static final String FIELD_FTID = "FTId";
    private static final String SQL_FROM = "FROM ";
    private static final String SQL_WHERE = "WHERE ";
    private static final String WHERE_FTBILLID = "FTBillId = ? ";
    private static final String WHERE_FTID = "FTId = ? ";
    private static final String SELECT_SBILLID_STABLEID_TBILLID_TTABLEID = "SELECT FSBillId, FSTableId, FTBillId, FTTableId ";
    private static final String SELECT_SBILLID_STABLEID_SID_TBILLID_TTABLEID_TID = "SELECT FSBillId, FSTableId, FSId, FTBillId, FTTableId, FTId ";
    private Map<Long, Long> mainTableIds = new HashMap<Long, Long>();
    private Map<String, MainEntityType> mainTypes = new HashMap<String, MainEntityType>();

    EntryTrackReader() {
    }

    protected Set<BFRow> readFullUpBillBFRows(String targetEntityNumber, Long[] targetBillIds) {
        HashSet<BFRow> allEntryBFRows = new HashSet<BFRow>(targetBillIds.length);
        Set<BFRow> myEntryBFRows = this.readUpBillBFRows(targetEntityNumber, targetBillIds);
        allEntryBFRows.addAll(myEntryBFRows);
        HashMap allSrcBillIds = new HashMap(myEntryBFRows.size());
        HashMap srcBillIds = new HashMap(myEntryBFRows.size());
        for (BFRow myEntryBFRow : myEntryBFRows) {
            Long sBillId;
            Long sMainTableId = myEntryBFRow.getSId().getMainTableId();
            if (!this.addToMap(allSrcBillIds, sMainTableId, sBillId = myEntryBFRow.getSId().getBillId())) continue;
            this.addToMap(srcBillIds, sMainTableId, sBillId);
        }
        HashSet<BFRow> entryBFRows = new HashSet<BFRow>(myEntryBFRows.size());
        int count = 0;
        while (srcBillIds.size() > 0 && count < 100) {
            ++count;
            entryBFRows.clear();
            for (Map.Entry entry : srcBillIds.entrySet()) {
                Long tMainTableId = (Long)entry.getKey();
                Set tBillIds = (Set)entry.getValue();
                entryBFRows.addAll(this.readUpBillBFRows(tMainTableId, tBillIds.toArray(new Long[0])));
            }
            allEntryBFRows.addAll(entryBFRows);
            srcBillIds.clear();
            for (BFRow bfRow : entryBFRows) {
                Long sBillId;
                Long sMainTableId = bfRow.getSId().getMainTableId();
                if (!this.addToMap(allSrcBillIds, sMainTableId, sBillId = bfRow.getSId().getBillId())) continue;
                this.addToMap(srcBillIds, sMainTableId, sBillId);
            }
        }
        return allEntryBFRows;
    }

    protected Set<BFRow> readUpBillBFRows(String targetEntityNumber, Long[] targetBillIds) {
        ConvertDataService reader = new ConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(targetEntityNumber, targetEntityNumber);
        return this.readUpBillBFRows(mainTableDefine.getTableId(), targetBillIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<BFRow> readUpBillBFRows(final Long targetMainTableId, Long[] targetBillIds) {
        if (targetBillIds == null || targetBillIds.length == 0) {
            return new HashSet<BFRow>(0);
        }
        ConvertDataService reader = new ConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(targetMainTableId);
        String entityNumber = mainTableDefine.getEntityNumber();
        MainEntityType mainType = this.loadMainType(entityNumber);
        LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)entityNumber);
        if (linkSet == null || StringUtils.isBlank((CharSequence)linkSet.getTrackerTable())) {
            return new HashSet<BFRow>(0);
        }
        SqlBuilder sBuilder = new SqlBuilder();
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        sBuilder.append(SELECT_SBILLID_STABLEID_TBILLID_TTABLEID, new Object[0]);
        sBuilder.append(SQL_FROM, new Object[0]).append(linkSet.getTrackerTable(), new Object[0]).append(" ", new Object[0]);
        sBuilder.append(SQL_WHERE, new Object[0]);
        if (targetBillIds.length == 1) {
            sBuilder.append(WHERE_FTBILLID, new Object[0]);
            params.add(new SqlParameter(FIELD_FTBILLID, -5, (Object)targetBillIds[0]));
        } else {
            sBuilder.appendIn(FIELD_FTBILLID, (Object[])targetBillIds);
        }
        sBuilder.append(" ", params.toArray(new Object[params.size()]));
        ResultSetHandler<Set<BFRow>> action = new ResultSetHandler<Set<BFRow>>(){

            public Set<BFRow> handle(ResultSet rs) throws SQLException {
                HashSet<BFRow> rows = new HashSet<BFRow>(16);
                while (rs.next()) {
                    Long sBillId = rs.getLong(1);
                    Long sTableId = rs.getLong(2);
                    Long sMainTableId = EntryTrackReader.this.loadMainTableId(sTableId);
                    Long tBillId = rs.getLong(3);
                    Long tTableId = rs.getLong(4);
                    Long tMainTableId = EntryTrackReader.this.loadMainTableId(tTableId);
                    if (Long.compare(targetMainTableId, tMainTableId) != 0) continue;
                    BFRowId sRowId = new BFRowId(sMainTableId, sBillId, sMainTableId, sBillId);
                    BFRowId tRowid = new BFRowId(targetMainTableId, tBillId, targetMainTableId, tBillId);
                    BFRow row = new BFRow();
                    row.setSId(sRowId);
                    row.setId(tRowid);
                    rows.add(row);
                }
                return rows;
            }
        };
        ShardingHintContext ctx = ShardingHinter.tryHint((IDataEntityType)mainType, (Object[])targetBillIds);
        if (ctx != null) {
            try {
                ctx.set();
                Set set = (Set)DB.query((DBRoute)new DBRoute(mainType.getDBRouteKey()), (SqlBuilder)sBuilder, (ResultSetHandler)action);
                return set;
            }
            finally {
                ctx.close();
            }
        }
        return (Set)DB.query((DBRoute)new DBRoute(mainType.getDBRouteKey()), (SqlBuilder)sBuilder, (ResultSetHandler)action);
    }

    protected List<BFRow> readFullUpEntryBFRows(String targetEntityNumber, Long[] targetBillIds, boolean onlyDirtLink) {
        ArrayList<BFRow> allEntryBFRows = new ArrayList<BFRow>(targetBillIds.length);
        List<BFRow> myEntryBFRows = this.readUpEntryBFRows(targetEntityNumber, targetBillIds);
        allEntryBFRows.addAll(myEntryBFRows);
        if (onlyDirtLink) {
            return allEntryBFRows;
        }
        HashMap allSrcBillIds = new HashMap(myEntryBFRows.size());
        HashMap srcBillIds = new HashMap(myEntryBFRows.size());
        for (BFRow myEntryBFRow : myEntryBFRows) {
            Long sBillId;
            Long sMainTableId = myEntryBFRow.getSId().getMainTableId();
            if (!this.addToMap(allSrcBillIds, sMainTableId, sBillId = myEntryBFRow.getSId().getBillId())) continue;
            this.addToMap(srcBillIds, sMainTableId, sBillId);
        }
        ArrayList<BFRow> entryBFRows = new ArrayList<BFRow>(myEntryBFRows.size());
        int count = 0;
        while (srcBillIds.size() > 0 && count < 100) {
            ++count;
            entryBFRows.clear();
            for (Map.Entry entry : srcBillIds.entrySet()) {
                Long tMainTableId = (Long)entry.getKey();
                Set tBillIds = (Set)entry.getValue();
                entryBFRows.addAll(this.readUpEntryBFRows(tMainTableId, tBillIds.toArray(new Long[0])));
            }
            allEntryBFRows.addAll(entryBFRows);
            srcBillIds.clear();
            for (BFRow bfRow : entryBFRows) {
                Long sBillId;
                Long sMainTableId = bfRow.getSId().getMainTableId();
                if (!this.addToMap(allSrcBillIds, sMainTableId, sBillId = bfRow.getSId().getBillId())) continue;
                this.addToMap(srcBillIds, sMainTableId, sBillId);
            }
        }
        return allEntryBFRows;
    }

    protected List<BFRow> readFullUpEntryBFRows(String targetEntityNumber, String targetEntryKey, Long[] targetBillIds, Long[] targetEntryIds) {
        return this.readFullUpEntryBFRows(targetEntityNumber, targetEntryKey, targetBillIds, targetEntryIds, false);
    }

    protected List<BFRow> readFullUpEntryBFRows(String targetEntityNumber, String targetEntryKey, Long[] targetBillIds, Long[] targetEntryIds, boolean isSearchEntry) {
        ArrayList<BFRow> allEntryBFRows = new ArrayList<BFRow>(targetBillIds.length);
        List<BFRow> myEntryBFRows = this.readUpEntryBFRows(targetEntityNumber, targetEntryKey, targetBillIds, targetEntryIds, isSearchEntry);
        allEntryBFRows.addAll(myEntryBFRows);
        HashMap allSrcBillRowIds = new HashMap(myEntryBFRows.size());
        HashMap srcBillRowIds = new HashMap(myEntryBFRows.size());
        for (BFRow myEntryBFRow : myEntryBFRows) {
            BFRowId sRowId = myEntryBFRow.getSId();
            Long sEntryTableId = sRowId.getTableId();
            if (!this.addToMap(allSrcBillRowIds, sEntryTableId, sRowId)) continue;
            this.addToMap(srcBillRowIds, sEntryTableId, sRowId);
        }
        ArrayList<BFRow> entryBFRows = new ArrayList<BFRow>(myEntryBFRows.size());
        int count = 0;
        while (srcBillRowIds.size() > 0 && count < 100) {
            ++count;
            entryBFRows.clear();
            for (Map.Entry entry : srcBillRowIds.entrySet()) {
                Long tTableId = (Long)entry.getKey();
                HashSet<Long> tBillIds = new HashSet<Long>(((Set)entry.getValue()).size());
                HashSet<Long> tEntryIds = new HashSet<Long>(((Set)entry.getValue()).size());
                for (BFRowId bfRowId : (Set)entry.getValue()) {
                    tBillIds.add(bfRowId.getBillId());
                    tEntryIds.add(bfRowId.getEntryId());
                }
                entryBFRows.addAll(this.readUpEntryBFRows(tTableId, tBillIds.toArray(new Long[0]), tEntryIds.toArray(new Long[0]), isSearchEntry));
            }
            allEntryBFRows.addAll(entryBFRows);
            srcBillRowIds.clear();
            for (BFRow bfRow : entryBFRows) {
                BFRowId sRowId = bfRow.getSId();
                Long sEntryTableId = sRowId.getTableId();
                if (!this.addToMap(allSrcBillRowIds, sEntryTableId, sRowId)) continue;
                this.addToMap(srcBillRowIds, sEntryTableId, sRowId);
            }
        }
        return allEntryBFRows;
    }

    protected List<BFRow> readUpEntryBFRows(String targetEntityNumber, String targetEntryKey, Long[] targetEntryIds) {
        return this.readUpEntryBFRows(targetEntityNumber, targetEntryKey, targetEntryIds, false);
    }

    protected List<BFRow> readUpEntryBFRows(String targetEntityNumber, String targetEntryKey, Long[] targetEntryIds, final boolean isSearchEntry) {
        if (StringUtils.isBlank((CharSequence)targetEntityNumber) || targetEntryIds == null || targetEntryIds.length == 0) {
            return new ArrayList<BFRow>();
        }
        ConvertDataService reader = new ConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(targetEntityNumber, targetEntityNumber);
        final Long mainTableId = mainTableDefine.getTableId();
        if (StringUtils.isBlank((CharSequence)targetEntryKey)) {
            return this.readUpEntryBFRows(mainTableId, targetEntryIds);
        }
        MainEntityType mainType = this.loadMainType(targetEntityNumber);
        LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)targetEntityNumber);
        if (linkSet == null || StringUtils.isBlank((CharSequence)linkSet.getTrackerTable())) {
            return new ArrayList<BFRow>();
        }
        SqlBuilder sBuilder = new SqlBuilder();
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        sBuilder.append(SELECT_SBILLID_STABLEID_SID_TBILLID_TTABLEID_TID, new Object[0]);
        sBuilder.append(SQL_FROM, new Object[0]).append(linkSet.getTrackerTable(), new Object[0]).append(" ", new Object[0]);
        sBuilder.append(SQL_WHERE, new Object[0]);
        final TableDefine tableDefine = reader.loadTableDefine(targetEntityNumber, targetEntryKey);
        if (targetEntryIds.length == 1) {
            sBuilder.append(WHERE_FTID, new Object[0]);
            params.add(new SqlParameter(FIELD_FTID, -5, (Object)targetEntryIds[0]));
        } else {
            sBuilder.appendIn(FIELD_FTID, (Object[])targetEntryIds);
        }
        sBuilder.append(" ", params.toArray(new Object[params.size()]));
        ResultSetHandler<List<BFRow>> action = new ResultSetHandler<List<BFRow>>(){

            public List<BFRow> handle(ResultSet rs) throws SQLException {
                ArrayList<BFRow> rows = new ArrayList<BFRow>(16);
                while (rs.next()) {
                    Long sBillId = rs.getLong(1);
                    Long sTableId = rs.getLong(2);
                    Long sId = rs.getLong(3);
                    Long sMainTableId = EntryTrackReader.this.loadMainTableId(sTableId);
                    Long tBillId = rs.getLong(4);
                    Long tTableId = rs.getLong(5);
                    Long tId = rs.getLong(6);
                    if (isSearchEntry && Long.compare(sTableId, sMainTableId) == 0 || Long.compare(tTableId, tableDefine.getTableId()) != 0) continue;
                    BFRowId sRowId = new BFRowId(sMainTableId, sBillId, sTableId, sId);
                    BFRowId tRowid = new BFRowId(mainTableId, tBillId, tTableId, tId);
                    BFRow row = new BFRow();
                    row.setSId(sRowId);
                    row.setId(tRowid);
                    rows.add(row);
                }
                return rows;
            }
        };
        List rows = (List)DB.query((DBRoute)new DBRoute(mainType.getDBRouteKey()), (SqlBuilder)sBuilder, (ResultSetHandler)action);
        return rows;
    }

    protected List<BFRow> readUpEntryBFRows(String targetEntityNumber, String targetEntryKey, Long[] targetBillIds, Long[] targetEntryIds) {
        return this.readUpEntryBFRows(targetEntityNumber, targetEntryKey, targetBillIds, targetEntryIds, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<BFRow> readUpEntryBFRows(String targetEntityNumber, String targetEntryKey, Long[] targetBillIds, Long[] targetEntryIds, boolean isSearchEntry) {
        MainEntityType mainType = this.loadMainType(targetEntityNumber);
        ShardingHintContext ctx = ShardingHinter.tryHint((IDataEntityType)mainType, (Object[])targetBillIds);
        if (ctx != null) {
            try {
                ctx.set();
                List<BFRow> list = this.readUpEntryBFRows(targetEntityNumber, targetEntryKey, targetEntryIds, isSearchEntry);
                return list;
            }
            finally {
                ctx.close();
            }
        }
        return this.readUpEntryBFRows(targetEntityNumber, targetEntryKey, targetEntryIds, isSearchEntry);
    }

    protected List<BFRow> readUpEntryBFRows(Long targetEntryTableId, Long[] targetBillIds, Long[] targetEntryIds) {
        return this.readUpEntryBFRows(targetEntryTableId, targetBillIds, targetEntryIds, false);
    }

    protected List<BFRow> readUpEntryBFRows(Long targetEntryTableId, Long[] targetBillIds, Long[] targetEntryIds, boolean isSearchEntry) {
        ConvertDataService reader = new ConvertDataService();
        TableDefine tableDefine = reader.loadTableDefine(targetEntryTableId);
        return this.readUpEntryBFRows(tableDefine.getEntityNumber(), tableDefine.getEntityKey(), targetBillIds, targetEntryIds, isSearchEntry);
    }

    protected List<BFRow> readUpEntryBFRows(String targetEntityNumber, Long[] targetBillIds) {
        ConvertDataService reader = new ConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(targetEntityNumber, targetEntityNumber);
        Long mainTableId = mainTableDefine.getTableId();
        return this.readUpEntryBFRows(mainTableId, targetBillIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<BFRow> readUpEntryBFRows(final Long targetMainTableId, Long[] targetBillIds) {
        if (targetBillIds == null || targetBillIds.length == 0) {
            return new ArrayList<BFRow>();
        }
        ConvertDataService reader = new ConvertDataService();
        TableDefine mainTableDefine = reader.loadTableDefine(targetMainTableId);
        String entityNumber = mainTableDefine.getEntityNumber();
        MainEntityType mainType = this.loadMainType(entityNumber);
        LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)entityNumber);
        if (linkSet == null || StringUtils.isBlank((CharSequence)linkSet.getTrackerTable())) {
            return new ArrayList<BFRow>();
        }
        SqlBuilder sBuilder = new SqlBuilder();
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        sBuilder.append(SELECT_SBILLID_STABLEID_SID_TBILLID_TTABLEID_TID, new Object[0]);
        sBuilder.append(SQL_FROM, new Object[0]).append(linkSet.getTrackerTable(), new Object[0]).append(" ", new Object[0]);
        sBuilder.append(SQL_WHERE, new Object[0]);
        if (targetBillIds.length == 1) {
            sBuilder.append(WHERE_FTBILLID, new Object[0]);
            params.add(new SqlParameter(FIELD_FTBILLID, -5, (Object)targetBillIds[0]));
        } else {
            sBuilder.appendIn(FIELD_FTBILLID, (Object[])targetBillIds);
        }
        sBuilder.append(" ", params.toArray(new Object[params.size()]));
        ResultSetHandler<List<BFRow>> action = new ResultSetHandler<List<BFRow>>(){

            public List<BFRow> handle(ResultSet rs) throws SQLException {
                ArrayList<BFRow> rows = new ArrayList<BFRow>(16);
                while (rs.next()) {
                    Long sBillId = rs.getLong(1);
                    Long sTableId = rs.getLong(2);
                    Long sId = rs.getLong(3);
                    Long sMainTableId = EntryTrackReader.this.loadMainTableId(sTableId);
                    Long tBillId = rs.getLong(4);
                    Long tTableId = rs.getLong(5);
                    Long tId = rs.getLong(6);
                    Long tMainTableId = EntryTrackReader.this.loadMainTableId(tTableId);
                    if (Long.compare(targetMainTableId, tMainTableId) != 0) continue;
                    BFRowId sRowId = new BFRowId(sMainTableId, sBillId, sTableId, sId);
                    BFRowId tRowid = new BFRowId(targetMainTableId, tBillId, tTableId, tId);
                    BFRow row = new BFRow();
                    row.setSId(sRowId);
                    row.setId(tRowid);
                    rows.add(row);
                }
                return rows;
            }
        };
        ShardingHintContext ctx = ShardingHinter.tryHint((IDataEntityType)mainType, (Object[])targetBillIds);
        if (ctx != null) {
            try {
                ctx.set();
                List list = (List)DB.query((DBRoute)DBRoute.of((String)mainType.getDBRouteKey()), (SqlBuilder)sBuilder, (ResultSetHandler)action);
                return list;
            }
            finally {
                ctx.close();
            }
        }
        return (List)DB.query((DBRoute)new DBRoute(mainType.getDBRouteKey()), (SqlBuilder)sBuilder, (ResultSetHandler)action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isExistsEntryTracker(final Long srcSearchTableId, final Long srcSearchId, final boolean isSearchEntry, Long targetMainTableId, Long[] targetBillIds) {
        if (targetBillIds == null || targetBillIds.length == 0) {
            return false;
        }
        ConvertDataService reader = new ConvertDataService();
        TableDefine targetMainTableDefine = reader.loadTableDefine(targetMainTableId);
        String targetEntityNumber = targetMainTableDefine.getEntityNumber();
        MainEntityType targetMainType = this.loadMainType(targetEntityNumber);
        LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)targetEntityNumber);
        if (linkSet == null || StringUtils.isBlank((CharSequence)linkSet.getTrackerTable())) {
            return false;
        }
        SqlBuilder sBuilder = new SqlBuilder();
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        sBuilder.append(SELECT_SBILLID_STABLEID_SID_TBILLID_TTABLEID_TID, new Object[0]);
        sBuilder.append(SQL_FROM, new Object[0]).append(linkSet.getTrackerTable(), new Object[0]).append(" ", new Object[0]);
        sBuilder.append(SQL_WHERE, new Object[0]);
        if (targetBillIds.length == 1) {
            sBuilder.append(WHERE_FTBILLID, new Object[0]);
            params.add(new SqlParameter(FIELD_FTBILLID, -5, (Object)targetBillIds[0]));
        } else {
            sBuilder.appendIn(FIELD_FTBILLID, (Object[])targetBillIds);
        }
        sBuilder.append(" ", params.toArray(new Object[params.size()]));
        ResultSetHandler<Boolean> action = new ResultSetHandler<Boolean>(){

            public Boolean handle(ResultSet rs) throws SQLException {
                Boolean result = Boolean.FALSE;
                while (rs.next()) {
                    Long sBillId = rs.getLong(1);
                    Long sTableId = rs.getLong(2);
                    Long sId = rs.getLong(3);
                    Long sMainTableId = EntryTrackReader.this.loadMainTableId(sTableId);
                    if (!(isSearchEntry ? Long.compare(srcSearchTableId, sTableId) == 0 && Long.compare(srcSearchId, sId) == 0 : Long.compare(srcSearchTableId, sMainTableId) == 0 && Long.compare(srcSearchId, sBillId) == 0)) continue;
                    return Boolean.TRUE;
                }
                return result;
            }
        };
        ShardingHintContext ctx = ShardingHinter.tryHint((IDataEntityType)targetMainType, (Object[])targetBillIds);
        if (ctx != null) {
            try {
                ctx.set();
                boolean bl = (Boolean)DB.query((DBRoute)new DBRoute(targetMainType.getDBRouteKey()), (SqlBuilder)sBuilder, (ResultSetHandler)action);
                return bl;
            }
            finally {
                ctx.close();
            }
        }
        return (Boolean)DB.query((DBRoute)new DBRoute(targetMainType.getDBRouteKey()), (SqlBuilder)sBuilder, (ResultSetHandler)action);
    }

    protected HashSet<Long> readExistsBillIds(String entityNumber, Long[] billIds) {
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            return new HashSet<Long>(0);
        }
        if (billIds == null || billIds.length == 0) {
            return new HashSet<Long>(0);
        }
        HashSet<Long> existBillIds = new HashSet<Long>(billIds.length);
        QFilter idfilter = new QFilter("id", "in", (Object)billIds);
        try (DataSet dataSet = ORM.create().queryDataSet("EntryTrackReader.readExistsBillIds", entityNumber, "id", new QFilter[]{idfilter});){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Long billId = row.getLong("id");
                existBillIds.add(billId);
            }
        }
        return existBillIds;
    }

    @Deprecated
    protected HashSet<Long> readBillIds(String entityNumber, String entryKey, Long[] entryIds) {
        if (StringUtils.isBlank((CharSequence)entityNumber) || entryIds == null || entryIds.length == 0) {
            return new HashSet<Long>(0);
        }
        HashSet<Long> billIds = new HashSet<Long>();
        if (StringUtils.isBlank((CharSequence)entryKey) || entityNumber.equals(entryKey)) {
            for (Long billId : entryIds) {
                billIds.add(billId);
            }
            return billIds;
        }
        MainEntityType mainType = this.loadMainType(entityNumber);
        EntityType entity = (EntityType)mainType.getAllEntities().get(entryKey);
        if (entity == null) {
            return billIds;
        }
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add(String.format("%s f0", mainType.getPrimaryKey().getName()));
        String entryPKFieldName = "";
        if (entity instanceof SubEntryType) {
            EntityType parent = (EntityType)entity.getParent();
            selectFields.add(String.format("%s.%s f1", parent.getName(), parent.getPrimaryKey().getName()));
            entryPKFieldName = String.format("%s.%s.%s", parent.getName(), entity.getName(), entity.getPrimaryKey().getName());
            selectFields.add(entryPKFieldName + " f2");
        } else {
            entryPKFieldName = String.format("%s.%s", entity.getName(), entity.getPrimaryKey().getName());
            selectFields.add(entryPKFieldName + " f1");
        }
        QFilter qFilter = new QFilter(entryPKFieldName, "in", (Object)entryIds);
        String select = StringUtils.join((Object[])selectFields.toArray(), (String)",");
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet(this.getClass().getName(), entityNumber, select, new QFilter[]{qFilter});){
            DynamicObjectCollection rows = orm.toPlainDynamicObjectCollection(ds);
            DynamicObjectType dType = rows.getDynamicObjectType();
            DynamicProperty pkProp = dType.getProperty("f0");
            for (DynamicObject row : rows) {
                Long billId = (Long)pkProp.getValueFast((Object)row);
                billIds.add(billId);
            }
        }
        return billIds;
    }

    protected TableDefine loadTableDefine(String entityNumber, String entityKey) {
        ConvertDataService reader = new ConvertDataService();
        return reader.loadTableDefine(entityNumber, entityKey);
    }

    protected Long loadMainTableId(Long entityTableId) {
        Long mainTableId = this.mainTableIds.get(entityTableId);
        if (mainTableId == null) {
            ConvertDataService reader = new ConvertDataService();
            TableDefine entityTableDefine = reader.loadTableDefine(entityTableId);
            TableDefine mainTableDefine = reader.loadTableDefine(entityTableDefine.getEntityNumber(), entityTableDefine.getEntityNumber());
            mainTableId = mainTableDefine.getTableId();
            this.mainTableIds.put(entityTableId, mainTableId);
        }
        return mainTableId;
    }

    protected MainEntityType loadMainType(String entityNumber) {
        MainEntityType mainType = this.mainTypes.get(entityNumber);
        if (mainType == null) {
            try {
                mainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            }
            catch (KDException e) {
                PushAndDrawUtil.nonMetaNotFound((KDException)e);
                throw new KDBizException(String.format(ResManager.loadKDString((String)"number\u4e3a%s\uff08\u5355\u636e\u6807\u8bc6\uff09\u7684\u5143\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"EntryTrackReader_0", (String)"bos-botp-dao", (Object[])new Object[0]), entityNumber));
            }
            this.mainTypes.put(entityNumber, mainType);
        }
        return mainType;
    }

    protected <T1, T2> boolean addToMap(Map<T1, Set<T2>> map, T1 groupId, T2 detail) {
        Set<T2> set = map.get(groupId);
        if (set == null) {
            set = new HashSet<T2>();
            map.put(groupId, set);
        }
        return set.add(detail);
    }
}

