/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.botp;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.ConvertRuleCache;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.LastBillRuleRecord;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mservice.sysparam.SystemParamService;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class LastBillRuleService {
    private static final Log log = LogFactory.getLog(LastBillRuleService.class);
    private static final String BOTP_BILL_RULE_RECORD = "botp_bill_rule_record";
    private static SystemParamService systemParamService = (SystemParamService)ServiceFactory.getService(SystemParamService.class);
    private static final String ENABLE_LAST_BILL_RULE = "enable_last_bill_rule";

    public boolean isEnabled() {
        Object lastBillRuleParam = systemParamService.loadPublicParameterFromCache(ENABLE_LAST_BILL_RULE);
        return lastBillRuleParam == null ? false : Boolean.parseBoolean(lastBillRuleParam.toString());
    }

    public void addRecord(LastBillRuleRecord lastBillRuleRecord) {
        block15: {
            try (TXHandle h = TX.requiresNew((String)"bill_rule_record_save");){
                try {
                    DynamicObject dynamicObject = LastBillRuleService.buildDynamicObject(lastBillRuleRecord);
                    if (lastBillRuleRecord.getId() == null) {
                        dynamicObject.set("createTime", (Object)new Date());
                        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
                        break block15;
                    }
                    dynamicObject.set("modifyTime", (Object)new Date());
                    SaveServiceHelper.update((DynamicObject)dynamicObject);
                }
                catch (Throwable e) {
                    h.markRollback();
                    log.error("add lastBillRuleRecord error\uff01" + e);
                }
            }
        }
    }

    public LastBillRuleRecord getLastBillRuleRecord(Long userId, String curBill, String opType) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)BOTP_BILL_RULE_RECORD, (QFilter[])new QFilter[]{new QFilter("userid", "=", (Object)userId), new QFilter("curbill", "=", (Object)curBill), new QFilter("optype", "=", (Object)opType)});
        LastBillRuleRecord lastBillRuleRecord = LastBillRuleService.buildLastBillRuleRecord(dynamicObject);
        if (this.lastBillRuleIfNormal(lastBillRuleRecord)) {
            return lastBillRuleRecord;
        }
        return new LastBillRuleRecord(userId, curBill, opType);
    }

    private boolean lastBillRuleIfNormal(LastBillRuleRecord lastBillRuleRecord) {
        boolean ruleFlag = false;
        if (StringUtils.isNotBlank((CharSequence)lastBillRuleRecord.getBill()) && StringUtils.isNotBlank((CharSequence)lastBillRuleRecord.getRule())) {
            if (StringUtils.equalsIgnoreCase((CharSequence)"@all", (CharSequence)lastBillRuleRecord.getRule())) {
                ruleFlag = true;
            } else {
                try {
                    ConvertRuleElement convertRuleElement = ConvertRuleCache.loadRule((String)lastBillRuleRecord.getRule());
                    if (convertRuleElement == null || !convertRuleElement.isNormual()) {
                        if (lastBillRuleRecord.getOpType().equals("push")) {
                            lastBillRuleRecord.setRule("@all");
                        } else {
                            lastBillRuleRecord.setRule("");
                        }
                    }
                }
                catch (Exception e) {
                    log.error("loadRule error! ruleId:" + lastBillRuleRecord.getRule());
                    lastBillRuleRecord.setRule("");
                }
                ruleFlag = true;
            }
            MainEntityType dt = EntityMetadataCache.getDataEntityType((String)lastBillRuleRecord.getBill());
            if (dt == null) {
                lastBillRuleRecord.setBill("");
                ruleFlag = true;
            }
        }
        return ruleFlag;
    }

    public static DynamicObject buildDynamicObject(LastBillRuleRecord lastBillRuleRecord) {
        DynamicObject newObj = BusinessDataServiceHelper.newDynamicObject((String)BOTP_BILL_RULE_RECORD);
        newObj.set("id", (Object)lastBillRuleRecord.getId());
        newObj.set("userId", (Object)lastBillRuleRecord.getUserId());
        newObj.set("curBill", (Object)lastBillRuleRecord.getCurBill());
        newObj.set("bill", (Object)lastBillRuleRecord.getBill());
        newObj.set("rule", (Object)lastBillRuleRecord.getRule());
        newObj.set("opType", (Object)lastBillRuleRecord.getOpType());
        newObj.set("opCode", (Object)lastBillRuleRecord.getOpCode());
        newObj.set("createTime", (Object)lastBillRuleRecord.getCreateTime());
        newObj.set("modifyTime", (Object)lastBillRuleRecord.getModifyTime());
        return newObj;
    }

    public static LastBillRuleRecord buildLastBillRuleRecord(DynamicObject dynamicObject) {
        LastBillRuleRecord lastBillRuleRecord = new LastBillRuleRecord();
        if (dynamicObject != null) {
            lastBillRuleRecord.setId((Long)dynamicObject.getPkValue());
            lastBillRuleRecord.setUserId((Long)dynamicObject.get("userId"));
            lastBillRuleRecord.setCurBill((String)dynamicObject.get("curBill"));
            lastBillRuleRecord.setBill((String)dynamicObject.get("bill"));
            lastBillRuleRecord.setRule((String)dynamicObject.get("rule"));
            lastBillRuleRecord.setOpType((String)dynamicObject.get("opType"));
            lastBillRuleRecord.setOpCode((String)dynamicObject.get("opCode"));
            lastBillRuleRecord.setCreateTime((Date)dynamicObject.get("createTime"));
            lastBillRuleRecord.setModifyTime((Date)dynamicObject.get("modifyTime"));
        }
        return lastBillRuleRecord;
    }
}

