/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.botp.linkquery;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.botp.linkquery.LinkQueryUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.linkquery.LinkTcPo;
import kd.bos.entity.botp.linkquery.QueryTcLinkArgs;
import kd.bos.entity.botp.linkquery.QueryTcLinkPo;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.orm.dataentity.ShardingHinter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.xdb.hint.ShardingHintContext;
import org.apache.commons.collections.CollectionUtils;

public class LinkTcDataQueryService {
    private static String COMMA_CODE = ",";
    private Map<Integer, List<String>> fidShowed = new HashMap<Integer, List<String>>(16);
    private Integer resultCount = 0;
    private Integer otherCount = 0;

    public Integer loadLinkCount(QueryTcLinkArgs args) {
        Integer num = 0;
        ArrayList<Long> sourceFids = new ArrayList<Long>(16);
        ArrayList<Long> removeSourceFids = new ArrayList<Long>(16);
        ArrayList<Long> targetFids = new ArrayList<Long>(16);
        ArrayList<Long> removeTargetFids = new ArrayList<Long>(16);
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)args.getTargetNumber());
        LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)args.getTargetNumber());
        if (StringUtils.isBlank((CharSequence)targetMainType.getAlias()) || StringUtils.isBlank((CharSequence)linkSet.getTrackerTable())) {
            return num;
        }
        this.queryFid(args, targetMainType, linkSet, sourceFids, null, removeSourceFids, targetFids, null, removeTargetFids, true);
        SqlBuilder sBuilder = this.builderSql(linkSet.getTrackerTable(), args.getSourceNumber(), args.getSourceEntity(), args.getTargetNumber(), args.getTargetEntity(), sourceFids, targetFids, 0, 0, true);
        sourceFids.addAll(targetFids);
        num = this.queryTcTableNum(targetMainType, sBuilder, sourceFids);
        sourceFids.removeAll(removeSourceFids);
        sourceFids.removeAll(targetFids);
        targetFids.removeAll(removeTargetFids);
        this.resultCount = num;
        this.otherCount = sourceFids.size() + targetFids.size();
        return this.resultCount + this.otherCount;
    }

    public List<QueryTcLinkPo> loadLinkTc(QueryTcLinkArgs args) {
        ArrayList<Long> sourceFids = new ArrayList<Long>(16);
        ArrayList<Long> targetFids = new ArrayList<Long>(16);
        HashMap<String, DynamicObject> sourceMap = new HashMap<String, DynamicObject>(16);
        HashMap<String, DynamicObject> targetMap = new HashMap<String, DynamicObject>(16);
        List<QueryTcLinkPo> result = new ArrayList<QueryTcLinkPo>(16);
        MainEntityType sourceMainType = EntityMetadataCache.getDataEntityType((String)args.getTargetNumber());
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)args.getTargetNumber());
        LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)args.getTargetNumber());
        if (targetMainType == null || linkSet == null || StringUtils.isBlank((CharSequence)targetMainType.getAlias()) || StringUtils.isBlank((CharSequence)linkSet.getTrackerTable())) {
            return result;
        }
        if (args.getPageIndex() == 1) {
            this.fidShowed.clear();
        }
        this.queryFid(args, targetMainType, linkSet, sourceFids, sourceMap, null, targetFids, targetMap, null, false);
        if (sourceFids.size() == 0 && targetFids.size() == 0) {
            return result;
        }
        if (this.fidShowed.size() == 0) {
            this.noLinkBillPage(targetMainType, linkSet, sourceMap, targetMap, args.getPageIndex(), args.getPageRows());
        }
        SqlBuilder sBuilder = this.builderSql(linkSet.getTrackerTable(), args.getSourceNumber(), args.getSourceEntity(), args.getTargetNumber(), args.getTargetEntity(), sourceFids, targetFids, args.getPageIndex(), args.getPageRows(), false);
        sourceFids.addAll(targetFids);
        result = this.queryTcTable(targetMainType, sBuilder, sourceFids);
        this.appendBillInfo(args, result, sourceMap, targetMap);
        this.bulidCurrentNoLinkBillPage(args, sourceMainType, targetMainType, linkSet, sourceMap, targetMap, result);
        return result;
    }

    private void queryFid(QueryTcLinkArgs args, MainEntityType targetMainType, LinkSetElement linkSet, List<Long> sourceFids, HashMap<String, DynamicObject> sourceMap, List<Long> removeSourceFids, List<Long> targetFids, HashMap<String, DynamicObject> targetMap, List<Long> removeTargetFids, Boolean isGetCount) {
        if (args.getSourceBillnos() != null && args.getSourceBillnos().size() > 0 && !isGetCount.booleanValue()) {
            this.getFidByBillNo(targetMainType, linkSet, args.getSourceNumber(), args.getSourceBillnos(), sourceFids, null, sourceMap, null, false);
        } else if (args.getSourceBillnos() != null && args.getSourceBillnos().size() > 0) {
            this.getFidByBillNo(targetMainType, linkSet, args.getSourceNumber(), args.getSourceBillnos(), sourceFids, removeSourceFids, null, "fsbillid", true);
        }
        if (args.getTargetBillnos() != null && args.getTargetBillnos().size() > 0 && !isGetCount.booleanValue()) {
            this.getFidByBillNo(targetMainType, linkSet, args.getTargetNumber(), args.getTargetBillnos(), targetFids, null, targetMap, null, false);
        } else if (args.getTargetBillnos() != null && args.getTargetBillnos().size() > 0) {
            this.getFidByBillNo(targetMainType, linkSet, args.getTargetNumber(), args.getTargetBillnos(), targetFids, removeTargetFids, null, "ftbillid", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<QueryTcLinkPo> queryTcTable(MainEntityType targetMainType, SqlBuilder sBuilder, List<Long> sourceFids) {
        List result;
        ShardingHintContext ctx = ShardingHinter.tryHint((IDataEntityType)targetMainType, (Object[])sourceFids.toArray());
        if (ctx != null) {
            try {
                ctx.set();
                result = (List)DB.query((DBRoute)new DBRoute(targetMainType.getDBRouteKey()), (SqlBuilder)sBuilder, this.getAction());
            }
            finally {
                ctx.close();
            }
        } else {
            result = (List)DB.query((DBRoute)new DBRoute(targetMainType.getDBRouteKey()), (SqlBuilder)sBuilder, this.getAction());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Integer queryTcTableNum(MainEntityType targetMainType, SqlBuilder sBuilder, List<Long> sourceFids) {
        Integer num = 0;
        ResultSetHandler<Integer> action = new ResultSetHandler<Integer>(){

            public Integer handle(ResultSet rs) throws SQLException {
                Integer num = 0;
                while (rs.next()) {
                    num = rs.getInt("num");
                }
                return num;
            }
        };
        ShardingHintContext ctx = ShardingHinter.tryHint((IDataEntityType)targetMainType, (Object[])sourceFids.toArray());
        if (ctx != null) {
            try {
                ctx.set();
                num = (Integer)DB.query((DBRoute)new DBRoute(targetMainType.getDBRouteKey()), (SqlBuilder)sBuilder, (ResultSetHandler)action);
            }
            finally {
                ctx.close();
            }
        } else {
            num = (Integer)DB.query((DBRoute)new DBRoute(targetMainType.getDBRouteKey()), (SqlBuilder)sBuilder, (ResultSetHandler)action);
        }
        return num;
    }

    private void appendBillInfo(QueryTcLinkArgs args, List<QueryTcLinkPo> result, HashMap<String, DynamicObject> sourceMap, HashMap<String, DynamicObject> targetMap) {
        if (CollectionUtils.isEmpty(result)) {
            return;
        }
        BillEntityType sourceEntityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)args.getTargetNumber());
        BillEntityType targetEntityType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)args.getTargetNumber());
        DynamicObject dynamicObject = null;
        for (QueryTcLinkPo queryLinkPo : result) {
            if (StringUtils.isBlank((CharSequence)queryLinkPo.getFsbillid()) && StringUtils.isBlank((CharSequence)queryLinkPo.getFtbillid())) continue;
            if (StringUtils.isNotBlank((CharSequence)queryLinkPo.getFsbillid())) {
                dynamicObject = this.getDynamicObject(args.getSourceNumber(), sourceEntityType.getBillNo(), sourceMap, queryLinkPo.getFsbillid());
            }
            if (dynamicObject != null) {
                queryLinkPo.setSourceFid(String.valueOf(dynamicObject.getPkValue()));
                queryLinkPo.setSourceBillNo(String.valueOf(dynamicObject.get(sourceEntityType.getBillNo())));
                queryLinkPo.setSourceCreatetime((Date)dynamicObject.get("createtime"));
            }
            dynamicObject = null;
            if (StringUtils.isNotBlank((CharSequence)queryLinkPo.getFtbillid())) {
                dynamicObject = this.getDynamicObject(args.getTargetNumber(), targetEntityType.getBillNo(), targetMap, queryLinkPo.getFtbillid());
            }
            if (dynamicObject == null) continue;
            queryLinkPo.setTargetFid(String.valueOf(dynamicObject.getPkValue()));
            queryLinkPo.setTargetBillNo(String.valueOf(dynamicObject.get(targetEntityType.getBillNo())));
            queryLinkPo.setTargetCreatetime((Date)dynamicObject.get("createtime"));
        }
    }

    private DynamicObject getDynamicObject(String billNumber, String billno, HashMap<String, DynamicObject> billMap, String billId) {
        DynamicObject dynamicObject;
        if (billMap.get(billId) != null) {
            dynamicObject = billMap.get(billId);
        } else {
            dynamicObject = BusinessDataServiceHelper.loadSingle((String)billNumber, (String)("id,createtime," + billno), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(billId))});
            if (dynamicObject != null) {
                billMap.put(billId, dynamicObject);
            }
        }
        return dynamicObject;
    }

    private void bulidCurrentNoLinkBillPage(QueryTcLinkArgs args, MainEntityType sourceMainType, MainEntityType targetMainType, LinkSetElement linkSet, HashMap<String, DynamicObject> sourceMap, HashMap<String, DynamicObject> targetMap, List<QueryTcLinkPo> result) {
        int i;
        for (i = 0; i < result.size(); ++i) {
            sourceMap.remove(result.get(i).getFsbillid());
            targetMap.remove(result.get(i).getFtbillid());
        }
        if (this.fidShowed.size() > 0) {
            for (i = 1; i < args.getPageIndex(); ++i) {
                if (this.fidShowed.get(i) == null) continue;
                for (int j = 0; j < this.fidShowed.get(i).size(); ++j) {
                    sourceMap.remove(this.fidShowed.get(i).get(j));
                    targetMap.remove(this.fidShowed.get(i).get(j));
                }
            }
        }
        ArrayList<String> fidListTmp = new ArrayList<String>(16);
        if (result.size() < args.getPageRows() && sourceMap.size() > 0) {
            this.loadNoLinkBillInfo(sourceMainType, targetMainType, linkSet, sourceMap, result, fidListTmp, args.getPageRows(), true);
        }
        if (result.size() < args.getPageRows() && targetMap.size() > 0) {
            this.loadNoLinkBillInfo(sourceMainType, targetMainType, linkSet, targetMap, result, fidListTmp, args.getPageRows(), false);
        }
        this.fidShowed.put(args.getPageIndex(), fidListTmp);
    }

    private void loadNoLinkBillInfo(MainEntityType sourceMainType, MainEntityType targetMainType, LinkSetElement linkSet, HashMap<String, DynamicObject> billMap, List<QueryTcLinkPo> result, List<String> fidListTmp, int pageRows, boolean isSourceBill) {
        String sourceBillno = ((BillEntityType)sourceMainType).getBillNo();
        String targetBillno = ((BillEntityType)targetMainType).getBillNo();
        Map<String, LinkTcPo> map = isSourceBill ? this.loadTcByFids(targetMainType, linkSet, new ArrayList<String>(billMap.keySet()), null) : this.loadTcByFids(targetMainType, linkSet, null, new ArrayList<String>(billMap.keySet()));
        for (Map.Entry<String, DynamicObject> entry : billMap.entrySet()) {
            if (map.get(entry.getKey()) != null) continue;
            QueryTcLinkPo queryLinkPo = new QueryTcLinkPo();
            if (isSourceBill) {
                queryLinkPo.setSourceFid(String.valueOf(entry.getValue().getPkValue()));
                queryLinkPo.setSourceBillNo(String.valueOf(entry.getValue().get(sourceBillno)));
                queryLinkPo.setSourceCreatetime((Date)entry.getValue().get("createtime"));
            } else {
                queryLinkPo.setTargetFid(String.valueOf(entry.getValue().getPkValue()));
                queryLinkPo.setTargetBillNo(String.valueOf(entry.getValue().get(targetBillno)));
                queryLinkPo.setTargetCreatetime((Date)entry.getValue().get("createtime"));
            }
            result.add(queryLinkPo);
            fidListTmp.add(String.valueOf(entry.getValue().getPkValue()));
            if (result.size() != pageRows) continue;
            break;
        }
    }

    private void noLinkBillPage(MainEntityType targetMainType, LinkSetElement linkSet, HashMap<String, DynamicObject> sourceMap, HashMap<String, DynamicObject> targetMap, int pageIndex, int pageRows) {
        HashMap<String, DynamicObject> source = new HashMap<String, DynamicObject>(16);
        source.putAll(sourceMap);
        HashMap<String, DynamicObject> target = new HashMap<String, DynamicObject>(16);
        target.putAll(targetMap);
        int allPageNum = (this.resultCount + this.otherCount) % pageRows > 0 ? (this.resultCount + this.otherCount) / pageRows + 1 : (this.resultCount + this.otherCount) / pageRows;
        int fromIndex = this.resultCount / pageRows;
        if (this.resultCount % pageRows > 0) {
            ++fromIndex;
        }
        for (int i = 1; i <= allPageNum; ++i) {
            Map.Entry entry;
            int pageSize = pageRows;
            if (i < fromIndex) {
                this.fidShowed.put(i, new ArrayList(16));
                continue;
            }
            if (i == fromIndex) {
                pageSize -= this.resultCount % pageRows;
            }
            ArrayList<String> fidListTmp = new ArrayList<String>(16);
            if (source.size() > 0) {
                Map<String, LinkTcPo> map = this.loadTcByFids(targetMainType, linkSet, new ArrayList<String>(source.keySet()), null);
                Iterator iterator = source.entrySet().iterator();
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    if (map.get(entry.getKey()) != null) {
                        iterator.remove();
                        continue;
                    }
                    fidListTmp.add(String.valueOf(((DynamicObject)entry.getValue()).getPkValue()));
                    iterator.remove();
                    if (fidListTmp.size() != pageSize) continue;
                    break;
                }
            }
            if (target.size() > 0) {
                Iterator iterator = target.entrySet().iterator();
                Map<String, LinkTcPo> map = this.loadTcByFids(targetMainType, linkSet, null, new ArrayList<String>(target.keySet()));
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    if (map.get(entry.getKey()) != null) {
                        iterator.remove();
                        continue;
                    }
                    fidListTmp.add(String.valueOf(((DynamicObject)entry.getValue()).getPkValue()));
                    iterator.remove();
                    if (fidListTmp.size() != pageSize) continue;
                    break;
                }
            }
            this.fidShowed.put(i, fidListTmp);
        }
    }

    private SqlBuilder builderSql(String tcTable, String sourceNumber, String sourceEntity, String targetNumber, String targetEntity, List<Long> sourceFids, List<Long> targetFids, int pageIndex, int pageRows, Boolean isGetCount) {
        TableDefine tableDefine;
        SqlBuilder sBuilder = new SqlBuilder();
        if (!isGetCount.booleanValue()) {
            sBuilder.append("select top ", new Object[0]);
            sBuilder.append(String.valueOf(pageRows), new Object[0]);
            sBuilder.append(",", new Object[0]);
            sBuilder.append(String.valueOf(pageRows * (pageIndex - 1)), new Object[0]);
            sBuilder.append(" fid,ftbillid,ftid,fttableid,fsbillid,fstableid,fsid ", new Object[0]);
        } else {
            sBuilder.append("select count(*) as num ", new Object[0]);
        }
        sBuilder.append("FROM ", new Object[0]);
        sBuilder.append(tcTable, new Object[0]);
        sBuilder.append(" where 1 = 1 ", new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)sourceEntity) && (tableDefine = LinkQueryUtil.loadTableDefine(sourceNumber, sourceEntity)) != null) {
            sBuilder.append("and fstableid = ", new Object[0]);
            sBuilder.append(String.valueOf(tableDefine.getTableId()), new Object[0]);
            sBuilder.append(" ", new Object[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)targetEntity) && (tableDefine = LinkQueryUtil.loadTableDefine(targetNumber, targetEntity)) != null) {
            sBuilder.append("and fttableid = ", new Object[0]);
            sBuilder.append(String.valueOf(tableDefine.getTableId()), new Object[0]);
            sBuilder.append(" ", new Object[0]);
        }
        if (targetFids.size() > 0) {
            sBuilder.append(" and ", new Object[0]);
            sBuilder.appendIn("ftbillid", targetFids.toArray());
        }
        if (sourceFids.size() > 0) {
            sBuilder.append(" and ", new Object[0]);
            sBuilder.appendIn("fsbillid", sourceFids.toArray());
        }
        return sBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, LinkTcPo> loadTcByFids(MainEntityType targetMainType, LinkSetElement linkSet, final List<String> sourceBillIds, List<String> targetBillIds) {
        ShardingHintContext ctx;
        if (CollectionUtils.isEmpty(sourceBillIds) && CollectionUtils.isEmpty(targetBillIds)) {
            return new HashMap<String, LinkTcPo>(16);
        }
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("select fid,ftbillid,ftid,fttableid,fsbillid,fstableid,fsid ");
        sBuilder.append("FROM ");
        sBuilder.append(linkSet.getTrackerTable());
        sBuilder.append(" where 1=1");
        ResultSetHandler<Map<String, LinkTcPo>> action = new ResultSetHandler<Map<String, LinkTcPo>>(){

            public Map<String, LinkTcPo> handle(ResultSet rs) throws SQLException {
                HashMap<String, LinkTcPo> map = new HashMap<String, LinkTcPo>(16);
                while (rs.next()) {
                    LinkTcPo linkTcPo = new LinkTcPo();
                    linkTcPo.setFid(rs.getString("fid"));
                    linkTcPo.setFtbillid(rs.getString("ftbillid"));
                    linkTcPo.setFtid(rs.getString("ftid"));
                    linkTcPo.setFttableid(rs.getString("fttableid"));
                    linkTcPo.setFsbillid(rs.getString("fsbillid"));
                    linkTcPo.setFsid(rs.getString("fsid"));
                    linkTcPo.setFstableid(rs.getString("fstableid"));
                    if (sourceBillIds != null && sourceBillIds.size() > 0) {
                        map.put(rs.getString("fsbillid"), linkTcPo);
                        continue;
                    }
                    map.put(rs.getString("ftbillid"), linkTcPo);
                }
                return map;
            }
        };
        if (sourceBillIds != null && sourceBillIds.size() > 0) {
            sBuilder.append(" and fsbillid in(").append(String.join((CharSequence)COMMA_CODE, sourceBillIds)).append(") ");
        }
        if (targetBillIds != null && targetBillIds.size() > 0) {
            sBuilder.append(" and ftbillid in(").append(String.join((CharSequence)COMMA_CODE, targetBillIds)).append(") ");
        }
        if (targetBillIds == null) {
            targetBillIds = new ArrayList<String>(16);
        }
        if (sourceBillIds != null) {
            targetBillIds.addAll(sourceBillIds);
        }
        if ((ctx = ShardingHinter.tryHint((IDataEntityType)targetMainType, (Object[])targetBillIds.toArray())) != null) {
            try {
                ctx.set();
                Map map = (Map)DB.query((DBRoute)new DBRoute(targetMainType.getDBRouteKey()), (String)sBuilder.toString(), (ResultSetHandler)action);
                return map;
            }
            finally {
                ctx.close();
            }
        }
        return (Map)DB.query((DBRoute)new DBRoute(targetMainType.getDBRouteKey()), (String)sBuilder.toString(), (ResultSetHandler)action);
    }

    private ResultSetHandler<List<QueryTcLinkPo>> getAction() {
        ResultSetHandler<List<QueryTcLinkPo>> action = new ResultSetHandler<List<QueryTcLinkPo>>(){

            public List<QueryTcLinkPo> handle(ResultSet rs) throws SQLException {
                ArrayList<QueryTcLinkPo> queryLinkPos = new ArrayList<QueryTcLinkPo>(16);
                while (rs.next()) {
                    QueryTcLinkPo queryLinkPo = new QueryTcLinkPo();
                    queryLinkPo.setFid(rs.getString("fid"));
                    queryLinkPo.setFtbillid(rs.getString("ftbillid"));
                    queryLinkPo.setFtid(rs.getString("ftid"));
                    queryLinkPo.setFttableid(rs.getString("fttableid"));
                    queryLinkPo.setFsbillid(rs.getString("fsbillid"));
                    queryLinkPo.setFsid(rs.getString("fsid"));
                    queryLinkPo.setFstableid(rs.getString("fstableid"));
                    queryLinkPos.add(queryLinkPo);
                }
                return queryLinkPos;
            }
        };
        return action;
    }

    private void getFidByBillNo(MainEntityType targetMainType, LinkSetElement linkSet, String billNumber, List<String> billnos, List<Long> fids, List<Long> removeFids, HashMap<String, DynamicObject> billMap, String tcBillFid, Boolean isGetCount) {
        String billno = ((BillEntityType)targetMainType).getBillNo();
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)billNumber, (String)("id,createtime," + billno), (QFilter[])new QFilter[]{new QFilter(billno, "in", (Object)billnos.toArray())});
        if (dynamicObjects == null) {
            return;
        }
        List<String> ids = Arrays.stream(dynamicObjects).map(a -> String.valueOf(a.getPkValue())).collect(Collectors.toList());
        Map<String, LinkTcPo> map = "fsbillid".equals(tcBillFid) ? this.loadTcByFids(targetMainType, linkSet, ids, null) : this.loadTcByFids(targetMainType, linkSet, null, ids);
        for (int i = 0; i < dynamicObjects.length; ++i) {
            Long fid = (Long)dynamicObjects[i].getPkValue();
            fids.add(fid);
            if (!isGetCount.booleanValue()) {
                billMap.put(String.valueOf(fid), dynamicObjects[i]);
                continue;
            }
            if (map.get(String.valueOf(fid)) == null) continue;
            removeFids.add(fid);
        }
    }
}

