/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.botp.linkquery;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.linkquery.QueryWbSnapArgs;
import kd.bos.entity.botp.linkquery.QueryWriteBackSnapPo;
import kd.bos.util.CollectionUtils;

public class LinkWbDataQueryService {
    private static String COMMA_CODE = ",";

    public Map<String, String> loadWbSnapMap(QueryWbSnapArgs args) {
        if (CollectionUtils.isEmpty((Collection)args.getSbillids()) && CollectionUtils.isEmpty((Collection)args.getFids())) {
            return new HashMap<String, String>(16);
        }
        StringBuilder sBuilder = new StringBuilder();
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)args.getTargetNumber());
        LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)args.getTargetNumber());
        sBuilder.append("select fid,fsbillid ");
        sBuilder.append("FROM ");
        sBuilder.append(linkSet.getWbSnapTable());
        sBuilder.append(" where 1 = 1 ");
        if (args.getFids() != null && args.getFids().size() > 0 && args.getSbillids() != null && args.getSbillids().size() == 0) {
            sBuilder.append("and fid in(").append(String.join((CharSequence)COMMA_CODE, args.getFids())).append(") ");
        } else if (args.getFids() != null && args.getFids().size() > 0 && args.getSbillids() != null && args.getSbillids().size() > 0) {
            sBuilder.append("and fid in(").append(String.join((CharSequence)COMMA_CODE, args.getFids())).append(") ");
            sBuilder.append("or fsbillid in(").append(String.join((CharSequence)COMMA_CODE, args.getSbillids())).append(") ");
            if (args.getSids() != null && args.getSids().size() > 0) {
                sBuilder.append("or fsid in(").append(String.join((CharSequence)COMMA_CODE, args.getSids())).append(") ");
            }
        } else {
            sBuilder.append("and fsbillid in(").append(String.join((CharSequence)COMMA_CODE, args.getSbillids())).append(") ");
            if (args.getSids() != null && args.getSids().size() > 0) {
                sBuilder.append("and fsid in(").append(String.join((CharSequence)COMMA_CODE, args.getSids())).append(") ");
            }
        }
        ResultSetHandler<Map<String, String>> action = new ResultSetHandler<Map<String, String>>(){

            public Map<String, String> handle(ResultSet rs) throws SQLException {
                HashMap<String, String> map = new HashMap<String, String>(16);
                while (rs.next()) {
                    map.put(rs.getString("fid"), rs.getString("fid"));
                    map.put(rs.getString("fsbillid"), rs.getString("fid"));
                }
                return map;
            }
        };
        return (Map)DB.query((DBRoute)new DBRoute(targetMainType.getDBRouteKey()), (String)sBuilder.toString(), (ResultSetHandler)action);
    }

    public List<QueryWriteBackSnapPo> loadWbSnap(QueryWbSnapArgs args) {
        if (StringUtils.isBlank((CharSequence)args.getTargetNumber()) || CollectionUtils.isEmpty((Collection)args.getSbillids()) && CollectionUtils.isEmpty((Collection)args.getSids()) && CollectionUtils.isEmpty((Collection)args.getFids())) {
            return new ArrayList<QueryWriteBackSnapPo>(16);
        }
        StringBuilder sBuilder = new StringBuilder();
        MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)args.getTargetNumber());
        LinkSetElement linkSet = EntityMetadataCache.getLinkSet((String)args.getTargetNumber());
        sBuilder.append("select fid,fentryid,fseq,fruleverid,fruleitemid,foperate,fstableid,fsid,fsbillid,fwritevalue ");
        sBuilder.append("FROM ");
        sBuilder.append(linkSet.getWbSnapTable());
        sBuilder.append(" where 1 = 1 ");
        if (args.getFids() != null && args.getFids().size() > 0 && args.getSbillids() != null && args.getSbillids().size() == 0) {
            sBuilder.append("and fid in(").append(String.join((CharSequence)COMMA_CODE, args.getFids())).append(") ");
        } else if (args.getFids() != null && args.getFids().size() > 0 && args.getSbillids() != null && args.getSbillids().size() > 0) {
            sBuilder.append("and fid in(").append(String.join((CharSequence)COMMA_CODE, args.getFids())).append(") ");
            sBuilder.append("or fsbillid in(").append(String.join((CharSequence)COMMA_CODE, args.getSbillids())).append(") ");
            if (args.getSids() != null && args.getSids().size() > 0) {
                sBuilder.append("or fsid in(").append(String.join((CharSequence)COMMA_CODE, args.getSids())).append(") ");
            }
        } else {
            sBuilder.append("and fsbillid in(").append(String.join((CharSequence)COMMA_CODE, args.getSbillids())).append(") ");
            if (args.getSids() != null && args.getSids().size() > 0) {
                sBuilder.append("and fsid in(").append(String.join((CharSequence)COMMA_CODE, args.getSids())).append(") ");
            }
        }
        ResultSetHandler<List<QueryWriteBackSnapPo>> action = new ResultSetHandler<List<QueryWriteBackSnapPo>>(){

            public List<QueryWriteBackSnapPo> handle(ResultSet rs) throws SQLException {
                ArrayList<QueryWriteBackSnapPo> queryWriteBackSnapPos = new ArrayList<QueryWriteBackSnapPo>(16);
                while (rs.next()) {
                    QueryWriteBackSnapPo writeBackSnap = new QueryWriteBackSnapPo();
                    writeBackSnap.setFid(rs.getString("fid"));
                    writeBackSnap.setFentryid(rs.getString("fentryid"));
                    writeBackSnap.setFseq(rs.getString("fseq"));
                    writeBackSnap.setFruleverid(rs.getString("fruleverid"));
                    writeBackSnap.setFruleitemid(rs.getString("fruleitemid"));
                    writeBackSnap.setFoperate(rs.getString("foperate"));
                    writeBackSnap.setFsbillid(rs.getString("fsbillid"));
                    writeBackSnap.setFsid(rs.getString("fsid"));
                    writeBackSnap.setFstableid(rs.getString("fstableid"));
                    writeBackSnap.setFwritevalue(rs.getString("fwritevalue"));
                    queryWriteBackSnapPos.add(writeBackSnap);
                }
                return queryWriteBackSnapPos;
            }
        };
        return (List)DB.query((DBRoute)new DBRoute(targetMainType.getDBRouteKey()), (String)sBuilder.toString(), null, (ResultSetHandler)action);
    }
}

