/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ctbotp.apiparam.CtAutoMatchFieldsReq;
import kd.bos.entity.ctbotp.apiparam.TreeNodeParam;
import kd.bos.entity.ctbotp.dto.DynamicPropertyDto;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.PictureProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ctbotp.CtBillTreeBuildParameter;
import kd.bos.service.ctbotp.CtEntityParseHelper;
import kd.bos.service.ctbotp.GetTargetFieldInfo;

public class GetSourceFieldInfo {
    private Log log = LogFactory.getLog(GetSourceFieldInfo.class);
    private GetTargetFieldInfo getTargetFieldInfo = new GetTargetFieldInfo();

    public TreeNode getSourceTreeNode(TreeNodeParam param) {
        String targetProperty;
        MainEntityType sourceMainType = null;
        if (StringUtils.isNotBlank((CharSequence)param.getSourceEntityNumber())) {
            sourceMainType = EntityMetadataCache.getDataEntityType((String)param.getSourceEntityNumber());
        }
        if (StringUtils.isBlank((CharSequence)(targetProperty = param.getTargetProperty()))) {
            return null;
        }
        Class<?> type = null;
        try {
            type = Class.forName(targetProperty);
        }
        catch (ClassNotFoundException e) {
            this.log.error((Throwable)e);
        }
        CtBillTreeBuildParameter parameter = new CtBillTreeBuildParameter(sourceMainType, null, type);
        parameter.setIncludePKField(true);
        parameter.setEntityNumbers(param.getEntityNumbers());
        TreeNode srcBillNode = CtEntityParseHelper.buildBillTreeNodes(parameter);
        return srcBillNode;
    }

    public TreeNode getSourceBillTreeNode(String entityNumber, String selectEntitys) {
        MainEntityType sourceMainType = null;
        if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
            sourceMainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        }
        CtBillTreeBuildParameter parameter = new CtBillTreeBuildParameter(sourceMainType);
        parameter.setIncludePKField(true);
        if (StringUtils.isNotBlank((CharSequence)selectEntitys)) {
            HashSet entitys = (HashSet)SerializationUtils.fromJsonString((String)selectEntitys, HashSet.class);
            parameter.getSelectedEntity().addAll(entitys);
            parameter.getForbidClassTypes().add(AttachmentProp.class);
            parameter.getForbidClassTypes().add(PictureProp.class);
            parameter.getForbidRefPropFieldTypes().add(MulBasedataProp.class);
        }
        TreeNode billTreeNode = CtEntityParseHelper.buildBillTreeNodes(parameter);
        return billTreeNode;
    }

    public Map<String, DynamicPropertyDto> getAutoMatchFields(CtAutoMatchFieldsReq autoMatchFieldsReq) {
        MainEntityType sourceMainType = null;
        HashMap<String, DynamicPropertyDto> result = new HashMap<String, DynamicPropertyDto>(16);
        String entityNumber = autoMatchFieldsReq.getEntityNumber();
        if (StringUtils.isNotBlank((CharSequence)entityNumber)) {
            sourceMainType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        }
        if (sourceMainType == null) {
            return null;
        }
        for (String fieldKey : autoMatchFieldsReq.getFieldKeys()) {
            DynamicProperty dynamicProperty = (DynamicProperty)sourceMainType.findProperty(fieldKey);
            if (dynamicProperty == null) continue;
            DynamicPropertyDto dto = new DynamicPropertyDto();
            dto.setClassName(dynamicProperty.getClass().getName());
            dto.setParentName(dynamicProperty.getParent().getName());
            dto.setDisplayName(dynamicProperty.getName());
            dto.setAlias(dynamicProperty.getAlias());
            Boolean supportAutoMatch = this.getTargetFieldInfo.isSupportAutoBatch(entityNumber, fieldKey);
            dto.setSupportAutoBatch(supportAutoMatch);
            String name = this.getFieldCaption(entityNumber, fieldKey, RequestContext.get().getLang().toString());
            dto.setFieldName(name);
            result.put(fieldKey, dto);
        }
        return result;
    }

    public String getFieldCaption(String sourceEntityNumber, String fieldPropName, String localId) {
        if (StringUtils.isNotBlank((CharSequence)sourceEntityNumber) && StringUtils.isNotBlank((CharSequence)fieldPropName)) {
            MainEntityType sourceMainType = EntityMetadataCache.getDataEntityType((String)sourceEntityNumber);
            return CtEntityParseHelper.buildPropFullCaption((EntityType)sourceMainType, fieldPropName, localId);
        }
        this.log.error("sourceEntityNumber is " + sourceEntityNumber + "fieldPropName is " + fieldPropName);
        return "";
    }
}

