/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ctbotp.syncdata.SyncRuleRecord;
import kd.bos.entity.ctbotp.syncdata.SyncRuleResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.ctbotp.CtConvertRuleMetadata;
import kd.bos.metadata.ctbotp.CtRuleTreeNode;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.CtConvertMetaServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class SyncCtConvertRule {
    private static final Log log = LogFactory.getLog(SyncCtConvertRule.class);
    private static final String CT_BOTP_CONVERTRULE_SYNCLOG = "ct_botp_rule_synclog";

    public SyncRuleResult syncRule(CtRuleTreeNode rootRuleNode) {
        SyncRuleResult result = new SyncRuleResult();
        List ruleNodes = rootRuleNode.mergeAllChildren();
        HashSet<Long> verIds = new HashSet<Long>(ruleNodes.size());
        for (CtRuleTreeNode ruleNode : ruleNodes) {
            CtConvertRuleMetadata ruleMetadata = ruleNode.deserialize(rootRuleNode);
            Map map = CtConvertMetaServiceHelper.syncRuleSave((CtConvertRuleMetadata)ruleMetadata);
            if (!((Boolean)map.get("success")).booleanValue()) continue;
            long verId = ruleMetadata.getRuleElement().getCurrentVerId();
            if (ruleMetadata.getDevType().equals("2")) {
                verId = ruleMetadata.getRuleElement().getExtVerId();
            }
            verIds.add(verId);
        }
        for (CtRuleTreeNode ruleNode : ruleNodes) {
            if (ruleNode.getDevType().equals("2")) continue;
            CtConvertMetaServiceHelper.saveRuleVer((String)ruleNode.getId());
        }
        if (verIds.size() <= 0) {
            result.setSuccess(false);
        } else {
            result.setVerIds(verIds);
        }
        return result;
    }

    public SyncRuleRecord getSyncRec(Long verId) {
        SyncRuleRecord record = null;
        IDataEntityType dType = OrmUtils.getDataEntityType(SyncRuleRecord.class);
        try {
            record = (SyncRuleRecord)BusinessDataReader.read((Object)verId, (IDataEntityType)dType, (Boolean)false);
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        return record;
    }

    public void updateSyncStatus(Long verId) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)CT_BOTP_CONVERTRULE_SYNCLOG);
        MainEntityType subEntityType = (MainEntityType)mainEntityType.getSubEntityType(Arrays.asList("id", "sourcestatus", "updatetime", "modifier"));
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)verId, (DynamicObjectType)subEntityType);
        dynamicObject.set("updatetime", (Object)new Date());
        dynamicObject.set("modifier", (Object)new Date());
        dynamicObject.set("sourcestatus", (Object)"S");
        SaveServiceHelper.update((DynamicObject)dynamicObject);
    }
}

