/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ctbotp.CtConvertRuleElement;
import kd.bos.entity.ctbotp.runtime.CtSourceBillReport;
import kd.bos.entity.ctbotp.runtime.CtSourceRowReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.service.ctbotp.convert.BillAndRule;
import kd.bos.service.ctbotp.convert.group.CtSourceRowId;
import kd.bos.service.ctbotp.convert.sort.CtListSelectedRowComparator;

public class CtConvertReportManager {
    private Map<Object, BillAndRule> billAndRules = new HashMap<Object, BillAndRule>();
    private Map<Object, CtSourceBillReport> billReports = new LinkedHashMap<Object, CtSourceBillReport>();
    private Set<CtSourceRowId> linkSourceRowIds = new HashSet<CtSourceRowId>();
    private Map<CtConvertRuleElement, String> breakMessages = new HashMap<CtConvertRuleElement, String>();

    public Collection<BillAndRule> getBillAndRules() {
        return this.billAndRules.values();
    }

    public List<Object> getNoRuleBillIds() {
        ArrayList<Object> billIds = new ArrayList<Object>();
        for (BillAndRule bill : this.billAndRules.values()) {
            if (!StringUtils.isBlank((CharSequence)bill.getRuleId())) continue;
            billIds.add(bill.getBillId());
        }
        return billIds;
    }

    public BillAndRule getOneBillIdByRule(String ruleId) {
        for (BillAndRule bill : this.billAndRules.values()) {
            if (!StringUtils.isNotEmpty((CharSequence)bill.getRuleId()) || !bill.getRuleId().equals(ruleId) || bill.getBillId() == null) continue;
            return bill;
        }
        return null;
    }

    public Collection<CtSourceBillReport> getBillReports() {
        return this.billReports.values();
    }

    public CtSourceBillReport getBillReports(Long billid) {
        return this.billReports.get(billid);
    }

    public Map<CtConvertRuleElement, String> getBreakMessages() {
        return this.breakMessages;
    }

    public void addBreakMessage(CtConvertRuleElement rule, String failMessage) {
        this.breakMessages.put(rule, failMessage);
    }

    public void initBillAndRules(List<ListSelectedRow> selectedRows) {
        ArrayList<ListSelectedRow> sortRows = new ArrayList<ListSelectedRow>(selectedRows.size());
        sortRows.addAll(selectedRows);
        CtListSelectedRowComparator comparator = new CtListSelectedRowComparator();
        sortRows.sort(comparator);
        for (ListSelectedRow row : sortRows) {
            Object billId = row.getPrimaryKeyValue();
            if (this.billAndRules.containsKey(billId)) continue;
            BillAndRule billAndRule = new BillAndRule(billId, row.getBillNo());
            this.billAndRules.put(billId, billAndRule);
            this.createBillReport(billId, row.getBillNo());
        }
    }

    public void updateRuleId(Object billId, String ruleId, String ruleName) {
        BillAndRule billAndRule = this.billAndRules.get(billId);
        billAndRule.setRuleId(ruleId);
        billAndRule.setRuleName(ruleName);
        CtSourceBillReport billReport = this.billReports.get(billId);
        if (billReport == null) {
            billReport = new CtSourceBillReport();
            billReport.setBillId(billId);
            this.billReports.put(billId, billReport);
        }
        billReport.setRuleId(ruleId);
        billReport.setRuleName(ruleName);
    }

    private void createBillReport(Object billId, String billNo) {
        if (!this.billReports.containsKey(billId)) {
            CtSourceBillReport billReport = new CtSourceBillReport();
            billReport.setBillId(billId);
            billReport.setBillNo(billNo);
            this.billReports.put(billId, billReport);
        }
    }

    public void failBill(Object billId, String failMessage) {
        CtSourceBillReport billReport = this.billReports.get(billId);
        if (billReport != null) {
            billReport.addFailMessage(failMessage);
        }
    }

    public void addLinkRow(Object billId, String billNo, String linkEntityKey, String linkEntityName, String entryKey, String entryName, String subEntryKey, String subEntryName, CtSourceRowId sourceRowId) {
        if (this.linkSourceRowIds.add(sourceRowId)) {
            this.addLinkRow(billId, billNo, linkEntityKey, linkEntityName, entryKey, entryName, subEntryKey, subEntryName);
        }
    }

    public void addLinkRow(Object billId, String billNo, String linkEntityKey, String linkEntityName, String entryKey, String entryName, String subEntryKey, String subEntryName) {
        CtSourceBillReport billReport = this.billReports.get(billId);
        if (billReport == null) {
            billReport = new CtSourceBillReport();
            billReport.setBillId(billId);
            this.billReports.put(billId, billReport);
        }
        billReport.setBillNo(billNo);
        billReport.setLinkEntityKey(linkEntityKey);
        billReport.setLinkEntityName(linkEntityName);
        billReport.addRowCount(1);
        billReport.setEntryKey(entryKey);
        billReport.setEntryName(entryName);
        billReport.setSubEntryKey(subEntryKey);
        billReport.setSubEntryName(subEntryName);
    }

    public void addErrorReport(String entityKey, CtSourceRowId rowInfo, String failMessage) {
        CtSourceBillReport billReport = this.billReports.get(rowInfo.getBillId());
        if (billReport == null) {
            return;
        }
        CtSourceRowReport rowReport = new CtSourceRowReport();
        rowReport.setEntryId(rowInfo.getEntryId());
        rowReport.setEntrySeq(rowInfo.getEntrySeq());
        rowReport.setSubEntryId(rowInfo.getSubEntryId());
        rowReport.setSubEntrySeq(rowInfo.getSubEntrySeq());
        rowReport.getFailMessages().add(failMessage);
        billReport.addSourceRowReport(entityKey, rowReport);
    }
}

