/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert;

import java.util.Collection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.trace.EntityTraceHint;
import kd.bos.dataentity.trace.EntityTraceSpan;
import kd.bos.dataentity.trace.EntityTracer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ctbotp.constants.SourceOperateEnum;
import kd.bos.entity.ctbotp.runtime.CtConvertOperationResult;
import kd.bos.entity.ctbotp.runtime.CtPushArgs;
import kd.bos.id.ID;
import kd.bos.service.ctbotp.ICtConvertService;
import kd.bos.service.ctbotp.convert.CtConvertEngine;
import org.apache.commons.collections4.CollectionUtils;

public class CtConvertServiceImpl
implements ICtConvertService {
    private static final String CONVERT_SERVICE = "ConvertService";

    public String ctPush(String argsJson) {
        CtPushArgs args = (CtPushArgs)SerializationUtils.fromJsonString((String)argsJson, CtPushArgs.class);
        try (EntityTraceSpan span = EntityTracer.create((String)CONVERT_SERVICE, (String)"CtConvertServiceImpl.ctPush", (EntityTraceHint)new EntityTraceHint(false));){
            if (span.isRealtime()) {
                span.addTag("SourceEntityNumber", args.getSourceEntityNumber());
                span.addTag("TargetEntityNumber", args.getTargetEntityNumber());
                span.addTag("CurrentOrgId", "" + args.getCurrentOrgId());
                span.addTag("ListSelectedRow", CollectionUtils.isEmpty((Collection)args.getSelectedRows()) ? "null" : SerializationUtils.toJsonString(args.getSelectedRows().get(0)));
            }
            CtConvertEngine engine = new CtConvertEngine();
            CtConvertOperationResult result = null;
            if (StringUtils.isNotBlank((CharSequence)args.getSourceOperate()) && args.getSourceOperate().equals(SourceOperateEnum.EVENT.getValue())) {
                result = engine.ctEventPush(args);
            } else {
                args.setRootJobId(Long.valueOf(ID.genLongId()));
                result = engine.ctPush(args);
            }
            String string = SerializationUtils.toJsonString((Object)result);
            return string;
        }
    }
}

