/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.actions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ctbotp.CtDataEntity;
import kd.bos.entity.ctbotp.CtExtendedDataEntity;
import kd.bos.entity.ctbotp.CtExtendedDataEntitySet;
import kd.bos.entity.ctbotp.constants.CtPushProcessEnum;
import kd.bos.entity.ctbotp.runtime.CtAttachmentPanelMap;
import kd.bos.openapi.base.util.DynamicObjectUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ctbotp.convert.CtConvertContext;
import kd.bos.service.ctbotp.convert.CtConvertResultManager;
import kd.bos.service.ctbotp.convert.actions.AbstractCtConvertAction;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class CtAttachmentPanelPushAction
extends AbstractCtConvertAction {
    public CtAttachmentPanelPushAction(CtConvertContext context, CtConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    protected void doAction() {
        super.doAction();
        String sourceEntityNumber = this.context.getInputArgs().getSourceEntityNumber();
        String targetEntityNumber = this.context.getInputArgs().getTargetEntityNumber();
        Map<String, CtAttachmentPanelMap> attachmentPanelMapRules = this.ruleContext.getRuleCompiler().getAttachmentPanelMaps();
        if (attachmentPanelMapRules == null || attachmentPanelMapRules.isEmpty()) {
            return;
        }
        if ((attachmentPanelMapRules = attachmentPanelMapRules.entrySet().stream().filter(entry -> StringUtils.isNotBlank((CharSequence)((CtAttachmentPanelMap)entry.getValue()).getSourceAttachmentPanelKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).isEmpty()) {
            return;
        }
        CtExtendedDataEntitySet targetExtDataSet = this.getTargetExtendedDataEntities();
        CtExtendedDataEntity[] targetExtDataEntitys = targetExtDataSet.FindByEntityKey(targetEntityNumber);
        this.setAttachmentPanelMapList(targetExtDataEntitys, sourceEntityNumber, attachmentPanelMapRules);
    }

    @Override
    protected void setProcess() {
        this.resultManager.setCtPushProcessEnum(CtPushProcessEnum.CtAttachmentPanelPushAction);
    }

    protected void setAttachmentPanelMapList(CtExtendedDataEntity[] targetExtDataEntitys, String sourceEntityNumber, Map<String, CtAttachmentPanelMap> attachmentPanelMapRules) {
        String sourceAppId = this.getContext().getSourceMainType().getAppId();
        for (CtExtendedDataEntity extDataEntity : targetExtDataEntitys) {
            ArrayList attachmentPanelMapList = new ArrayList();
            CtDataEntity ctDataEntity = extDataEntity.getCtDataEntity();
            Long targetBillPk = ctDataEntity.getId();
            List sourceRows = (List)extDataEntity.getValue("ConvertSource");
            if (sourceRows == null || sourceRows.isEmpty()) continue;
            ArrayList<String> sourcePks = new ArrayList<String>(sourceRows.size());
            for (DynamicObject dynamicObject : sourceRows) {
                String sourceId = String.valueOf(dynamicObject.getPkValue());
                if (sourcePks.contains(sourceId)) continue;
                sourcePks.add(sourceId);
            }
            for (Map.Entry entry : attachmentPanelMapRules.entrySet()) {
                CtAttachmentPanelMap ctAttachmentPanelMap = (CtAttachmentPanelMap)entry.getValue();
                QFilter entityNumberQFilter = new QFilter("fbilltype", "=", (Object)ctAttachmentPanelMap.getSourceEntityNumber());
                QFilter billPkQFilter = new QFilter("finterid", "in", sourcePks);
                QFilter attKeyQFilter = new QFilter("fattachmentpanel", "=", (Object)ctAttachmentPanelMap.getSourceAttachmentPanelKey());
                Map sourceAttchmentMap = BusinessDataServiceHelper.loadFromCache((String)"bos_attachment", (QFilter[])new QFilter[]{entityNumberQFilter, billPkQFilter, attKeyQFilter});
                List curAttachmentPanelMapList = DynamicObjectUtil.serializeToListMap((DynamicObject[])sourceAttchmentMap.values().toArray(new DynamicObject[0]));
                for (Map curAttachmentPanelMap : curAttachmentPanelMapList) {
                    curAttachmentPanelMap.put("target_finterid", targetBillPk);
                    curAttachmentPanelMap.put("target_fbilltype", ctAttachmentPanelMap.getTargetEntityNumber());
                    curAttachmentPanelMap.put("target_fattachmentpanel", ctAttachmentPanelMap.getTargetAttachmentPanelKey());
                    curAttachmentPanelMap.put("source_appId", sourceAppId);
                }
                attachmentPanelMapList.addAll(curAttachmentPanelMapList);
            }
            ctDataEntity.setAttachmentPanelMapList(attachmentPanelMapList);
        }
    }
}

