/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ctbotp.constants.CtApiUrlEnum;
import kd.bos.entity.ctbotp.runtime.CtPushArgs;
import kd.bos.entity.ctbotp.runtime.CtSaveArgs;
import kd.bos.entity.ctbotp.runtime.CtSaveOperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ctbotp.convert.CtConvertContext;
import kd.bos.service.ctbotp.convert.CtConvertResultManager;
import kd.bos.service.ctbotp.convert.actions.AbstractCtConvertAction;
import kd.bos.service.ctbotp.utils.CtBotpApiUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class CtConvertSaveAction
extends AbstractCtConvertAction {
    private static final Log log = LogFactory.getLog(CtConvertSaveAction.class);
    private static final String BOS_MSERVICE_OPERATION = "bos-mservice-botp";

    public CtConvertSaveAction(CtConvertContext context, CtConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    public void setProcess() {
    }

    @Override
    protected void doAction() {
        super.doAction();
        this.ctSave(this.resultManager, this.context.getCtPushArgs());
    }

    private void ctSave(CtConvertResultManager resultManager, CtPushArgs args) {
        CtSaveArgs ctSaveArgs = new CtSaveArgs();
        ctSaveArgs.setSyncType(args.getSyncType());
        ctSaveArgs.setData(resultManager.getTargetCtDataObjects());
        ctSaveArgs.setsEntityKey(args.getSourceEntityNumber());
        ctSaveArgs.settEntityKey(args.getTargetEntityNumber());
        ctSaveArgs.setRuleId(args.getRuleId());
        ctSaveArgs.setRuleVerId(args.getRuleVerId());
        ctSaveArgs.setRuleExtVerId(args.getRuleExtVerId());
        ctSaveArgs.setsAccountId(args.getsAccountId());
        ctSaveArgs.setsTenantCode(args.getsTenantCode());
        ctSaveArgs.settAccountId(args.gettAccountId());
        ctSaveArgs.settTenantCode(args.gettTenantCode());
        ctSaveArgs.setsSyncLogs(resultManager.getsSyncLogs());
        ctSaveArgs.setCheckPushAgain(args.isCheckPushAgain());
        ctSaveArgs.setTargetBillOp(args.getTargetBillOp());
        String result = null;
        boolean isApiException = false;
        String errorMsg = "";
        try {
            log.info("before ctSave:" + args.getRuleId() + "|" + args.getRuleVerId() + "|" + args.getRuleExtVerId() + "|" + args.getSyncType());
            result = CtBotpApiUtils.post(ctSaveArgs.gettTenantCode(), ctSaveArgs.gettAccountId(), CtApiUrlEnum.CTSAVE, SerializationUtils.toJsonString((Object)ctSaveArgs));
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        if (result == null) {
            errorMsg = ResManager.loadKDString((String)"\u8c03\u7528\u4fdd\u5b58\u76ee\u6807\u5355\u63a5\u53e3\u5f02\u5e38\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"CtBatchSyncAction_0", (String)"bos-mservice-ctbotp", (Object[])new Object[0]);
            resultManager.getReporter().setException(Boolean.TRUE.booleanValue());
            resultManager.getReporter().setErrorMsg(errorMsg);
            return;
        }
        Map openApiResult = (Map)SerializationUtils.fromJsonString(result, Map.class);
        if (openApiResult != null && !openApiResult.get("errorCode").equals("0")) {
            resultManager.getReporter().setException(Boolean.TRUE.booleanValue());
            Object message = openApiResult.get("message");
            errorMsg = StringUtils.isNotBlank(message) ? message.toString() : String.format(ResManager.loadKDString((String)"\u8c03\u7528\u4fdd\u5b58\u76ee\u6807\u5355\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002\u9519\u8bef\u7801\uff1a%s", (String)"CtBatchSyncAction_1", (String)"bos-mservice-ctbotp", (Object[])new Object[0]), openApiResult.get("errorCode"));
            resultManager.getReporter().setErrorMsg(errorMsg);
            return;
        }
        CtSaveOperationResult ctSaveOperationResult = (CtSaveOperationResult)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(openApiResult.get("data")), CtSaveOperationResult.class);
        this.outMessage(ctSaveOperationResult);
        resultManager.getReporter().setException(ctSaveOperationResult.isException());
        resultManager.getReporter().setErrorMsg(ctSaveOperationResult.getMessage());
        resultManager.settBillNoMap(ctSaveOperationResult.gettBillNoMap());
        resultManager.setCtBillLks(ctSaveOperationResult.getCtBillLks());
    }

    private void outMessage(CtSaveOperationResult saveResult) {
        if (saveResult.isException()) {
            this.resultManager.getReporter().setException(true);
            this.resultManager.getReporter().setErrorMsg(saveResult.getMessage());
        }
        if (saveResult == null || saveResult.getReporter() == null) {
            return;
        }
        if (MapUtils.isNotEmpty((Map)saveResult.getReporter().getFailIds())) {
            Map errorMap = saveResult.getReporter().getFailIds();
            for (Map.Entry entry : errorMap.entrySet()) {
                this.resultManager.getReporter().addFailId((Long)entry.getKey(), (String)entry.getValue());
            }
        }
        if (CollectionUtils.isNotEmpty((Collection)saveResult.getReporter().getSuccessIds())) {
            ArrayList successPkIds = new ArrayList(saveResult.getReporter().getSuccessIds());
            this.resultManager.getReporter().getSuccessIds().addAll(successPkIds);
        }
    }
}

