/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.ctbotp.CtDataEntity;
import kd.bos.entity.ctbotp.CtExtendedDataEntity;
import kd.bos.entity.ctbotp.CtExtendedDataEntitySet;
import kd.bos.entity.ctbotp.constants.CtPushProcessEnum;
import kd.bos.service.ctbotp.convert.CtConvertContext;
import kd.bos.service.ctbotp.convert.CtConvertResultManager;
import kd.bos.service.ctbotp.convert.actions.AbstractCtConvertAction;
import kd.bos.service.ctbotp.convert.compiler.CtDependEntityMap;
import kd.bos.service.ctbotp.convert.compiler.CtLinkEntityMap;
import kd.bos.service.ctbotp.convert.group.CtSourceRowsGroupKey;
import kd.bos.service.ctbotp.convert.sort.CtSourceRowComparator;

public class CtCreateDependEntityRowsAction
extends AbstractCtConvertAction {
    private CtExtendedDataEntitySet targetExtSet;

    private List<DynamicObject> getSourceRows(CtDependEntityMap entityMap) {
        if (this.batchContext != null) {
            return this.batchContext.getDependEntitySourceRows(entityMap);
        }
        return entityMap.getSourceRows();
    }

    public CtCreateDependEntityRowsAction(CtConvertContext context, CtConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    public void setProcess() {
        this.resultManager.setCtPushProcessEnum(CtPushProcessEnum.CtCreateDependEntityRowsAction);
    }

    @Override
    protected void doAction() {
        this.targetExtSet = this.getTargetExtendedDataEntities();
        this.getRuleContext().getRuleCompiler().getLinkEntityMap();
        HashMap<String, CtDependEntityMap> headEntityMap = new HashMap<String, CtDependEntityMap>();
        HashMap<String, CtDependEntityMap> entryEntityMap = new HashMap<String, CtDependEntityMap>();
        HashMap<String, CtDependEntityMap> subEntryEntityMap = new HashMap<String, CtDependEntityMap>();
        for (Map.Entry<String, CtDependEntityMap> entry : this.ruleContext.getRuleCompiler().getDependEntityMaps().entrySet()) {
            String key = entry.getKey();
            CtDependEntityMap entityMap = entry.getValue();
            for (String targetEntry : entityMap.getTargetFields().keySet()) {
                if (targetEntry.split("\\|").length == 3) {
                    subEntryEntityMap.put(key, entityMap);
                    continue;
                }
                if (targetEntry.split("\\|").length == 2) {
                    entryEntityMap.put(key, entityMap);
                    continue;
                }
                headEntityMap.put(key, entityMap);
            }
        }
        for (Map.Entry<String, CtDependEntityMap> entry : headEntityMap.entrySet()) {
            this.mapMainType(entry.getValue());
        }
        for (Map.Entry<String, CtDependEntityMap> entry : entryEntityMap.entrySet()) {
            this.mapEntryType(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, CtDependEntityMap> entry : subEntryEntityMap.entrySet()) {
            CtDependEntityMap entityMap = entry.getValue();
            if (entityMap.getTargetAnchorEntityKey().equalsIgnoreCase("billhead")) {
                this.mapSubEntryTypeWithParent(entry.getKey(), entityMap);
                continue;
            }
            this.mapSubEntryTypeOnly(entityMap);
        }
    }

    private void mapMainType(CtDependEntityMap entityMap) {
        Map<Long, List<DynamicObject>> srcDependRows = this.splitBySrcAnchorRowId(entityMap);
        CtExtendedDataEntity[] headRows = this.targetExtSet.FindByEntityKey(this.context.getCtPushArgs().getTargetEntityNumber());
        CtSourceRowComparator comparator = new CtSourceRowComparator(this.ruleContext, entityMap);
        for (CtExtendedDataEntity dataEntity : headRows) {
            List<DynamicObject> myBillDependRows = this.findMyBillDependRows(dataEntity, entityMap, comparator, srcDependRows);
            if (myBillDependRows.isEmpty()) continue;
            dataEntity.setValueExt(entityMap.getJoinSourceEntityKeys(), myBillDependRows);
        }
    }

    private void mapEntryType(String joinTargetEntityKeys, CtDependEntityMap entityMap) {
        CtExtendedDataEntity[] headDataEntities;
        String entityType = entityMap.getTargetEntity();
        String[] targetEntityArr = entityType.split("\\|");
        entityType = targetEntityArr.length == 3 ? targetEntityArr[targetEntityArr.length - 2] : targetEntityArr[targetEntityArr.length - 1];
        ArrayList<CtExtendedDataEntity> entryExtEntitys = new ArrayList<CtExtendedDataEntity>();
        Map<Long, List<DynamicObject>> srcDependRows = this.splitBySrcAnchorRowId(entityMap);
        CtSourceRowComparator comparator = new CtSourceRowComparator(this.ruleContext, entityMap);
        for (CtExtendedDataEntity headDataEntity : headDataEntities = this.targetExtSet.FindByEntityKey(this.context.getTargetEntityNumber())) {
            List<DynamicObject> myDependRows = this.findMyBillDependRows(headDataEntity, entityMap, comparator, srcDependRows);
            if (myDependRows.isEmpty() || this.isMergeIntoLinkEntryRow(entityMap, entityMap.getTargetEntryKey(), myDependRows)) continue;
            Map<CtSourceRowsGroupKey, List<DynamicObject>> srcRowGroups = this.splitBySourceEntityId(entityMap, myDependRows);
            int rowIndex = 0;
            for (Map.Entry<CtSourceRowsGroupKey, List<DynamicObject>> group : srcRowGroups.entrySet()) {
                CtDataEntity ctDataEntity = new CtDataEntity();
                ctDataEntity.setSeq(Integer.valueOf(rowIndex));
                headDataEntity.getCtDataEntity().addChildEntitys(entityType, "", ctDataEntity);
                CtExtendedDataEntity entryExtEntity = new CtExtendedDataEntity(ctDataEntity, headDataEntity.getDataEntityIndex(), rowIndex);
                entryExtEntity.setValueExt(entityMap.getJoinSourceEntityKeys(), group.getValue());
                entryExtEntity.setValueExt("isNewEntity", (Object)Boolean.TRUE);
                entryExtEntitys.add(entryExtEntity);
                ++rowIndex;
            }
        }
        this.targetExtSet.AddExtendedDataEntities(entityType, entryExtEntitys);
    }

    private void mapSubEntryTypeOnly(CtDependEntityMap entityMap) {
        String subEntryType = entityMap.getTargetEntity();
        String[] targetEntityArr = subEntryType.split("\\|");
        String entryType = "";
        String subEntryKey = "";
        if (targetEntityArr.length == 3) {
            entryType = targetEntityArr[targetEntityArr.length - 2];
            subEntryKey = targetEntityArr[2];
        }
        ArrayList<CtExtendedDataEntity> extSubEntryEntitys = new ArrayList<CtExtendedDataEntity>();
        Map<Long, List<DynamicObject>> srcDependRows = this.splitBySrcAnchorRowId(entityMap);
        CtSourceRowComparator comparator = new CtSourceRowComparator(this.ruleContext, entityMap);
        CtExtendedDataEntity[] headDataEntities = this.targetExtSet.FindByEntityKey(this.context.getTargetEntityNumber());
        Map<Integer, List<CtExtendedDataEntity>> entryDataEntityMap = this.splitByDataIndex(entryType);
        for (CtExtendedDataEntity headDataEntitiy : headDataEntities) {
            List<CtExtendedDataEntity> entryRows = entryDataEntityMap.get(headDataEntitiy.getDataEntityIndex());
            if (entryRows == null) continue;
            for (CtExtendedDataEntity entryRow : entryRows) {
                this.createSubEntryRows(entityMap, headDataEntitiy, entryRow, subEntryType, extSubEntryEntitys, srcDependRows, comparator);
            }
        }
        this.targetExtSet.AddExtendedDataEntities(subEntryKey, extSubEntryEntitys);
    }

    private void createSubEntryRows(CtDependEntityMap entityMap, CtExtendedDataEntity headDataEntitiy, CtExtendedDataEntity entryRow, String subEntryType, List<CtExtendedDataEntity> extSubEntryEntitys, Map<Long, List<DynamicObject>> srcDependRows, CtSourceRowComparator comparator) {
        List<DynamicObject> myEntryDependRows = this.findMyEntryDependRows(entryRow, entityMap, comparator, srcDependRows);
        if (myEntryDependRows.isEmpty()) {
            return;
        }
        if (this.isMergeIntoLinkEntryRow(entityMap, entityMap.getTargetSubEntryKey(), myEntryDependRows)) {
            return;
        }
        Map<CtSourceRowsGroupKey, List<DynamicObject>> srcRowGroups = this.splitBySourceEntityId(entityMap, myEntryDependRows);
        int subRowIndex = 0;
        String[] targetEntityArr = subEntryType.split("\\|");
        String entryType = "";
        String subEntryKey = "";
        if (targetEntityArr.length == 3) {
            entryType = targetEntityArr[targetEntityArr.length - 2];
            subEntryKey = targetEntityArr[2];
        }
        for (Map.Entry<CtSourceRowsGroupKey, List<DynamicObject>> group : srcRowGroups.entrySet()) {
            List<DynamicObject> list = group.getValue();
            CtDataEntity ctDataEntity = new CtDataEntity();
            ctDataEntity.setSeq(Integer.valueOf(subRowIndex));
            ((CtDataEntity)((List)headDataEntitiy.getCtDataEntity().getChildEntitys().get(entryType)).get(entryRow.getRowIndex())).addChildEntitys(subEntryKey, subEntryType, ctDataEntity);
            CtExtendedDataEntity subEntryExtEntity = new CtExtendedDataEntity(ctDataEntity, headDataEntitiy.getDataEntityIndex(), entryRow.getRowIndex(), subRowIndex, "");
            subEntryExtEntity.setValueExt(entityMap.getJoinSourceEntityKeys(), list);
            subEntryExtEntity.setValueExt("isNewEntity", (Object)Boolean.TRUE);
            extSubEntryEntitys.add(subEntryExtEntity);
            ++subRowIndex;
        }
    }

    private void mapSubEntryTypeWithParent(String joinTargetEntityKeys, CtDependEntityMap entityMap) {
        CtExtendedDataEntity[] headDataEntities;
        String subEntryType = entityMap.getTargetEntity();
        String entryType = "";
        String[] targetEntityArr = subEntryType.split("\\|");
        if (targetEntityArr.length == 3) {
            entryType = targetEntityArr[targetEntityArr.length - 2];
        }
        ArrayList extEntryEntitys = new ArrayList();
        ArrayList extSubEntryEntitys = new ArrayList();
        Map<Long, List<DynamicObject>> srcDependRows = this.splitBySrcAnchorRowId(entityMap);
        CtSourceRowComparator comparator = new CtSourceRowComparator(this.ruleContext, entityMap);
        for (CtExtendedDataEntity headDataEntity : headDataEntities = this.targetExtSet.FindByEntityKey(this.context.getTargetEntityNumber())) {
            List<DynamicObject> myBillDependRows = this.findMyBillDependRows(headDataEntity, entityMap, comparator, srcDependRows);
            if (myBillDependRows.isEmpty()) continue;
            Map<CtSourceRowsGroupKey, List<DynamicObject>> srcRowGroups = this.splitBySourceEntityId(entityMap, myBillDependRows);
            int rowIndex = this.batchCreateNewEntryRow(joinTargetEntityKeys, headDataEntity, entryType, srcRowGroups.size());
            for (Map.Entry<CtSourceRowsGroupKey, List<DynamicObject>> group : srcRowGroups.entrySet()) {
                List ctDataEntities = (List)headDataEntity.getCtDataEntity().getChildEntitys().get(joinTargetEntityKeys);
                List<DynamicObject> srcRows = group.getValue();
                ++rowIndex;
            }
        }
        this.targetExtSet.AddExtendedDataEntities(entryType, extEntryEntitys);
        this.targetExtSet.AddExtendedDataEntities(subEntryType, extSubEntryEntitys);
    }

    private boolean isMergeIntoLinkEntryRow(CtDependEntityMap entityMap, String targetEntityKey, List<DynamicObject> myDependRows) {
        return false;
    }

    private Map<Long, List<DynamicObject>> splitBySrcAnchorRowId(CtDependEntityMap entityMap) {
        Map<String, DynamicProperty> srcFldPropertys = entityMap.getSrcFldPropertys();
        HashMap<Long, List<DynamicObject>> srcDependRows = new HashMap<Long, List<DynamicObject>>();
        for (DynamicObject dependRow : this.getSourceRows(entityMap)) {
            Long srcRowId = (Long)entityMap.getSrcAnchorRowIdGetter().getValue(entityMap.getBaseDataPropInfoMap(), srcFldPropertys, dependRow);
            if (!srcDependRows.containsKey(srcRowId)) {
                srcDependRows.put(srcRowId, new ArrayList());
            }
            ((List)srcDependRows.get(srcRowId)).add(dependRow);
        }
        return srcDependRows;
    }

    private List<DynamicObject> findMyBillDependRows(CtExtendedDataEntity headDataEntity, CtDependEntityMap entityMap, CtSourceRowComparator comparator, Map<Long, List<DynamicObject>> srcDependRows) {
        List<CtExtendedDataEntity> targetAnchorRows = this.findMyBillEntryRows(headDataEntity, entityMap);
        ArrayList<DynamicObject> myBillDependRows = new ArrayList<DynamicObject>();
        for (CtExtendedDataEntity targetAnchorRow : targetAnchorRows) {
            Set<Long> srcRowIds = this.findMySrcAnchorRowIds(entityMap, targetAnchorRow);
            for (Long srcRowId : srcRowIds) {
                List<DynamicObject> list = srcDependRows.get(srcRowId);
                if (list == null) continue;
                list.sort(comparator);
                myBillDependRows.addAll(list);
            }
        }
        return myBillDependRows;
    }

    private List<CtExtendedDataEntity> findMyBillEntryRows(CtExtendedDataEntity headDataEntity, CtDependEntityMap entityMap) {
        ArrayList<CtExtendedDataEntity> targetAnchorRows = new ArrayList<CtExtendedDataEntity>();
        if (entityMap.getTargetAnchorEntityKey().equalsIgnoreCase("billhead")) {
            targetAnchorRows.add(headDataEntity);
        } else {
            CtExtendedDataEntity[] extRows;
            for (CtExtendedDataEntity extRow : extRows = this.targetExtSet.FindByEntityKey(entityMap.getTargetAnchorEntityKey())) {
                if (extRow.getDataEntityIndex() != headDataEntity.getDataEntityIndex()) continue;
                targetAnchorRows.add(extRow);
            }
        }
        return targetAnchorRows;
    }

    private Set<Long> findMySrcAnchorRowIds(CtDependEntityMap entityMap, CtExtendedDataEntity targetAnchorRow) {
        LinkedHashSet<Long> srcRowIds = new LinkedHashSet<Long>(32);
        Object sourceRows = null;
        sourceRows = entityMap.getTargetAnchorEntityMap() instanceof CtLinkEntityMap ? targetAnchorRow.getValue("ConvertSource") : targetAnchorRow.getValue(entityMap.getTargetAnchorEntityMap().getJoinSourceEntityKeys());
        if (sourceRows == null) {
            return srcRowIds;
        }
        List srcAnchorRows = (List)sourceRows;
        Map<String, DynamicProperty> anchorRowFldPropertys = entityMap.getTargetAnchorEntityMap().getSrcFldPropertys();
        for (DynamicObject srcAnchorRow : srcAnchorRows) {
            Long srcRowId = (Long)entityMap.getSrcAnchorRowIdGetter().getValue(entityMap.getBaseDataPropInfoMap(), anchorRowFldPropertys, srcAnchorRow);
            if (srcRowIds.contains(srcRowId)) continue;
            srcRowIds.add(srcRowId);
        }
        return srcRowIds;
    }

    private List<DynamicObject> findMyEntryDependRows(CtExtendedDataEntity entryDataEntity, CtDependEntityMap entityMap, CtSourceRowComparator comparator, Map<Long, List<DynamicObject>> srcDependRows) {
        ArrayList<DynamicObject> myEntryDependRows = new ArrayList<DynamicObject>();
        Map<String, DynamicProperty> anchorRowFldPropertys = entityMap.getTargetAnchorEntityMap().getSrcFldPropertys();
        Object sourceRows = null;
        sourceRows = entityMap.getTargetAnchorEntityMap() instanceof CtLinkEntityMap ? entryDataEntity.getValue("ConvertSource") : entryDataEntity.getValue(entityMap.getTargetAnchorEntityMap().getJoinSourceEntityKeys());
        if (sourceRows == null) {
            return myEntryDependRows;
        }
        List srcAnchorRows = (List)sourceRows;
        HashSet<Long> srcRowIds = new HashSet<Long>();
        for (DynamicObject srcAnchorRow : srcAnchorRows) {
            Long srcRowId = (Long)entityMap.getSrcAnchorRowIdGetter().getValue(entityMap.getBaseDataPropInfoMap(), anchorRowFldPropertys, srcAnchorRow);
            if (srcRowIds.contains(srcRowId)) continue;
            srcRowIds.add(srcRowId);
            List<DynamicObject> list = srcDependRows.get(srcRowId);
            if (list == null) continue;
            list.sort(comparator);
            myEntryDependRows.addAll(list);
        }
        return myEntryDependRows;
    }

    private Map<CtSourceRowsGroupKey, List<DynamicObject>> splitBySourceEntityId(CtDependEntityMap dependEntityMap, List<DynamicObject> srcRows) {
        LinkedHashMap<CtSourceRowsGroupKey, List<DynamicObject>> groups = new LinkedHashMap<CtSourceRowsGroupKey, List<DynamicObject>>();
        for (DynamicObject srcRow : srcRows) {
            CtSourceRowsGroupKey groupKey = dependEntityMap.getSourceRowsGroupKeyBuilders().get(0).getFldValues(dependEntityMap.getBaseDataPropInfoMap(), dependEntityMap.getSrcFldPropertys(), srcRow);
            if (!groups.containsKey(groupKey)) {
                groups.put(groupKey, new ArrayList());
            }
            ((List)groups.get(groupKey)).add(srcRow);
        }
        return groups;
    }

    private Map<Integer, List<CtExtendedDataEntity>> splitByDataIndex(String entityKey) {
        CtExtendedDataEntity[] entryDataEntities = this.targetExtSet.FindByEntityKey(entityKey);
        HashMap<Integer, List<CtExtendedDataEntity>> entryDataEntityMap = new HashMap<Integer, List<CtExtendedDataEntity>>();
        for (CtExtendedDataEntity entryDataEntity : entryDataEntities) {
            Integer dataIndex = entryDataEntity.getDataEntityIndex();
            if (!entryDataEntityMap.containsKey(dataIndex)) {
                entryDataEntityMap.put(dataIndex, new ArrayList());
            }
            ((List)entryDataEntityMap.get(dataIndex)).add(entryDataEntity);
        }
        return entryDataEntityMap;
    }

    private int batchCreateNewEntryRow(String joinTargetEntityKeys, CtExtendedDataEntity headDataEntity, String entryKey, int count) {
        int rowIndex = count;
        CtDataEntity ctDataEntity = headDataEntity.getCtDataEntity();
        ctDataEntity.createChildEntitys(entryKey, joinTargetEntityKeys, count);
        return rowIndex;
    }

    private boolean isNewEntity(CtExtendedDataEntity dataEntity) {
        boolean newEntity = false;
        Object extNewEntityValue = dataEntity.getValue("isNewEntity");
        if (extNewEntityValue != null) {
            newEntity = (Boolean)extNewEntityValue;
        }
        return newEntity;
    }
}

