/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.actions;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.ctbotp.link.CtBillLinkService;
import kd.bos.ctbotp.sync.SSyncLogService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ctbotp.constants.CtPushProcessEnum;
import kd.bos.entity.ctbotp.constants.LkSyncStatusEnum;
import kd.bos.entity.ctbotp.constants.SyncStatusEnum;
import kd.bos.entity.ctbotp.constants.SyncTypeEnum;
import kd.bos.entity.ctbotp.link.CtBillLk;
import kd.bos.entity.ctbotp.link.CtLkUpQueryArgs;
import kd.bos.entity.ctbotp.sync.SyncLog;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ctbotp.convert.CtConvertContext;
import kd.bos.service.ctbotp.convert.CtConvertResultManager;
import kd.bos.service.ctbotp.convert.actions.AbstractCtConvertAction;
import kd.bos.service.ctbotp.convert.group.CtSourceRowsGroup;
import kd.bos.service.ctbotp.utils.CtDescUtils;
import kd.bos.servicehelper.DBServiceHelper;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class CtCreateSyncLogAction
extends AbstractCtConvertAction {
    private static final Log log = LogFactory.getLog((String)"CtCreateSyncLogAction");

    public CtCreateSyncLogAction(CtConvertContext context, CtConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    public void setProcess() {
        this.resultManager.setCtPushProcessEnum(CtPushProcessEnum.CtCreateSyncLogAction);
    }

    @Override
    protected void doAction() {
        SyncLog sSyncLog;
        super.doAction();
        ArrayList<SyncLog> sSyncLogs = new ArrayList<SyncLog>(8);
        HashSet<Long> ids = new HashSet<Long>(16);
        HashMap<Long, List> billIdMaps = new HashMap<Long, List>();
        CtSourceRowsGroup ctSourceRowsGroup = this.getSourceRowsGroupRoot();
        for (CtSourceRowsGroup group : ctSourceRowsGroup.getChildGroupList()) {
            if (group == null || !CollectionUtils.isNotEmpty(group.getSourceRows())) continue;
            Long tBillId = (Long)group.getTargetBillId();
            for (DynamicObject dynamicObject : group.getSourceRows()) {
                Long sBillId = (Long)dynamicObject.getPkValue();
                ids.add(sBillId);
                billIdMaps.putIfAbsent(sBillId, new ArrayList(16));
                List tBillIds = (List)billIdMaps.get(sBillId);
                if (!tBillIds.contains(tBillId)) {
                    tBillIds.add(tBillId);
                }
                billIdMaps.put(sBillId, tBillIds);
            }
        }
        if (SyncTypeEnum.REVERSE.getValue().equals(this.context.getCtPushArgs().getSyncType())) {
            CtLkUpQueryArgs ctLkUpQueryArgs = new CtLkUpQueryArgs();
            ctLkUpQueryArgs.settTenantCode(RequestContext.get().getTenantCode());
            ctLkUpQueryArgs.settAccountId(RequestContext.get().getAccountId());
            ctLkUpQueryArgs.settEntityKey(this.context.getSourceEntityNumber());
            ctLkUpQueryArgs.settBillIds(new ArrayList(ids));
            List ctBillLks = CtBillLinkService.getCtDirtBillLkUp((CtLkUpQueryArgs)ctLkUpQueryArgs);
            for (CtBillLk ctBillLk : ctBillLks) {
                sSyncLog = new SyncLog();
                sSyncLog.setUniqueKey(ID.genStringId());
                sSyncLog.setStenantCode(ctBillLk.gettTenantCode());
                sSyncLog.setsAccountId(ctBillLk.gettAccountId());
                sSyncLog.setsEntityKey(ctBillLk.gettEntityKey());
                sSyncLog.setSbillId(ctBillLk.getTBillId());
                sSyncLog.setSbillNo(this.resultManager.getsBillNoMap().get(ctBillLk.getTBillId()));
                sSyncLog.setRulename(this.ruleContext.getRule().getName().getLocaleValue());
                sSyncLog.setTtenantCode(ctBillLk.getsTenantCode());
                sSyncLog.settAccountId(ctBillLk.getsAccountId());
                sSyncLog.settEntityKey(ctBillLk.getsEntityKey());
                sSyncLog.setTbillId(ctBillLk.getSBillId());
                sSyncLog.setStatus(SyncStatusEnum.A.getStatus());
                sSyncLog.setRuleId(this.context.getCtPushArgs().getRuleId());
                sSyncLog.setId(Long.valueOf(DBServiceHelper.genGlobalLongId()));
                sSyncLog.setCreateTime(new Date());
                sSyncLog.setSyncType(this.context.getCtPushArgs().getSyncType());
                sSyncLog.setDesc(CtDescUtils.getDesc());
                sSyncLog.setLkSyncStatus(LkSyncStatusEnum.A.getStatus());
                if (this.context.getCtPushArgs().getRootJobId() != null) {
                    sSyncLog.setRootJobId(this.context.getCtPushArgs().getRootJobId());
                } else {
                    sSyncLog.setRootJobId(this.context.getTaskId());
                }
                sSyncLog.setSourceOperate(this.context.getCtPushArgs().getSourceOperate());
                sSyncLogs.add(sSyncLog);
            }
        } else if (MapUtils.isNotEmpty(billIdMaps)) {
            for (Long id : ids) {
                for (Long tBillId : (List)billIdMaps.get(id)) {
                    sSyncLog = new SyncLog();
                    sSyncLog.setUniqueKey(ID.genStringId());
                    sSyncLog.setStenantCode(RequestContext.get().getTenantId());
                    log.info("\u4e0a\u4e0b\u6587\u4e2d\u7684tenantId:" + RequestContext.get().getTenantId());
                    log.info("\u4e0a\u4e0b\u6587\u4e2d\u7684tenantCode:" + RequestContext.get().getTenantCode());
                    log.info("\u4e0b\u63a8\u53c2\u6570\u4e2d\u7684stenantcode:" + this.context.getCtPushArgs().getsTenantCode());
                    sSyncLog.setsAccountId(RequestContext.get().getAccountId());
                    sSyncLog.setsEntityKey(this.context.getSourceEntityNumber());
                    sSyncLog.setSbillId(id);
                    sSyncLog.setSbillNo(this.resultManager.getsBillNoMap().get(id));
                    sSyncLog.setTtenantCode(this.context.getCtPushArgs().gettTenantCode());
                    sSyncLog.settAccountId(this.context.getCtPushArgs().gettAccountId());
                    sSyncLog.settEntityKey(this.context.getTargetEntityNumber());
                    sSyncLog.setTbillId(tBillId);
                    sSyncLog.setStatus(SyncStatusEnum.A.getStatus());
                    sSyncLog.setRuleId(this.context.getCtPushArgs().getRuleId());
                    sSyncLog.setId(Long.valueOf(ID.genLongId()));
                    sSyncLog.setCreateTime(new Date());
                    sSyncLog.setSyncType(this.context.getCtPushArgs().getSyncType());
                    sSyncLog.setRulename(this.ruleContext.getRule().getName().getLocaleValue());
                    sSyncLog.setDesc(CtDescUtils.getDesc());
                    sSyncLog.setLkSyncStatus(LkSyncStatusEnum.A.getStatus());
                    if (this.context.getCtPushArgs().getRootJobId() != null) {
                        sSyncLog.setRootJobId(this.context.getCtPushArgs().getRootJobId());
                    } else {
                        sSyncLog.setRootJobId(this.context.getTaskId());
                    }
                    sSyncLog.setSourceOperate(this.context.getCtPushArgs().getSourceOperate());
                    sSyncLogs.add(sSyncLog);
                }
            }
        }
        SSyncLogService.create().addSyncLogs(sSyncLogs);
        this.resultManager.setsSyncLogs(sSyncLogs);
    }
}

