/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.ctbotp.CtConvertDataService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.ctbotp.CtDataEntity;
import kd.bos.entity.ctbotp.CtDataEntityField;
import kd.bos.entity.ctbotp.CtDataEntityFieldValue;
import kd.bos.entity.ctbotp.CtExtendedDataEntity;
import kd.bos.entity.ctbotp.CtExtendedDataEntitySet;
import kd.bos.entity.ctbotp.constants.CtPushProcessEnum;
import kd.bos.entity.ctbotp.constants.SyncTypeEnum;
import kd.bos.entity.ctbotp.link.CtBillLk;
import kd.bos.entity.ctbotp.link.CtBillSyncRoute;
import kd.bos.id.ID;
import kd.bos.service.ctbotp.convert.CtConvertContext;
import kd.bos.service.ctbotp.convert.CtConvertResultManager;
import kd.bos.service.ctbotp.convert.actions.AbstractCtConvertAction;
import kd.bos.service.ctbotp.convert.batchrequest.CtBatchRequestManager;
import kd.bos.service.ctbotp.convert.compiler.CtConvertRuleCompiler;
import kd.bos.service.ctbotp.convert.compiler.CtLinkEntityMap;
import kd.bos.service.ctbotp.convert.getvaluemode.ICtGetValueMode;
import kd.bos.service.ctbotp.convert.mapping.CtMappingSAccountId;
import kd.bos.service.ctbotp.convert.mapping.CtMappingSBillId;
import kd.bos.service.ctbotp.convert.mapping.CtMappingSEntityKey;
import kd.bos.service.ctbotp.convert.mapping.CtMappingSId;
import kd.bos.service.ctbotp.convert.mapping.CtMappingSLinkEntityKey;
import kd.bos.service.ctbotp.convert.mapping.CtMappingSLinkTableId;
import kd.bos.service.ctbotp.convert.mapping.CtMappingSTableId;
import kd.bos.service.ctbotp.convert.mapping.CtMappingSTenantCode;
import kd.bos.service.ctbotp.convert.mapping.CtMappingTAccountId;
import kd.bos.service.ctbotp.convert.mapping.CtMappingTEntityKey;
import kd.bos.service.ctbotp.convert.mapping.CtMappingTLinkEntityKey;
import kd.bos.service.ctbotp.convert.mapping.CtMappingTTenantCode;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class CtFillLinkInfoAction
extends AbstractCtConvertAction {
    private CtLinkEntityMap linkEntityMap;
    private Map<String, DynamicProperty> fldProperties;
    private CtExtendedDataEntitySet targetDataEntitySet;
    private CtMappingSTenantCode mappingSTenantCode;
    private CtMappingTTenantCode mappingTTenantCode;
    private CtMappingSAccountId mappingSAccountId;
    private CtMappingTAccountId mappingTAccountId;
    private CtMappingSLinkEntityKey mappingSLinkEntityKey;
    private CtMappingSLinkTableId mappingSLinkTableId;
    private CtMappingTLinkEntityKey mappingTLinkEntityKey;
    private CtMappingSTableId mappingSTableId;
    private CtMappingSBillId mappingSBillId;
    private CtMappingSEntityKey mappingSEntityKey;
    private CtMappingSId mappingSId;
    private CtMappingTEntityKey mappingTEntityKey;
    private ICtGetValueMode sIdGetHandler;
    private ICtGetValueMode idGetHandler;
    private CtBatchRequestManager batchRequestManager;

    public CtFillLinkInfoAction(CtConvertContext context, CtConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    public void setProcess() {
        this.resultManager.setCtPushProcessEnum(CtPushProcessEnum.CtFillLinkInfoAction);
    }

    @Override
    protected void doAction() {
        super.doAction();
        if (StringUtils.isBlank((CharSequence)this.ruleContext.getRuleCompiler().getLinkEntityMap().getTargetLinkEntityKey())) {
            return;
        }
        this.initVars();
        this.createLinkEntity();
    }

    private void initVars() {
        CtConvertRuleCompiler ruleCompiler = this.ruleContext.getRuleCompiler();
        this.linkEntityMap = ruleCompiler.getLinkEntityMap();
        this.fldProperties = this.linkEntityMap.getSrcFldPropertys();
        this.targetDataEntitySet = this.getTargetExtendedDataEntities();
        this.mappingSTableId = this.linkEntityMap.getMappingSTableId();
        this.mappingSBillId = this.linkEntityMap.getMappingSBillId();
        this.mappingSId = this.linkEntityMap.getMappingSId();
        this.mappingSBillId = this.linkEntityMap.getMappingSBillId();
        this.mappingSEntityKey = this.linkEntityMap.getMappingSEntityKey();
        this.mappingTEntityKey = this.linkEntityMap.getMappingTEntityKey();
        this.mappingSTenantCode = this.linkEntityMap.getMappingSTenantCode();
        this.mappingTTenantCode = this.linkEntityMap.getMappingTTenantCode();
        this.mappingSAccountId = this.linkEntityMap.getMappingSAccountId();
        this.mappingTAccountId = this.linkEntityMap.getMappingTAccountId();
        this.mappingSLinkEntityKey = this.linkEntityMap.getMappingSLinkEntityKey();
        this.mappingSLinkTableId = this.linkEntityMap.getMappingSLinkTableId();
        this.mappingTLinkEntityKey = this.linkEntityMap.getMappingTLinkEntityKey();
        this.sIdGetHandler = this.mappingSId.getUnionMode().getValueMode();
    }

    private void createLinkEntity() {
        CtExtendedDataEntity[] targetEntityRows = this.targetDataEntitySet.FindByEntityKey(this.context.getCtPushArgs().getTargetEntityNumber());
        if (targetEntityRows == null || targetEntityRows.length == 0) {
            return;
        }
        ArrayList<CtBillSyncRoute> ctBillSyncRoutes = new ArrayList<CtBillSyncRoute>();
        for (CtExtendedDataEntity targetEntityRow : targetEntityRows) {
            this.createBillLink(targetEntityRow, ctBillSyncRoutes);
        }
        this.resultManager.setBillRoutes(ctBillSyncRoutes);
        CtExtendedDataEntity[] entityRows = this.targetDataEntitySet.FindByEntityKey(this.linkEntityMap.getTargetLinkEntityKey());
        if (entityRows == null || entityRows.length == 0) {
            return;
        }
        for (CtExtendedDataEntity targetEntityRow : entityRows) {
            this.createLinkEntityRow(targetEntityRow);
        }
    }

    private void createBillLink(CtExtendedDataEntity targetEntityRow, List<CtBillSyncRoute> ctBillSyncRoutes) {
        CtConvertDataService reader = new CtConvertDataService();
        TableDefine sTableDefine = reader.loadTableDefine(this.context.getSourceEntityNumber(), this.context.getSourceEntityNumber());
        Long sourceTableId = sTableDefine.getTableId();
        List sourceRows = (List)targetEntityRow.getValue("ConvertSource");
        if (sourceRows == null) {
            return;
        }
        Map childEntitys = targetEntityRow.getCtDataEntity().getChildEntitys();
        if (MapUtils.isEmpty((Map)childEntitys)) {
            targetEntityRow.getCtDataEntity().setChildEntitys(new HashMap());
        }
        List<CtDataEntity> ctDataEntities = new ArrayList(16);
        List childLkData = (List)targetEntityRow.getCtDataEntity().getChildEntitys().get("billhead_lk");
        if (childLkData == null) {
            targetEntityRow.getCtDataEntity().getChildEntitys().put("billhead_lk", ctDataEntities);
        }
        ctDataEntities = (List)targetEntityRow.getCtDataEntity().getChildEntitys().get("billhead_lk");
        for (DynamicObject sourceRow : sourceRows) {
            CtDataEntity ctDataEntity = new CtDataEntity();
            ctDataEntity.setEntityKey("billhead_lk");
            ArrayList<CtDataEntityField> ctDataEntityFields = new ArrayList<CtDataEntityField>();
            if (SyncTypeEnum.REVERSE.getValue().equals(this.context.getCtPushArgs().getSyncType())) {
                for (CtBillLk ctBillLk : this.context.getCtPushArgs().getCtBillLks()) {
                    ISimpleProperty property = this.getContext().getSourceMainType().getPrimaryKey();
                    if (ctBillLk.getTBillId().longValue() != sourceRow.getLong((IDataEntityProperty)property)) continue;
                    CtDataEntityField sTenantCode = new CtDataEntityField();
                    sTenantCode.setName("sTenantCode");
                    sTenantCode.setValue(CtDataEntityFieldValue.CreateSimpleValue((String)ctBillLk.gettTenantCode()));
                    ctDataEntityFields.add(sTenantCode);
                    CtDataEntityField sAccountId = new CtDataEntityField();
                    sAccountId.setName("sAccountId");
                    sAccountId.setValue(CtDataEntityFieldValue.CreateSimpleValue((String)ctBillLk.gettAccountId()));
                    ctDataEntityFields.add(sAccountId);
                    CtDataEntityField sTableId = new CtDataEntityField();
                    sTableId.setName("sTableId");
                    sTableId.setValue(CtDataEntityFieldValue.CreateSimpleValue((String)String.valueOf(ctBillLk.getSTableId())));
                    ctDataEntityFields.add(sTableId);
                    CtDataEntityField sEntityKey = new CtDataEntityField();
                    sEntityKey.setName("sEntityKey");
                    sEntityKey.setValue(CtDataEntityFieldValue.CreateSimpleValue((String)ctBillLk.gettEntityKey()));
                    ctDataEntityFields.add(sEntityKey);
                    CtDataEntityField sBillId = new CtDataEntityField();
                    sBillId.setName("sBillId");
                    sBillId.setValue(CtDataEntityFieldValue.CreateSimpleValue((String)String.valueOf(ctBillLk.getTBillId())));
                    ctDataEntityFields.add(sBillId);
                    CtDataEntityField tTenantCode = new CtDataEntityField();
                    tTenantCode.setName("tTenantCode");
                    tTenantCode.setValue(CtDataEntityFieldValue.CreateSimpleValue((String)ctBillLk.getsTenantCode()));
                    ctDataEntityFields.add(tTenantCode);
                    CtDataEntityField tAccountId = new CtDataEntityField();
                    tAccountId.setName("tAccountId");
                    tAccountId.setValue(CtDataEntityFieldValue.CreateSimpleValue((String)ctBillLk.getsAccountId()));
                    ctDataEntityFields.add(tAccountId);
                    CtDataEntityField tTableId = new CtDataEntityField();
                    tTableId.setName("tTableId");
                    tTableId.setValue(CtDataEntityFieldValue.CreateSimpleValue((String)String.valueOf(ctBillLk.getTTableId())));
                    ctDataEntityFields.add(tTableId);
                    CtDataEntityField tEntityKey = new CtDataEntityField();
                    tEntityKey.setName("tEntityKey");
                    tEntityKey.setValue(CtDataEntityFieldValue.CreateSimpleValue((String)ctBillLk.getsEntityKey()));
                    ctDataEntityFields.add(tEntityKey);
                    CtDataEntityField tBillId = new CtDataEntityField();
                    tBillId.setName("tBillId");
                    tBillId.setValue(CtDataEntityFieldValue.CreateSimpleValue((String)String.valueOf(ctBillLk.getSBillId())));
                    ctDataEntityFields.add(tBillId);
                    ctDataEntity.setFields(ctDataEntityFields);
                }
            } else {
                this.setSyncBillRoutes(ctBillSyncRoutes, targetEntityRow, sourceRow);
                CtDataEntityField sbField = new CtDataEntityField();
                sbField.setName("sBillId");
                this.idGetHandler = this.mappingSBillId.getUnionMode().getValueMode();
                Object id = this.idGetHandler.getValue(null, this.fldProperties, sourceRow);
                sbField.setValue(CtDataEntityFieldValue.CreateSimpleValue((String)String.valueOf(id)));
                ctDataEntityFields.add(sbField);
                CtDataEntityField sTenantCode = new CtDataEntityField();
                sTenantCode.setName("sTenantCode");
                sTenantCode.setValue(CtDataEntityFieldValue.CreateSimpleValue((String)RequestContext.get().getTenantId()));
                ctDataEntityFields.add(sTenantCode);
                CtDataEntityField sAccountId = new CtDataEntityField();
                sAccountId.setName("sAccountId");
                sAccountId.setValue(CtDataEntityFieldValue.CreateSimpleValue((String)RequestContext.get().getAccountId()));
                ctDataEntityFields.add(sAccountId);
                CtDataEntityField sTableId = new CtDataEntityField();
                sTableId.setName("sTableId");
                sTableId.setValue(CtDataEntityFieldValue.CreateSimpleValue((String)String.valueOf(sourceTableId)));
                ctDataEntityFields.add(sTableId);
                CtDataEntityField sEntityKey = new CtDataEntityField();
                sEntityKey.setName("sEntityKey");
                sEntityKey.setValue(CtDataEntityFieldValue.CreateSimpleValue((String)this.mappingSEntityKey.getsEntityKey()));
                ctDataEntityFields.add(sEntityKey);
                CtDataEntityField tEntityKey = new CtDataEntityField();
                tEntityKey.setName("tEntityKey");
                tEntityKey.setValue(CtDataEntityFieldValue.CreateSimpleValue((String)this.mappingTEntityKey.gettEntityKey()));
                ctDataEntityFields.add(tEntityKey);
            }
            ctDataEntity.setFields(ctDataEntityFields);
            ctDataEntities.add(ctDataEntity);
        }
    }

    private void setSyncBillRoutes(List<CtBillSyncRoute> ctBillSyncRoutes, CtExtendedDataEntity ctExtendedDataEntity, DynamicObject sourceRow) {
        CtBillSyncRoute ctBillSyncRoute = new CtBillSyncRoute();
        ctBillSyncRoute.setId(Long.valueOf(ID.genLongId()));
        ctBillSyncRoute.setsTenantCode(this.mappingSTenantCode.getsTenantCode());
        ctBillSyncRoute.setsAccountId(this.mappingSAccountId.getsAccountId());
        ctBillSyncRoute.setsEntityKey(this.mappingSEntityKey.getsEntityKey());
        ctBillSyncRoute.setSBillId((Long)sourceRow.getPkValue());
        ctBillSyncRoute.settTenantCode(this.mappingTTenantCode.gettTenantCode());
        ctBillSyncRoute.settAccountId(this.mappingTAccountId.gettAccountId());
        ctBillSyncRoute.settEntityKey(this.mappingTEntityKey.gettEntityKey());
        ctBillSyncRoute.setTBillId(ctExtendedDataEntity.getId());
        ctBillSyncRoute.setCreateTime(new Date());
        ctBillSyncRoutes.add(ctBillSyncRoute);
    }

    private void createLinkEntityRow(CtExtendedDataEntity targetEntityRow) {
        List sourceRows = (List)targetEntityRow.getValue("ConvertSource");
        if (sourceRows == null) {
            return;
        }
        Map childEntitys = targetEntityRow.getCtDataEntity().getChildEntitys();
        if (MapUtils.isEmpty((Map)childEntitys)) {
            targetEntityRow.getCtDataEntity().setChildEntitys(new HashMap());
        }
        String lkName = this.linkEntityMap.getTargetLinkEntityKey() + "_lk";
        List<CtDataEntity> ctDataEntities = (ArrayList)targetEntityRow.getCtDataEntity().getChildEntitys().get(lkName);
        if (CollectionUtils.isEmpty((Collection)ctDataEntities)) {
            ctDataEntities = new ArrayList(16);
            targetEntityRow.getCtDataEntity().getChildEntitys().put(lkName, ctDataEntities);
        }
        ctDataEntities = (List)targetEntityRow.getCtDataEntity().getChildEntitys().get(lkName);
        HashSet<Object> sIds = new HashSet<Object>(sourceRows.size());
        for (DynamicObject sourceRow : sourceRows) {
            Object sId = this.sIdGetHandler.getValue(null, this.fldProperties, sourceRow);
            if (sIds.contains(sId)) continue;
            sIds.add(sId);
            CtDataEntity ctDataEntity = new CtDataEntity(lkName, "");
            ctDataEntity.initProp(lkName, "");
            ctDataEntities.add(ctDataEntity);
            this.fillLinkEntryRowObject(sourceRow, ctDataEntity);
        }
    }

    private void fillLinkEntryRowObject(DynamicObject sourceRow, CtDataEntity ctDataEntity) {
        ArrayList<DynamicObject> sourceRows = new ArrayList<DynamicObject>();
        sourceRows.add(sourceRow);
        this.mappingSTableId.calcAndMappingValue(null, this.fldProperties, sourceRows, ctDataEntity, this.batchRequestManager);
        this.mappingSBillId.calcAndMappingValue(null, this.fldProperties, sourceRows, ctDataEntity, this.batchRequestManager);
        this.mappingSId.calcAndMappingValue(null, this.fldProperties, sourceRows, ctDataEntity, this.batchRequestManager);
        this.mappingSEntityKey.calcAndMappingValue(null, this.fldProperties, sourceRows, ctDataEntity, this.batchRequestManager);
        this.mappingTEntityKey.calcAndMappingValue(null, this.fldProperties, sourceRows, ctDataEntity, this.batchRequestManager);
        this.mappingSTenantCode.calcAndMappingValue(null, this.fldProperties, sourceRows, ctDataEntity, this.batchRequestManager);
        this.mappingTTenantCode.calcAndMappingValue(null, this.fldProperties, sourceRows, ctDataEntity, this.batchRequestManager);
        this.mappingSAccountId.calcAndMappingValue(null, this.fldProperties, sourceRows, ctDataEntity, this.batchRequestManager);
        this.mappingTAccountId.calcAndMappingValue(null, this.fldProperties, sourceRows, ctDataEntity, this.batchRequestManager);
        this.mappingSLinkEntityKey.calcAndMappingValue(null, this.fldProperties, sourceRows, ctDataEntity, this.batchRequestManager);
        this.mappingSLinkTableId.calcAndMappingValue(null, this.fldProperties, sourceRows, ctDataEntity, this.batchRequestManager);
        this.mappingTLinkEntityKey.calcAndMappingValue(null, this.fldProperties, sourceRows, ctDataEntity, this.batchRequestManager);
    }
}

