/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.baseversion;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ctbotp.CtFieldConvertType;
import kd.bos.entity.ctbotp.CtFieldMapItem;
import kd.bos.entity.nameversion.NameVersionEntry;
import kd.bos.entity.nameversion.NameVersionService;
import kd.bos.entity.property.BasedataProp;
import kd.bos.service.ctbotp.convert.CtSingleRuleContext;
import kd.bos.service.ctbotp.convert.getvaluemode.ICtGetValueMode;
import kd.bos.service.ctbotp.convert.getvaluemode.basedataver.CtGetConditionValueBasedataVer;
import kd.bos.service.ctbotp.convert.getvaluemode.basedataver.CtGetFormulaValueBasedataVer;
import kd.bos.service.ctbotp.convert.getvaluemode.basedataver.CtGetSourceFieldValueBasedataVer;
import kd.bos.service.ctbotp.convert.getvaluemode.basedataver.CtGetValueByConditionBasedataVer;
import kd.bos.service.ctbotp.convert.mapping.CtMappingBasedataVersionField;
import kd.bos.service.ctbotp.convert.mapping.CtMappingField;
import kd.bos.service.ctbotp.convert.mapping.ICtMappingField;
import kd.bos.service.ctbotp.convert.var.CtSourceFieldVariable;
import kd.bos.service.ctbotp.convert.var.ICtVariableMode;
import org.apache.commons.collections4.CollectionUtils;

public class CtBasedataVersionManager {
    private static final String BOTP_ENABLE_BASEDATAVERSION = "botp.enable.basedataversion";
    private Map<String, String> basedataPropVarMap = new HashMap<String, String>();
    private String versionControlVar = null;

    public void prepareBasedataPropForVersion(BillEntityType billEntityType, Map<String, CtSourceFieldVariable> srcFields, Map<String, String> srcFldAlias, List<String> selectFldStrings) {
        if (!"true".equals(System.getProperty(BOTP_ENABLE_BASEDATAVERSION))) {
            return;
        }
        int lastFldIndex = srcFldAlias.size();
        for (CtSourceFieldVariable srcField : srcFields.values()) {
            if (!CtBasedataVersionManager.validateFieldPropForVersion(srcField) || srcField.getKeyItems().length <= 1) continue;
            String var = srcField.getSourceField().getName();
            this.basedataPropVarMap.put(srcField.getFullPropName(), var);
            if (srcFldAlias.containsKey(var)) continue;
            String fldAlias = "f" + lastFldIndex++;
            String selectFldString = var + " " + fldAlias;
            selectFldStrings.add(selectFldString);
            srcFldAlias.put(var, fldAlias);
        }
        this.prepareVersionControlField(billEntityType, srcFldAlias, selectFldStrings, lastFldIndex);
    }

    private void prepareVersionControlField(BillEntityType billEntityType, Map<String, String> srcFldAlias, List<String> selectFldStrings, int lastFldIndex) {
        if (!this.basedataPropVarMap.isEmpty()) {
            String versionControl = billEntityType.getVersionControl();
            if (StringUtils.isBlank((CharSequence)versionControl)) {
                return;
            }
            DynamicProperty versionControlProp = billEntityType.getProperty(versionControl);
            if (versionControlProp == null) {
                return;
            }
            this.versionControlVar = versionControlProp.getName();
            String fldAlias = "f" + lastFldIndex++;
            String selectFldString = this.versionControlVar + " " + fldAlias;
            selectFldStrings.add(selectFldString);
            srcFldAlias.put(this.versionControlVar, fldAlias);
        }
    }

    private static boolean validateFieldPropForVersion(CtSourceFieldVariable srcField) {
        return srcField.getSourceField() instanceof BasedataProp;
    }

    public ICtMappingField mappingFieldRecreate(CtSingleRuleContext ruleContext, CtFieldMapItem fieldMapItem, DynamicProperty fieldProp, ICtMappingField mappingField) {
        if (!"true".equals(System.getProperty(BOTP_ENABLE_BASEDATAVERSION))) {
            return mappingField;
        }
        if (mappingField.getClass() != CtMappingField.class) {
            return mappingField;
        }
        if (!(this.validateFieldConvertTypeSourceField(fieldMapItem, mappingField) || this.validateFieldConvertTypeFormula(fieldMapItem, mappingField) || this.validateFieldConvertTypeByCondition(fieldMapItem, mappingField))) {
            return mappingField;
        }
        mappingField = new CtMappingBasedataVersionField();
        mappingField.initialize(ruleContext, fieldMapItem);
        mappingField.compile(ruleContext);
        return mappingField;
    }

    private boolean validateFieldConvertTypeSourceField(CtFieldMapItem fieldMapItem, ICtMappingField mappingField) {
        return fieldMapItem.getCtFieldConvertType() == CtFieldConvertType.SourceField && CollectionUtils.isNotEmpty(mappingField.getVars()) && mappingField.getVars().get(0) instanceof CtSourceFieldVariable && CtBasedataVersionManager.validateFieldPropForVersion((CtSourceFieldVariable)mappingField.getVars().get(0));
    }

    private boolean validateFieldConvertTypeFormula(CtFieldMapItem fieldMapItem, ICtMappingField mappingField) {
        if (fieldMapItem.getCtFieldConvertType() == CtFieldConvertType.Formula && CollectionUtils.isNotEmpty(mappingField.getVars())) {
            for (ICtVariableMode var : mappingField.getVars()) {
                if (!(var instanceof CtSourceFieldVariable) || !CtBasedataVersionManager.validateFieldPropForVersion((CtSourceFieldVariable)var)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean validateFieldConvertTypeByCondition(CtFieldMapItem fieldMapItem, ICtMappingField mappingField) {
        if (fieldMapItem.getCtFieldConvertType() == CtFieldConvertType.ByCondition && CollectionUtils.isNotEmpty(mappingField.getVars())) {
            for (ICtVariableMode var : mappingField.getVars()) {
                if (!(var instanceof CtSourceFieldVariable) || !CtBasedataVersionManager.validateFieldPropForVersion((CtSourceFieldVariable)var)) continue;
                return true;
            }
        }
        return false;
    }

    public void setGetValueFuncToValueModel(Map<String, DynamicProperty> fldProperties, ICtGetValueMode valueMode) {
        if (!"true".equals(System.getProperty(BOTP_ENABLE_BASEDATAVERSION))) {
            return;
        }
        this.setGetValueFuncForSourceField(fldProperties, valueMode);
        this.setGetValueFuncForFormula(fldProperties, valueMode);
        this.setGetValueFuncForCondition(fldProperties, valueMode);
        this.setGetValueFuncForByCondition(fldProperties, valueMode);
    }

    private void setGetValueFuncForSourceField(Map<String, DynamicProperty> fldProperties, ICtGetValueMode valueMode) {
        if (valueMode instanceof CtGetSourceFieldValueBasedataVer) {
            ((CtGetSourceFieldValueBasedataVer)valueMode).setGetValueFunctionForBasedataVersion(var -> activeObj -> this.doGetValueFunctionForBasedataVersion(fldProperties, this.getBasedataPropVarMap(), (ICtVariableMode)var, (DynamicObject)activeObj));
        }
    }

    private void setGetValueFuncForFormula(Map<String, DynamicProperty> fldProperties, ICtGetValueMode valueMode) {
        if (valueMode instanceof CtGetFormulaValueBasedataVer) {
            ((CtGetFormulaValueBasedataVer)valueMode).setGetValueFunctionForBasedataVersion(var -> activeObj -> this.doGetValueFunctionForBasedataVersion(fldProperties, this.getBasedataPropVarMap(), (ICtVariableMode)var, (DynamicObject)activeObj));
        }
    }

    private void setGetValueFuncForCondition(Map<String, DynamicProperty> fldProperties, ICtGetValueMode valueMode) {
        if (valueMode instanceof CtGetConditionValueBasedataVer) {
            ((CtGetConditionValueBasedataVer)valueMode).setGetValueFunctionForBasedataVersion(var -> activeObj -> this.doGetValueFunctionForBasedataVersion(fldProperties, this.getBasedataPropVarMap(), (ICtVariableMode)var, (DynamicObject)activeObj));
        }
    }

    private void setGetValueFuncForByCondition(Map<String, DynamicProperty> fldProperties, ICtGetValueMode valueMode) {
        if (valueMode instanceof CtGetValueByConditionBasedataVer) {
            for (Tuple<ICtGetValueMode, ICtGetValueMode> valueHandler : ((CtGetValueByConditionBasedataVer)valueMode).getValueHandlers()) {
                this.setGetValueFuncForCondition(fldProperties, (ICtGetValueMode)valueHandler.item1);
                this.setGetValueFuncForFormula(fldProperties, (ICtGetValueMode)valueHandler.item2);
            }
        }
    }

    private Optional<Object> doGetValueFunctionForBasedataVersion(Map<String, DynamicProperty> fldProperties, Map<String, String> basedataPropVarMap, ICtVariableMode var, DynamicObject activeObj) {
        NameVersionEntry nameByDate;
        DynamicProperty tmpVersionControlProp;
        if (!(var instanceof CtSourceFieldVariable)) {
            return Optional.empty();
        }
        IDataEntityProperty sourceField = ((CtSourceFieldVariable)var).getSourceField();
        if (!(sourceField instanceof BasedataProp)) {
            return Optional.empty();
        }
        String basedataPropVar = basedataPropVarMap.get(var.getVar());
        if (StringUtils.isBlank((CharSequence)basedataPropVar)) {
            return Optional.empty();
        }
        DynamicProperty tmpBasedataProp = fldProperties.get(basedataPropVar);
        if (tmpBasedataProp == null) {
            return Optional.empty();
        }
        Object basedataPkId = tmpBasedataProp.getValue((Object)activeObj);
        boolean enableNameVersionControl = NameVersionService.getInstance().enableNameVersionControl(((BasedataProp)sourceField).getBaseEntityId());
        if (!enableNameVersionControl) {
            return Optional.empty();
        }
        Object versionDate = null;
        String versionControlVar = this.getVersionControlVar();
        if (StringUtils.isNotBlank((CharSequence)versionControlVar) && !((versionDate = (tmpVersionControlProp = fldProperties.get(versionControlVar)).getValue((Object)activeObj)) instanceof Date)) {
            versionDate = null;
        }
        return (nameByDate = NameVersionService.getInstance().getNameByDate(((BasedataProp)sourceField).getBaseEntityId(), basedataPkId, (Date)versionDate)) == null ? Optional.empty() : Optional.of(nameByDate.getName().getLocaleValue());
    }

    public Map<String, String> getBasedataPropVarMap() {
        return this.basedataPropVarMap;
    }

    public String getVersionControlVar() {
        return this.versionControlVar;
    }
}

