/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.batchactions;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.ctbotp.link.CtBillLinkService;
import kd.bos.ctbotp.sync.SSyncLogService;
import kd.bos.entity.ctbotp.constants.CtPushProcessEnum;
import kd.bos.entity.ctbotp.constants.LkSyncStatusEnum;
import kd.bos.entity.ctbotp.constants.SyncStatusEnum;
import kd.bos.entity.ctbotp.constants.SyncTypeEnum;
import kd.bos.entity.ctbotp.link.CtBillLk;
import kd.bos.entity.ctbotp.sync.SyncLog;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ctbotp.convert.CtConvertContext;
import kd.bos.service.ctbotp.convert.CtConvertResultManager;
import kd.bos.service.ctbotp.convert.actions.AbstractCtConvertAction;
import kd.bos.service.ctbotp.convert.group.CtSourceRowId;
import kd.bos.service.ctbotp.convert.group.CtSourceRowsGroup;
import kd.bos.service.ctbotp.utils.CtDescUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class CtBatchCreateSyncLogAction
extends AbstractCtConvertAction {
    private static final Log log = LogFactory.getLog((String)"CtCreateSyncLogAction");

    public CtBatchCreateSyncLogAction(CtConvertContext context, CtConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    public void setProcess() {
        this.resultManager.setCtPushProcessEnum(CtPushProcessEnum.CtCreateSyncLogAction);
    }

    @Override
    protected void doAction() {
        super.doAction();
        ArrayList<SyncLog> sSyncLogs = new ArrayList<SyncLog>(8);
        ArrayList<SyncLog> addSyncLogs = new ArrayList<SyncLog>(8);
        HashSet<Long> ids = new HashSet<Long>(16);
        HashMap<Long, List> billIdMaps = new HashMap<Long, List>();
        CtSourceRowsGroup ctSourceRowsGroup = this.getSourceRowsGroupRoot();
        for (CtSourceRowsGroup ctSourceRowsGroup2 : ctSourceRowsGroup.getChildGroupList()) {
            if (ctSourceRowsGroup2 == null || !CollectionUtils.isNotEmpty(ctSourceRowsGroup2.getSourceRowIds())) continue;
            Long tBillId = (Long)ctSourceRowsGroup2.getTargetBillId();
            for (CtSourceRowId ctSourceRowId : ctSourceRowsGroup2.getSourceRowIds()) {
                Long sBillId = (Long)ctSourceRowId.getBillId();
                if (!ctSourceRowsGroup2.isFirstBatch()) {
                    SyncLog syncLog;
                    String key = String.valueOf(sBillId) + tBillId;
                    if (!MapUtils.isNotEmpty(this.ruleResultManager.getExistNextSyncLogs()) || (syncLog = this.ruleResultManager.getExistNextSyncLogs().get(key)) == null) continue;
                    sSyncLogs.add(this.ruleResultManager.getExistNextSyncLogs().get(key));
                    continue;
                }
                ids.add(sBillId);
                billIdMaps.putIfAbsent(sBillId, new ArrayList(16));
                List tBillIds = (List)billIdMaps.get(sBillId);
                if (!tBillIds.contains(tBillId)) {
                    tBillIds.add(tBillId);
                }
                billIdMaps.put(sBillId, tBillIds);
            }
            List srcIds = ctSourceRowsGroup2.getSourceRowIds().stream().map(a -> (Long)a.getBillId()).collect(Collectors.toList());
            ids.addAll(srcIds);
        }
        if (SyncTypeEnum.REVERSE.getValue().equals(this.context.getCtPushArgs().getSyncType())) {
            List ctBillLks = CtBillLinkService.getCtBillLks(new ArrayList(ids), (String)this.context.getSourceEntityNumber());
            for (CtBillLk ctBillLk : ctBillLks) {
                SyncLog sSyncLog = new SyncLog();
                sSyncLog.setUniqueKey(ID.genStringId());
                sSyncLog.setStenantCode(ctBillLk.gettTenantCode());
                sSyncLog.setsAccountId(ctBillLk.gettAccountId());
                sSyncLog.setsEntityKey(ctBillLk.gettEntityKey());
                sSyncLog.setSbillId(ctBillLk.getTBillId());
                sSyncLog.setSbillNo(this.resultManager.getsBillNoMap().get(ctBillLk.getTBillId()));
                sSyncLog.setRulename(this.ruleContext.getRule().getName().getLocaleValue());
                sSyncLog.setTtenantCode(ctBillLk.getsTenantCode());
                sSyncLog.settAccountId(ctBillLk.getsAccountId());
                sSyncLog.settEntityKey(ctBillLk.getsEntityKey());
                sSyncLog.setTbillId(ctBillLk.getSBillId());
                sSyncLog.setStatus(SyncStatusEnum.A.getStatus());
                sSyncLog.setRuleId(this.context.getCtPushArgs().getRuleId());
                sSyncLog.setId(Long.valueOf(ID.genLongId()));
                sSyncLog.setCreateTime(new Date());
                sSyncLog.setSyncType(this.context.getCtPushArgs().getSyncType());
                sSyncLog.setDesc(CtDescUtils.getDesc());
                sSyncLog.setLkSyncStatus(LkSyncStatusEnum.A.getStatus());
                if (this.context.getCtPushArgs().getRootJobId() != null) {
                    sSyncLog.setRootJobId(this.context.getCtPushArgs().getRootJobId());
                }
                sSyncLog.setSourceOperate(this.context.getCtPushArgs().getSourceOperate());
                addSyncLogs.add(sSyncLog);
            }
        } else if (MapUtils.isNotEmpty(billIdMaps)) {
            for (Long l : ids) {
                for (Long tBillId : (List)billIdMaps.get(l)) {
                    SyncLog sSyncLog = new SyncLog();
                    sSyncLog.setUniqueKey(ID.genStringId());
                    sSyncLog.setStenantCode(RequestContext.get().getTenantId());
                    log.info("\u4e0a\u4e0b\u6587\u4e2d\u7684tenantId:" + RequestContext.get().getTenantId());
                    log.info("\u4e0a\u4e0b\u6587\u4e2d\u7684tenantCode:" + RequestContext.get().getTenantCode());
                    log.info("\u4e0b\u63a8\u53c2\u6570\u4e2d\u7684stenantcode:" + this.context.getCtPushArgs().getsTenantCode());
                    sSyncLog.setsAccountId(RequestContext.get().getAccountId());
                    sSyncLog.setsEntityKey(this.context.getSourceEntityNumber());
                    sSyncLog.setSbillId(l);
                    sSyncLog.setSbillNo(this.resultManager.getsBillNoMap().get(l));
                    sSyncLog.setTtenantCode(this.context.getCtPushArgs().gettTenantCode());
                    sSyncLog.settAccountId(this.context.getCtPushArgs().gettAccountId());
                    sSyncLog.settEntityKey(this.context.getTargetEntityNumber());
                    sSyncLog.setTbillId(tBillId);
                    sSyncLog.setStatus(SyncStatusEnum.A.getStatus());
                    sSyncLog.setRuleId(this.context.getCtPushArgs().getRuleId());
                    sSyncLog.setId(Long.valueOf(ID.genLongId()));
                    sSyncLog.setCreateTime(new Date());
                    sSyncLog.setSyncType(this.context.getCtPushArgs().getSyncType());
                    sSyncLog.setRulename(this.ruleContext.getRule().getName().getLocaleValue());
                    sSyncLog.setDesc(CtDescUtils.getDesc());
                    sSyncLog.setLkSyncStatus(LkSyncStatusEnum.A.getStatus());
                    if (this.context.getCtPushArgs().getRootJobId() != null) {
                        sSyncLog.setRootJobId(this.context.getCtPushArgs().getRootJobId());
                    }
                    sSyncLog.setSourceOperate(this.context.getCtPushArgs().getSourceOperate());
                    addSyncLogs.add(sSyncLog);
                }
            }
        }
        SSyncLogService.create().addSyncLogs(addSyncLogs);
        sSyncLogs.addAll(addSyncLogs);
        this.batchResultManager.setsSyncLogs(sSyncLogs);
    }
}

