/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.batchactions;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ctbotp.constants.CtPushProcessEnum;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.mutex.DataMutex;
import kd.bos.service.ctbotp.convert.CtConvertContext;
import kd.bos.service.ctbotp.convert.CtConvertResultManager;
import kd.bos.service.ctbotp.convert.actions.AbstractCtConvertAction;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.session.SystemPropertyUtils;

public class CtBatchDataMutexAction
extends AbstractCtConvertAction {
    private static final String DATA_MUTEX_KEY_SUCCESS = "success";
    private static final String DATA_MUTEX_MC_ON_KEY = "bos_push_data_mutex_on";
    private static final String BOS_MSERVICE_BOTP = "bos-mservice-botp";

    private boolean isRequireDataMutex() {
        return true;
    }

    private boolean forceRequireDataMutex() {
        String tenantId = RequestContext.get().getTenantId();
        return SystemPropertyUtils.getBoolean((String)tenantId, (String)DATA_MUTEX_MC_ON_KEY);
    }

    private boolean isStrict() {
        return true;
    }

    @Override
    public void setProcess() {
        this.resultManager.setCtPushProcessEnum(CtPushProcessEnum.CtDataMutexAction);
    }

    public CtBatchDataMutexAction(CtConvertContext context, CtConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    protected void doAction() {
        super.doAction();
        if (!this.ruleContext.getRule().getCtOptionPolicy().isPushOneTime()) {
            return;
        }
        List<ListSelectedRow> selectedRows = this.getRuleContext().getSelectedRows();
        HashSet<String> srcBillIds = new HashSet<String>(selectedRows.size());
        for (ListSelectedRow selectedRow : selectedRows) {
            srcBillIds.add(selectedRow.getPrimaryKeyValue().toString());
        }
        HashMap<String, Map<String, Object>> fails = new HashMap<String, Map<String, Object>>(srcBillIds.size());
        Set<String> successIds = this.startNetworkCtrl(srcBillIds, fails);
        ArrayList<ListSelectedRow> rows = new ArrayList<ListSelectedRow>(selectedRows);
        selectedRows.clear();
        if (!successIds.isEmpty()) {
            for (ListSelectedRow row : rows) {
                String srcBillId = row.getPrimaryKeyValue().toString();
                if (!successIds.contains(srcBillId)) continue;
                selectedRows.add(row);
            }
            for (String srcBillId : successIds) {
                this.getResultManager().addDataMutexSrcBillId(srcBillId);
            }
        }
        if (!fails.isEmpty()) {
            String failMessage = ResManager.loadKDString((String)"\u5355\u636e\u8f6c\u6362\u7533\u8bf7\u7f51\u7edc\u4e92\u65a5\u5931\u8d25\uff0c\u5176\u4ed6\u4eba\u6b63\u5728\u5904\u7406\u6e90\u5355\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"DataMutexAction_3", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]);
            HashSet<Object> reportIds = new HashSet<Object>();
            for (ListSelectedRow row : rows) {
                String srcBillId;
                Map ret;
                if (reportIds.contains(row.getPrimaryKeyValue()) || (ret = (Map)fails.get(srcBillId = row.getPrimaryKeyValue().toString())) == null) continue;
                reportIds.add(row.getPrimaryKeyValue());
                Object userId = ret.get("userid");
                if (userId == null) {
                    this.getResultManager().getReporter().addFailId(Long.valueOf(Long.parseLong(row.getPrimaryKeyValue().toString())), failMessage);
                    continue;
                }
                DynamicObject userObj = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(userId.toString()), (String)"bos_user", (String)"name");
                if (userObj != null) {
                    String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u8f6c\u6362\u7533\u8bf7\u7f51\u7edc\u4e92\u65a5\u5931\u8d25\uff0c%s\u6b63\u5728\u5904\u7406\u6e90\u5355\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", (String)"DataMutexAction_4", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), userObj.getString("name"));
                    this.getResultManager().getReporter().addFailId(Long.valueOf(Long.parseLong(row.getPrimaryKeyValue().toString())), msg);
                    continue;
                }
                this.getResultManager().getReporter().addFailId(Long.valueOf(Long.parseLong(row.getPrimaryKeyValue().toString())), failMessage);
            }
        }
        if (this.ruleContext.getSelectedRows().isEmpty()) {
            this.setSkipNextAction(true);
        }
    }

    private Set<String> startNetworkCtrl(Set<String> srcBillIds, Map<String, Map<String, Object>> fails) {
        if (srcBillIds.isEmpty()) {
            return new HashSet<String>();
        }
        boolean strict = this.isStrict();
        Map<String, Map<String, Object>> mutexResult = CtBatchDataMutexAction.requirePushMutex(this.getContext().getSourceMainType().getName(), srcBillIds, strict);
        HashSet<String> successIds = new HashSet<String>();
        for (String srcBillId : srcBillIds) {
            Map<String, Object> ret = mutexResult.get(srcBillId);
            if (ret == null) {
                successIds.add(srcBillId);
                continue;
            }
            Boolean success = (Boolean)ret.get(DATA_MUTEX_KEY_SUCCESS);
            if (success != null && success.booleanValue()) {
                successIds.add(srcBillId);
                continue;
            }
            fails.put(srcBillId, ret);
        }
        return successIds;
    }

    public static Map<String, Map<String, Object>> requirePushMutex(String srcEntityNumber, Set<String> srcBillIds, boolean isStrict) {
        if (srcBillIds == null || srcBillIds.isEmpty()) {
            return new HashMap<String, Map<String, Object>>(0);
        }
        if (StringUtils.isBlank((CharSequence)srcEntityNumber)) {
            return new HashMap<String, Map<String, Object>>(0);
        }
        ArrayList mutexRequireList = new ArrayList(srcBillIds.size());
        for (String srcBillId : srcBillIds) {
            HashMap<String, Object> requireParam = new HashMap<String, Object>();
            requireParam.put("dataObjId", srcBillId);
            requireParam.put("groupId", "default_netctrl");
            requireParam.put("entityKey", srcEntityNumber);
            requireParam.put("operationKey", "ctbotp_convert");
            requireParam.put("isStrict", isStrict);
            mutexRequireList.add(requireParam);
        }
        HashMap<String, Map<String, Object>> result = new HashMap<String, Map<String, Object>>(srcBillIds.size());
        HashMap<String, Boolean> success = new HashMap<String, Boolean>(1);
        success.put(DATA_MUTEX_KEY_SUCCESS, Boolean.TRUE);
        try (DataMutex dataMutex = DataMutex.create();){
            Map mutexResult = dataMutex.batchrequire(mutexRequireList);
            for (Map.Entry mutexItem : mutexResult.entrySet()) {
                String srcBillId = (String)mutexItem.getKey();
                Boolean ret = (Boolean)mutexItem.getValue();
                if (ret.booleanValue()) {
                    result.put(srcBillId, success);
                    continue;
                }
                HashMap<String, Boolean> failed = new HashMap<String, Boolean>(4);
                failed.put(DATA_MUTEX_KEY_SUCCESS, Boolean.FALSE);
                Map lockInfo = dataMutex.getLockInfo(srcBillId, "default_netctrl", srcEntityNumber);
                if (lockInfo != null) {
                    failed.putAll(lockInfo);
                }
                result.put(srcBillId, failed);
            }
        }
        catch (IOException e) {
            ErrorCode ec = new ErrorCode("MUTEX_REQUIRE_ERROR", String.format(ResManager.loadKDString((String)"\u7533\u8bf7\u4e92\u65a5\u9501\u51fa\u9519;err:%s", (String)"DataMutexAction_1", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), e.getMessage()));
            throw new KDException((Throwable)e, ec, new Object[0]);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Boolean> releasePushMutex(String srcEntityNumber, Set<String> srcBillIds) {
        if (srcBillIds == null) return new HashMap<String, Boolean>(0);
        if (srcBillIds.isEmpty()) {
            return new HashMap<String, Boolean>(0);
        }
        if (StringUtils.isBlank((CharSequence)srcEntityNumber)) {
            HashMap<String, Boolean> result = new HashMap<String, Boolean>(srcBillIds.size());
            Iterator<String> iterator = srcBillIds.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next();
                result.put(string, Boolean.FALSE);
            }
            return result;
        }
        ArrayList mutexRequireList = new ArrayList(srcBillIds.size());
        for (String string : srcBillIds) {
            HashMap<String, String> requireParam = new HashMap<String, String>();
            requireParam.put("dataObjId", string);
            requireParam.put("groupId", "default_netctrl");
            requireParam.put("entityKey", srcEntityNumber);
            requireParam.put("operationKey", "ctbotp_convert");
            mutexRequireList.add(requireParam);
        }
        try {
            Throwable throwable = null;
            try (DataMutex dataMutex = DataMutex.create();){
                Map map = dataMutex.batchRelease(mutexRequireList);
                return map;
            }
            catch (Throwable map) {
                Throwable throwable3 = map;
                throw map;
            }
        }
        catch (IOException e) {
            ErrorCode errorCode = new ErrorCode("MUTEX_REQUIRE_ERROR", String.format(ResManager.loadKDString((String)"\u91ca\u653e\u4e92\u65a5\u9501\u51fa\u9519;err:%s", (String)"DataMutexAction_2", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), e.getMessage()));
            throw new KDException((Throwable)e, errorCode, new Object[0]);
        }
    }
}

