/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.batchactions;

import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ctbotp.convert.CtConvertContext;
import kd.bos.service.ctbotp.convert.CtConvertResultManager;
import kd.bos.service.ctbotp.convert.actions.AbstractCtConvertAction;
import kd.bos.service.ctbotp.convert.compiler.AbstractCtEntityMap;
import kd.bos.service.ctbotp.convert.compiler.CtLinkEntityMap;
import kd.bos.service.ctbotp.convert.group.CtSourceRowId;

public class CtBatchLoadSourceDataAction
extends AbstractCtConvertAction {
    private static final Log log = LogFactory.getLog(CtBatchLoadSourceDataAction.class);

    public CtBatchLoadSourceDataAction(CtConvertContext context, CtConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    public void setProcess() {
    }

    @Override
    protected void doAction() {
        super.doAction();
        CtLinkEntityMap linkEntityMap = this.ruleContext.getRuleCompiler().getLinkEntityMap();
        QFilter[] qFilters = new QFilter[]{linkEntityMap.comileQFilter(this.ruleContext, this.getSourceRowsGroupRoot())};
        String selectSQLString = linkEntityMap.getSrcSelectString();
        String entityNumber = this.ruleContext.getContext().getInputArgs().getSourceEntityNumber();
        DynamicObjectCollection rows = null;
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet(this.getClass().getName(), entityNumber, selectSQLString, qFilters);){
            rows = orm.toPlainDynamicObjectCollection(ds);
        }
        DynamicObjectType dType = rows.getDynamicObjectType();
        if (linkEntityMap.getSrcFldPropertys().isEmpty()) {
            Map<String, DynamicProperty> fldPropertys = this.buildSourceRowPropsDictory(dType, linkEntityMap.getSrcFldAlias());
            linkEntityMap.setSrcFldPropertys(fldPropertys);
        }
        HashMap<CtSourceRowId, DynamicObject> sourceRowIds = new HashMap<CtSourceRowId, DynamicObject>();
        for (DynamicObject sourceRow : rows) {
            CtSourceRowId sourceRowId = CtSourceRowId.create((AbstractCtEntityMap)linkEntityMap, sourceRow);
            sourceRowIds.put(sourceRowId, sourceRow);
        }
        this.getSourceRowsGroupRoot().fillSourceRow(sourceRowIds);
        this.ruleContext.getMulbasedataParaManager().collectMulbasedataNumberForLoadSource(linkEntityMap, linkEntityMap.getSrcFldPropertys(), rows);
    }

    private Map<String, DynamicProperty> buildSourceRowPropsDictory(DynamicObjectType dType, Map<String, String> fldAlias) {
        HashMap<String, DynamicProperty> fldPropertys = new HashMap<String, DynamicProperty>(fldAlias.size());
        for (Map.Entry<String, String> fldAliasItem : fldAlias.entrySet()) {
            String var = fldAliasItem.getKey();
            String alias = fldAliasItem.getValue();
            DynamicProperty property = dType.getProperty(alias);
            fldPropertys.put(var, property);
        }
        return fldPropertys;
    }
}

