/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.batchactions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ctbotp.apiresponse.CtBillLkRes;
import kd.bos.entity.ctbotp.constants.CtPushProcessEnum;
import kd.bos.entity.ctbotp.constants.SyncStatusEnum;
import kd.bos.entity.ctbotp.link.CtLkDownQueryArgs;
import kd.bos.entity.ctbotp.sync.SyncLog;
import kd.bos.entity.ctbotp.sync.SyncQueryArgs;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.service.ctbotp.convert.CtConvertContext;
import kd.bos.service.ctbotp.convert.CtConvertResultManager;
import kd.bos.service.ctbotp.convert.actions.AbstractCtConvertAction;
import kd.bos.service.ctbotp.service.CtBillLkServiceHelper;
import kd.bos.servicehelper.CtSyncLogServiceHelper;
import org.apache.commons.collections.MapUtils;

public class CtBatchPushAgainCheckAction
extends AbstractCtConvertAction {
    public CtBatchPushAgainCheckAction(CtConvertContext context, CtConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    public void setProcess() {
        this.resultManager.setCtPushProcessEnum(CtPushProcessEnum.CtPushAgainCheckAction);
    }

    @Override
    protected void doAction() {
        super.doAction();
        if (!this.ruleContext.getRule().getCtOptionPolicy().isPushOneTime()) {
            return;
        }
        Set<Long> srcBillIds = this.getSrcBillIds();
        Set<Long> noPushBillIds = this.findNoPushBills(srcBillIds);
        this.filterSelectedRows(noPushBillIds);
        if (this.ruleContext.getSelectedRows().isEmpty()) {
            this.setSkipNextAction(true);
        }
    }

    private Set<Long> getSrcBillIds() {
        HashSet<Long> srcBillIds = new HashSet<Long>(this.getRuleContext().getSelectedRows().size());
        for (ListSelectedRow selectedRow : this.getRuleContext().getSelectedRows()) {
            Long srcBillId = (Long)selectedRow.getPrimaryKeyValue();
            srcBillIds.add(srcBillId);
        }
        return srcBillIds;
    }

    private Set<Long> findNoPushBills(Set<Long> srcBillIds) {
        if (srcBillIds == null || srcBillIds.size() == 0) {
            return Collections.emptySet();
        }
        CtLkDownQueryArgs ctLkDownQueryArgs = new CtLkDownQueryArgs();
        ctLkDownQueryArgs.setsTenantCode(RequestContext.get().getTenantId());
        ctLkDownQueryArgs.setsAccountId(RequestContext.get().getAccountId());
        ctLkDownQueryArgs.setsEntityKey(this.getContext().getCtPushArgs().getSourceEntityNumber());
        ctLkDownQueryArgs.setsBillIds(new ArrayList<Long>(srcBillIds));
        List<CtBillLkRes> ctBillLks = CtBillLkServiceHelper.getDirtBillLkDown(ctLkDownQueryArgs);
        HashMap<Long, CtBillLkRes> ctBillLkMap = new HashMap<Long, CtBillLkRes>(ctBillLks.size());
        for (CtBillLkRes ctBillLk : ctBillLks) {
            ctBillLkMap.put(ctBillLk.getsBillId(), ctBillLk);
        }
        SyncQueryArgs syncQueryArgs = SyncQueryArgs.create().addSTenantCode(RequestContext.get().getTenantId()).addSAccountId(RequestContext.get().getAccountId());
        syncQueryArgs.addSEntityKey(this.getContext().getCtPushArgs().getSourceEntityNumber()).addSBillIds(new ArrayList<Long>(srcBillIds));
        syncQueryArgs.addTTenantCode(this.getContext().getCtPushArgs().gettTenantCode()).addTAccountId(this.getContext().getCtPushArgs().gettAccountId()).addTEntityKey(this.getContext().getCtPushArgs().getTargetEntityNumber());
        syncQueryArgs.setSyncType(this.getContext().getCtPushArgs().getSyncType());
        Map sSyncLogMaps = CtSyncLogServiceHelper.getSSyncLogMaps((SyncQueryArgs)syncQueryArgs);
        String failMessage = String.format(ResManager.loadKDString((String)"\u5df2\u6709\u4e0b\u6e38\u5355\u636e\uff0c\u8bf7\u52ff\u91cd\u590d\u4e0b\u63a8\u3002", (String)"CtPushAgainCheckAction_0", (String)"bos-mservice-ctbotp", (Object[])new Object[0]), "");
        HashSet<Long> noPushBillIds = new HashSet<Long>(16);
        for (Long srcBillId : srcBillIds) {
            if (MapUtils.isEmpty((Map)sSyncLogMaps)) {
                noPushBillIds.add(srcBillId);
                continue;
            }
            SyncLog sSyncLog = (SyncLog)sSyncLogMaps.get(srcBillId);
            if (sSyncLog != null) {
                if (sSyncLog.getStatus().equals(SyncStatusEnum.A.getStatus())) {
                    this.getResultManager().getReporter().addFailId(srcBillId, ResManager.loadKDString((String)"\u6b63\u5728\u4e0b\u63a8\u4e2d\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"CtPushAgainCheckAction_1", (String)"bos-mservice-ctbotp", (Object[])new Object[0]));
                    continue;
                }
                CtBillLkRes ctBillLk = (CtBillLkRes)ctBillLkMap.get(srcBillId);
                if (ctBillLk != null) {
                    this.getResultManager().getReporter().addFailId(srcBillId, failMessage);
                    continue;
                }
                noPushBillIds.add(srcBillId);
                continue;
            }
            noPushBillIds.add(srcBillId);
        }
        return noPushBillIds;
    }

    private void filterSelectedRows(Set<Long> noPushBillIds) {
        ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(this.ruleContext.getSelectedRows());
        this.ruleContext.getSelectedRows().clear();
        if (noPushBillIds == null) {
            return;
        }
        for (ListSelectedRow selectedRow : selectedRows) {
            Object billId = selectedRow.getPrimaryKeyValue();
            if (!noPushBillIds.contains(billId)) continue;
            this.ruleContext.getSelectedRows().add(selectedRow);
        }
    }
}

