/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.batchactions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ctbotp.business.datamodel.CtDrawDataModel;
import kd.bos.service.ctbotp.convert.CtConvertContext;
import kd.bos.service.ctbotp.convert.CtConvertResultManager;
import kd.bos.service.ctbotp.convert.CtSingleBatchContext;
import kd.bos.service.ctbotp.convert.CtSingleBatchResultManager;
import kd.bos.service.ctbotp.convert.CtSingleRuleContext;
import kd.bos.service.ctbotp.convert.CtSingleRuleResultManager;
import kd.bos.service.ctbotp.convert.actions.AbstractCtConvertAction;
import kd.bos.service.ctbotp.convert.actions.CtFillLinkInfoAction;
import kd.bos.service.ctbotp.convert.actions.CtMappingDependFieldAction;
import kd.bos.service.ctbotp.convert.actions.CtMappingFieldAction;
import kd.bos.service.ctbotp.convert.batchactions.CtBatchAddBillLkAction;
import kd.bos.service.ctbotp.convert.batchactions.CtBatchCreateDependEntityRowsAction;
import kd.bos.service.ctbotp.convert.batchactions.CtBatchCreateLinkEntityRowsAction;
import kd.bos.service.ctbotp.convert.batchactions.CtBatchCreateSyncLogAction;
import kd.bos.service.ctbotp.convert.batchactions.CtBatchCreateTargetBillAction;
import kd.bos.service.ctbotp.convert.batchactions.CtBatchLoadDependEntityRowsAction;
import kd.bos.service.ctbotp.convert.batchactions.CtBatchLoadSourceDataAction;
import kd.bos.service.ctbotp.convert.batchactions.CtBatchSyncAction;
import kd.bos.service.ctbotp.convert.group.CtSourceRowsGroup;

public class CtBatchSingleExecute
implements Callable<CtSingleBatchResultManager> {
    private RequestContext rc;
    private boolean syncExecute = false;
    private static Log log = LogFactory.getLog(CtBatchSingleExecute.class);
    private CtConvertContext context;
    private CtSingleRuleContext ruleContext;
    private CtConvertResultManager resultManager;
    private CtSingleRuleResultManager ruleResultManager;
    private CtSourceRowsGroup currGroupRoot;
    private List<AbstractCtConvertAction> actions = new ArrayList<AbstractCtConvertAction>(0);

    public boolean isSyncExecute() {
        return this.syncExecute;
    }

    public void setSyncExecute(boolean syncExecute) {
        this.syncExecute = syncExecute;
    }

    public CtBatchSingleExecute(RequestContext rc, CtConvertContext context, CtSingleRuleContext ruleContext, CtConvertResultManager resultManager, CtSingleRuleResultManager ruleResultManager, CtSourceRowsGroup currGroupRoot) {
        this.rc = rc;
        this.context = context;
        this.ruleContext = ruleContext;
        this.resultManager = resultManager;
        this.ruleResultManager = ruleResultManager;
        this.currGroupRoot = currGroupRoot;
    }

    @Override
    public CtSingleBatchResultManager call() throws Exception {
        if (!this.isSyncExecute()) {
            RequestContext.copyAndSet((RequestContext)this.rc);
        }
        this.actions = this.createActions();
        CtSingleBatchContext batchContext = new CtSingleBatchContext();
        batchContext.setRuleContext(this.ruleContext);
        batchContext.setSourceRowsGroupRoot(this.currGroupRoot);
        batchContext.setModelProxy(this.createDataModel());
        CtSingleBatchResultManager batchResultManager = new CtSingleBatchResultManager();
        batchResultManager.setSourceRowsGroupRoot(this.currGroupRoot);
        try {
            for (AbstractCtConvertAction action : this.actions) {
                action.setRuleContext(this.ruleContext);
                action.setRuleResultManager(this.ruleResultManager);
                action.setBatchContext(batchContext);
                action.setBatchResultManager(batchResultManager);
                action.action();
            }
        }
        catch (KDBizException ex) {
            batchResultManager.setException(ex);
            batchResultManager.getReporter().setException(Boolean.TRUE.booleanValue());
            batchResultManager.getReporter().setErrorMsg(ex.getMessage());
        }
        catch (Throwable ex) {
            batchResultManager.getReporter().setException(Boolean.TRUE.booleanValue());
            batchResultManager.getReporter().setErrorMsg(ex.getMessage());
            batchResultManager.setException(ex);
            log.error(ex);
        }
        batchContext.clearMemory();
        batchContext = null;
        return batchResultManager;
    }

    private List<AbstractCtConvertAction> createActions() {
        ArrayList<AbstractCtConvertAction> list = new ArrayList<AbstractCtConvertAction>();
        list.add(new CtBatchCreateSyncLogAction(this.context, this.resultManager));
        list.add(new CtBatchLoadSourceDataAction(this.context, this.resultManager));
        list.add(new CtBatchLoadDependEntityRowsAction(this.context, this.resultManager));
        list.add(new CtBatchCreateTargetBillAction(this.context, this.resultManager));
        list.add(new CtBatchCreateLinkEntityRowsAction(this.context, this.resultManager));
        list.add(new CtBatchCreateDependEntityRowsAction(this.context, this.resultManager));
        list.add(new CtMappingDependFieldAction(this.context, this.resultManager));
        list.add(new CtMappingFieldAction(this.context, this.resultManager));
        list.add(new CtFillLinkInfoAction(this.context, this.resultManager));
        list.add(new CtBatchSyncAction(this.context, this.resultManager));
        list.add(new CtBatchAddBillLkAction(this.context, this.resultManager));
        return list;
    }

    private CtDrawDataModel createDataModel() {
        HashMap services = new HashMap();
        String targetEntityNumber = this.context.getInputArgs().getTargetEntityNumber();
        String pageId = UUID.randomUUID().toString();
        return new CtDrawDataModel(targetEntityNumber, pageId, services);
    }

    public CtSourceRowsGroup getCurrGroupRoot() {
        return this.currGroupRoot;
    }
}

