/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.batchactions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ctbotp.CtDataEntity;
import kd.bos.entity.ctbotp.CtExtendedDataEntity;
import kd.bos.entity.ctbotp.CtExtendedDataEntitySet;
import kd.bos.entity.ctbotp.constants.CtApiUrlEnum;
import kd.bos.entity.ctbotp.runtime.CtPushArgs;
import kd.bos.entity.ctbotp.runtime.CtSaveOperationResult;
import kd.bos.entity.ctbotp.runtime.CtSyncArgs;
import kd.bos.service.ctbotp.convert.CtConvertContext;
import kd.bos.service.ctbotp.convert.CtConvertResultManager;
import kd.bos.service.ctbotp.convert.actions.AbstractCtConvertAction;
import kd.bos.service.ctbotp.convert.group.CtSourceRowsGroup;
import kd.bos.service.ctbotp.utils.CtBotpApiUtils;
import kd.bos.service.ctbotp.utils.CtBotpTenantUtils;
import kd.bos.util.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class CtBatchSyncAction
extends AbstractCtConvertAction {
    private static final String BOS_MSERVICE_OPERATION = "bos-mservice-ctbotp";

    public CtBatchSyncAction(CtConvertContext context, CtConvertResultManager resultManager) {
        super(context, resultManager);
    }

    @Override
    public void setProcess() {
    }

    @Override
    protected void doAction() {
        super.doAction();
        CtExtendedDataEntitySet targetExtDataSet = this.getTargetExtendedDataEntities();
        CtExtendedDataEntity[] headExtEntitys = targetExtDataSet.FindByEntityKey(this.context.getInputArgs().getTargetEntityNumber());
        ArrayList<CtDataEntity> ctDataEntities = new ArrayList<CtDataEntity>(16);
        for (int i = 0; i < headExtEntitys.length; ++i) {
            List sourceRows = (List)headExtEntitys[i].getValue("ConvertSource");
            if (CollectionUtils.isEmpty((Collection)sourceRows)) continue;
            ctDataEntities.add(headExtEntitys[i].getCtDataEntity());
        }
        HashSet<Object> savingBillList = new HashSet<Object>(headExtEntitys.length);
        ArrayList<CtDataEntity> targetBillObjs = new ArrayList<CtDataEntity>(headExtEntitys.length);
        for (int i = 0; i < headExtEntitys.length; ++i) {
            CtDataEntity obj = headExtEntitys[i].getCtDataEntity();
            Long billId = obj.getId();
            if (this.ruleResultManager.isFail(billId)) {
                this.batchResultManager.addFailId(billId, ResManager.loadKDString((String)"\u76ee\u6807\u5355\u5176\u4ed6\u5206\u6279\u8f6c\u6362\u5931\u8d25\uff0c\u672c\u6279\u8df3\u8fc7", (String)"CtBatchSyncAction_2", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
                continue;
            }
            targetBillObjs.add(obj);
            savingBillList.add(billId);
        }
        if (!targetBillObjs.isEmpty()) {
            this.doSave(savingBillList, ctDataEntities);
        }
        this.setTargetExtendedDataEntities(null);
        this.batchContext.getSourceRowsGroupRoot().clearSourceRow();
    }

    private CtSaveOperationResult ctSync(List<CtDataEntity> ctDataEntities) {
        CtPushArgs args = this.getContext().getCtPushArgs();
        CtSyncArgs ctSyncArgs = new CtSyncArgs();
        ctSyncArgs.setSyncType(args.getSyncType());
        ctSyncArgs.setData(ctDataEntities);
        ctSyncArgs.setsEntityKey(args.getSourceEntityNumber());
        ctSyncArgs.settEntityKey(args.getTargetEntityNumber());
        ctSyncArgs.setRuleId(args.getRuleId());
        ctSyncArgs.setsAccountId(args.getsAccountId());
        ctSyncArgs.setsTenantCode(args.getsTenantCode());
        ctSyncArgs.settAccountId(args.gettAccountId());
        ctSyncArgs.settTenantCode(args.gettTenantCode());
        ctSyncArgs.setsSyncLogs(this.batchResultManager.getsSyncLogs());
        ctSyncArgs.setCheckPushAgain(args.isCheckPushAgain());
        ctSyncArgs.setBatchPush(args.isBatchPush());
        String result = null;
        String errorMsg = "";
        try {
            result = CtBotpApiUtils.post(CtBotpTenantUtils.getGroupTenantInfo().getTenantId(), CtBotpTenantUtils.getGroupTenantInfo().getAccountId(), CtApiUrlEnum.CTSYNC, SerializationUtils.toJsonString((Object)ctSyncArgs));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result == null) {
            errorMsg = ResManager.loadKDString((String)"\u8c03\u7528\u4fdd\u5b58\u76ee\u6807\u5355\u63a5\u53e3\u5f02\u5e38\uff0c\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"CtBatchSyncAction_0", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]);
            this.batchResultManager.getReporter().setException(Boolean.TRUE.booleanValue());
            this.batchResultManager.getReporter().setErrorMsg(errorMsg);
            return null;
        }
        Map openApiResult = (Map)SerializationUtils.fromJsonString(result, Map.class);
        if (openApiResult != null && !openApiResult.get("errorCode").equals("0")) {
            this.batchResultManager.getReporter().setException(Boolean.TRUE.booleanValue());
            Object message = openApiResult.get("message");
            errorMsg = StringUtils.isNotBlank(message) ? message.toString() : String.format(ResManager.loadKDString((String)"\u8c03\u7528\u4fdd\u5b58\u76ee\u6807\u5355\u63a5\u53e3\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002\u9519\u8bef\u7801\uff1a%s", (String)"CtBatchSyncAction_1", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), openApiResult.get("errorCode"));
            this.batchResultManager.getReporter().setErrorMsg(errorMsg);
            return null;
        }
        if (openApiResult != null && openApiResult.get("data") != null) {
            return (CtSaveOperationResult)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString(openApiResult.get("data")), CtSaveOperationResult.class);
        }
        return null;
    }

    private void doSave(Set<Object> savingBillList, List<CtDataEntity> ctDataEntities) {
        CtSaveOperationResult ctConvertOperationResult = this.ctSync(ctDataEntities);
        HashSet<Long> successPkIds = new HashSet<Long>(16);
        if (ctConvertOperationResult != null && ctConvertOperationResult.getReporter() != null && CollectionUtils.isNotEmpty((Collection)ctConvertOperationResult.getReporter().getSuccessIds())) {
            successPkIds = new HashSet(ctConvertOperationResult.getReporter().getSuccessIds());
        }
        this.batchResultManager.addSuccessIds(successPkIds);
        if (ctConvertOperationResult != null) {
            this.batchResultManager.getReporter().addSuccessIds((Collection)ctConvertOperationResult.getReporter().getSuccessIds());
        }
        this.outFailMessage(ctConvertOperationResult);
        this.outSuccessObjs(ctConvertOperationResult, ctDataEntities);
        if (ctConvertOperationResult != null) {
            this.batchResultManager.setCtBillLks(ctConvertOperationResult.getCtBillLks());
            this.batchResultManager.settBillNoMap(ctConvertOperationResult.gettBillNoMap());
        }
    }

    private void outFailMessage(CtSaveOperationResult saveResult) {
        if (saveResult == null || saveResult.getReporter() == null || MapUtils.isEmpty((Map)saveResult.getReporter().getFailIds())) {
            return;
        }
        Map errorMap = saveResult.getReporter().getFailIds();
        for (Map.Entry entry : errorMap.entrySet()) {
            this.batchResultManager.addFailId((Long)entry.getKey(), (String)entry.getValue());
            this.batchResultManager.getReporter().addFailId((Long)entry.getKey(), (String)entry.getValue());
        }
        if (!this.batchResultManager.getFailIds().isEmpty()) {
            this.ruleResultManager.addFailBillIds(this.batchResultManager.getFailIds().keySet());
        }
    }

    private void outSuccessObjs(CtSaveOperationResult ctConvertOperationResult, List<CtDataEntity> ctDataEntities) {
        if (ctConvertOperationResult == null || ctConvertOperationResult.getReporter() == null || CollectionUtils.isEmpty((Collection)ctConvertOperationResult.getReporter().getSuccessIds())) {
            return;
        }
        HashMap<Long, CtDataEntity> idDataMaps = new HashMap<Long, CtDataEntity>(16);
        for (CtDataEntity ctDataEntity : ctDataEntities) {
            idDataMaps.put(ctDataEntity.getId(), ctDataEntity);
        }
        HashMap idToObjs = new HashMap(16);
        for (Object id : ctConvertOperationResult.getReporter().getSuccessIds()) {
            idToObjs.put(id, idDataMaps.get(id));
        }
        ArrayList<CtDataEntity> arrayList = new ArrayList<CtDataEntity>();
        for (CtSourceRowsGroup billGroup : this.getSourceRowsGroupRoot().getChildGroupList()) {
            if (billGroup.getStartEntrySeq() != 1 || !billGroup.isExistNextBatch() || !this.batchResultManager.getSuccessIds().contains(billGroup.getTargetBillId())) continue;
            arrayList.add((CtDataEntity)idToObjs.get(billGroup.getTargetBillId()));
        }
        if (!arrayList.isEmpty()) {
            this.ruleResultManager.putTargetBillHeads(arrayList);
        }
    }
}

