/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.batchrequest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.CacheLoader;
import kd.bos.cache.ThreadCache;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ctbotp.CtFieldMapItem;
import kd.bos.entity.ctbotp.runtime.CtReportManager;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MaterielProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.validate.IValidatorHanlder;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ctbotp.convert.CtSingleRuleContext;
import kd.bos.service.ctbotp.convert.CtSingleRuleResultManager;
import kd.bos.service.ctbotp.convert.batchrequest.CtOrgSeprFieldGroupKey;
import kd.bos.service.ctbotp.convert.batchrequest.CtOrgSeprFieldSetValueRequest;
import kd.bos.service.ctbotp.convert.compiler.AbstractCtEntityMap;
import kd.bos.service.ctbotp.convert.compiler.CtLinkEntityMap;
import kd.bos.service.ctbotp.convert.getvaluemode.ICtGetValueMode;
import kd.bos.service.ctbotp.convert.report.ICtBuildDetailReport;
import kd.bos.service.ctbotp.save.batchrequest.CtSaveOrgSeprFieldSetValueRequest;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class CtBatchOrgSeprFieldSetValue {
    private static final Log log = LogFactory.getLog(CtBatchOrgSeprFieldSetValue.class);
    private static final String BOS_MSERVICE_OPERATION = "bos-mservice-botp";
    private static final String THREAD_CACHE_KEY_BASEDATA_USE_FILTER = "botp_basedata_use_filter";
    private static final String THREAD_CACHE_KEY_BASEDATA_MASTER_TO_IDS = "botp_basedata_mastertoids";
    private CtSingleRuleContext ruleContext;
    private CtSingleRuleResultManager ruleResultManager;
    private CtReportManager reportManager;
    private ICtBuildDetailReport buildReporter;
    private boolean fail = false;
    private AbstractCtEntityMap linkEntityMap;
    private BillEntityType sourceMainType;
    private BillEntityType targetMainType;
    private List<CtSaveOrgSeprFieldSetValueRequest> requests = new ArrayList<CtSaveOrgSeprFieldSetValueRequest>();

    public CtBatchOrgSeprFieldSetValue(CtSingleRuleContext ruleContext, CtSingleRuleResultManager ruleResultManager, AbstractCtEntityMap linkEntityMap) {
        this.ruleContext = ruleContext;
        this.ruleResultManager = ruleResultManager;
        this.reportManager = ruleResultManager.getConvertResultManager().getReporter();
        this.linkEntityMap = linkEntityMap;
        this.sourceMainType = ruleContext.getContext().getSourceMainType();
        this.targetMainType = ruleContext.getContext().getTargetMainType();
        BillEntityType linkEntity = this.sourceMainType;
        if (linkEntityMap instanceof CtLinkEntityMap) {
            linkEntity = (EntityType)this.ruleContext.getContext().getSourceMainType().getAllEntities().get(((CtLinkEntityMap)linkEntityMap).getSourceLinkEntityKey());
        } else {
            if (StringUtils.isNotBlank((CharSequence)linkEntityMap.getSourceEntryKey())) {
                linkEntity = (EntityType)this.sourceMainType.getAllEntities().get(linkEntityMap.getSourceEntryKey());
            }
            if (StringUtils.isNotBlank((CharSequence)linkEntityMap.getSourceSubEntryKey())) {
                linkEntity = (EntityType)this.sourceMainType.getAllEntities().get(linkEntityMap.getSourceSubEntryKey());
            }
        }
        this.buildReporter = this.ruleContext.getSrcRowReportBuilder((EntityType)linkEntity);
        this.fail = false;
    }

    public BillEntityType getSourceMainType() {
        return this.sourceMainType;
    }

    public BillEntityType getTargetMainType() {
        return this.targetMainType;
    }

    public List<CtSaveOrgSeprFieldSetValueRequest> getRequests() {
        return this.requests;
    }

    public boolean isFail() {
        return this.fail;
    }

    public void batchDo() {
        HashMap fields = new HashMap();
        for (CtSaveOrgSeprFieldSetValueRequest ctSaveOrgSeprFieldSetValueRequest : this.requests) {
        }
        for (Map.Entry entry : fields.entrySet()) {
            this.setFieldValue((CtOrgSeprFieldGroupKey)entry.getKey(), (List)entry.getValue());
        }
    }

    private void setFieldValue(CtOrgSeprFieldGroupKey fldGroupKey, List<CtOrgSeprFieldSetValueRequest> fldRequests) {
        HashSet<Object> noMasterIds;
        HashMap<Object, Object> oldIdToMasterids;
        BasedataProp targetFieldProp = fldGroupKey.getTargetFieldProp();
        String useOrgPropName = this.getUseOrgFieldKey(targetFieldProp);
        if (StringUtils.isBlank((CharSequence)useOrgPropName)) {
            this.setSrcFieldValue(fldRequests);
            return;
        }
        List<CtOrgSeprFieldSetValueRequest> changeOrgRequests = this.findOrgChangedRequests(fldGroupKey, fldRequests, useOrgPropName);
        if (changeOrgRequests.isEmpty()) {
            return;
        }
        CtFieldMapItem fieldMapItem = changeOrgRequests.get(0).getFieldMapItem();
        if (!this.loadMasterids(fldGroupKey, fieldMapItem, changeOrgRequests, oldIdToMasterids = new HashMap<Object, Object>(), noMasterIds = new HashSet<Object>())) {
            this.setSrcFieldValue(changeOrgRequests);
            return;
        }
        Map<Long, List<CtOrgSeprFieldSetValueRequest>> dctByUseOrg = this.groupByOrg(targetFieldProp, useOrgPropName, changeOrgRequests);
        for (Map.Entry<Long, List<CtOrgSeprFieldSetValueRequest>> entry : dctByUseOrg.entrySet()) {
            Long useOrgId = entry.getKey();
            if (Long.compare(useOrgId, 0L) == 0) {
                this.setSrcFieldValue(entry.getValue());
                continue;
            }
            ArrayList<CtOrgSeprFieldSetValueRequest> orgRequests = new ArrayList<CtOrgSeprFieldSetValueRequest>(entry.getValue().size());
            HashSet<Object> masterids = new HashSet<Object>();
            for (CtOrgSeprFieldSetValueRequest request : entry.getValue()) {
                if (oldIdToMasterids.containsKey(request.getSourceRefId())) {
                    masterids.add(oldIdToMasterids.get(request.getSourceRefId()));
                    orgRequests.add(request);
                    continue;
                }
                request.setValue();
            }
            if (masterids.isEmpty()) continue;
            HashMap<Object, Object> masteridToIds = new HashMap<Object, Object>();
            if (!this.loadIdsinUseOrg(fieldMapItem, fldGroupKey.getTargetFieldRefType(), useOrgId, masterids, masteridToIds)) {
                this.setSrcFieldValue(orgRequests);
                continue;
            }
            for (CtOrgSeprFieldSetValueRequest request : orgRequests) {
                Object masterid = oldIdToMasterids.get(request.getSourceRefId());
                Object obj = masteridToIds.get(masterid);
                if (obj != null) {
                    request.setValue();
                    continue;
                }
                this.addErrorMessage(fldGroupKey, useOrgPropName, useOrgId, request);
            }
        }
    }

    private List<CtOrgSeprFieldSetValueRequest> findOrgChangedRequests(CtOrgSeprFieldGroupKey fldGroupKey, List<CtOrgSeprFieldSetValueRequest> fldRequests, String useOrgFld) {
        if (fldGroupKey.getTargetFieldRefType() == null || fldGroupKey.getTargetFieldRefType().getMasteridType() == 0) {
            this.setSrcFieldValue(fldRequests);
            return new ArrayList<CtOrgSeprFieldSetValueRequest>(0);
        }
        ArrayList<CtOrgSeprFieldSetValueRequest> changeOrgRequests = new ArrayList<CtOrgSeprFieldSetValueRequest>(fldRequests);
        CtFieldMapItem fieldMapItem = fldRequests.get(0).getFieldMapItem();
        ICtGetValueMode srcOrg_GetHandler = ((CtOrgSeprFieldSetValueRequest)changeOrgRequests.get(0)).getSrcOrg_GetHandler();
        if (srcOrg_GetHandler == null) {
            return changeOrgRequests;
        }
        BasedataEntityType refBDType = this.getSrcFldRefType(fieldMapItem, fldGroupKey.getTargetFieldRefType());
        if (!StringUtils.equals((CharSequence)refBDType.getName(), (CharSequence)fldGroupKey.getTargetFieldRefType().getName())) {
            return changeOrgRequests;
        }
        RowDataModel rowDataModel = new RowDataModel(fldGroupKey.getTargetFieldProp().getParent().getName(), (MainEntityType)this.targetMainType);
        String useOrgFld_Id = useOrgFld + "_id";
        for (CtOrgSeprFieldSetValueRequest fldRequest : fldRequests) {
            Long targetOrgId;
            Long srcOrgId = (Long)srcOrg_GetHandler.getValue(this.linkEntityMap.getBaseDataPropInfoMap(), this.linkEntityMap.getSrcFldPropertys(), fldRequest.getSourceRows().get(0));
            if (srcOrgId == null) {
                srcOrgId = 0L;
            }
            if ((targetOrgId = (Long)rowDataModel.getValue(useOrgFld_Id)) == null) {
                targetOrgId = 0L;
            }
            if (Long.compare(srcOrgId, targetOrgId) != 0) continue;
            fldRequest.setValue();
            changeOrgRequests.remove(fldRequest);
        }
        return changeOrgRequests;
    }

    public boolean loadMasterids(CtOrgSeprFieldGroupKey fldGroupKey, CtFieldMapItem fieldMapItem, List<CtOrgSeprFieldSetValueRequest> requests, Map<Object, Object> idToMasterids, Set<Object> noMasterIds) {
        BasedataEntityType refBDType = this.getSrcFldRefType(fieldMapItem, fldGroupKey.getTargetFieldRefType());
        if (refBDType == null || refBDType.getMasteridType() == 0) {
            return false;
        }
        HashSet<Object> oldIds = new HashSet<Object>(requests.size());
        for (CtOrgSeprFieldSetValueRequest request : requests) {
            oldIds.add(request.getSourceRefId());
        }
        if (oldIds.isEmpty()) {
            return true;
        }
        IValidatorHanlder masteridProp = (IValidatorHanlder)refBDType.findProperty(refBDType.getMasteridPropName());
        HashSet<String> fields = new HashSet<String>(2);
        fields.add(refBDType.getPrimaryKey().getName());
        fields.add(refBDType.getMasteridPropName());
        MainEntityType subType = (MainEntityType)EntityMetadataCache.getSubDataEntityType((String)refBDType.getName(), fields);
        Map objs = BusinessDataServiceHelper.loadFromCache((Object[])oldIds.toArray(), (DynamicObjectType)subType);
        for (Map.Entry entry : objs.entrySet()) {
            Object id = entry.getKey();
            Object masterid = ((DynamicObject)entry.getValue()).get(refBDType.getMasteridPropName());
            if (masterid instanceof DynamicObject) {
                masterid = ((DynamicObject)masterid).getPkValue();
            }
            if (masteridProp.getValueComparator().compareValue(masterid)) {
                noMasterIds.add(id);
                continue;
            }
            idToMasterids.put(id, masterid);
        }
        return true;
    }

    private BasedataEntityType getSrcFldRefType(CtFieldMapItem fieldMapItem, BasedataEntityType targetFldRefType) {
        BasedataEntityType refBDType = null;
        switch (fieldMapItem.getCtFieldConvertType()) {
            case CONSTANT: 
            case Formula: 
            case ByCondition: {
                refBDType = targetFldRefType;
                break;
            }
            default: {
                BasedataEntityType srcRefType;
                IDataEntityProperty srcFieldProp = this.sourceMainType.findProperty(fieldMapItem.getSourceFieldKey());
                refBDType = !(srcFieldProp instanceof BasedataProp) ? targetFldRefType : (srcFieldProp instanceof ItemClassProp ? targetFldRefType : ((srcRefType = (BasedataEntityType)((BasedataProp)srcFieldProp).getComplexType()) == null || srcRefType.getMasteridType() == 0 ? targetFldRefType : srcRefType));
            }
        }
        return refBDType;
    }

    private Map<Long, List<CtOrgSeprFieldSetValueRequest>> groupByOrg(BasedataProp targetFieldProp, String useOrgPropName, List<CtOrgSeprFieldSetValueRequest> requests) {
        HashMap<Long, List<CtOrgSeprFieldSetValueRequest>> dctByUseOrg = new HashMap<Long, List<CtOrgSeprFieldSetValueRequest>>();
        RowDataModel rowDataModel = new RowDataModel(targetFieldProp.getParent().getName(), (MainEntityType)this.targetMainType);
        for (CtOrgSeprFieldSetValueRequest request : requests) {
            DynamicObject useOrg = (DynamicObject)rowDataModel.getValue(useOrgPropName);
            Long useOrgId = 0L;
            if (useOrg != null) {
                useOrgId = (Long)useOrg.getPkValue();
            }
            if (!dctByUseOrg.containsKey(useOrgId)) {
                dctByUseOrg.put(useOrgId, new ArrayList());
            }
            ((List)dctByUseOrg.get(useOrgId)).add(request);
        }
        return dctByUseOrg;
    }

    private boolean loadIdsinUseOrg(CtFieldMapItem fieldMapItem, BasedataEntityType targetFldRefType, long useOrgid, Set<Object> masterids, Map<Object, Object> masteridToIds) {
        BasedataEntityType srcFldRefType;
        if (targetFldRefType.getMasteridType() == 0) {
            return false;
        }
        if (Long.compare(useOrgid, 0L) == 0) {
            return false;
        }
        String cacheKey = String.format("%s_%s_%s", RequestContext.get().getTenantCode(), THREAD_CACHE_KEY_BASEDATA_MASTER_TO_IDS, targetFldRefType.getName());
        Map cacheMasteridToIds = (Map)ThreadCache.get((Object)cacheKey, (CacheLoader)new CacheLoader<Map<String, Object>>(){

            public Map<String, Object> load() {
                return new HashMap<String, Object>();
            }
        });
        HashSet<Object> nofindFromCacheMasterIds = new HashSet<Object>(masterids.size());
        for (Object masterId : masterids) {
            String key = String.format("%s,%s", masterId, useOrgid);
            if (cacheMasteridToIds.containsKey(key)) {
                masteridToIds.put(masterId, cacheMasteridToIds.get(key));
                continue;
            }
            nofindFromCacheMasterIds.add(masterId);
        }
        if (nofindFromCacheMasterIds.isEmpty()) {
            return true;
        }
        if (!BaseDataServiceHelper.checkBaseDataCtrl((String)targetFldRefType.getName()).booleanValue() && ((srcFldRefType = this.getSrcFldRefType(fieldMapItem, targetFldRefType)) == null || StringUtils.equals((CharSequence)srcFldRefType.getName(), (CharSequence)targetFldRefType.getName()))) {
            return false;
        }
        ORM orm = ORM.create();
        String entity = targetFldRefType.getName();
        String fields = StringUtils.join((Object[])new String[]{"id", targetFldRefType.getMasteridPropName(), "enable"}, (String)",");
        QFilter masteridFilter = new QFilter(targetFldRefType.getMasteridPropName(), "in", (Object)nofindFromCacheMasterIds.toArray());
        QFilter[] filters = new QFilter[]{masteridFilter};
        String filterStr = this.qFilterToString(filters);
        DynamicObjectCollection dynamicObjects = BaseDataServiceHelper.queryBaseData((String)targetFldRefType.getName(), (Long)useOrgid, (QFilter)masteridFilter, (String)fields);
        for (DynamicObject dynamicObject : dynamicObjects) {
            Object id = dynamicObject.get("id");
            Object masterid = dynamicObject.get(targetFldRefType.getMasteridPropName());
            Object enable = dynamicObject.get("enable");
            if (!this.validateBasedataEnable(fieldMapItem.getTargetFieldKey(), enable)) continue;
            masteridToIds.put(masterid, id);
        }
        for (Object e : nofindFromCacheMasterIds) {
            if (!masteridToIds.containsKey(e)) continue;
            String key = String.format("%s,%s", e, useOrgid);
            cacheMasteridToIds.put(key, masteridToIds.get(e));
        }
        for (Object e : nofindFromCacheMasterIds) {
            if (masteridToIds.containsKey(e)) continue;
            String logMsg = String.format("source :%s, target: %s, bdtype: %s, masterid: %s, orgid: %s, filter : %s", this.ruleContext.getContext().getSourceMainType().getName(), this.ruleContext.getContext().getTargetMainType().getName(), targetFldRefType.getName(), e, useOrgid, filterStr);
            log.info(logMsg);
            break;
        }
        return true;
    }

    private boolean validateBasedataEnable(String targetFieldKey, Object enable) {
        if (this.isValidateBasedataEnable(targetFieldKey)) {
            return enable == null || !"0".equalsIgnoreCase(enable.toString());
        }
        return true;
    }

    private boolean isValidateBasedataEnable(String targetFieldKey) {
        return true;
    }

    private QFilter loadBaseQFilter(final BasedataEntityType targetFldRefType, final long useOrgid) {
        String threadCacheKey = String.format("%s_%s_%s", THREAD_CACHE_KEY_BASEDATA_USE_FILTER, targetFldRefType.getName(), useOrgid);
        QFilter orgFilter = (QFilter)ThreadCache.get((Object)threadCacheKey, (CacheLoader)new CacheLoader<QFilter>(){

            public QFilter load() {
                QFilter cacheFilter = BaseDataServiceHelper.getBaseDataFilter((String)targetFldRefType.getName(), (Long)useOrgid);
                if (cacheFilter == null) {
                    cacheFilter = new BotpNullQFilter(CtBatchOrgSeprFieldSetValue.THREAD_CACHE_KEY_BASEDATA_USE_FILTER, "=", "");
                }
                return cacheFilter;
            }
        });
        if (orgFilter instanceof BotpNullQFilter) {
            orgFilter = null;
        }
        return orgFilter;
    }

    private void setSrcFieldValue(List<CtOrgSeprFieldSetValueRequest> requests) {
        for (CtOrgSeprFieldSetValueRequest request : requests) {
            request.setValue();
        }
    }

    private String getUseOrgFieldKey(BasedataProp targetFieldProp) {
        if (StringUtils.isNotBlank((CharSequence)targetFieldProp.getOrgProp())) {
            return targetFieldProp.getOrgProp();
        }
        if (StringUtils.isNotBlank((CharSequence)this.targetMainType.getMainOrg())) {
            return this.targetMainType.getMainOrg();
        }
        return null;
    }

    private String getBDDisplayValue(BasedataProp bdProp, Object id) {
        if (id == null) {
            return null;
        }
        DynamicObjectType bdType = bdProp.getDynamicComplexPropertyType();
        Map objs = BusinessDataReader.loadFromCache((Object[])new Object[]{id}, (DynamicObjectType)bdType);
        if (objs.isEmpty() || !objs.containsKey(id)) {
            return String.valueOf(id);
        }
        return bdProp.getDisplayValue(objs.get(id));
    }

    private void addErrorMessage(CtOrgSeprFieldGroupKey fldGroupKey, String useOrgPropName, Long useOrgId, CtOrgSeprFieldSetValueRequest request) {
        BasedataEntityType srcFldRefType;
        String bdDisplayValue = "";
        OrgProp useOrgProp = (OrgProp)this.targetMainType.findProperty(useOrgPropName);
        String orgDisplayValue = this.getBDDisplayValue((BasedataProp)useOrgProp, useOrgId);
        String failMessage = null;
        failMessage = fldGroupKey.getSourceFieldProp() instanceof MaterielProp && fldGroupKey.getTargetFieldProp() instanceof MaterielProp && fldGroupKey.getTargetFieldRefType().getMasteridType() == 2 ? String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u5728\u76ee\u6807\u7ec4\u7ec7\u201c%2$s\u201d\u4e0b\u4e0d\u53ef\u4f7f\u7528\uff0c\u8bf7\u68c0\u67e5\uff1a1\u3001\u662f\u5426\u5df2\u521b\u5efa\u201c%3$s\u201d\uff1b2\u3001\u201c%4$s\u201d\u5728\u76ee\u6807\u7ec4\u7ec7\u4e0b\u662f\u5426\u5206\u914d\u6216\u5171\u4eab\u3002", (String)"BatchOrgSeprFieldSetValue_3", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), bdDisplayValue, orgDisplayValue, request.getTargetFieldProp().getName(), request.getTargetFieldProp().getName()) : ((srcFldRefType = this.getSrcFldRefType(request.getFieldMapItem(), fldGroupKey.getTargetFieldRefType())) != null && !StringUtils.equals((CharSequence)srcFldRefType.getName(), (CharSequence)fldGroupKey.getTargetFieldRefType().getName()) ? String.format(ResManager.loadKDString((String)"\u8bf7\u4fee\u6539\u201c%1$s\u201d\u5b57\u6bb5\u7684\u53d6\u503c\u6620\u5c04\uff0c%2$s\u201c%3$s\u201d\u4e0d\u80fd\u76f4\u63a5\u8d4b\u503c\u7ed9%4$s", (String)"BatchOrgSeprFieldSetValue_4", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), request.getTargetFieldProp().getName(), srcFldRefType.getDisplayName().toString(), bdDisplayValue, request.getTargetFieldProp().getName()) : String.format(ResManager.loadKDString((String)"%1$s\u201c%2$s\u201d\u672a\u5206\u914d\u7ed9\u76ee\u6807\u7ec4\u7ec7\u201c%3$s\u201d\u4f7f\u7528", (String)"BatchOrgSeprFieldSetValue_5", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), request.getTargetFieldProp().getName(), bdDisplayValue, orgDisplayValue));
        for (DynamicObject sourceRow : request.getSourceRows()) {
            this.buildReporter.addErrorReport(this.reportManager, this.linkEntityMap.getSrcFldPropertys(), sourceRow, failMessage);
            this.fail = true;
        }
    }

    private String qFilterToString(QFilter[] qFilters) {
        if (qFilters == null || qFilters.length == 0) {
            return "";
        }
        StringBuilder filter = new StringBuilder();
        int index = 0;
        for (QFilter qFilter : qFilters) {
            if (qFilter == null) continue;
            if (index > 0) {
                filter.append(" and ").append(qFilter.toString());
            } else {
                filter.append(qFilter.toString());
            }
            ++index;
        }
        return filter.toString();
    }

    static class BotpNullQFilter
    extends QFilter {
        private static final long serialVersionUID = 970425729450374761L;

        public BotpNullQFilter(String property, String cp, Object value) {
            super(property, cp, value);
        }
    }
}

