/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.batchrequest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ctbotp.CtDataEntityFieldValue;
import kd.bos.entity.ctbotp.CtFieldMapItem;
import kd.bos.entity.ctbotp.runtime.CtReportManager;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ctbotp.convert.CtSingleRuleContext;
import kd.bos.service.ctbotp.convert.CtSingleRuleResultManager;
import kd.bos.service.ctbotp.convert.batchrequest.CtBatchOrgSeprFieldSetValue;
import kd.bos.service.ctbotp.convert.batchrequest.CtRefBillFieldGroupKey;
import kd.bos.service.ctbotp.convert.batchrequest.CtRefBillFieldSetValueRequest;
import kd.bos.service.ctbotp.convert.compiler.AbstractCtEntityMap;
import kd.bos.service.ctbotp.convert.compiler.CtLinkEntityMap;
import kd.bos.service.ctbotp.convert.getvaluemode.ICtGetValueMode;

public class CtBatchRefBillFieldSetValue {
    private static final Log log = LogFactory.getLog(CtBatchOrgSeprFieldSetValue.class);
    private static final String BOS_MSERVICE_OPERATION = "bos-mservice-botp";
    private CtSingleRuleContext ruleContext;
    private CtSingleRuleResultManager ruleResultManager;
    private CtReportManager reportManager;
    private boolean fail = false;
    private AbstractCtEntityMap linkEntityMap;
    private BillEntityType sourceMainType;
    private BillEntityType targetMainType;
    private List<CtRefBillFieldSetValueRequest> requests = new ArrayList<CtRefBillFieldSetValueRequest>();

    public CtBatchRefBillFieldSetValue(CtSingleRuleContext ruleContext, CtSingleRuleResultManager ruleResultManager, AbstractCtEntityMap linkEntityMap) {
        this.ruleContext = ruleContext;
        this.ruleResultManager = ruleResultManager;
        this.reportManager = ruleResultManager.getConvertResultManager().getReporter();
        this.linkEntityMap = linkEntityMap;
        this.sourceMainType = ruleContext.getContext().getSourceMainType();
        this.targetMainType = ruleContext.getContext().getTargetMainType();
        BillEntityType linkEntity = this.sourceMainType;
        if (linkEntityMap instanceof CtLinkEntityMap) {
            linkEntity = (EntityType)this.ruleContext.getContext().getSourceMainType().getAllEntities().get(((CtLinkEntityMap)linkEntityMap).getSourceLinkEntityKey());
        } else {
            if (StringUtils.isNotBlank((CharSequence)linkEntityMap.getSourceEntryKey())) {
                linkEntity = (EntityType)this.sourceMainType.getAllEntities().get(linkEntityMap.getSourceEntryKey());
            }
            if (StringUtils.isNotBlank((CharSequence)linkEntityMap.getSourceSubEntryKey())) {
                linkEntity = (EntityType)this.sourceMainType.getAllEntities().get(linkEntityMap.getSourceSubEntryKey());
            }
        }
        this.fail = false;
    }

    public BillEntityType getSourceMainType() {
        return this.sourceMainType;
    }

    public BillEntityType getTargetMainType() {
        return this.targetMainType;
    }

    public List<CtRefBillFieldSetValueRequest> getRequests() {
        return this.requests;
    }

    public boolean isFail() {
        return this.fail;
    }

    public void batchDo() {
    }

    private List<CtRefBillFieldSetValueRequest> findOrgChangedRequests(CtRefBillFieldGroupKey fldGroupKey, List<CtRefBillFieldSetValueRequest> fldRequests, String useOrgFld) {
        ArrayList<CtRefBillFieldSetValueRequest> changeOrgRequests = new ArrayList<CtRefBillFieldSetValueRequest>(fldRequests);
        CtFieldMapItem fieldMapItem = fldRequests.get(0).getFieldMapItem();
        ICtGetValueMode srcOrg_GetHandler = ((CtRefBillFieldSetValueRequest)changeOrgRequests.get(0)).getSrcOrg_GetHandler();
        if (srcOrg_GetHandler == null) {
            return changeOrgRequests;
        }
        BillEntityType refBillType = this.getSrcFldRefType(fieldMapItem, fldGroupKey.getTargetFieldRefType());
        if (!StringUtils.equals((CharSequence)refBillType.getName(), (CharSequence)fldGroupKey.getTargetFieldRefType().getName())) {
            return changeOrgRequests;
        }
        RowDataModel rowDataModel = new RowDataModel(fldGroupKey.getTargetFieldProp().getParent().getName(), (MainEntityType)this.targetMainType);
        String useOrgFld_Id = useOrgFld + "_id";
        for (CtRefBillFieldSetValueRequest fldRequest : fldRequests) {
            Long targetOrgId;
            Long srcOrgId = (Long)srcOrg_GetHandler.getValue(this.linkEntityMap.getBaseDataPropInfoMap(), this.linkEntityMap.getSrcFldPropertys(), fldRequest.getSourceRows().get(0));
            if (srcOrgId == null) {
                srcOrgId = 0L;
            }
            if ((targetOrgId = (Long)rowDataModel.getValue(useOrgFld_Id)) == null) {
                targetOrgId = 0L;
            }
            if (Long.compare(srcOrgId, targetOrgId) != 0) continue;
            fldRequest.setTargetRefId(CtDataEntityFieldValue.CreateSimpleValue((String)String.valueOf(fldRequest.getSourceRefId())));
            fldRequest.setValue();
            changeOrgRequests.remove(fldRequest);
        }
        return changeOrgRequests;
    }

    private BillEntityType getSrcFldRefType(CtFieldMapItem fieldMapItem, BillEntityType targetFldRefType) {
        BillEntityType refBDType = null;
        switch (fieldMapItem.getCtFieldConvertType()) {
            case CONSTANT: 
            case Formula: 
            case ByCondition: {
                refBDType = targetFldRefType;
                break;
            }
            default: {
                BillEntityType srcRefType;
                IDataEntityProperty srcFieldProp = this.sourceMainType.findProperty(fieldMapItem.getSourceFieldKey());
                refBDType = srcRefType = (BillEntityType)((RefBillProp)srcFieldProp).getComplexType();
            }
        }
        return refBDType;
    }

    private Map<Long, List<CtRefBillFieldSetValueRequest>> groupByOrg(RefBillProp targetFieldProp, String useOrgPropName, List<CtRefBillFieldSetValueRequest> requests) {
        HashMap<Long, List<CtRefBillFieldSetValueRequest>> dctByUseOrg = new HashMap<Long, List<CtRefBillFieldSetValueRequest>>();
        RowDataModel rowDataModel = new RowDataModel(targetFieldProp.getParent().getName(), (MainEntityType)this.targetMainType);
        for (CtRefBillFieldSetValueRequest request : requests) {
            DynamicObject useOrg = (DynamicObject)rowDataModel.getValue(useOrgPropName);
            Long useOrgId = 0L;
            if (useOrg != null) {
                useOrgId = (Long)useOrg.getPkValue();
            }
            if (!dctByUseOrg.containsKey(useOrgId)) {
                dctByUseOrg.put(useOrgId, new ArrayList());
            }
            ((List)dctByUseOrg.get(useOrgId)).add(request);
        }
        return dctByUseOrg;
    }

    private void setSrcFieldValue(List<CtRefBillFieldSetValueRequest> requests) {
        for (CtRefBillFieldSetValueRequest request : requests) {
            request.setTargetRefId(CtDataEntityFieldValue.CreateSimpleValue((String)String.valueOf(request.getSourceRefId())));
            request.setValue();
        }
    }

    private String getUseOrgFieldKey(RefBillProp targetFieldProp) {
        if (StringUtils.isNotBlank((CharSequence)targetFieldProp.getOrgProp())) {
            return targetFieldProp.getOrgProp();
        }
        if (StringUtils.isNotBlank((CharSequence)this.targetMainType.getMainOrg())) {
            return this.targetMainType.getMainOrg();
        }
        return null;
    }

    private String getBDDisplayValue(BasedataProp bdProp, Object id) {
        if (id == null) {
            return null;
        }
        DynamicObjectType bdType = bdProp.getDynamicComplexPropertyType();
        Map objs = BusinessDataReader.loadFromCache((Object[])new Object[]{id}, (DynamicObjectType)bdType);
        if (objs.isEmpty() || !objs.containsKey(id)) {
            return String.valueOf(id);
        }
        return bdProp.getDisplayValue(objs.get(id));
    }

    private String getBillDisplayValue(RefBillProp refBillProp, Object id) {
        if (id == null) {
            return null;
        }
        DynamicObjectType bdType = refBillProp.getDynamicComplexPropertyType();
        Map objs = BusinessDataReader.loadFromCache((Object[])new Object[]{id}, (DynamicObjectType)bdType);
        if (objs.isEmpty() || !objs.containsKey(id)) {
            return String.valueOf(id);
        }
        return refBillProp.getDisplayValue(objs.get(id));
    }
}

