/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.ctbotp.BaseDataPropInfo;
import kd.bos.entity.ctbotp.CtCRCondition;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.LogicOperate;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.TimeService;
import kd.bos.service.ctbotp.convert.CtSingleRuleContext;
import kd.bos.service.ctbotp.convert.getvaluemode.CtGetConstValue;
import kd.bos.service.ctbotp.convert.getvaluemode.ICtGetValueMode;
import kd.bos.service.ctbotp.convert.getvaluemode.basedataver.CtGetConditionValueBasedataVer;
import kd.bos.service.ctbotp.convert.var.CtSourceFieldVariable;
import kd.bos.service.ctbotp.convert.var.ICtVariableMode;
import kd.bos.servicehelper.user.UserService;

public class CtCRConditionCompiler {
    private CtCRCondition crCondition;
    private List<QFilter> gridQFilters = new ArrayList<QFilter>();
    private ICtGetValueMode gridFilterExecuter;
    private ICtGetValueMode expressionExecuter;
    private List<QFilter> custQFilters = new ArrayList<QFilter>();
    private String custFilterExpression;
    private ICtGetValueMode custExpressionExecuter;
    private String custFilterDesc;
    private List<CtCRConditionCompiler> subCondCompilers = new ArrayList<CtCRConditionCompiler>();
    private String description;
    private String fullExpression;
    private List<ICtVariableMode> vars = new ArrayList<ICtVariableMode>();

    public CtCRConditionCompiler(CtCRCondition crCondition) {
        this.crCondition = crCondition;
    }

    public CtCRConditionCompiler(List<QFilter> custQFilters, String custFilterExpression, String custFilterDesc) {
        if (custQFilters != null) {
            this.custQFilters.addAll(custQFilters);
        }
        this.custFilterExpression = custFilterExpression;
        this.custFilterDesc = custFilterDesc;
    }

    public CtCRConditionCompiler(CtCRCondition crCondition, List<QFilter> custQFilters, String custFilterExpression, String custFilterDesc) {
        this.crCondition = crCondition;
        if (custQFilters != null) {
            this.custQFilters.addAll(custQFilters);
        }
        this.custFilterExpression = custFilterExpression;
        this.custFilterDesc = custFilterDesc;
    }

    public CtCRCondition getCRCondition() {
        return this.crCondition;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFullExpression() {
        return this.fullExpression;
    }

    public List<QFilter> getGridQFilters() {
        return this.gridQFilters;
    }

    public ICtGetValueMode getGridFilterExecuter() {
        return this.gridFilterExecuter;
    }

    public ICtGetValueMode getExpressionExecuter() {
        return this.expressionExecuter;
    }

    public List<QFilter> getCustQFilters() {
        return this.custQFilters;
    }

    public String getCustFilterDesc() {
        return this.custFilterDesc;
    }

    public void setCustFilterDesc(String custFilterDesc) {
        this.custFilterDesc = custFilterDesc;
    }

    public String getCustFilterExpression() {
        return this.custFilterExpression;
    }

    public ICtGetValueMode getCustExpressionExecuter() {
        return this.custExpressionExecuter;
    }

    public List<CtCRConditionCompiler> getSubCondCompilers() {
        return this.subCondCompilers;
    }

    public List<ICtVariableMode> getVars() {
        return this.vars;
    }

    public EntityType getDependEntityType(CtSingleRuleContext ruleContext) {
        BillEntityType entityType = ruleContext.getContext().getSourceMainType();
        for (ICtVariableMode var : this.vars) {
            if (!(var instanceof CtSourceFieldVariable)) continue;
            IDataEntityType fldParentType = ((CtSourceFieldVariable)var).getSourceField().getParent();
            if (fldParentType instanceof SubEntryType) {
                entityType = (SubEntryType)fldParentType;
                continue;
            }
            if (!(fldParentType instanceof EntryType) || !(entityType instanceof BillEntityType)) continue;
            entityType = (EntryType)fldParentType;
        }
        return entityType;
    }

    public void compile(CtSingleRuleContext ruleContext) {
        String gridFilterDesc = null;
        ArrayList<String> exps = new ArrayList<String>();
        if (this.crCondition == null) {
            this.gridFilterExecuter = new CtGetConstValue(Boolean.TRUE);
            this.expressionExecuter = new CtGetConstValue(Boolean.TRUE);
        } else {
            FilterCondition filterCondition = this.crCondition.getFilterCondition();
            if (filterCondition == null || CollectionUtils.isEmpty((Collection)filterCondition.getFilterRow())) {
                this.gridFilterExecuter = new CtGetConstValue(Boolean.TRUE);
            } else {
                FilterBuilder filterBuilder = new FilterBuilder((MainEntityType)ruleContext.getContext().getSourceMainType(), filterCondition);
                TimeService timeService = new TimeService();
                filterBuilder.setTimeService((ITimeService)timeService);
                UserService userService = new UserService();
                filterBuilder.setUserService((IUserService)userService);
                filterBuilder.buildFilter(false);
                this.gridQFilters.clear();
                this.gridQFilters.add(filterBuilder.getQFilter());
                String[] filterScripts = filterBuilder.buildFilterScript();
                String gridFilterString = filterScripts[0];
                if (StringUtils.isNotBlank((CharSequence)gridFilterString)) {
                    this.gridFilterExecuter = new CtGetConditionValueBasedataVer(ruleContext, gridFilterString);
                    exps.add(gridFilterString);
                } else {
                    this.gridFilterExecuter = new CtGetConstValue(Boolean.TRUE);
                }
                gridFilterDesc = filterScripts[1];
            }
            if (StringUtils.isBlank((CharSequence)this.crCondition.getExpression())) {
                this.expressionExecuter = new CtGetConstValue(Boolean.TRUE);
            } else {
                this.expressionExecuter = new CtGetConditionValueBasedataVer(ruleContext, this.crCondition.getExpression());
                exps.add(this.crCondition.getExpression());
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.custFilterExpression)) {
            this.custExpressionExecuter = new CtGetConditionValueBasedataVer(ruleContext, this.custFilterExpression);
            exps.add(this.custFilterExpression);
        } else {
            this.custExpressionExecuter = new CtGetConstValue(Boolean.TRUE);
        }
        this.description = this.crCondition != null && StringUtils.isNotBlank((CharSequence)this.crCondition.getDescription().toString()) ? this.crCondition.getDescription().toString() : gridFilterDesc;
        this.fullExpression = StringUtils.join((Object[])exps.toArray(), (String)" and ");
        this.vars.addAll(this.gridFilterExecuter.getVars());
        this.vars.addAll(this.expressionExecuter.getVars());
        this.vars.addAll(this.custExpressionExecuter.getVars());
    }

    public void compileSubCondition(CtSingleRuleContext ruleContext) {
        if (this.crCondition == null) {
            return;
        }
        if (this.crCondition.getFilterCondition() != null && !this.crCondition.getFilterCondition().getFilterRow().isEmpty()) {
            String str = SerializationUtils.toJsonString((Object)this.crCondition.getFilterCondition());
            FilterCondition copyFilter = (FilterCondition)SerializationUtils.fromJsonString((String)str, FilterCondition.class);
            List<List<SimpleFilterRow>> rowGroups = this.splitFilterRows(copyFilter.getFilterRow());
            for (List<SimpleFilterRow> rows : rowGroups) {
                FilterCondition filterCondition = new FilterCondition();
                filterCondition.setFilterRow(rows);
                CtCRCondition subCondition = new CtCRCondition();
                subCondition.setFilterCondition(filterCondition);
                CtCRConditionCompiler subCondCompiler = new CtCRConditionCompiler(subCondition);
                subCondCompiler.compile(ruleContext);
                this.subCondCompilers.add(subCondCompiler);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.crCondition.getExpression())) {
            CtCRCondition subCondition = new CtCRCondition();
            subCondition.setExpression(this.crCondition.getExpression());
            subCondition.setDescription(this.crCondition.getDescription());
            CtCRConditionCompiler subCondCompiler = new CtCRConditionCompiler(subCondition);
            subCondCompiler.compile(ruleContext);
            this.subCondCompilers.add(subCondCompiler);
        }
        if (!this.custQFilters.isEmpty() || StringUtils.isNotBlank((CharSequence)this.custFilterExpression)) {
            CtCRConditionCompiler subCondCompiler = new CtCRConditionCompiler(this.custQFilters, this.custFilterExpression, this.custFilterDesc);
            subCondCompiler.compile(ruleContext);
            this.subCondCompilers.add(subCondCompiler);
        }
    }

    public boolean executeCondition(Map<String, BaseDataPropInfo> baseDataPropInfoMap, Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow) {
        return (Boolean)this.gridFilterExecuter.getValue(baseDataPropInfoMap, fldProperties, sourceRow) != false && (Boolean)this.expressionExecuter.getValue(baseDataPropInfoMap, fldProperties, sourceRow) != false && (Boolean)this.custExpressionExecuter.getValue(baseDataPropInfoMap, fldProperties, sourceRow) != false;
    }

    public boolean executeCondition(Map<String, String> fldAlias, Row row) {
        return (Boolean)this.gridFilterExecuter.getValue(fldAlias, row) != false && (Boolean)this.expressionExecuter.getValue(fldAlias, row) != false && (Boolean)this.custExpressionExecuter.getValue(fldAlias, row) != false;
    }

    public String buildFailMessage(Map<String, BaseDataPropInfo> baseDataPropInfoMap, Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow, boolean outFormula) {
        String failMessage = null;
        CtCRConditionCompiler subCondition = null;
        for (CtCRConditionCompiler condition : this.getSubCondCompilers()) {
            if (condition.executeCondition(baseDataPropInfoMap, fldProperties, sourceRow)) continue;
            subCondition = condition;
            break;
        }
        if (subCondition != null) {
            if (!outFormula) {
                failMessage = StringUtils.isNotBlank((CharSequence)subCondition.getCustFilterDesc()) ? String.format(this.getMultiLMismatchCondition(), subCondition.getCustFilterDesc()) : (this.crCondition != null && this.crCondition.getDescription() != null && StringUtils.isNotBlank((CharSequence)this.crCondition.getDescription().toString()) ? String.format(this.getMultiLMismatchCondition(), this.getDescription()) : String.format(this.getMultiLMismatchCondition(), subCondition.getDescription()));
            }
            if (StringUtils.isBlank(failMessage)) {
                failMessage = String.format(this.getMultiLMismatchCondition(), subCondition.getFullExpression());
            }
        }
        if (failMessage == null && this.executeCondition(baseDataPropInfoMap, fldProperties, sourceRow)) {
            failMessage = String.format(this.getMultiLMismatchCondition(), this.getFullExpression());
        }
        return failMessage;
    }

    public String buildFailMessage(Map<String, String> fldAlias, Row row, boolean outFormula) {
        String failMessage = null;
        CtCRConditionCompiler subCondition = null;
        for (CtCRConditionCompiler condition : this.getSubCondCompilers()) {
            if (condition.executeCondition(fldAlias, row)) continue;
            subCondition = condition;
            break;
        }
        if (subCondition != null) {
            if (!outFormula) {
                failMessage = StringUtils.isNotBlank((CharSequence)subCondition.getCustFilterDesc()) ? String.format(this.getMultiLMismatchCondition(), subCondition.getCustFilterDesc()) : (this.crCondition != null && this.crCondition.getDescription() != null && StringUtils.isNotBlank((CharSequence)this.crCondition.getDescription().toString()) ? String.format(this.getMultiLMismatchCondition(), this.getDescription()) : String.format(this.getMultiLMismatchCondition(), subCondition.getDescription()));
            }
            if (StringUtils.isBlank(failMessage)) {
                failMessage = String.format(this.getMultiLMismatchCondition(), subCondition.getFullExpression());
            }
        }
        if (failMessage == null && this.executeCondition(fldAlias, row)) {
            failMessage = String.format(this.getMultiLMismatchCondition(), this.getFullExpression());
        }
        return failMessage;
    }

    private List<List<SimpleFilterRow>> splitFilterRows(List<SimpleFilterRow> rows) {
        List<List<SimpleFilterRow>> lstGroup = new ArrayList<List<SimpleFilterRow>>();
        if (rows == null || rows.isEmpty()) {
            return lstGroup;
        }
        if (rows.size() == 1) {
            lstGroup.add(rows);
            return lstGroup;
        }
        lstGroup = this.splitByBracket(rows);
        if (lstGroup.isEmpty()) {
            return lstGroup;
        }
        if (lstGroup.size() == 1) {
            String leftBracket = rows.get(0).getLeftBracket().replace(" ", "");
            String rightBracket = rows.get(rows.size() - 1).getRightBracket().replace(" ", "");
            rows.get(0).setLeftBracket(leftBracket.substring(1));
            rows.get(rows.size() - 1).setRightBracket(rightBracket.substring(1));
            lstGroup = this.splitFilterRows(rows);
        }
        if (lstGroup.size() > 1) {
            boolean hadOr = this.isJoinByOr(lstGroup);
            if (hadOr) {
                lstGroup = new ArrayList();
                lstGroup.add(rows);
            } else {
                ArrayList<List<SimpleFilterRow>> tmpGroup = new ArrayList<List<SimpleFilterRow>>();
                tmpGroup.addAll(lstGroup);
                lstGroup.clear();
                for (List list : tmpGroup) {
                    List<List<SimpleFilterRow>> subListGroup = this.splitFilterRows(list);
                    lstGroup.addAll(subListGroup);
                }
            }
        }
        return lstGroup;
    }

    private List<List<SimpleFilterRow>> splitByBracket(List<SimpleFilterRow> rows) {
        ArrayList<List<SimpleFilterRow>> lstGroup = new ArrayList<List<SimpleFilterRow>>();
        int totalLeftBracket = 0;
        ArrayList<SimpleFilterRow> groupDetail = new ArrayList<SimpleFilterRow>();
        for (SimpleFilterRow row : rows) {
            int currRightBracket;
            int currLeftBracket = row.getLeftBracket().replace(" ", "").length();
            if ((totalLeftBracket = totalLeftBracket + currLeftBracket - (currRightBracket = row.getRightBracket().replace(" ", "").length())) > 0) {
                groupDetail.add(row);
                continue;
            }
            groupDetail.add(row);
            lstGroup.add(groupDetail);
            groupDetail = new ArrayList();
        }
        if (!groupDetail.isEmpty()) {
            lstGroup.add(groupDetail);
        }
        return lstGroup;
    }

    private boolean isJoinByOr(List<List<SimpleFilterRow>> lstGroup) {
        boolean hadOr = false;
        for (int i = 0; i < lstGroup.size() - 1; ++i) {
            List<SimpleFilterRow> group = lstGroup.get(i);
            String logic = group.get(group.size() - 1).getLogic();
            if (!StringUtils.equals((CharSequence)logic, (CharSequence)String.valueOf(LogicOperate.OR.getValue())) && !StringUtils.equalsIgnoreCase((CharSequence)logic, (CharSequence)LogicOperate.OR.toString())) continue;
            hadOr = true;
            break;
        }
        return hadOr;
    }

    private String getMultiLMismatchCondition() {
        return ResManager.loadKDString((String)"\u4e0d\u7b26\u5408\u6761\u4ef6\uff1a %s", (String)"CRConditionCompiler_0", (String)"bos-mservice-botp", (Object[])new Object[0]);
    }
}

