/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.compiler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.ctbotp.CtAttachmentPanelMapItem;
import kd.bos.entity.ctbotp.CtCRCondition;
import kd.bos.entity.ctbotp.CtConvertRuleElement;
import kd.bos.entity.ctbotp.CtDataEntityField;
import kd.bos.entity.ctbotp.CtFieldMapItem;
import kd.bos.entity.ctbotp.CtGroupByMode;
import kd.bos.entity.ctbotp.CtGroupByPolicy;
import kd.bos.entity.ctbotp.plugin.tracker.args.CtBeforeBuildRowConditionEventArgs;
import kd.bos.entity.ctbotp.runtime.CtAttachmentPanelMap;
import kd.bos.entity.property.BillTypeProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.exception.KDBizException;
import kd.bos.service.ctbotp.convert.CtSingleRuleContext;
import kd.bos.service.ctbotp.convert.compiler.CtCRConditionCompiler;
import kd.bos.service.ctbotp.convert.compiler.CtDependEntityMap;
import kd.bos.service.ctbotp.convert.compiler.CtLinkEntityMap;
import kd.bos.service.ctbotp.convert.getvaluemode.CtGetConstValue;
import kd.bos.service.ctbotp.convert.getvaluemode.CtGetSourceFieldValue;
import kd.bos.service.ctbotp.convert.group.CtSourceRowsGroupKeyBuilder;
import kd.bos.service.ctbotp.convert.mapping.CtMappingSAccountId;
import kd.bos.service.ctbotp.convert.mapping.CtMappingSBillId;
import kd.bos.service.ctbotp.convert.mapping.CtMappingSEntityKey;
import kd.bos.service.ctbotp.convert.mapping.CtMappingSId;
import kd.bos.service.ctbotp.convert.mapping.CtMappingSLinkEntityKey;
import kd.bos.service.ctbotp.convert.mapping.CtMappingSLinkTableId;
import kd.bos.service.ctbotp.convert.mapping.CtMappingSTableId;
import kd.bos.service.ctbotp.convert.mapping.CtMappingSTenantCode;
import kd.bos.service.ctbotp.convert.mapping.CtMappingTAccountId;
import kd.bos.service.ctbotp.convert.mapping.CtMappingTEntityKey;
import kd.bos.service.ctbotp.convert.mapping.CtMappingTLinkEntityKey;
import kd.bos.service.ctbotp.convert.mapping.CtMappingTTenantCode;
import kd.bos.service.ctbotp.convert.mapping.ICtMappingField;
import kd.bos.service.ctbotp.convert.var.CtSourceFieldVariable;
import kd.bos.service.ctbotp.convert.var.ICtVariableMode;
import kd.bos.servicehelper.CtConvertMetaServiceHelper;

public class CtConvertRuleCompiler {
    private static final String BOS_MSERVICE_BOTP = "bos-mservice-botp";
    private CtSingleRuleContext ruleContext;
    private CtConvertRuleElement rule;
    private CtCRConditionCompiler ruleCondCompiler;
    private CtCRConditionCompiler dataFilterCompiler;
    private List<CtCRConditionCompiler> dataFilterCompilers;
    private ICtMappingField mappingMainOrg;
    private ICtMappingField mappingBillType;
    private CtLinkEntityMap linkEntityMap;
    private List<CtLinkEntityMap> muliLinkEntityMaps;
    private Map<String, CtDependEntityMap> dependEntityMaps = new HashMap<String, CtDependEntityMap>();
    private Map<String, CtAttachmentPanelMap> attachmentPanelMaps = new HashMap<String, CtAttachmentPanelMap>();

    public CtConvertRuleCompiler(CtSingleRuleContext ruleContext) {
        this.ruleContext = ruleContext;
        this.rule = ruleContext.getRule();
    }

    public CtCRConditionCompiler getRuleCondCompiler() {
        return this.ruleCondCompiler;
    }

    public List<CtCRConditionCompiler> getDataFilterCompilers() {
        return this.dataFilterCompilers;
    }

    public void setDataFilterCompilers(List<CtCRConditionCompiler> dataFilterCompilers) {
        this.dataFilterCompilers = dataFilterCompilers;
    }

    public ICtMappingField getMappingMainOrg() {
        return this.mappingMainOrg;
    }

    public ICtMappingField getMappingBillType() {
        return this.mappingBillType;
    }

    public CtLinkEntityMap getLinkEntityMap() {
        return this.linkEntityMap;
    }

    public Map<String, CtDependEntityMap> getDependEntityMaps() {
        return this.dependEntityMaps;
    }

    public Map<String, CtAttachmentPanelMap> getAttachmentPanelMaps() {
        return this.attachmentPanelMaps;
    }

    public List<CtLinkEntityMap> getMuliLinkEntityMaps() {
        return this.muliLinkEntityMaps;
    }

    public void setMuliLinkEntityMaps(List<CtLinkEntityMap> muliLinkEntityMaps) {
        this.muliLinkEntityMaps = muliLinkEntityMaps;
    }

    public CtCRConditionCompiler compileRunCondition() {
        CtCRCondition condition = this.rule.getCtCRCondition();
        this.ruleCondCompiler = new CtCRConditionCompiler(condition);
        this.ruleCondCompiler.compile(this.ruleContext);
        return this.ruleCondCompiler;
    }

    public CtCRConditionCompiler compileRowCondition(CtCRCondition crCondition) {
        CtCRCondition condition = crCondition;
        CtBeforeBuildRowConditionEventArgs eventArgs = new CtBeforeBuildRowConditionEventArgs();
        eventArgs.setSelectedRows(this.ruleContext.getSelectedRows());
        this.dataFilterCompiler = null;
        this.dataFilterCompiler = eventArgs.isIgnoreRuleFilterPolicy() ? new CtCRConditionCompiler(eventArgs.getCustQFilters(), eventArgs.getCustFilterExpression(), eventArgs.getCustFilterDesc()) : new CtCRConditionCompiler(condition, eventArgs.getCustQFilters(), eventArgs.getCustFilterExpression(), eventArgs.getCustFilterDesc());
        this.dataFilterCompiler.compile(this.ruleContext);
        return this.dataFilterCompiler;
    }

    public void compilePolicys() {
        this.compileLinkEntryPolicy();
        this.compileBillTypeMapPolicy();
        this.compileAttachmentPanelMapPolicy();
        this.compileFieldMapPolicy();
        this.compileFilterPolicy();
        this.compileGroupPolicy();
    }

    private void compileLinkEntryPolicy() {
        this.linkEntityMap = new CtLinkEntityMap();
        this.compileMainLinkEntity();
        this.compileLinkSet();
    }

    private void compileMuliLinkEntryPolicy() {
        this.muliLinkEntityMaps = new ArrayList<CtLinkEntityMap>();
        this.compileMainLinkEntity();
        this.compileLinkSet();
    }

    private void compileMainOrgMapPolicy() {
        IDataEntityProperty mainOrgProp;
        String mainOrgKey = this.ruleContext.getContext().getSourceMainType().getMainOrg();
        IDataEntityProperty iDataEntityProperty = mainOrgProp = StringUtils.isBlank((CharSequence)mainOrgKey) ? null : this.ruleContext.getContext().getSourceMainType().findProperty(mainOrgKey);
        if (mainOrgProp == null) {
            CtGetConstValue reader = new CtGetConstValue(0L);
            this.linkEntityMap.setSrcMainOrgReader(reader);
        } else {
            CtGetSourceFieldValue reader = new CtGetSourceFieldValue(this.ruleContext, mainOrgProp.getName());
            this.linkEntityMap.setSrcMainOrgReader(reader);
            for (ICtVariableMode var : reader.getVars()) {
                if (!(var instanceof CtSourceFieldVariable)) continue;
                this.linkEntityMap.addSourceField((CtSourceFieldVariable)var);
            }
        }
    }

    private void compileBillTypeMapPolicy() {
        IDataEntityProperty billTypeProp;
        String billTypeKey = this.ruleContext.getContext().getSourceMainType().getBillType();
        IDataEntityProperty iDataEntityProperty = billTypeProp = StringUtils.isBlank((CharSequence)billTypeKey) ? null : this.ruleContext.getContext().getSourceMainType().findProperty(billTypeKey);
        if (billTypeProp == null) {
            CtGetConstValue reader = new CtGetConstValue(0L);
            this.linkEntityMap.setSrcBillTypeReader(reader);
        } else {
            CtGetSourceFieldValue reader = new CtGetSourceFieldValue(this.ruleContext, billTypeProp.getName());
            this.linkEntityMap.setSrcBillTypeReader(reader);
            for (ICtVariableMode var : reader.getVars()) {
                if (!(var instanceof CtSourceFieldVariable)) continue;
                this.linkEntityMap.addSourceField((CtSourceFieldVariable)var);
            }
        }
    }

    private void compileAttachmentPanelMapPolicy() {
        List mapItems = this.rule.getCtAttachmentPanelMapPolicy().getItems();
        if (mapItems.isEmpty()) {
            return;
        }
        this.attachmentPanelMaps = new HashMap<String, CtAttachmentPanelMap>();
        for (CtAttachmentPanelMapItem attachmentMapItem : mapItems) {
            this.compileAttachmentPanelMapItem(attachmentMapItem);
        }
    }

    private void compileAttachmentPanelMapItem(CtAttachmentPanelMapItem attachmentMapItem) {
        String sourceEntityNumber = this.ruleContext.getContext().getSourceEntityNumber();
        String targetEntityNumber = this.ruleContext.getContext().getTargetEntityNumber();
        CtAttachmentPanelMap attachMap = new CtAttachmentPanelMap(sourceEntityNumber, targetEntityNumber);
        attachMap.setSourceAttachmentPanelKey(attachmentMapItem.getSourceAttachmentPanel());
        attachMap.setTargetAttachmentPanelKey(attachmentMapItem.getTargetAttachmentPanel());
        attachMap.setAttachmentPanelMergeType(attachmentMapItem.getAttachmentPanelMergeType());
        this.attachmentPanelMaps.put(attachmentMapItem.getTargetAttachmentPanel(), attachMap);
    }

    private void compileFieldMapPolicy() {
        for (CtFieldMapItem fieldMapItem : this.rule.getCtFieldMapPolicy().getCtFieldMapItems()) {
            this.compileFieldMapItem(fieldMapItem);
        }
        this.compileDependEntityMaps();
    }

    private void compileFieldMapItem(CtFieldMapItem fieldMapItem) {
        ICtMappingField mappingField = ICtMappingField.create(this.ruleContext, fieldMapItem);
        if (mappingField == null) {
            return;
        }
        Object fieldClassType = TypesContainer.createInstance((String)fieldMapItem.getTargetFieldType());
        if (fieldClassType instanceof MainOrgProp) {
            this.mappingMainOrg = mappingField;
        } else if (fieldClassType instanceof BillTypeProp) {
            this.mappingBillType = mappingField;
        }
        String joinTargetEntityKeys = mappingField.getJoinTargetEntityKeys();
        String joinSourceEntityKeys = mappingField.getJoinSourceEntityKeys();
        if (this.linkEntityMap.getJoinTargetEntityKeys().startsWith(joinTargetEntityKeys) && this.linkEntityMap.getJoinSourceEntityKeys().startsWith(joinSourceEntityKeys)) {
            this.linkEntityMap.addMappingField(mappingField);
        } else {
            CtDependEntityMap dependEntityMap = this.dependEntityMaps.get(joinTargetEntityKeys);
            if (dependEntityMap == null) {
                dependEntityMap = this.createDependEntityMap(mappingField);
                this.dependEntityMaps.put(joinTargetEntityKeys, dependEntityMap);
            } else {
                dependEntityMap.addMappingField(mappingField);
            }
        }
    }

    private void compileFilterPolicy() {
        List conditionList = this.rule.getCtFilterPolicy().getConditionList();
        this.dataFilterCompilers = new ArrayList<CtCRConditionCompiler>(conditionList.size());
        for (CtCRCondition condition : conditionList) {
            if (!condition.isEnabled()) continue;
            this.compileRowCondition(condition);
            this.dataFilterCompiler.compileSubCondition(this.ruleContext);
            for (ICtVariableMode var : this.dataFilterCompiler.getVars()) {
                this.linkEntityMap.addSourceField((CtSourceFieldVariable)var);
            }
            this.dataFilterCompilers.add(this.dataFilterCompiler);
        }
        if (this.dataFilterCompilers.size() == 0) {
            CtCRCondition crcondition = new CtCRCondition();
            this.compileRowCondition(crcondition);
            this.dataFilterCompiler.compileSubCondition(this.ruleContext);
            for (ICtVariableMode var : this.dataFilterCompiler.getVars()) {
                this.linkEntityMap.addSourceField((CtSourceFieldVariable)var);
            }
            this.dataFilterCompilers.add(this.dataFilterCompiler);
        }
    }

    private void compileGroupPolicy() {
        block4: {
            CtGroupByPolicy policy = this.rule.getCtGroupByPolicy();
            String groupKey1 = this.compileGroupHead(policy);
            String groupKey2 = this.compileGroupEntry(policy);
            String groupKey3 = this.compileGroupSubEntry(policy);
            try {
                CtSourceRowsGroupKeyBuilder headGroupBuilder = new CtSourceRowsGroupKeyBuilder(this.ruleContext, groupKey1);
                this.linkEntityMap.addSourceRowsGroupKeyBuilders(headGroupBuilder);
                if (StringUtils.isNotBlank((CharSequence)groupKey2)) {
                    CtSourceRowsGroupKeyBuilder entryGroupBuilder = new CtSourceRowsGroupKeyBuilder(this.ruleContext, groupKey2);
                    this.linkEntityMap.addSourceRowsGroupKeyBuilders(entryGroupBuilder);
                }
                if (StringUtils.isNotBlank((CharSequence)groupKey3)) {
                    CtSourceRowsGroupKeyBuilder subEntryGroupBuilder = new CtSourceRowsGroupKeyBuilder(this.ruleContext, groupKey3);
                    this.linkEntityMap.addSourceRowsGroupKeyBuilders(subEntryGroupBuilder);
                }
            }
            catch (KDBizException exp) {
                if (!exp.getErrorCode().getCode().equals("bos.fieldNotExist")) break block4;
                String errMessage = String.format(ResManager.loadKDString((String)"\u8f6c\u6362\u89c4\u5219[%1$s]\u914d\u7f6e\u6709\u8bef\uff1a\u5206\u5355\u7b56\u7565/\u5355\u636e\u4f53\u884c\u5408\u5e76\u7b56\u7565\u7684\u5206\u5355\u4f9d\u636e\u5b57\u6bb5/\u5408\u5e76\u4f9d\u636e\u5b57\u6bb5[%2$s]\uff0c\u5728\u6e90\u5355\u4e0a\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u8f6c\u6362\u89c4\u5219", (String)"ConvertRuleCompiler_6", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), this.ruleContext.getRule().getName(), exp.getArgs()[1]);
                throw new KDBizException(errMessage);
            }
        }
    }

    private String compileGroupHead(CtGroupByPolicy policy) {
        String groupKey1 = "id";
        if (policy.getGroupByMode() == CtGroupByMode.GroupByField) {
            if (StringUtils.isNotBlank((CharSequence)policy.getGroupByField())) {
                groupKey1 = policy.getGroupByField();
            }
        } else if (policy.getGroupByMode() == CtGroupByMode.AllInOne) {
            groupKey1 = "@all";
        }
        return groupKey1;
    }

    private String compileGroupEntry(CtGroupByPolicy policy) {
        String groupKey2 = "";
        if (StringUtils.isNotBlank((CharSequence)this.linkEntityMap.targetEntryKey)) {
            groupKey2 = "@all";
            boolean isLinkEntity = StringUtils.equalsIgnoreCase((CharSequence)this.linkEntityMap.getTargetEntryKey(), (CharSequence)this.linkEntityMap.getTargetLinkEntityKey());
            String sourceEntryPKField = "id";
            if (isLinkEntity) {
                if (StringUtils.equals((CharSequence)this.linkEntityMap.getSourceLinkEntityKey(), (CharSequence)this.linkEntityMap.getSourceEntryKey())) {
                    sourceEntryPKField = this.linkEntityMap.getSourceEntryPKFullName();
                } else if (StringUtils.equals((CharSequence)this.linkEntityMap.getSourceLinkEntityKey(), (CharSequence)this.linkEntityMap.getSourceSubEntryKey())) {
                    sourceEntryPKField = this.linkEntityMap.getSourceSubEntryPKFullName();
                }
            } else if (StringUtils.isNotBlank((CharSequence)this.linkEntityMap.sourceEntryKey)) {
                sourceEntryPKField = this.linkEntityMap.getSourceEntryPKFullName();
            }
            if (policy.getCtGroupByMode2() == CtGroupByMode.OneToOne) {
                groupKey2 = sourceEntryPKField;
            } else if (policy.getCtGroupByMode2() == CtGroupByMode.GroupByField && StringUtils.isBlank((CharSequence)(groupKey2 = policy.getGroupByField2()))) {
                groupKey2 = sourceEntryPKField;
            }
        }
        return groupKey2;
    }

    private String compileGroupSubEntry(CtGroupByPolicy policy) {
        String groupKey3 = "";
        if (StringUtils.isNotBlank((CharSequence)this.linkEntityMap.targetSubEntryKey)) {
            groupKey3 = "@all";
            String sourceSubEntryPKField = "id";
            if (StringUtils.isNotBlank((CharSequence)this.linkEntityMap.sourceSubEntryKey)) {
                sourceSubEntryPKField = this.linkEntityMap.getSourceSubEntryPKFullName();
            } else if (StringUtils.isNotBlank((CharSequence)this.linkEntityMap.sourceEntryKey)) {
                sourceSubEntryPKField = this.linkEntityMap.getSourceEntryPKFullName();
            }
            if (policy.getCtGroupByMode3() == CtGroupByMode.OneToOne) {
                groupKey3 = sourceSubEntryPKField;
            } else if (policy.getCtGroupByMode3() == CtGroupByMode.GroupByField && StringUtils.isBlank((CharSequence)(groupKey3 = policy.getGroupByField3()))) {
                groupKey3 = sourceSubEntryPKField;
            }
        }
        return groupKey3;
    }

    private void compileDependEntityMaps() {
        CtDependEntityMap entityMap;
        CtDependEntityMap headMap = null;
        HashMap<String, CtDependEntityMap> entryMaps = new HashMap<String, CtDependEntityMap>();
        HashMap<String, CtDependEntityMap> subEntryMaps = new HashMap<String, CtDependEntityMap>();
        for (Map.Entry<String, CtDependEntityMap> entry : this.dependEntityMaps.entrySet()) {
            entityMap = entry.getValue();
            String entityType = entityMap.getTargetEntity();
            String[] targetEntityArr = entityType.split("\\|");
            if (targetEntityArr.length == 3) {
                subEntryMaps.put(entityType, entityMap);
                continue;
            }
            if (targetEntityArr.length == 2) {
                entryMaps.put(entityType, entityMap);
                continue;
            }
            if (targetEntityArr.length != 1) continue;
            headMap = entityMap;
        }
        for (Map.Entry<String, CtDependEntityMap> entry : subEntryMaps.entrySet()) {
            CtDependEntityMap subEntryMap = entry.getValue();
            this.mergeEntryDependEntityMap(subEntryMap, entryMaps);
        }
        this.dependEntityMaps.clear();
        for (Map.Entry<String, CtDependEntityMap> entry : subEntryMaps.entrySet()) {
            this.dependEntityMaps.put(entry.getValue().getJoinTargetEntityKeys(), entry.getValue());
        }
        for (Map.Entry<String, CtDependEntityMap> entry : entryMaps.entrySet()) {
            entityMap = entry.getValue();
            List<ICtMappingField> targetFields = entityMap.getTargetFields().get(entry.getKey());
            if (targetFields.isEmpty()) continue;
            this.compileDependSourceEntity(entityMap);
            this.dependEntityMaps.put(entityMap.getJoinTargetEntityKeys(), entityMap);
        }
        this.mergeHeadDependEntityMap(headMap);
        for (CtDependEntityMap ctDependEntityMap : this.dependEntityMaps.values()) {
            ctDependEntityMap.compileAnchorEntity(this.ruleContext, this.linkEntityMap, this.dependEntityMaps);
        }
    }

    private void mergeEntryDependEntityMap(CtDependEntityMap subEntryMap, Map<String, CtDependEntityMap> entryMaps) {
        this.compileDependSourceEntity(subEntryMap);
        String joinSourceEntityKey = subEntryMap.getJoinSourceEntityKeys();
        String entryType = subEntryMap.getParentEntity();
        CtDependEntityMap entryMap = entryMaps.get(entryType);
        if (entryMap != null) {
            List<ICtMappingField> targetFields = entryMap.getTargetFields().get(entryType);
            ArrayList<ICtMappingField> list = new ArrayList<ICtMappingField>();
            list.addAll(targetFields);
            for (ICtMappingField mappingField : list) {
                if (!joinSourceEntityKey.equalsIgnoreCase(mappingField.getJoinSourceEntityKeys())) continue;
                subEntryMap.addMappingField(mappingField);
                targetFields.remove(mappingField);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void mergeHeadDependEntityMap(CtDependEntityMap targetHeadEntityMap) {
        if (targetHeadEntityMap == null) {
            return;
        }
        HashMap srcEntityMaps = new HashMap();
        for (CtDependEntityMap entityMap : this.dependEntityMaps.values()) {
            String joinSourceEntityKeys = entityMap.getJoinSourceEntityKeys();
            if (!srcEntityMaps.containsKey(joinSourceEntityKeys)) {
                srcEntityMaps.put(joinSourceEntityKeys, new ArrayList());
            }
            ((List)srcEntityMaps.get(joinSourceEntityKeys)).add(entityMap);
        }
        HashMap fieldGroups = new HashMap();
        List<ICtMappingField> fields = targetHeadEntityMap.getTargetFields().entrySet().iterator().next().getValue();
        for (ICtMappingField iCtMappingField : fields) {
            String string = iCtMappingField.getJoinSourceEntityKeys();
            if (!fieldGroups.containsKey(string)) {
                fieldGroups.put(string, new ArrayList());
            }
            ((List)fieldGroups.get(string)).add(iCtMappingField);
        }
        HashMap<String, CtDependEntityMap> newEntityMaps = new HashMap<String, CtDependEntityMap>();
        for (Map.Entry entry : fieldGroups.entrySet()) {
            String sourceEntityKeys = (String)entry.getKey();
            List mappingFields = (List)entry.getValue();
            List dependEntityMapList = (List)srcEntityMaps.get(sourceEntityKeys);
            CtDependEntityMap dependEntityMap = (CtDependEntityMap)newEntityMaps.get(sourceEntityKeys);
            if (dependEntityMapList != null && !dependEntityMapList.isEmpty()) {
                ((CtDependEntityMap)dependEntityMapList.get(0)).addMappingFields(mappingFields);
                continue;
            }
            if (dependEntityMap != null) {
                dependEntityMap.addMappingFields(mappingFields);
                continue;
            }
            CtDependEntityMap entityMap = new CtDependEntityMap(this.ruleContext.getContext().getCtPushArgs().getTargetEntityNumber());
            entityMap.addMappingFields(mappingFields);
            newEntityMaps.put(sourceEntityKeys, entityMap);
        }
        boolean bl = true;
        for (Map.Entry entry : newEntityMaps.entrySet()) {
            void var6_9;
            CtDependEntityMap entityMap = (CtDependEntityMap)entry.getValue();
            String joinTargetEntityKeys = entityMap.getJoinTargetEntityKeys() + String.valueOf((int)var6_9);
            this.dependEntityMaps.put(joinTargetEntityKeys, entityMap);
            ++var6_9;
        }
    }

    private void compileDependSourceEntity(CtDependEntityMap entityMap) {
        entityMap.compileSourceEntity();
        if (!entityMap.isCompileSuccess()) {
            String errMessage = String.format(ResManager.loadKDString((String)"\u8f6c\u6362\u89c4\u5219-[%1$s]\u914d\u7f6e\u4e0d\u5408\u7406\uff1a%2$s", (String)"ConvertRuleCompiler_3", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), this.rule.getName(), entityMap.getCompileFailMessage());
            throw new KDBizException(errMessage);
        }
    }

    private CtDependEntityMap createDependEntityMap(ICtMappingField mappingField) {
        String targetEntity = mappingField.getJoinTargetEntityKeys();
        CtDependEntityMap entityMap = new CtDependEntityMap(targetEntity);
        entityMap.addMappingField(mappingField);
        return entityMap;
    }

    private void compileMainLinkEntity() {
        BillEntityType srcMainType;
        BillEntityType srcEntity = srcMainType = this.ruleContext.getContext().getSourceMainType();
        if (StringUtils.isNotBlank((CharSequence)this.rule.getCtLinkEntityPolicy().getSourceEntryKey()) && (srcEntity = (EntityType)srcMainType.getAllEntities().get(this.rule.getCtLinkEntityPolicy().getSourceEntryKey())) == null) {
            String errMessage = String.format(ResManager.loadKDString((String)"\u8f6c\u6362\u89c4\u5219-[%1$s]\u914d\u7f6e\u4e0d\u5408\u7406\uff1a\u5728\u6e90\u5355\u4e0a\uff0c\u627e\u4e0d\u5230\u5173\u8054\u4e3b\u5b9e\u4f53%2$s", (String)"ConvertRuleCompiler_4", (String)BOS_MSERVICE_BOTP, (Object[])new Object[0]), this.rule.getName(), this.rule.getCtLinkEntityPolicy().getSourceEntryKey());
            throw new KDBizException(errMessage);
        }
        this.linkEntityMap.setSourceLinkEntityKey(srcEntity.getName());
        if (srcEntity instanceof SubEntryType) {
            this.linkEntityMap.setSourceEntryKey(((SubEntryType)srcEntity).getParent().getName());
            this.linkEntityMap.setSourceSubEntryKey(srcEntity.getName());
        } else if (srcEntity instanceof EntryType) {
            this.linkEntityMap.setSourceEntryKey(srcEntity.getName());
            if (StringUtils.isNotBlank((CharSequence)this.rule.getCtLinkEntityPolicy().getSourceSubEntryKey())) {
                this.linkEntityMap.setSourceSubEntryKey(this.rule.getCtLinkEntityPolicy().getSourceSubEntryKey());
            }
        }
        this.linkEntityMap.setTargetLinkEntityKey(this.rule.getCtLinkEntityPolicy().getTargetEntryKey());
        String[] tgtEntitys = this.rule.getCtLinkEntityPolicy().getTargetEntityKeys().split("\\|");
        if (tgtEntitys.length == 3) {
            this.linkEntityMap.setTargetSubEntryKey(tgtEntitys[2]);
            this.linkEntityMap.setTargetEntryKey(tgtEntitys[1]);
        } else if (tgtEntitys.length == 2) {
            this.linkEntityMap.setTargetEntryKey(tgtEntitys[1]);
            if (StringUtils.isNotBlank((CharSequence)this.rule.getCtLinkEntityPolicy().getTargetSubEntryKey())) {
                this.linkEntityMap.setTargetSubEntryKey(this.rule.getCtLinkEntityPolicy().getTargetSubEntryKey());
            }
        }
    }

    private void compileLinkSet() {
        TableDefine linkTableDefine = CtConvertMetaServiceHelper.loadTableDefine((String)this.rule.getSourceEntityNumber(), (String)this.linkEntityMap.getSourceLinkEntityKey());
        TableDefine tableDefine = CtConvertMetaServiceHelper.loadTableDefine((String)this.rule.getSourceEntityNumber(), (String)this.rule.getSourceEntityNumber());
        CtDataEntityField sTenantCode = new CtDataEntityField("sTenantCode", "sTenantCode");
        CtMappingSTenantCode mappingSTenantCode = new CtMappingSTenantCode(sTenantCode, this.rule.getSourceTenant());
        this.linkEntityMap.addMappingField(mappingSTenantCode);
        CtDataEntityField tTenantCode = new CtDataEntityField("tTenantCode", "tTenantCode");
        CtMappingTTenantCode mappingTTenantCode = new CtMappingTTenantCode(tTenantCode, this.rule.getTargetTenant());
        this.linkEntityMap.addMappingField(mappingTTenantCode);
        CtDataEntityField sAccountId = new CtDataEntityField("sAccountId", "sAccountId");
        CtMappingSAccountId mappingSAccountId = new CtMappingSAccountId(sAccountId, this.rule.getSourceDataCenter());
        this.linkEntityMap.addMappingField(mappingSAccountId);
        CtDataEntityField tAccountId = new CtDataEntityField("tAccountId", "tAccountId");
        CtMappingTAccountId mappingTAccountId = new CtMappingTAccountId(tAccountId, this.rule.getTargetDataCenter());
        this.linkEntityMap.addMappingField(mappingTAccountId);
        CtDataEntityField sLinkEntityProp = new CtDataEntityField("sLkEntityKey", "sLkEntityKey");
        CtMappingSLinkEntityKey mappingSLinkEntityKey = new CtMappingSLinkEntityKey(sLinkEntityProp, this.linkEntityMap.getSourceLinkEntityKey());
        this.linkEntityMap.addMappingField(mappingSLinkEntityKey);
        CtDataEntityField tLinkEntityProp = new CtDataEntityField("tLkEntityKey", "tLkEntityKey");
        CtMappingTLinkEntityKey mappingTLinkEntityKey = new CtMappingTLinkEntityKey(tLinkEntityProp, this.linkEntityMap.getTargetLinkEntityKey());
        this.linkEntityMap.addMappingField(mappingTLinkEntityKey);
        CtDataEntityField sLinktableIdProp = new CtDataEntityField("sLkTableId", "sLkTableId");
        CtMappingSLinkTableId mappingSLinkTableId = new CtMappingSLinkTableId(sLinktableIdProp, linkTableDefine.getTableId());
        this.linkEntityMap.addMappingField(mappingSLinkTableId);
        CtDataEntityField sTableIdProp = new CtDataEntityField("sTableId", "sTableId");
        CtMappingSTableId mappingSTableId = new CtMappingSTableId(sTableIdProp, tableDefine.getTableId());
        this.linkEntityMap.addMappingField(mappingSTableId);
        CtDataEntityField sEntityKeyProp = new CtDataEntityField("sEntityKey", "sEntityKey");
        CtMappingSEntityKey mappingSEntityKey = new CtMappingSEntityKey(sEntityKeyProp, this.rule.getSourceEntityNumber());
        this.linkEntityMap.addMappingField(mappingSEntityKey);
        CtDataEntityField tEntityKeyProp = new CtDataEntityField("tEntityKey", "tEntityKey");
        CtMappingTEntityKey mappingTEntityKey = new CtMappingTEntityKey(tEntityKeyProp, this.rule.getTargetEntityNumber());
        this.linkEntityMap.addMappingField(mappingTEntityKey);
        CtDataEntityField sBillIdProp = new CtDataEntityField("sBillId", "sBillId");
        CtMappingSBillId mappingSBillId = new CtMappingSBillId(this.ruleContext, sBillIdProp);
        this.linkEntityMap.addMappingField(mappingSBillId);
        CtMappingSId mappingSId = null;
        CtDataEntityField sIdProp = new CtDataEntityField("sId", "sId");
        if (this.linkEntityMap.getSourceLinkEntityKey().equalsIgnoreCase(this.rule.getSourceEntityNumber())) {
            mappingSId = new CtMappingSId(this.ruleContext, sIdProp, "id");
        } else if (this.linkEntityMap.getSourceLinkEntityKey().equalsIgnoreCase(this.linkEntityMap.getSourceSubEntryKey())) {
            String srcSubEntryPK = this.linkEntityMap.getSourceSubEntryPKFullName();
            mappingSId = new CtMappingSId(this.ruleContext, sIdProp, srcSubEntryPK);
        } else {
            String srcEntryPK = this.linkEntityMap.getSourceEntryPKFullName();
            mappingSId = new CtMappingSId(this.ruleContext, sIdProp, srcEntryPK);
        }
        this.linkEntityMap.addMappingField(mappingSId);
    }
}

