/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.compiler;

import java.text.MessageFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.SubEntryType;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ctbotp.convert.CtSingleBatchContext;
import kd.bos.service.ctbotp.convert.CtSingleRuleContext;
import kd.bos.service.ctbotp.convert.compiler.AbstractCtEntityMap;
import kd.bos.service.ctbotp.convert.compiler.CtLinkEntityMap;
import kd.bos.service.ctbotp.convert.getvaluemode.CtGetSourceFieldValue;
import kd.bos.service.ctbotp.convert.group.CtSourceRowsGroupKeyBuilder;
import kd.bos.service.ctbotp.convert.var.CtSourceFieldVariable;

public class CtDependEntityMap
extends AbstractCtEntityMap {
    private static final String BOS_MSERVICE_OPERATION = "bos-mservice-botp";
    private String targetEntity;
    private String targetAnchorEntityKey;
    private AbstractCtEntityMap targetAnchorEntityMap;
    private String sourceAnchorEntityKey;
    private CtGetSourceFieldValue srcAnchorRowIdGetter;
    protected boolean compileSuccess = false;
    protected String compileFailMessage;

    public CtDependEntityMap(String targetEntity) {
        this.targetEntity = targetEntity;
        String[] targetEntityArr = targetEntity.split("\\|");
        if (targetEntityArr.length == 3) {
            this.targetEntryKey = targetEntityArr[1];
            this.targetSubEntryKey = targetEntityArr[2];
        } else if (targetEntityArr.length == 2) {
            this.targetEntryKey = targetEntityArr[1];
        } else {
            if (targetEntityArr.length == 1) {
                return;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u5b57\u6bb5\u6240\u5c5e\u7684\u5b9e\u4f53\u7c7b\u578b\uff0c\u4e0d\u80fd\u901a\u8fc7\u5355\u636e\u8f6c\u6362\u643a\u5e26\u6570\u636e\u4e0b\u6765", (String)"DependEntityMap_0", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
        }
    }

    public String getTargetEntity() {
        return this.targetEntity;
    }

    public String getParentEntity() {
        String[] targetEntityArr = this.targetEntity.split("\\|");
        return targetEntityArr[0] + "|" + targetEntityArr[1];
    }

    public String getTargetAnchorEntityKey() {
        return this.targetAnchorEntityKey;
    }

    public AbstractCtEntityMap getTargetAnchorEntityMap() {
        return this.targetAnchorEntityMap;
    }

    public String getSourceAnchorEntityKey() {
        return this.sourceAnchorEntityKey;
    }

    public CtGetSourceFieldValue getSrcAnchorRowIdGetter() {
        return this.srcAnchorRowIdGetter;
    }

    public boolean isCompileSuccess() {
        return this.compileSuccess;
    }

    public String getCompileFailMessage() {
        return this.compileFailMessage;
    }

    public boolean compileSourceEntity() {
        this.compileSuccess = true;
        int entryCount = 0;
        int subEntryCount = 0;
        EntryType entryType = null;
        SubEntryType subEntryType = null;
        for (EntityType entityType : this.sourceFields.keySet()) {
            if (entityType instanceof SubEntryType) {
                ++subEntryCount;
                subEntryType = (SubEntryType)entityType;
                continue;
            }
            if (!(entityType instanceof EntryType)) continue;
            ++entryCount;
            entryType = (EntryType)entityType;
        }
        if (entryCount > 1 || subEntryCount > 1) {
            this.compileFailMessage = String.format(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u201c%1$s(%2$s)\u201d\u7684\u5b57\u6bb5\uff0c\u6765\u6e90\u4e8e\u591a\u4e2a\u4e0d\u540c\u7684\u5355\u636e\u4f53\uff0c\u6620\u5c04\u5173\u7cfb\u8fc7\u4e8e\u590d\u6742\uff0c\u7cfb\u7edf\u65e0\u6cd5\u6b63\u786e\u643a\u5e26\u6570\u636e\u3002", (String)"DependEntityMap_1", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), this.targetEntity, this.targetEntity);
            this.compileSuccess = false;
        }
        if (subEntryType == null && entryType != null) {
            this.sourceEntryKey = entryType.getName();
        } else if (subEntryType != null) {
            if (entryType == null) {
                this.sourceEntryKey = subEntryType.getParent().getName();
                this.sourceSubEntryKey = subEntryType.getName();
            } else if (subEntryType.getParent().getName().equals(entryType.getName())) {
                this.sourceEntryKey = entryType.getName();
                this.sourceSubEntryKey = subEntryType.getName();
            } else {
                this.compileSuccess = false;
                this.compileFailMessage = MessageFormat.format(ResManager.loadKDString((String)"\u76ee\u6807\u5355\u201c%1$s(%2$s)\u201d\u7684\u6570\u636e\u6765\u6e90\u5b9e\u4f53%3$s\u3001%4$s\u6ca1\u6709\u7236\u5b50\u5173\u7cfb\uff0c\u65e0\u6cd5\u540c\u65f6\u643a\u5e26\u6570\u636e\u4e0b\u6765\u3002", (String)"DependEntityMap_2", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]), this.targetEntity, this.targetEntity, entryType.getDisplayName(), subEntryType.getDisplayName());
            }
        }
        return this.compileSuccess;
    }

    public void compileAnchorEntity(CtSingleRuleContext ruleContext, CtLinkEntityMap linkEntityMap, Map<String, CtDependEntityMap> otherEntityMap) {
        this.compileTargetAnchorEntity(ruleContext, linkEntityMap, otherEntityMap);
        this.compileSourceAnchorEntity(ruleContext);
    }

    private void compileTargetAnchorEntity(CtSingleRuleContext ruleContext, CtLinkEntityMap linkEntityMap, Map<String, CtDependEntityMap> otherEntityMap) {
        String[] targetEntityArr = this.targetEntity.split("\\|");
        String parentType = "";
        if (targetEntityArr.length == 3) {
            this.targetEntryKey = targetEntityArr[1];
            this.targetSubEntryKey = targetEntityArr[2];
            parentType = targetEntityArr[1];
        } else if (targetEntityArr.length == 2) {
            this.targetEntryKey = targetEntityArr[1];
            parentType = targetEntityArr[0];
        } else {
            if (targetEntityArr.length == 1) {
                this.targetAnchorEntityMap = linkEntityMap;
                this.targetAnchorEntityKey = ruleContext.getContext().getTargetEntityNumber();
                return;
            }
            throw new KDBizException(ResManager.loadKDString((String)"\u5b57\u6bb5\u6240\u5c5e\u7684\u5b9e\u4f53\u7c7b\u578b\uff0c\u4e0d\u80fd\u901a\u8fc7\u5355\u636e\u8f6c\u6362\u643a\u5e26\u6570\u636e\u4e0b\u6765", (String)"DependEntityMap_0", (String)BOS_MSERVICE_OPERATION, (Object[])new Object[0]));
        }
        if (targetEntityArr.length == 2) {
            this.targetAnchorEntityMap = linkEntityMap;
            this.targetAnchorEntityKey = parentType;
        } else {
            String mapKey = String.format("billhead|%s|", parentType);
            this.targetAnchorEntityMap = otherEntityMap.get(mapKey);
            if (this.targetAnchorEntityMap != null) {
                this.targetAnchorEntityKey = parentType;
            } else {
                this.targetAnchorEntityMap = linkEntityMap;
                this.targetAnchorEntityKey = StringUtils.equalsIgnoreCase((CharSequence)linkEntityMap.getTargetEntryKey(), (CharSequence)parentType) ? parentType : "billhead";
            }
        }
        if (this.targetAnchorEntityMap.getJoinSourceEntityKeys().indexOf(this.getJoinSourceEntityKeys()) >= 0) {
            for (Map.Entry<String, CtSourceFieldVariable> entry : this.getAllSourceFields().entrySet()) {
                linkEntityMap.addSourceField(entry.getValue());
            }
        }
    }

    private void compileSourceAnchorEntity(CtSingleRuleContext ruleContext) {
        BillEntityType sourceMainType = ruleContext.getContext().getSourceMainType();
        String groupKey = "id";
        HashSet<String> srcAnchorEntityKeys = new HashSet<String>();
        srcAnchorEntityKeys.add(sourceMainType.getName());
        if (StringUtils.isNotBlank((CharSequence)this.targetAnchorEntityMap.getSourceEntryKey())) {
            srcAnchorEntityKeys.add(this.targetAnchorEntityMap.getSourceEntryKey());
        }
        if (StringUtils.isNotBlank((CharSequence)this.targetAnchorEntityMap.getSourceSubEntryKey())) {
            srcAnchorEntityKeys.add(this.targetAnchorEntityMap.getSourceSubEntryKey());
        }
        BillEntityType sourceEntity = sourceMainType;
        if (StringUtils.isNotBlank((CharSequence)this.sourceSubEntryKey)) {
            sourceEntity = (EntityType)sourceMainType.getAllEntities().get(this.sourceSubEntryKey);
            groupKey = this.sourceEntryKey + "." + this.sourceSubEntryKey + ".id";
        } else if (StringUtils.isNotBlank((CharSequence)this.sourceEntryKey)) {
            sourceEntity = (EntityType)sourceMainType.getAllEntities().get(this.sourceEntryKey);
            groupKey = this.sourceEntryKey + ".id";
        }
        while (sourceEntity != null && !srcAnchorEntityKeys.contains(sourceEntity.getName())) {
            sourceEntity = (EntityType)sourceEntity.getParent();
        }
        if (sourceEntity == null) {
            sourceEntity = sourceMainType;
        }
        this.sourceAnchorEntityKey = sourceEntity.getName();
        this.srcAnchorRowIdGetter = sourceEntity instanceof BillEntityType ? new CtGetSourceFieldValue(ruleContext, "id") : new CtGetSourceFieldValue(ruleContext, sourceEntity.getName() + ".id");
        CtSourceRowsGroupKeyBuilder groupKeyBuilder = new CtSourceRowsGroupKeyBuilder(ruleContext, groupKey);
        this.addSourceRowsGroupKeyBuilders(groupKeyBuilder);
    }

    public void compileQFilter() {
        QFilter qFilter = this.buildSrcIdFilter(this.targetAnchorEntityMap.getSourceRows());
        if (qFilter != null) {
            this.qFilters.add(qFilter);
        }
    }

    public QFilter[] compileBatchQFilter(CtSingleBatchContext batchContext) {
        List<DynamicObject> sourceRows = null;
        sourceRows = this.targetAnchorEntityMap instanceof CtLinkEntityMap ? batchContext.getSourceRowsGroupRoot().getSourceRows() : batchContext.getDependEntitySourceRows(this.targetAnchorEntityMap);
        QFilter qFilter = this.buildSrcIdFilter(sourceRows);
        if (qFilter == null) {
            return new QFilter[0];
        }
        return new QFilter[]{qFilter};
    }

    private QFilter buildSrcIdFilter(List<DynamicObject> sourceRows) {
        if (sourceRows == null || sourceRows.isEmpty()) {
            return null;
        }
        HashSet<Object> srcBillIds = new HashSet<Object>(sourceRows.size());
        HashSet<Long> srcAnchorEntryIds = new HashSet<Long>(sourceRows.size());
        String srcAnchorEntityPKPropName = this.srcAnchorRowIdGetter.getFullPropName();
        Map<String, DynamicProperty> srcFldPropertys = this.targetAnchorEntityMap.getSrcFldPropertys();
        for (DynamicObject sourceRow : sourceRows) {
            Long entryId = (Long)this.srcAnchorRowIdGetter.getValue(this.targetAnchorEntityMap.baseDataPropInfoMap, srcFldPropertys, sourceRow);
            srcAnchorEntryIds.add(entryId);
            Object billId = sourceRow.get("id");
            srcBillIds.add(billId);
        }
        QFilter qFilter = new QFilter(srcAnchorEntityPKPropName, "in", srcAnchorEntryIds);
        if (!"id".equals(srcAnchorEntityPKPropName)) {
            qFilter.and(new QFilter("id", "in", srcBillIds));
        }
        if (StringUtils.isNotBlank((CharSequence)this.getSourceSubEntryKey())) {
            qFilter.and(new QFilter(this.getSourceSubEntryPKFullName(), "!=", (Object)0L));
        } else if (StringUtils.isNotBlank((CharSequence)this.getSourceEntryKey())) {
            qFilter.and(new QFilter(this.getSourceEntryPKFullName(), "!=", (Object)0L));
        }
        return qFilter;
    }
}

