/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.getscale;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.PriceProp;
import kd.bos.entity.property.QtyProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ctbotp.convert.getscale.ICtGetScale;

class CtGetCtrlFieldPrecision
implements ICtGetScale {
    private static final Log log = LogFactory.getLog(CtGetCtrlFieldPrecision.class);
    int defScale;
    String ctrlFldKey;
    String precisionPropName;
    static final String CURR_AMOUNT_PRECISION = "amtprecision";
    static final String CURR_PRICE_PRECISION = "priceprecision";
    static final String UNIT_PRECISION = "precision";
    RowDataModel rowDataModel;

    public CtGetCtrlFieldPrecision(BillEntityType mainType, DecimalProp prop) {
        this.ctrlFldKey = prop.getControlPropName();
        if (prop instanceof PriceProp) {
            this.precisionPropName = CURR_PRICE_PRECISION;
        } else if (prop instanceof AmountProp) {
            this.precisionPropName = CURR_AMOUNT_PRECISION;
        } else if (prop instanceof QtyProp) {
            this.precisionPropName = UNIT_PRECISION;
        }
        this.defScale = prop.getScale();
        this.rowDataModel = new RowDataModel(prop.getParent().getName(), (MainEntityType)mainType);
    }

    @Override
    public int getScale(DynamicObject activeRow) {
        this.rowDataModel.setRowContext(activeRow);
        return this.getScale(this.rowDataModel);
    }

    @Override
    public int getScale(RowDataModel rowDataModel) {
        int scale = this.defScale;
        try {
            Object ctrlFldObj = rowDataModel.getValue(this.ctrlFldKey);
            if (ctrlFldObj != null) {
                if (ctrlFldObj instanceof DynamicObject) {
                    scale = ((DynamicObject)ctrlFldObj).getInt(this.precisionPropName);
                } else if (ctrlFldObj instanceof Integer) {
                    scale = (Integer)ctrlFldObj;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return scale;
    }
}

