/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.getvaluemode;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ctbotp.BaseDataPropInfo;
import kd.bos.service.ctbotp.convert.CtSingleRuleContext;
import kd.bos.service.ctbotp.convert.getvaluemode.CtGetFormulaValue;
import kd.bos.service.ctbotp.convert.getvaluemode.CtToken;
import kd.bos.service.ctbotp.convert.var.ICtVariableMode;

public class CtGetDynamicTextValue
extends CtGetFormulaValue {
    public CtGetDynamicTextValue(CtSingleRuleContext ruleContext, String dynamicText) {
        super(ruleContext, dynamicText);
    }

    @Override
    public String getValue(Map<String, BaseDataPropInfo> baseDataPropInfoMap, Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow) {
        HashMap<String, Object> ctx = new HashMap<String, Object>(this.vars.size());
        for (ICtVariableMode var : this.vars) {
            ctx.put(var.getVar(), this.getSingleFieldValue(baseDataPropInfoMap, fldProperties, sourceRow, var));
        }
        return this.parse(ctx);
    }

    @Override
    public Object getValue(Map<String, String> fldAlias, Row row) {
        HashMap<String, Object> ctx = new HashMap<String, Object>(this.vars.size());
        for (ICtVariableMode var : this.vars) {
            ctx.put(var.getVar(), this.getSingleFieldValue(fldAlias, row, var));
        }
        return this.parse(ctx);
    }

    @Override
    protected void compileFormula(String formula) {
        this.formula = formula;
        String[] varStrings = this.extractVariables();
        BillEntityType mainEntityType = this.ruleContext.getContext().getSourceMainType();
        for (String varString : varStrings) {
            String[] keyItems = StringUtils.split((String)varString, (String)".");
            ICtVariableMode var = this.buildVarMode(mainEntityType, varString, keyItems);
            this.vars.add(var);
        }
    }

    private String[] extractVariables() {
        ArrayList<String> variables = new ArrayList<String>();
        int len = this.formula.length();
        CtToken token = CtToken.TEXT;
        for (int pos = 0; pos < len; ++pos) {
            if ((token = this.getCharToken(len, pos, token)) != CtToken.VARIABLE) continue;
            int endIndex = this.formula.indexOf(125, pos + 1);
            if (endIndex == -1) break;
            String variableName = this.formula.substring(pos + 1, endIndex);
            variables.add(variableName);
            pos = endIndex;
            token = CtToken.TEXT;
        }
        return variables.toArray(new String[variables.size()]);
    }

    private String parse(Map<String, Object> ctx) {
        int len = this.formula.length();
        StringBuilder sb = new StringBuilder(len + len / 2);
        CtToken token = CtToken.TEXT;
        block4: for (int pos = 0; pos < len; ++pos) {
            token = this.getCharToken(len, pos, token);
            switch (token) {
                case ESCAPE: {
                    sb.append('{');
                    token = CtToken.TEXT;
                    ++pos;
                    continue block4;
                }
                case VARIABLE: {
                    pos = this.appendVarValue(len, pos, sb, ctx);
                    token = CtToken.TEXT;
                    continue block4;
                }
                default: {
                    sb.append(this.formula.charAt(pos));
                }
            }
        }
        return sb.toString();
    }

    private int appendVarValue(int len, int pos, StringBuilder sb, Map<String, Object> ctx) {
        int endIndex = this.formula.indexOf(125, pos + 1);
        if (endIndex == -1) {
            sb.append(this.formula.substring(pos));
            return len + 1;
        }
        String variableName = this.formula.substring(pos + 1, endIndex);
        Object vName = ctx.get(variableName);
        if (vName != null) {
            String sValue = this.formatValue(vName);
            sb.append(sValue);
        } else {
            sb.append('{').append(variableName).append(']');
        }
        return endIndex;
    }

    private CtToken getCharToken(int len, int pos, CtToken t) {
        CtToken token = t;
        char c = this.formula.charAt(pos);
        if (c == '{') {
            boolean condition = pos + 1 < len && this.formula.charAt(pos + 1) == '{';
            token = condition ? CtToken.ESCAPE : CtToken.VARIABLE;
        }
        return token;
    }

    private String formatValue(Object variableValue) {
        String sValue;
        if (variableValue == null) {
            return "";
        }
        if (variableValue instanceof BigDecimal) {
            BigDecimal dValue = new BigDecimal(variableValue.toString());
            sValue = dValue.toString();
        } else {
            sValue = variableValue.toString();
        }
        return sValue;
    }
}

