/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.getvaluemode;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ctbotp.BaseDataPropInfo;
import kd.bos.entity.ctbotp.runtime.CtCRExpressionContext;
import kd.bos.entity.formula.BOSExpression;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.formula.OutValue;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.entity.function.BatchFuncParser;
import kd.bos.entity.function.BatchFuncRunParam;
import kd.bos.entity.function.FunctionManage;
import kd.bos.entity.function.UDFunctionVisitor;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.formula.FormulaEngine;
import kd.bos.formula.excel.Expr;
import kd.bos.formula.excel.UDFunction;
import kd.bos.formula.excel.Visitor;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ctbotp.convert.CtSingleRuleContext;
import kd.bos.service.ctbotp.convert.getvaluemode.AbstractCtGetValueMode;
import kd.bos.service.ctbotp.convert.var.CtSourceFieldVariable;
import kd.bos.service.ctbotp.convert.var.CtUnknowVariable;
import kd.bos.service.ctbotp.convert.var.ICtVariableMode;

public class CtGetFormulaValue
extends AbstractCtGetValueMode {
    private static Log log = LogFactory.getLog(CtGetFormulaValue.class);
    protected String formula;
    protected CtSingleRuleContext ruleContext;
    protected FunctionManage funcLib;
    protected CtCRExpressionContext expContext;
    protected List<ICtVariableMode> vars = new ArrayList<ICtVariableMode>();
    protected Set<String> funcs = new HashSet<String>();
    protected Expr expr;
    protected Set<BatchFuncRunParam> batchFuncRunParams = new HashSet<BatchFuncRunParam>(8);
    protected boolean isFunBatchCall;

    public CtGetFormulaValue(CtSingleRuleContext ruleContext, String formula) {
        this.ruleContext = ruleContext;
        this.funcLib = ruleContext.getFuncLib();
        this.expContext = new CtCRExpressionContext(ruleContext.getContext().getSourceMainType(), ruleContext.getContext().getTargetMainType(), ruleContext.getRule());
        this.expContext.setConvertServiceArgs(ruleContext.getContext().getInputArgs());
        this.expContext.setOption(ruleContext.getContext().getOption());
        this.expContext.setLocalCache(ruleContext.getExpLocalCache());
        this.compileFormula(formula);
    }

    public void setFormula(String formula) {
        this.compileFormula(formula);
    }

    public String getFormula() {
        return this.formula;
    }

    @Override
    public List<ICtVariableMode> getVars() {
        return this.vars;
    }

    public Set<String> getFuncs() {
        return this.funcs;
    }

    @Override
    public Object getValue(Map<String, BaseDataPropInfo> baseDataPropInfoMap, Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow) {
        this.expContext.setActiveRow(sourceRow);
        this.expContext.setFldProperties(fldProperties);
        this.funBatchCall();
        Map<String, Object> ctx = this.getVarValues(this.expContext);
        BOSUDFunction[] funcInstances = this.createUDFunctions(this.expContext);
        this.ruleContext.getMulbasedataParaManager().getCollection(ctx, this.vars, sourceRow.get("id"), this.expr);
        return FormulaEngine.execExcelFormula((Expr)this.expr, ctx, (UDFunction[])funcInstances);
    }

    private void funBatchCall() {
        try {
            if (this.isFunBatchCall) {
                return;
            }
            BatchFuncParser batchFuncParser = new BatchFuncParser();
            if (this.batchFuncRunParams != null && this.batchFuncRunParams.size() > 0) {
                Map batchCallResult = batchFuncParser.batchCall(this.batchFuncRunParams, (ExpressionContext)this.expContext, this.funcLib);
                this.expContext.setBatchRunResult(batchCallResult);
                this.isFunBatchCall = true;
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
            this.isFunBatchCall = true;
        }
    }

    @Override
    public boolean batchPreCall(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow) {
        this.expContext.setActiveRow(sourceRow);
        this.expContext.setFldProperties(fldProperties);
        BatchFuncParser batchFuncParser = new BatchFuncParser();
        BOSExpression expression = new BOSExpression(this.formula);
        Set batchFuncRunParamsSet = batchFuncParser.preCall(expression, (ExpressionContext)this.expContext, this.funcLib);
        if (batchFuncRunParamsSet == null || batchFuncRunParamsSet.size() == 0) {
            return false;
        }
        this.batchFuncRunParams.addAll(batchFuncRunParamsSet);
        return true;
    }

    @Override
    public Object getValue(Map<String, String> fldAlias, Row row) {
        Map<String, Object> ctx = this.getVarValues(fldAlias, row);
        return FormulaEngine.execExcelFormula((Expr)this.expr, ctx, (UDFunction[])new BOSUDFunction[0]);
    }

    protected Object getSingleFieldValue(Map<String, BaseDataPropInfo> baseDataPropInfoMap, Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow, ICtVariableMode var) {
        return var.getValue(baseDataPropInfoMap, fldProperties, sourceRow);
    }

    protected Object getSingleFieldValue(Map<String, String> fldAlias, Row row, ICtVariableMode var) {
        return var.getValue(fldAlias, row);
    }

    protected void compileFormula(String formula) {
        this.formula = formula;
        String[] varStrings = new String[]{};
        try {
            varStrings = FormulaEngine.extractVariables((String)this.formula);
            this.expr = FormulaEngine.parseFormula((String)this.formula);
            UDFunctionVisitor funVisitor = new UDFunctionVisitor();
            this.expr.accept((Visitor)funVisitor);
            this.funcs.addAll(funVisitor.getFuncNames());
        }
        catch (Throwable exp) {
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(ResManager.loadKDString((String)"%1$s \u8868\u8fbe\u5f0f\u89e3\u6790\u51fa\u9519\uff1a%2$s", (String)"GetFormulaValue_0", (String)"bos-mservice-botp", (Object[])new Object[0]), this.formula, exp.getMessage()));
            throw new KDBizException(exp, BosErrorCode.expressionParseFailed, new Object[]{sb.toString()});
        }
        BillEntityType mainEntityType = this.ruleContext.getContext().getSourceMainType();
        for (String varString : varStrings) {
            String[] keyItems = StringUtils.split((String)varString, (String)".");
            ICtVariableMode var = this.buildVarMode(mainEntityType, varString, keyItems);
            this.vars.add(var);
        }
    }

    protected ICtVariableMode buildVarMode(BillEntityType mainEntityType, String varString, String[] keyItems) {
        ICtVariableMode var = null;
        IDataEntityProperty property = mainEntityType.findProperty(keyItems[0]);
        if (property == null && mainEntityType.getProperties().containsKey((Object)keyItems[0])) {
            property = (IDataEntityProperty)mainEntityType.getProperties().get((Object)keyItems[0]);
        }
        var = property != null ? new CtSourceFieldVariable(varString, keyItems, property) : new CtUnknowVariable(varString, keyItems);
        return var;
    }

    protected Map<String, Object> getVarValues(CtCRExpressionContext expContext) {
        HashMap<String, Object> ctx = new HashMap<String, Object>();
        for (ICtVariableMode var : this.getVars()) {
            OutValue value = new OutValue();
            if (!expContext.tryGetValue(var.getVar(), value).booleanValue()) {
                ctx.put(var.getVar(), null);
                continue;
            }
            Object item = value.get();
            ctx.put(var.getVar(), item);
        }
        return ctx;
    }

    protected Map<String, Object> getVarValues(Map<String, String> fldAlias, Row row) {
        HashMap<String, Object> ctx = new HashMap<String, Object>(this.getVars().size());
        for (ICtVariableMode var : this.getVars()) {
            Object varValue = var.getValue(fldAlias, row);
            ctx.put(var.getVar(), varValue);
        }
        return ctx;
    }

    private BOSUDFunction[] createUDFunctions(CtCRExpressionContext expContext) {
        if (this.getFuncs().isEmpty()) {
            return null;
        }
        ArrayList<BOSUDFunction> instances = new ArrayList<BOSUDFunction>();
        for (String funcName : this.getFuncs()) {
            if (!this.funcLib.getFuncMap().containsKey(funcName)) continue;
            BOSUDFunction instance = ((BOSUDFunction)this.funcLib.getFuncMap().get(funcName)).getInstance((ExpressionContext)expContext);
            instances.add(instance);
        }
        return instances.toArray(new BOSUDFunction[0]);
    }
}

