/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.getvaluemode;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ctbotp.BaseDataPropInfo;
import kd.bos.entity.ctbotp.CtCRValByCondition;
import kd.bos.entity.ctbotp.CtCRValByConditionType;
import kd.bos.entity.ctbotp.CtCRValByConditions;
import kd.bos.service.ctbotp.convert.CtSingleRuleContext;
import kd.bos.service.ctbotp.convert.getvaluemode.AbstractCtGetValueMode;
import kd.bos.service.ctbotp.convert.getvaluemode.CtGetConditionValue;
import kd.bos.service.ctbotp.convert.getvaluemode.CtGetConstValue;
import kd.bos.service.ctbotp.convert.getvaluemode.CtGetFormulaValue;
import kd.bos.service.ctbotp.convert.getvaluemode.ICtGetValueMode;
import kd.bos.service.ctbotp.convert.var.ICtVariableMode;

public class CtGetValueByCondition
extends AbstractCtGetValueMode {
    protected CtSingleRuleContext ruleContext;
    private CtCRValByConditions valByConditions;
    private Object defValue;
    protected List<ICtVariableMode> vars = new ArrayList<ICtVariableMode>();
    protected List<Tuple<ICtGetValueMode, ICtGetValueMode>> getValueHandlers = new ArrayList<Tuple<ICtGetValueMode, ICtGetValueMode>>();

    public CtGetValueByCondition(CtSingleRuleContext ruleContext, CtCRValByConditions valByConditions, Object defValue) {
        this.ruleContext = ruleContext;
        this.valByConditions = valByConditions;
        this.defValue = defValue;
        this.compile();
    }

    public CtCRValByConditions getValByConditions() {
        return this.valByConditions;
    }

    @Override
    public List<ICtVariableMode> getVars() {
        return this.vars;
    }

    public List<Tuple<ICtGetValueMode, ICtGetValueMode>> getValueHandlers() {
        return this.getValueHandlers;
    }

    public Object getDefValue() {
        return this.defValue;
    }

    @Override
    public Object getValue(Map<String, BaseDataPropInfo> baseDataPropInfoMap, Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow) {
        Object value = this.defValue;
        for (Tuple<ICtGetValueMode, ICtGetValueMode> tuple : this.getValueHandlers) {
            if (!((Boolean)((ICtGetValueMode)tuple.item1).getValue(baseDataPropInfoMap, fldProperties, sourceRow)).booleanValue()) continue;
            value = ((ICtGetValueMode)tuple.item2).getValue(baseDataPropInfoMap, fldProperties, sourceRow);
            break;
        }
        return value;
    }

    @Override
    public boolean batchPreCall(Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow) {
        boolean preCall = false;
        for (Tuple<ICtGetValueMode, ICtGetValueMode> tuple : this.getValueHandlers) {
            boolean preCallL = ((ICtGetValueMode)tuple.item1).batchPreCall(fldProperties, sourceRow);
            boolean preCallF = ((ICtGetValueMode)tuple.item2).batchPreCall(fldProperties, sourceRow);
            if (!preCallL && !preCallF) continue;
            preCall = true;
        }
        return preCall;
    }

    @Override
    public Object getValue(Map<String, String> fldAlias, Row row) {
        Object value = this.defValue;
        for (Tuple<ICtGetValueMode, ICtGetValueMode> tuple : this.getValueHandlers) {
            if (!((Boolean)((ICtGetValueMode)tuple.item1).getValue(fldAlias, row)).booleanValue()) continue;
            value = ((ICtGetValueMode)tuple.item2).getValue(fldAlias, row);
            break;
        }
        return value;
    }

    private void compile() {
        this.getValueHandlers.clear();
        if (this.valByConditions == null || this.valByConditions.getItems().isEmpty()) {
            this.getValueHandlers.add(this.buildGetDefValueTuple());
            return;
        }
        ArrayList items = new ArrayList();
        items.addAll(this.valByConditions.getItems());
        items.sort((o1, o2) -> o1.getSeq() - o2.getSeq());
        for (CtCRValByCondition item : items) {
            ICtGetValueMode conditionHandler = null;
            ICtGetValueMode valueHandler = null;
            conditionHandler = this.buildConditionHandler(item);
            valueHandler = this.buildValueHandler(item);
            this.vars.addAll(conditionHandler.getVars());
            this.vars.addAll(valueHandler.getVars());
            this.getValueHandlers.add((Tuple<ICtGetValueMode, ICtGetValueMode>)new Tuple((Object)conditionHandler, (Object)valueHandler));
        }
        this.getValueHandlers.add(this.buildGetDefValueTuple());
    }

    protected ICtGetValueMode buildConditionHandler(CtCRValByCondition item) {
        if (item.getCtCRCondition() == null || item.getSelectType() == CtCRValByConditionType.Others) {
            return new CtGetConstValue(Boolean.TRUE);
        }
        String condition = item.getCtCRCondition().buildFullFormula((MainEntityType)this.ruleContext.getContext().getSourceMainType());
        if (StringUtils.isBlank((CharSequence)condition)) {
            return new CtGetConstValue(Boolean.TRUE);
        }
        return new CtGetConditionValue(this.ruleContext, condition);
    }

    protected ICtGetValueMode buildValueHandler(CtCRValByCondition item) {
        if (item.getFormula() == null) {
            return new CtGetConstValue(this.defValue);
        }
        String formula = item.getFormula().getExpression();
        if (StringUtils.isBlank((CharSequence)formula)) {
            return new CtGetConstValue(this.defValue);
        }
        return new CtGetFormulaValue(this.ruleContext, formula);
    }

    private Tuple<ICtGetValueMode, ICtGetValueMode> buildGetDefValueTuple() {
        CtGetConstValue condition = new CtGetConstValue(Boolean.TRUE);
        CtGetConstValue value = new CtGetConstValue(this.defValue);
        return new Tuple((Object)condition, (Object)value);
    }
}

