/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.getvaluemode;

import java.util.List;
import java.util.Map;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ctbotp.BaseDataPropInfo;
import kd.bos.entity.ctbotp.CtFieldMapItem;
import kd.bos.service.ctbotp.convert.CtSingleRuleContext;
import kd.bos.service.ctbotp.convert.getvaluemode.AbstractCtGetValueMode;
import kd.bos.service.ctbotp.convert.getvaluemode.CtGetConstValue;
import kd.bos.service.ctbotp.convert.getvaluemode.CtGetFormulaValue;
import kd.bos.service.ctbotp.convert.getvaluemode.CtGetSourceFieldValue;
import kd.bos.service.ctbotp.convert.getvaluemode.CtGetValueByCondition;
import kd.bos.service.ctbotp.convert.var.ICtVariableMode;

public interface ICtGetValueMode {
    public Object getValue(Map<String, BaseDataPropInfo> var1, Map<String, DynamicProperty> var2, DynamicObject var3);

    public boolean batchPreCall(Map<String, DynamicProperty> var1, DynamicObject var2);

    public Object getValue(Map<String, String> var1, Row var2);

    public List<ICtVariableMode> getVars();

    public static ICtGetValueMode create(CtSingleRuleContext ruleContext, CtFieldMapItem fieldMapItem) {
        AbstractCtGetValueMode valueMode = null;
        switch (fieldMapItem.getCtFieldConvertType()) {
            case SourceField: {
                if (StringUtils.isBlank((CharSequence)fieldMapItem.getSourceFieldKey())) {
                    valueMode = new CtGetConstValue(null);
                    break;
                }
                valueMode = new CtGetSourceFieldValue(ruleContext, fieldMapItem.getSourceFieldKey());
                break;
            }
            case Formula: {
                if (fieldMapItem.getFormula() == null || StringUtils.isBlank((CharSequence)fieldMapItem.getFormula().getExpression())) {
                    valueMode = new CtGetConstValue(null);
                    break;
                }
                valueMode = new CtGetFormulaValue(ruleContext, fieldMapItem.getFormula().getExpression());
                break;
            }
            case ByCondition: {
                if (fieldMapItem.getValByConditions() == null || fieldMapItem.getValByConditions().getItems().isEmpty()) {
                    valueMode = new CtGetConstValue(null);
                    break;
                }
                valueMode = new CtGetValueByCondition(ruleContext, fieldMapItem.getValByConditions(), null);
                break;
            }
            case CONSTANT: {
                if (fieldMapItem.getConstant() == null || StringUtils.isBlank((CharSequence)fieldMapItem.getConstant().getExpression())) {
                    valueMode = new CtGetConstValue(null);
                    break;
                }
                valueMode = new CtGetConstValue(fieldMapItem.getConstant().getExpression());
                break;
            }
            default: {
                valueMode = new CtGetConstValue(null);
            }
        }
        return valueMode;
    }
}

