/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.group;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.service.ctbotp.convert.group.CtSourceRowId;
import kd.bos.service.ctbotp.convert.group.CtSourceRowsGroupKey;

public class CtSourceRowsGroup {
    private CtSourceRowsGroupKey groupKey;
    private List<CtSourceRowId> sourceRowIds = new ArrayList<CtSourceRowId>();
    private List<DynamicObject> sourceRows = new ArrayList<DynamicObject>();
    private Map<CtSourceRowsGroupKey, CtSourceRowsGroup> childGroupMap = new HashMap<CtSourceRowsGroupKey, CtSourceRowsGroup>();
    private List<CtSourceRowsGroup> childGroupList = new ArrayList<CtSourceRowsGroup>();
    private Object targetBillId;
    private int startEntrySeq = 1;
    private boolean isFirstBatch;
    private boolean existNextBatch;
    private boolean isConver = false;

    public boolean isConver() {
        return this.isConver;
    }

    public void setConver(boolean conver) {
        this.isConver = conver;
    }

    public CtSourceRowsGroup(CtSourceRowsGroupKey groupKey) {
        this.groupKey = groupKey;
    }

    public CtSourceRowsGroupKey getGroupKey() {
        return this.groupKey;
    }

    public List<CtSourceRowId> getSourceRowIds() {
        return this.sourceRowIds;
    }

    public List<DynamicObject> getSourceRows() {
        return this.sourceRows;
    }

    public Map<CtSourceRowsGroupKey, CtSourceRowsGroup> getChildGroupMap() {
        return this.childGroupMap;
    }

    public List<CtSourceRowsGroup> getChildGroupList() {
        return this.childGroupList;
    }

    public Object getTargetBillId() {
        return this.targetBillId;
    }

    public void setTargetBillId(Object targetBillId) {
        this.targetBillId = targetBillId;
    }

    public int getStartEntrySeq() {
        return this.startEntrySeq;
    }

    public void setStartEntrySeq(int startEntrySeq) {
        this.startEntrySeq = startEntrySeq;
    }

    public boolean isExistNextBatch() {
        return this.existNextBatch;
    }

    public void setExistNextBatch(boolean existNextBatch) {
        this.existNextBatch = existNextBatch;
    }

    public boolean isFirstBatch() {
        return this.isFirstBatch;
    }

    public void setFirstBatch(boolean firstBatch) {
        this.isFirstBatch = firstBatch;
    }

    public int getEntryRowCount() {
        int entryRowCount = 0;
        if (this.groupKey == null) {
            for (CtSourceRowsGroup bill : this.childGroupList) {
                entryRowCount += bill.getEntryRowCount();
            }
        } else {
            if (this.childGroupList.isEmpty()) {
                return 1;
            }
            return this.childGroupList.size();
        }
        return entryRowCount;
    }

    public void addSourceRow(DynamicObject sourceRow, List<CtSourceRowsGroupKey> groupKeys) {
        this.sourceRows.add(sourceRow);
        if (groupKeys.isEmpty()) {
            return;
        }
        CtSourceRowsGroupKey firstGroupKey = groupKeys.get(0);
        ArrayList<CtSourceRowsGroupKey> otherGroupKeys = new ArrayList<CtSourceRowsGroupKey>(groupKeys.size());
        for (int i = 1; i < groupKeys.size(); ++i) {
            otherGroupKeys.add(groupKeys.get(i));
        }
        CtSourceRowsGroup childGroup = this.childGroupMap.computeIfAbsent(firstGroupKey, key -> {
            CtSourceRowsGroup newChildGroup = new CtSourceRowsGroup((CtSourceRowsGroupKey)key);
            this.childGroupList.add(newChildGroup);
            return newChildGroup;
        });
        childGroup.addSourceRow(sourceRow, otherGroupKeys);
    }

    public void addSourceRow(CtSourceRowId sourceRowId, List<CtSourceRowsGroupKey> groupKeys) {
        this.sourceRowIds.add(sourceRowId);
        if (groupKeys == null || groupKeys.isEmpty()) {
            return;
        }
        CtSourceRowsGroupKey firstGroupKey = groupKeys.get(0);
        ArrayList<CtSourceRowsGroupKey> otherGroupKeys = new ArrayList<CtSourceRowsGroupKey>(3);
        for (int i = 1; i < groupKeys.size(); ++i) {
            otherGroupKeys.add(groupKeys.get(i));
        }
        CtSourceRowsGroup childGroup = this.childGroupMap.computeIfAbsent(firstGroupKey, key -> {
            CtSourceRowsGroup newChildGroup = new CtSourceRowsGroup((CtSourceRowsGroupKey)key);
            this.childGroupList.add(newChildGroup);
            return newChildGroup;
        });
        childGroup.addSourceRow(sourceRowId, otherGroupKeys);
    }

    public CtSourceRowsGroup splitSubList(int batchRowCount) {
        int count;
        int startEntrySeq = this.getStartEntrySeq();
        if (startEntrySeq > this.getChildGroupList().size()) {
            return null;
        }
        CtSourceRowsGroup billGroup = new CtSourceRowsGroup(this.getGroupKey());
        billGroup.setTargetBillId(this.getTargetBillId());
        billGroup.setStartEntrySeq(startEntrySeq);
        for (count = 0; count < batchRowCount && startEntrySeq + count <= this.childGroupList.size(); ++count) {
            CtSourceRowsGroup rowGroup = this.childGroupList.get(startEntrySeq + count - 1);
            billGroup.getChildGroupList().add(rowGroup);
            billGroup.getChildGroupMap().put(rowGroup.getGroupKey(), rowGroup);
            billGroup.getSourceRowIds().addAll(rowGroup.getSourceRowIds());
        }
        this.setStartEntrySeq(startEntrySeq + count);
        billGroup.setExistNextBatch(this.getStartEntrySeq() <= this.getChildGroupList().size());
        return billGroup;
    }

    public void fillSourceRow(Map<CtSourceRowId, DynamicObject> rows) {
        for (CtSourceRowId sourceRowId : this.sourceRowIds) {
            DynamicObject dynamicObject = rows.get(sourceRowId);
            if (dynamicObject == null) continue;
            this.sourceRows.add(dynamicObject);
        }
        for (CtSourceRowsGroup childGroup : this.childGroupList) {
            childGroup.fillSourceRow(rows);
        }
    }

    public void clearSourceRow() {
        for (CtSourceRowsGroup childGroup : this.childGroupList) {
            childGroup.clearSourceRow();
        }
        this.sourceRows.clear();
    }

    public void clearMemory() {
        if (this.childGroupList == null) {
            return;
        }
        for (CtSourceRowsGroup childGroup : this.childGroupList) {
            childGroup.clearMemory();
        }
        this.childGroupList.clear();
        this.childGroupList = null;
        this.childGroupMap.clear();
        this.childGroupMap = null;
        this.sourceRowIds.clear();
        this.sourceRowIds = null;
        this.sourceRows.clear();
        this.sourceRows = null;
    }

    public String toString() {
        if (this.groupKey == null) {
            return super.toString();
        }
        return this.groupKey.toString();
    }
}

