/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.mapping;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.ctbotp.BaseDataPropInfo;
import kd.bos.entity.ctbotp.CtDataEntity;
import kd.bos.entity.ctbotp.CtDataEntityFieldValue;
import kd.bos.entity.ctbotp.CtDataKeyValueValue;
import kd.bos.entity.ctbotp.CtFieldConvertType;
import kd.bos.entity.ctbotp.CtFieldMapItem;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.service.ctbotp.convert.CtSingleRuleContext;
import kd.bos.service.ctbotp.convert.batchrequest.CtBatchRequestManager;
import kd.bos.service.ctbotp.convert.batchrequest.CtMultiLangFieldSetValueRequest;
import kd.bos.service.ctbotp.convert.getvaluemode.CtGetSourceFieldValue;
import kd.bos.service.ctbotp.convert.getvaluemode.ICtGetValueMode;
import kd.bos.service.ctbotp.convert.mapping.CtMappingField;
import kd.bos.service.ctbotp.convert.var.CtSourceFieldVariable;
import kd.bos.service.ctbotp.convert.var.ICtVariableMode;

public class CtMappingMultiLangTextField
extends CtMappingField {
    private ICtGetValueMode getSrcBillIdHandler;
    private ICtGetValueMode getSrcRowIdHandler;
    private MuliLangTextProp srcMulLangTextProp;
    private BasedataProp srcBasedataProp;
    private String[] srcRefBDProps;
    private ICtGetValueMode getSrcBDFieldIdHandler;

    @Override
    public void initialize(CtSingleRuleContext ruleContext, CtFieldMapItem fieldMapItem) {
        super.initialize(ruleContext, fieldMapItem);
        if (fieldMapItem.getCtFieldConvertType() == CtFieldConvertType.SourceField && !this.vars.isEmpty()) {
            ICtVariableMode var = (ICtVariableMode)this.vars.get(0);
            IDataEntityProperty srcProp = null;
            if (var instanceof CtSourceFieldVariable) {
                srcProp = ((CtSourceFieldVariable)var).getSourceField();
            }
            if (srcProp instanceof MuliLangTextProp) {
                this.srcMulLangTextProp = (MuliLangTextProp)srcProp;
            } else if (srcProp instanceof BasedataProp) {
                this.srcBasedataProp = (BasedataProp)srcProp;
                this.srcRefBDProps = ((CtSourceFieldVariable)var).getRefProps();
                this.getSrcBDFieldIdHandler = new CtGetSourceFieldValue(ruleContext, this.srcBasedataProp.getName());
                this.getVars().addAll(this.getSrcBDFieldIdHandler.getVars());
            }
            if (srcProp != null) {
                String srcRowIdPropName = "id";
                IDataEntityType srcEntityType = srcProp.getParent();
                if (srcEntityType instanceof SubEntryType) {
                    srcRowIdPropName = String.format("%s.%s.id", srcEntityType.getParent().getName(), srcEntityType.getName());
                } else if (srcEntityType instanceof EntryType) {
                    srcRowIdPropName = String.format("%s.id", srcEntityType.getName());
                }
                this.getSrcRowIdHandler = new CtGetSourceFieldValue(ruleContext, srcRowIdPropName);
            }
        }
        this.getSrcBillIdHandler = new CtGetSourceFieldValue(ruleContext, "id");
    }

    @Override
    public synchronized void calcAndMappingValue(Map<String, BaseDataPropInfo> baseDataPropInfoMap, Map<String, DynamicProperty> fldProperties, List<DynamicObject> sourceRows, CtDataEntity activeRow, CtBatchRequestManager batchRequestManager) {
        if (this.srcMulLangTextProp == null && this.srcBasedataProp == null) {
            Object mapValue = this.calcMapValue(baseDataPropInfoMap, fldProperties, sourceRows);
            LocaleString localeValue = new LocaleString((String)mapValue);
            CtDataEntityFieldValue ctDataEntityFieldValue = new CtDataEntityFieldValue();
            for (Map.Entry entry : localeValue.entrySet()) {
                ArrayList<CtDataKeyValueValue> ctDataKeyValueValues = new ArrayList<CtDataKeyValueValue>(8);
                CtDataKeyValueValue ctDataKeyValueValue = new CtDataKeyValueValue();
                ctDataKeyValueValue.setKey((String)entry.getKey());
                ctDataKeyValueValue.setValue((String)entry.getValue());
                ctDataKeyValueValues.add(ctDataKeyValueValue);
                ctDataEntityFieldValue.setKeyValues(ctDataKeyValueValues);
            }
            this.targetFieldProp.setValue(activeRow, ctDataEntityFieldValue);
            return;
        }
        Object srcBillId = this.getSrcBillIdHandler.getValue(baseDataPropInfoMap, fldProperties, sourceRows.get(0));
        Object srcRowId = this.getSrcRowIdHandler.getValue(baseDataPropInfoMap, fldProperties, sourceRows.get(0));
        ArrayList<Object> srcRowIds = new ArrayList<Object>(10);
        for (DynamicObject sourceRow : sourceRows) {
            srcRowIds.add(this.getSrcRowIdHandler.getValue(baseDataPropInfoMap, fldProperties, sourceRow));
        }
        CtMultiLangFieldSetValueRequest setValueRequest = new CtMultiLangFieldSetValueRequest();
        setValueRequest.setFieldMapItem(this.getFieldMap());
        setValueRequest.setTargetFieldProp(this.getTargetFieldProp());
        setValueRequest.setActiveRow(activeRow);
        setValueRequest.setSrcBillId(srcBillId);
        setValueRequest.setSrcRowId(srcRowId);
        setValueRequest.setSrcRowIds(srcRowIds);
        setValueRequest.setSrcMuliLangTextProp(this.srcMulLangTextProp);
        if (this.srcBasedataProp != null) {
            setValueRequest.setSrcBDProp(this.srcBasedataProp);
            setValueRequest.setSrcRefBDProps(this.srcRefBDProps);
            Object srcBDId = this.getSrcBDFieldIdHandler.getValue(baseDataPropInfoMap, fldProperties, sourceRows.get(0));
            setValueRequest.setSrcBDId(srcBDId);
        }
        batchRequestManager.getBatchMultiLang().getRequests().add(setValueRequest);
    }
}

