/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.IComplexProperty;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.ctbotp.BaseDataPropInfo;
import kd.bos.entity.ctbotp.constants.CtBaseDataFieldTypeEnum;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BillTypeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.ItemClassTypeProp;
import kd.bos.entity.property.MasterBasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.service.ctbotp.convert.query.CtBotpRefQueryParameter;

public class CtBotpQueryParameter {
    private String entityNumber;
    private List<String> selectFields = new ArrayList<String>();
    private DynamicObjectType queryEntityType;
    private List<DynamicSimpleProperty> queryProps = new ArrayList<DynamicSimpleProperty>();
    private List<DynamicComplexProperty> queryComplexProps = new ArrayList<DynamicComplexProperty>();
    private Map<DynamicSimpleProperty, CtBotpRefQueryParameter> queryRefIdProps = new HashMap<DynamicSimpleProperty, CtBotpRefQueryParameter>();
    private Map<String, DynamicSimpleProperty> srcBasedataProps = new HashMap<String, DynamicSimpleProperty>();

    public CtBotpQueryParameter(String entityNumber) {
        this.entityNumber = entityNumber;
        this.queryEntityType = new MainEntityType();
        this.queryEntityType.setName("queryObject");
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public String getSelectString() {
        return StringUtils.join((Object[])this.selectFields.toArray(), (String)",");
    }

    public DynamicObjectType getQueryEntityType() {
        return this.queryEntityType;
    }

    public List<DynamicSimpleProperty> getQueryProps() {
        return this.queryProps;
    }

    public Map<DynamicSimpleProperty, CtBotpRefQueryParameter> getQueryRefIdProps() {
        return this.queryRefIdProps;
    }

    public Map<String, DynamicSimpleProperty> getSrcBasedataProps() {
        return this.srcBasedataProps;
    }

    public int addSelectField(Map<String, BaseDataPropInfo> baseDataPropInfoMap, Map<String, String> srcFldAlias, IDataEntityProperty srcFieldProp, String refPropName, String fldAlias, int fldIndex) {
        if (srcFieldProp instanceof ISimpleProperty) {
            this.registerProperty(srcFldAlias, this.queryEntityType, (ISimpleProperty)srcFieldProp, fldAlias);
            return fldIndex;
        }
        if (srcFieldProp instanceof IComplexProperty) {
            return this.registerProperty(baseDataPropInfoMap, srcFldAlias, this.queryEntityType, (IComplexProperty)srcFieldProp, refPropName, fldAlias, fldIndex);
        }
        if (srcFieldProp instanceof ICollectionProperty) {
            this.registerProperty(srcFldAlias, this.queryEntityType, (ICollectionProperty)srcFieldProp, refPropName, fldAlias);
            return fldIndex;
        }
        return fldIndex;
    }

    private String registerProperty(Map<String, String> srcFldAlias, DynamicObjectType dt, ISimpleProperty srcFieldProp, String fldAlias) {
        DynamicProperty sp = dt.getProperty(fldAlias);
        if (sp == null) {
            DynamicSimpleProperty property;
            Class<String> propertyType = srcFieldProp.getPropertyType();
            if (propertyType == ILocaleString.class) {
                propertyType = String.class;
            }
            if (srcFieldProp instanceof ItemClassTypeProp) {
                ItemClassTypeProp newProp = new ItemClassTypeProp();
                ItemClassTypeProp srcProp = (ItemClassTypeProp)srcFieldProp;
                newProp.setBaseEntityIds(srcProp.getBaseEntityIds());
                newProp.setComboItems(srcProp.getComboItems());
                newProp.getItemTypes().putAll(srcProp.getItemTypes());
                newProp.setName(fldAlias);
                property = newProp;
            } else {
                property = new DynamicSimpleProperty(fldAlias, propertyType, null);
            }
            property.setPrimaryKey(srcFieldProp.isPrimaryKey());
            property.setDbType(srcFieldProp.getDbType());
            sp = dt.registerSimpleProperty(property);
            this.selectFields.add(this.buildFullPropName((IDataEntityProperty)srcFieldProp) + " " + fldAlias);
            this.queryProps.add(property);
        }
        return fldAlias;
    }

    private int registerProperty(Map<String, BaseDataPropInfo> baseDataPropInfoMap, Map<String, String> srcFldAlias, DynamicObjectType dt, IComplexProperty srcFieldProp, String refPropName, String fldAlias, int fldIndex) {
        BasedataEntityType refType;
        DynamicProperty rp;
        if (!(srcFieldProp instanceof BasedataProp)) {
            this.selectFields.add(this.buildFullPropName((IDataEntityProperty)srcFieldProp) + " " + fldAlias);
            DynamicComplexProperty dynamicComplexProperty = new DynamicComplexProperty(fldAlias, refPropName, (DynamicObjectType)srcFieldProp.getComplexType(), false);
            dt.registerComplexProperty(dynamicComplexProperty);
            this.queryComplexProps.add(dynamicComplexProperty);
            return fldIndex;
        }
        if (srcFieldProp instanceof FlexProp) {
            this.selectFields.add(this.buildFullPropName((IDataEntityProperty)srcFieldProp) + " " + fldAlias);
            DynamicSimpleProperty refIdProp = new DynamicSimpleProperty(fldAlias, ((BasedataProp)srcFieldProp).getRefIdProp().getPropertyType(), null);
            dt.registerSimpleProperty(refIdProp);
            this.queryProps.add(refIdProp);
            return fldIndex;
        }
        DynamicSimpleProperty refIdProp = this.srcBasedataProps.get(srcFieldProp.getName());
        if (refIdProp == null) {
            String refIdPropName = null;
            refIdPropName = StringUtils.isBlank((CharSequence)refPropName) ? fldAlias : srcFieldProp.getName() + "_id";
            refIdProp = new DynamicSimpleProperty(refIdPropName, ((BasedataProp)srcFieldProp).getRefIdProp().getPropertyType(), null);
            dt.registerSimpleProperty(refIdProp);
            this.selectFields.add(this.buildFullPropName((IDataEntityProperty)srcFieldProp) + " " + refIdPropName);
            this.queryProps.add(refIdProp);
            this.srcBasedataProps.put(srcFieldProp.getName(), refIdProp);
        }
        if ((rp = dt.getProperty(fldAlias)) == null) {
            List<DynamicProperty> refProps;
            if (StringUtils.isBlank((CharSequence)refPropName)) {
                refPropName = "id";
            }
            if (!(refProps = this.findPropertys((MainEntityType)(refType = (BasedataEntityType)srcFieldProp.getComplexType()), refPropName, true)).isEmpty()) {
                DynamicProperty oldRefProp = refProps.get(refProps.size() - 1);
                DynamicSimpleProperty newRefProp = new DynamicSimpleProperty(fldAlias, oldRefProp.getPropertyType(), null);
                dt.registerSimpleProperty(newRefProp);
                CtBotpRefQueryParameter refQueryParameter = this.getQueryRefIdProps().get(refIdProp);
                if (refQueryParameter == null) {
                    refQueryParameter = new CtBotpRefQueryParameter(refType.getName(), srcFieldProp, refIdProp);
                    this.getQueryRefIdProps().put(refIdProp, refQueryParameter);
                }
                refQueryParameter.addSelectProp(refPropName, fldAlias);
            }
        }
        if (!(srcFieldProp instanceof BillTypeProp)) {
            refType = (BasedataEntityType)srcFieldProp.getComplexType();
            if (refType.getMasteridType() != 2) {
                String numPropStr = refType.getNumberProperty();
                if (!srcFldAlias.containsKey(srcFieldProp.getName() + "." + numPropStr)) {
                    String numberfldAlias = "f" + ++fldIndex;
                    List<DynamicProperty> refProps = this.findPropertys((MainEntityType)refType, numPropStr, true);
                    if (!refProps.isEmpty()) {
                        DynamicProperty oldRefProp = refProps.get(refProps.size() - 1);
                        DynamicSimpleProperty newRefProp = new DynamicSimpleProperty(numberfldAlias, oldRefProp.getPropertyType(), null);
                        dt.registerSimpleProperty(newRefProp);
                        CtBotpRefQueryParameter refQueryParameter = this.getQueryRefIdProps().get(refIdProp);
                        if (refQueryParameter == null) {
                            refQueryParameter = new CtBotpRefQueryParameter(refType.getName(), srcFieldProp, refIdProp);
                            this.getQueryRefIdProps().put(refIdProp, refQueryParameter);
                        }
                        refQueryParameter.addSelectProp(numPropStr, numberfldAlias);
                        srcFldAlias.put(srcFieldProp.getName() + "." + numPropStr, numberfldAlias);
                        this.setBaseDataPropInfo(baseDataPropInfoMap, srcFieldProp.getName(), srcFieldProp.getName() + "." + numPropStr, true);
                    }
                }
            } else {
                String refMasterId;
                DynamicProperty oldRefProp;
                String masterIdPropStr = refType.getMasteridPropName();
                List<DynamicProperty> refProps = this.findPropertys((MainEntityType)refType, masterIdPropStr, true);
                if (!refProps.isEmpty() && (oldRefProp = refProps.get(refProps.size() - 1)) instanceof MasterBasedataProp) {
                    MasterBasedataProp masterBasedataProp = (MasterBasedataProp)oldRefProp;
                    BasedataEntityType basedataEntityType = (BasedataEntityType)masterBasedataProp.getComplexType();
                    String numberPropStr = basedataEntityType.getNumberProperty();
                    List<DynamicProperty> numberProps = this.findPropertys((MainEntityType)basedataEntityType, numberPropStr, true);
                    String masterIdNumberStr = masterIdPropStr + "." + numberPropStr;
                    String fullNumberProp = srcFieldProp.getName() + "." + masterIdNumberStr;
                    if (!srcFldAlias.containsKey(fullNumberProp) && !numberProps.isEmpty()) {
                        String masterIdNumberfldAlias = "f" + ++fldIndex;
                        DynamicProperty numberProp = numberProps.get(refProps.size() - 1);
                        DynamicSimpleProperty newRefProp = new DynamicSimpleProperty(masterIdNumberfldAlias, numberProp.getPropertyType(), null);
                        dt.registerSimpleProperty(newRefProp);
                        CtBotpRefQueryParameter refQueryParameter = this.getQueryRefIdProps().get(refIdProp);
                        if (refQueryParameter == null) {
                            refQueryParameter = new CtBotpRefQueryParameter(refType.getName(), srcFieldProp, refIdProp);
                            this.getQueryRefIdProps().put(refIdProp, refQueryParameter);
                        }
                        refQueryParameter.addSelectProp(masterIdNumberStr, masterIdNumberfldAlias);
                        srcFldAlias.put(fullNumberProp, masterIdNumberfldAlias);
                        this.setBaseDataPropInfo(baseDataPropInfoMap, srcFieldProp.getName(), fullNumberProp, true);
                    }
                }
                if (StringUtils.isNotEmpty((CharSequence)(refMasterId = refType.getMasteridPropName()))) {
                    refMasterId = refMasterId + "_id";
                    String fullMasterIdProp = srcFieldProp.getName() + "." + refMasterId;
                    if (!srcFldAlias.containsKey(fullMasterIdProp)) {
                        String masterIdfld = "f" + ++fldIndex;
                        List<DynamicProperty> refMaterIdProps = this.findPropertys((MainEntityType)refType, refMasterId, true);
                        if (!refMaterIdProps.isEmpty()) {
                            DynamicProperty oldRefProp2 = refMaterIdProps.get(refMaterIdProps.size() - 1);
                            DynamicSimpleProperty newRefProp = new DynamicSimpleProperty(masterIdfld, oldRefProp2.getPropertyType(), null);
                            dt.registerSimpleProperty(newRefProp);
                            CtBotpRefQueryParameter refQueryParameter = this.getQueryRefIdProps().get(refIdProp);
                            if (refQueryParameter == null) {
                                refQueryParameter = new CtBotpRefQueryParameter(refType.getName(), srcFieldProp, refIdProp);
                                this.getQueryRefIdProps().put(refIdProp, refQueryParameter);
                            }
                            refQueryParameter.addSelectProp(refMasterId, masterIdfld);
                            srcFldAlias.put(fullMasterIdProp, masterIdfld);
                            this.setBaseDataPropInfo(baseDataPropInfoMap, srcFieldProp.getName(), fullMasterIdProp, false);
                        }
                    }
                }
            }
        }
        return fldIndex;
    }

    private void setBaseDataPropInfo(Map<String, BaseDataPropInfo> baseDataPropInfoMap, String baseDataProp, String childProp, boolean isNumber) {
        BaseDataPropInfo baseDataPropInfo = null;
        if (!baseDataPropInfoMap.containsKey(baseDataProp)) {
            baseDataPropInfo = new BaseDataPropInfo();
            baseDataPropInfoMap.put(baseDataProp, baseDataPropInfo);
        } else {
            baseDataPropInfo = baseDataPropInfoMap.get(baseDataProp);
        }
        if (isNumber) {
            baseDataPropInfo.setNumber(childProp);
        } else {
            baseDataPropInfo.setMasterId(childProp);
        }
    }

    private String registerProperty(Map<String, String> srcFldAlias, DynamicObjectType dt, ICollectionProperty srcFieldProp, String refPropName, String fldAlias) {
        if (!(srcFieldProp instanceof MulBasedataProp)) {
            return null;
        }
        MulBasedataProp mulBasedataProp = (MulBasedataProp)srcFieldProp;
        IComplexProperty bdProp = mulBasedataProp.getRefBaseProp();
        if (bdProp == null) {
            return null;
        }
        DynamicSimpleProperty refIdProp = this.srcBasedataProps.get(srcFieldProp.getName());
        if (refIdProp == null) {
            String refIdPropName = null;
            refIdPropName = StringUtils.isBlank((CharSequence)refPropName) ? fldAlias : srcFieldProp.getName() + "_id";
            refIdProp = new DynamicSimpleProperty(refIdPropName, mulBasedataProp.getRefIdProp().getPropertyType(), null);
            dt.registerSimpleProperty(refIdProp);
            this.selectFields.add(this.buildFullPropName((IDataEntityProperty)srcFieldProp) + " " + refIdPropName);
            this.queryProps.add(refIdProp);
            this.srcBasedataProps.put(srcFieldProp.getName(), refIdProp);
        }
        DynamicProperty rp = dt.getProperty(fldAlias);
        if (StringUtils.isNotBlank((CharSequence)refPropName) && rp == null) {
            MainEntityType refType = null;
            if (srcFieldProp instanceof BasedataProp) {
                refType = (MainEntityType)((BasedataProp)srcFieldProp).getComplexType();
            } else if (srcFieldProp instanceof MulBasedataProp) {
                refType = (MainEntityType)((MulBasedataProp)srcFieldProp).getComplexType();
            }
            List<DynamicProperty> refProps = this.findPropertys(refType, refPropName, true);
            if (!refProps.isEmpty()) {
                DynamicProperty oldRefProp = refProps.get(refProps.size() - 1);
                DynamicSimpleProperty newRefProp = new DynamicSimpleProperty(fldAlias, oldRefProp.getPropertyType(), null);
                dt.registerSimpleProperty(newRefProp);
                CtBotpRefQueryParameter refQueryParameter = this.getQueryRefIdProps().get(refIdProp);
                if (refQueryParameter == null) {
                    refQueryParameter = new CtBotpRefQueryParameter(refType != null ? refType.getName() : "", bdProp, refIdProp);
                    this.getQueryRefIdProps().put(refIdProp, refQueryParameter);
                }
                refQueryParameter.addSelectProp(refPropName, fldAlias);
            }
        }
        return fldAlias;
    }

    private void registMulBaseDataProp(Map<String, String> srcFldAlias, ICollectionProperty srcFieldProp, DynamicSimpleProperty refIdProp, DynamicObjectType dt, CtBaseDataFieldTypeEnum ctBaseDataFieldTypeEnum) {
        MulBasedataProp mulBasedataProp = (MulBasedataProp)srcFieldProp;
        IComplexProperty bdProp = mulBasedataProp.getRefBaseProp();
        if (bdProp == null) {
            return;
        }
        String refPropName = "";
        String fldAlias = srcFieldProp.getName() + ctBaseDataFieldTypeEnum.getValue();
        DynamicProperty rp = dt.getProperty(fldAlias);
        if (rp == null) {
            List<DynamicProperty> refProps;
            BasedataEntityType refType = (BasedataEntityType)((BasedataProp)srcFieldProp).getComplexType();
            if (ctBaseDataFieldTypeEnum.name().equals(ctBaseDataFieldTypeEnum.name())) {
                refPropName = refType.getNumberProperty();
            }
            if (!(refProps = this.findPropertys((MainEntityType)refType, refPropName, true)).isEmpty()) {
                DynamicProperty oldRefProp = refProps.get(refProps.size() - 1);
                DynamicSimpleProperty newRefProp = new DynamicSimpleProperty(fldAlias, oldRefProp.getPropertyType(), null);
                dt.registerSimpleProperty(newRefProp);
                CtBotpRefQueryParameter refQueryParameter = this.getQueryRefIdProps().get(refIdProp);
                if (refQueryParameter == null) {
                    refQueryParameter = new CtBotpRefQueryParameter(refType.getName(), bdProp, refIdProp);
                    this.getQueryRefIdProps().put(refIdProp, refQueryParameter);
                }
                refQueryParameter.addSelectProp(refPropName, fldAlias);
                srcFldAlias.put(this.buildFullPropName((IDataEntityProperty)srcFieldProp) + ctBaseDataFieldTypeEnum.getValue(), refPropName);
            }
        }
    }

    private String buildFullPropName(IDataEntityProperty prop) {
        if (prop.getParent() instanceof SubEntryType) {
            SubEntryType subEntryType = (SubEntryType)prop.getParent();
            return subEntryType.getParent().getName() + "." + subEntryType.getName() + "." + prop.getName();
        }
        if (prop.getParent() instanceof EntryType) {
            return prop.getParent().getName() + "." + prop.getName();
        }
        return prop.getName();
    }

    private List<DynamicProperty> findPropertys(MainEntityType mainType, String var, boolean throwError) {
        ArrayList<DynamicProperty> props = new ArrayList<DynamicProperty>();
        String[] keys = var.split("\\.");
        MainEntityType parentType = mainType;
        int forCount = 0;
        for (int i = 0; i < keys.length; ++i) {
            DynamicProperty prop = (DynamicProperty)parentType.findProperty(keys[i]);
            if (prop == null && parentType.getProperties().containsKey((Object)keys[i])) {
                prop = parentType.getProperty(keys[i]);
            }
            if (prop == null) break;
            ++forCount;
            if (prop instanceof EntryProp) {
                parentType = (EntityType)((EntryProp)prop).getItemType();
                continue;
            }
            props.add(prop);
            if (!(prop instanceof BasedataProp)) break;
            parentType = (EntityType)((BasedataProp)prop).getComplexType();
        }
        if (throwError && forCount < keys.length) {
            throw new KDException(BosErrorCode.fieldNotExist, new Object[]{mainType.getDisplayName().toString(), var});
        }
        return props;
    }

    public List<DynamicComplexProperty> getQueryComplexProps() {
        return this.queryComplexProps;
    }

    public void setQueryComplexProps(List<DynamicComplexProperty> queryComplexProps) {
        this.queryComplexProps = queryComplexProps;
    }
}

