/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.convert.var;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.ctbotp.BaseDataPropInfo;
import kd.bos.entity.ctbotp.CtDataBaseDataValue;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.SubEntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.ctbotp.convert.var.ICtVariableMode;

public class CtSourceFieldVariable
implements ICtVariableMode {
    private static final Log log = LogFactory.getLog(CtSourceFieldVariable.class);
    protected String var;
    protected String[] keyItems;
    protected String[] refProps;
    private IDataEntityProperty sourceField;
    private String fullPropName;

    public CtSourceFieldVariable(String var, String[] keyItems, IDataEntityProperty sourceField) {
        this.var = var;
        this.keyItems = keyItems;
        this.sourceField = sourceField;
        ArrayList<String> propNames = new ArrayList<String>(Arrays.asList(keyItems));
        if (sourceField instanceof EntryProp) {
            EntryType entryType;
            propNames.remove(0);
            if (keyItems.length == 1) {
                entryType = (EntryType)((EntryProp)this.sourceField).getItemType();
                this.sourceField = entryType.getPrimaryKey();
            } else {
                entryType = (EntryType)((EntryProp)this.sourceField).getItemType();
                IDataEntityProperty subProp = entryType.findProperty(keyItems[1]);
                if (subProp == null) {
                    subProp = entryType.findProperty(var);
                }
                if (subProp != null) {
                    if (subProp instanceof SubEntryProp && keyItems.length == 3) {
                        propNames.remove(0);
                        SubEntryType subEntryType = (SubEntryType)((SubEntryProp)subProp).getItemType();
                        subProp = subEntryType.findProperty(keyItems[2]);
                        if (subProp == null) {
                            subProp = subEntryType.findProperty(keyItems[1] + "." + keyItems[2]);
                        }
                    }
                    this.sourceField = subProp;
                }
            }
        }
        if (this.sourceField.getParent() instanceof SubEntryType) {
            SubEntryType subEntryType = (SubEntryType)this.sourceField.getParent();
            this.fullPropName = subEntryType.getParent().getName() + "." + subEntryType.getName() + "." + StringUtils.join((Object[])propNames.toArray(), (String)".");
        } else {
            this.fullPropName = this.sourceField.getParent() instanceof EntryType ? this.sourceField.getParent().getName() + "." + StringUtils.join((Object[])propNames.toArray(), (String)".") : var;
        }
        if (propNames.size() <= 1) {
            this.refProps = new String[0];
        } else {
            propNames.remove(0);
            this.refProps = StringUtils.equalsIgnoreCase((CharSequence)((CharSequence)propNames.get(0)), (CharSequence)"id") ? new String[0] : propNames.toArray(new String[0]);
        }
    }

    @Override
    public String getVar() {
        return this.var;
    }

    @Override
    public void setVar(String var) {
        this.var = var;
        this.keyItems = StringUtils.split((String)var, (String)".");
    }

    @Override
    public String[] getKeyItems() {
        return this.keyItems;
    }

    @Override
    public void setKeyItems(String[] keyItems) {
        this.keyItems = keyItems;
    }

    public String[] getRefProps() {
        return this.refProps;
    }

    @Override
    public String getFldKey() {
        return this.keyItems[0];
    }

    public IDataEntityProperty getSourceField() {
        return this.sourceField;
    }

    public String getFullPropName() {
        return this.fullPropName;
    }

    @Override
    public Object getValue(Map<String, BaseDataPropInfo> baseDataPropInfoMap, Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow) {
        DynamicProperty prop = fldProperties.get(this.var);
        if (prop == null) {
            return null;
        }
        if (baseDataPropInfoMap != null && baseDataPropInfoMap.containsKey(this.var)) {
            return this.setBaseDataInfo(baseDataPropInfoMap, fldProperties, sourceRow);
        }
        return prop.getValueFast((Object)sourceRow);
    }

    private CtDataBaseDataValue setBaseDataInfo(Map<String, BaseDataPropInfo> baseDataPropInfoMap, Map<String, DynamicProperty> fldProperties, DynamicObject sourceRow) {
        DynamicProperty masterIdProp;
        DynamicProperty prop = fldProperties.get(this.var);
        BaseDataPropInfo baseDataPropInfo = baseDataPropInfoMap.get(this.var);
        CtDataBaseDataValue ctDataBaseDataValue = new CtDataBaseDataValue();
        Object id = prop.getValueFast((Object)sourceRow);
        ctDataBaseDataValue.setId(String.valueOf(id));
        Object number = null;
        DynamicProperty numProp = fldProperties.get(baseDataPropInfo.getNumber());
        if (numProp != null) {
            number = numProp.getValueFast((Object)sourceRow);
            if (StringUtils.isNotBlank((Object)number)) {
                ctDataBaseDataValue.setNumber(number.toString());
            }
        } else {
            log.info("getBaseDataInfo numProp:{}", (Object)(this.fullPropName + "_number"));
        }
        if ((masterIdProp = fldProperties.get(baseDataPropInfo.getMasterId())) != null) {
            Object materId = masterIdProp.getValueFast((Object)sourceRow);
            if (StringUtils.isNotBlank((Object)materId)) {
                ctDataBaseDataValue.setMasterId(materId.toString());
            }
        } else {
            log.info("getBaseDataInfo masterIdProp:{}", (Object)(this.fullPropName + "_masterId"));
        }
        return ctDataBaseDataValue;
    }

    @Override
    public Object getValue(Map<String, String> fldAlias, Row row) {
        String alias = fldAlias.get(this.var);
        return row.get(alias);
    }

    public Set<String> getBelongEntityKeys(BillEntityType mainType) {
        LinkedHashSet<String> entityKeys = new LinkedHashSet<String>();
        String parentKey = this.sourceField.getParent().getName();
        entityKeys.add(parentKey);
        IDataEntityProperty parentProp = mainType.findProperty(parentKey);
        while (parentProp != null) {
            parentKey = parentProp.getParent().getName();
            entityKeys.add(parentKey);
            parentProp = mainType.findProperty(parentKey);
        }
        if (!entityKeys.contains(mainType.getName())) {
            entityKeys.add(mainType.getName());
        }
        return entityKeys;
    }
}

