/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.ctbotp.facade;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.ctbotp.CtBotpUniqueService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.service.ctbotp.facade.OperateSyncContext;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.CollectionUtils;
import org.apache.commons.collections.MapUtils;

public class CtTcSevice {
    public static void deleteTc(Map<String, Object> params, OperateSyncContext context) {
        if (context.isContinueExecution()) {
            CtTcSevice.collectBillIds(params, context);
            Map<Long, Map<Long, Map<Long, Long>>> tcMap = context.getDbService().readTcRows(context.getBillIds().toArray(new Long[0]));
            if (MapUtils.isEmpty(tcMap)) {
                return;
            }
            Set<Long> billIdInTc = tcMap.keySet();
            Set<Long> billIdExist = context.getDbService().readBillIds(context.getMainEntityType(), new ArrayList<Long>(billIdInTc));
            Set<Long> delBillIds = billIdInTc.stream().filter(a -> !billIdExist.contains(a)).collect(Collectors.toSet());
            HashSet<Long> delTcIds = new HashSet<Long>();
            CtTcSevice.collectTcForBillDelete(delBillIds, delTcIds, tcMap);
            HashMap<Long, List<Long>> entityMap = new HashMap<Long, List<Long>>();
            HashMap<Long, Map<Long, Long>> tcIdMap = new HashMap<Long, Map<Long, Long>>();
            CtTcSevice.collectEntityAndTcInfo(tcMap, entityMap, tcIdMap, context);
            HashMap<Long, Set<Long>> existEntryIdMap = new HashMap<Long, Set<Long>>();
            CtTcSevice.collectEntryIdExist(entityMap, context, billIdExist, existEntryIdMap);
            CtTcSevice.collectDelTcForEntry(tcIdMap, delTcIds, existEntryIdMap);
            if (CollectionUtils.isNotEmpty(delTcIds)) {
                DeleteServiceHelper.delete((IDataEntityType)context.getTrackerTypes().getEntryTrackerType(), (Object[])delTcIds.toArray(new Long[0]));
            }
            CtTcSevice.deleteUnique(delBillIds, context);
        }
    }

    private static void deleteUnique(Set<Long> delBillIds, OperateSyncContext context) {
        if (CollectionUtils.isEmpty(delBillIds)) {
            return;
        }
        if (CollectionUtils.isNotEmpty(delBillIds)) {
            CtBotpUniqueService.delete((String)context.getMainEntityType().getDBRouteKey(), (Long[])delBillIds.toArray(new Long[0]), (String)context.getMainEntityType().getName());
        }
    }

    private static void collectBillIds(Map<String, Object> params, OperateSyncContext context) {
        DynamicObject[] objs;
        DynamicObject[] dynamicObjectArray = objs = params.get("objs") != null ? (DynamicObject[])params.get("objs") : null;
        if (objs == null) {
            return;
        }
        for (DynamicObject obj : objs) {
            if (!(obj.getPkValue() instanceof Long)) continue;
            context.getBillIds().add((Long)obj.getPkValue());
        }
    }

    private static void collectTcForBillDelete(Set<Long> delBillIds, Set<Long> delTcIds, Map<Long, Map<Long, Map<Long, Long>>> tcMap) {
        Iterator<Map.Entry<Long, Map<Long, Map<Long, Long>>>> it = tcMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Long, Map<Long, Map<Long, Long>>> entry = it.next();
            if (!delBillIds.contains(entry.getKey())) continue;
            for (Map.Entry<Long, Map<Long, Long>> mapEntry : entry.getValue().entrySet()) {
                for (Map.Entry<Long, Long> item : mapEntry.getValue().entrySet()) {
                    delTcIds.add(item.getKey());
                }
            }
            it.remove();
        }
    }

    private static void collectEntityAndTcInfo(Map<Long, Map<Long, Map<Long, Long>>> tcMap, Map<Long, List<Long>> entityMap, Map<Long, Map<Long, Long>> tcIdMap, OperateSyncContext context) {
        for (Map.Entry<Long, Map<Long, Map<Long, Long>>> entry : tcMap.entrySet()) {
            for (Map.Entry<Long, Map<Long, Long>> mapEntry : entry.getValue().entrySet()) {
                if (mapEntry.getKey().compareTo(context.getMainTableId()) == 0) continue;
                if (entityMap.containsKey(mapEntry.getKey())) {
                    List<Long> entityIds = entityMap.get(mapEntry.getKey());
                    entityIds.addAll(new ArrayList<Long>(mapEntry.getValue().values()));
                } else {
                    entityMap.put(mapEntry.getKey(), new ArrayList<Long>(mapEntry.getValue().values()));
                }
                if (tcIdMap.containsKey(mapEntry.getKey())) {
                    Map<Long, Long> tcId = tcIdMap.get(mapEntry.getKey());
                    tcId.putAll(mapEntry.getValue());
                    continue;
                }
                tcIdMap.put(mapEntry.getKey(), mapEntry.getValue());
            }
        }
    }

    private static void collectEntryIdExist(Map<Long, List<Long>> entityMap, OperateSyncContext context, Set<Long> billIdExist, Map<Long, Set<Long>> existEntryIdMap) {
        for (Map.Entry<Long, List<Long>> entry : entityMap.entrySet()) {
            TableDefine tableDefine = context.getDbService().loadTableDefine(entry.getKey());
            if (tableDefine == null || tableDefine.getEntityKey().equals(context.getMainEntityType().getName())) continue;
            String entityKey = tableDefine.getEntityKey();
            Map entityTypeMap = context.getMainEntityType().getAllEntities();
            EntityType entityType = (EntityType)entityTypeMap.get(entityKey);
            if (!(entityType instanceof EntryType)) continue;
            Set<Long> entryIds = context.getDbService().readEntryIds(billIdExist.toArray(new Long[0]), (EntryType)entityType);
            existEntryIdMap.put(entry.getKey(), entryIds);
        }
    }

    private static void collectDelTcForEntry(Map<Long, Map<Long, Long>> tcIdMap, Set<Long> delTcIds, Map<Long, Set<Long>> existEntryIdMap) {
        for (Map.Entry<Long, Map<Long, Long>> entry : tcIdMap.entrySet()) {
            if (MapUtils.isEmpty(existEntryIdMap)) {
                for (Map.Entry<Long, Long> item : entry.getValue().entrySet()) {
                    delTcIds.add(item.getKey());
                }
                continue;
            }
            Set<Long> existEntryIds = existEntryIdMap.get(entry.getKey());
            for (Map.Entry<Long, Long> item : entry.getValue().entrySet()) {
                if (existEntryIds.contains(item.getValue())) continue;
                delTcIds.add(item.getKey());
            }
        }
    }
}

